' **********************************************************************
' ***
' ***	it.b	InteleTerm Terminal Program
' ***		(C)opyright 1994 Morgan Davis Group
' ***
' ***	09jul93 2.0	Major revision to interface
' ***

#define	IDENT_PROG "it"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "25mar94"
#define IDENT_NAME "Morgan_Davis"

#define	COPR	"(C)opyright 1994 Morgan Davis Group^MAll Rights Reserved"

#include <appleio.h>
#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>
#include <proline/parse.h>

#ifdef APP_STAND_ALONE
 #define TITLE		"InteleTerm Lite " IDENT_VERS
 #define SCRIPTS	AppPrefix$ + "/Scripts/"
 #define TCAPS		AppPrefix$ + "/Termcaps/"
 #define MODULES	AppPrefix$ + "/Modules/"
 #define HELPFILE	AppPrefix$ + "/Help/IT"
#else
 #define TITLE		"InteleTerm Pro " IDENT_VERS
 #define SCRIPTS	ID$[uHome] + "/src/"
 #define TCAPS		SYS_PATH + "termcaps/"
 #define MODULES	SysInfo$[plModulesDir]
 #define HELPFILE	HELP_PATH + "it"
#endif

#define	MAX_LABELS	30
#define	MAX_TEXT	100
#define	MAX_TOKENS	200
#define	MAX_MITEMS	64

#define NOTERM_TYPE	-1
#define	STDTERM_TYPE	0
#define	HEXTERM_TYPE	1

#define	HMENU_TYPE	0
#define	SMENU_TYPE	1

#define	mMain		0
#define	mFile		1
#define	mModem		2
#define	mTerm		3
#define	mScript		4
#define	mYesNo		5
#define	mSpeed		6
#define	mReceive	7
#define	mSend		8
#define	mSize		9
#define	mType		10
#define	mOK		11
#define	mDebug		12
#define	mLast		mDebug

#ifdef APP_STAND_ALONE
MainMenu:	data	mMain, HMENU_TYPE, "", \
			5, "Modem", "Terminal", "Recv", "Xmit", "Quit"
#else
MainMenu:	data	mMain, HMENU_TYPE, "", \
			7, "Modem", "Terminal", "Script", \
			"Recv", "Xmit", "File", "Quit"
FileMenu:	data	mFile, HMENU_TYPE, "File", \
			3, "Shell-Command", "Edit", "View"
ScriptMenu:	data	mScript, HMENU_TYPE, "Script", \
			6, "Run", "Goto", "Edit", "Compile", "Load", "New"
#endif
ModemMenu:	data	mModem, HMENU_TYPE, "Modem", \
			5, "Dial", "Hangup", "Speed", "Break", "Reset"
TermMenu:	data	mTerm, HMENU_TYPE, "Terminal", \
			6, "Go","Debug", "Emulate", "Local-Echo", "Printer", \
			"Reset"
YesNoMenu:	data	mYesNo, HMENU_TYPE, "", \
			2, "No", "Yes"
SpeedMenu:	data	mSpeed, SMENU_TYPE, "Speed", \
			18, "Default", "50", "75", "110", "135", \
			"150", "300", "600", "1200", "1800", \
			"2400", "3600", "4800", "7200", "9600", \
			"19200", "38400", "57600", \
			7, TRUE
ReceiveMenu:	data	mReceive, HMENU_TYPE, "Receive", \
			3, "XMODEM", "YMODEM", "ZMODEM"
SendMenu:	data	mSend, HMENU_TYPE, "Send", \
			4, "Text", "XMODEM", "YMODEM", "ZMODEM"
SizeMenu:	data	mSize, HMENU_TYPE, "Block Size", \
			4, "Standard", "CRC-128", "1K", "4K"
TypeMenu:	data	mType, HMENU_TYPE, "Transfer Mode", \
			4, "Standard", "Text", "Binary-II", "ProDOS"
OKMenu:		data	mOK, HMENU_TYPE, "", \
			1, "OK"
DebugMenu:	data	mDebug, HMENU_TYPE, "Debugging", \
			3, "None", "Show-Controls", "Hex-Mode"

			
	gosub AppInit

#ifdef APP_STAND_ALONE
	& load notrace
	& < AppPath$, AppPrefix$
	& < AppPrefix$, AppPrefix$
#else
	F$ = TEMP_PATH + "utmp"
	fOpen F$
	fRead F$
	& get : & get : & get 
	& get W$
	& get : & get : & get
	& get SL$
	fClose
	if val(W$) then 
		print argv$[0]": port busy"
		goto Exit
	endif
#endif

	onerr goto itHandleError
	& page def pagingFlag
	& page stop 
	& in ioConsole
	& pr ioConsole
	& chk stop 
	& timer stop 
	& int on 
	& on int goto main

	TmpFile$	= TEMP_PATH + "it.tmp"

#ifndef APP_STAND_ALONE
	if ReturnFlag% then
		& getinfo TmpFile$, i$
		if i$ > "" then			' returning from sublaunch
			fRestore TmpFile$
			fDelete TmpFile$
			
			if inExec% then
				inExec% = FALSE
				GOOD = not ReturnStatus%
				gosub getCursorXY
				gosub clrCmdLine
				gosub setTermWindow
				goto startScript2
			endif

			&get (1),"[End]"
			goto reentry
		endif
	endif
	
	ITC$		= AppPath$ + "c"	' Path to ITC compiler
	SRC$		= SCRIPTS		' Path to "src" directory
	Ext$		= ".src"		' Source extension

	dim L$[MAX_LABELS], L%[MAX_LABELS], \
	    T$[MAX_TEXT], M%[MAX_TOKENS]
#endif
	
	fPrefix
	& get rcvDir$
	& lcase(rcvDir$)

	dim lastItem%[mLast], mitem$[MAX_MITEMS]

	termType% = STDTERM_TYPE
	lastTerm% = NOTERM_TYPE

	termMod$[STDTERM_TYPE] = "Terminal"
	termMod$[HEXTERM_TYPE] = "HexTerm"

	XT$[1] = "failed"
	XT$[2] = "cancelled"

	OnOff$[FALSE] = "OFF"
	OnOff$[TRUE] = "ON"

	result$[1] = "Cancelled"
	result$[2] = "No Connect"
	result$[3] = "Busy"
	result$[4] = "No Dial Tone"
	result$[5] = "No Answer"
	result$[6] = "Voice"

	EscCan$	= " (Esc cancels)..."
	
#ifndef APP_STAND_ALONE
	if argc > 1 then
		F$ = SRC$ + argv$[1]
		gosub verifyScript2
		gosub startScript
	endif

reentry:
#endif
	poke _WNDTOP,0
	X% = 0
	Y% = 1
	home
	gosub clrCmdLine

	& fn fnPortDCD, inTerm%
	if not inTerm% then gosub tcHelp

main:
	if inTerm% then gosub termMode
	do
		& pop
		& pr ioConsole
		poke _WNDBOT, 1
		& setdata MainMenu
		& fn fnPortDCD,I
		a$ = OnOff$[I] + "LINE"
		gosub goMenu
#ifdef APP_STAND_ALONE
		on curItem gosub tcModem, tcTerm, tcRecv, tcSend, tcQuit
#else
		on curItem gosub \
			tcModem, tcTerm, tcScript, \
			tcRecv, tcSend, tcFile, tcQuit
#endif
	loop
' end


' ==============================
' Misc Routines
' ==============================

dumpAllTools:
	& load fre TerminalTool_ID
	& load fre PARSER_ID
dumpXTools:
	& load fre ReceiveTool_ID
	& load fre SendTool_ID
return

replaceStatus:
	print 
	poke _WNDTOP,0
	poke _WNDBOT,24
#ifndef APP_STAND_ALONE
	& goto 0,0
	inverse 
	print SL$ tab(81)
	normal
	poke _WNDTOP,1
#endif
	& goto 0,23
	& ioctl(ioEraseLine)
	& page stop 
	if pagingFlag then & page on 
	if forcedDCD then & usr uNormalCarrier
	& fn fnPortDCD, i
	if not i then & usr uDTRLow
return 

	
itHandleError:
	& onerr E,L
	if E = 255 then resume 
	& pr ioConsole
	fClose
	call -198
	if E = 5 then 
		gosub getCursorXY
		& clear
		goto main
	endif
	gosub clrCmdLine
	if E = 6 or E = 7 then 
		a$ = "File not found"
	else
		if E = 254 then
			a$ = F$ + " not compiled"
		else
			a$ = "Error " + str$(E) + " at " + str$(L)
		endif
	endif
	gosub doOK
goto main

doOK:
	& setdata OKMenu
goto goMenu


getFileName:
	gosub clrCmdLine
	print A$": ";
	& read (64),F$
	if F$ <> "?" then return 
	gosub homeTerm
	fCat
	gosub getCursorXY
goto getFileName


clrCmdLine:
	& scrn (printerOff)
	poke _WNDTOP, 0
	& goto 0, 0
	normal 
	& ioctl(ioClearEOL)
return 

setTermWindow:
	poke _WNDBOT,24
	& scrn (printerOff + printerMode%)
	& goto X%,Y%
return 


tcHelp:
	gosub setTermWindow
	if X% then print
	& hlin 80, 95
	print "^M" TITLE "^M" COPR
	F$ = HELPFILE
	& getinfo F$, i$
	if i$ > "" then & list F$ : print
	' goto getCursorXY

getCursorXY:
	X% = peek (_CH80)
	Y% = peek (_CV)
return 

offOnMenu:
	lastItem%[mYesNo] = curItem

getYN:
	yn$ = a$ + "?"
	repeat
		a$ = yn$
		& setdata YesNoMenu
		gosub goMenu
	until curItem
	y = curItem - 1
return 

waitMsg:
	gosub clrCmdLine
	print "Wait...";
return

tcQuit:
	gosub replaceStatus
goto Exit

#ifndef APP_STAND_ALONE
' ====================
  tcFile:
' ====================
	& setdata FileMenu
	gosub goMenu
	if curItem then
		on curItem gosub shellCmd, tcEditFile, viewFile
		goto tcFile
	endif
return

tcEditFile:
	a$ = "Edit"
	gosub getFileName
	if F$ > "" then goto editFile
return

shellCmd:
	gosub clrCmdLine
	& read "!", CommandLine$
	if CommandLine$ > "" then goto sublaunch
return


viewFile:
	A$ = "View file"
	gosub getFileName
	fVerify F$
	gosub homeTerm
	gosub clrCmdLine
	print "Viewing " F$ "..."
	& page on 
	print 
	& list F$
	print 
	& page stop 
goto getCursorXY
#endif	


' ====================
  tcModem:
' ====================
	& setdata ModemMenu
	gosub goMenu
	if curItem then
		on curItem gosub tcDial, tcHangup, tcSpeed, tcBreak, tcMReset
		goto tcModem
	endif
return

tcMReset:
	gosub waitMsg
	& usr uResetModem
return

tcBreak:
	gosub waitMsg
	& break
return

tcDial:
	a$ = lastNum$
	& read (-30, a$),"Number: ", lastNum$
	& spc(lastNum$), lastNum$
	if lastNum$ = "" then return
	C% = 0
	repeat
		gosub clrCmdLine
		if C% then print result$[C%] ": ";
		print "Dialing ";
		print lastNum$;
		& call lastNum$
		print EscCan$;
		& wait for carrier, C%
		if not C% then 
			gosub homeTerm
			& beep
			if not inTerm% then goto termMode
		endif
	until C% = 1
return

tcHangup:
	a$ = "Hangup"
	gosub getYN
	if not Y then return

hangupNow:
	print "Hanging up...";
	& hangup
return
	

tcSpeed:
	& fn fnModemSpeed, i
	if not i then &fn fnPortSpeed, i
	lastItem%[mSpeed] = i + 1
	& setdata SpeedMenu
	gosub goMenu
	if curItem then
		gosub waitMsg
		& speed 127 + curItem
	endif
return


' ====================
  tcTerm:
' ====================
	& setdata TermMenu
	gosub goMenu
	if curItem then
		on curItem gosub tcGoTerm, debugMode, tcEmulate, \
		tcEcho, tcPrinter, tcTReset
		if not inTerm% then goto tcTerm
	endif
return

tcTReset:
	& ioctl(ioMTextOff)
	& ioctl(ioULOff)
	& ioctl(ioInsertOff)
goto homeTerm

debugMode:
	& setdata DebugMenu
	gosub goMenu
	if curItem then
		termType% = curItem = 3		' True if hex term
		showControls% = curItem = 2
	endif
return

tcEcho:
	a$ = "Local-Echo"
	curItem = echoFlag% + 1
	gosub offOnMenu
	echoFlag% = y
return

tcPrinter:
	a$ = "Printer"
	curItem = printerMode% + 1
	gosub offOnMenu
	printerMode% = curItem - 1
return

tcEmulate:
	gosub waitMsg
	& files (TCAPS, mitem$, 0), itemCount
	& sort (mitem$, itemCount)
	a$ = "Emulate"
	itemWidth = 15
	curItem = lastTCap%
	menuType% = SMENU_TYPE
	itemJust% = FALSE
	gosub doMenu
	if curItem then
		lastTCap% = curItem
		gosub clrCmdLine
		F$ = mitem$[curItem]
		gosub tsetTerminal
	endif
return

tsetTerminal:
	fBload TCAPS F$ ",A768,T0"
	& tset(768)
return 

tcGoTerm:
	if inTerm% then return
	& fn fnPortDCD, I
	if not I then
		& usr uForceCarrier
		& usr uDTRHigh
		forcedDCD = TRUE
	endif

termMode:
	& fn fnPortDCD,I
	if I then
		if termType% <> lastTerm%
			gosub waitMsg
			gosub dumpAllTools
			& load get MODULES + termMod$[termType%]
			lastTerm% = termType%
		endif
		gosub GetConnectSpeed
		gosub clrCmdLine
		inverse
		print " " termMod$[termType%] " ";
		normal
		if connectSpeed then print " " connectSpeed " bps";
		print " (A-<Esc> for menu)";
		gosub setTermWindow
		& term(echoFlag%, showControls%), i
		gosub getCursorXY
		gosub clrCmdLine
		if i < 128 then
			inverse 
			print " No Carrier ";
			normal 
			print " ";
			gosub hangupNow
		else
			a$ = chr$(i - 128)
			& pos("0123456789", a$), inTerm%
#ifndef APP_STAND_ALONE
			if inTerm% then
				gosub tcGotoFkey
				goto termMode
			else
				& lcase(a$)
				& pos ("qfmlxrbdhsp/?e", a$), inTerm%
				if inTerm% then
					on inTerm% gosub tcQuit, tcFile, tcModem, \
					tcEcho, tcSend, tcRecv, tcBreak, debugMode, \
					tcHangup, tcScript, tcPrinter, \
					tcHelp, tcHelp, tcEmulate
					goto termMode
				endif
			endif
#else
				& lcase(a$)
				& pos ("qmlxrbdhp/?e", a$), inTerm%
				if inTerm% then
					on inTerm% gosub tcQuit, tcModem, \
					tcEcho, tcSend, tcRecv, tcBreak, debugMode, \
					tcHangup, tcPrinter, \
					tcHelp, tcHelp, tcEmulate
					goto termMode
				endif
#endif
		endif
	endif
	inTerm% = FALSE
return
	


' ====================
  tcRecv:
' ====================
	proto$ = "Receive"
	gosub protoTop
	& setdata ReceiveMenu
	gosub getOptions
	if curItem then
		A$ = "Receive into (" + rcvDir$ + ")"
		gosub getFileName
		if F$ > "" then
			rcvDir$ = F$
			if right$(F$,1) <> "/" then rcvDir$ = rcvDir$ + "/"
		endif
		fVerify rcvDir$
		F$ = rcvDir$ + "rcvtmp"
		& getinfo F$, i$
		if i$ > "" then fDelete F$

		gosub protoPrep
		
	rcvagain:
		& rcv (F$, options$), I, newName$
		if batchmode and newName$ = "" then
			& ioctl(ioCR)
			& ioctl(ioEraseLine)
		else
			gosub protoStat
		endif
		gosub getCursorXY
		if not I then
			if batchMode then
				if newName$ > "" then
					gosub _FixName
					gosub saveName
					gosub showCancelMsg
					goto rcvagain
				endif
			else
				gosub _FixName
				gosub clrCmdLine
				& read (-15, newName$), "^GSave file as: ", newName$
				gosub saveName
				gosub setTermWindow
			endif
		endif
		goto protoEnd
	endif
return


' ====================
  tcSend:
' ====================
	proto$ = "Send"
	gosub protoTop
	& setdata SendMenu
	gosub getOptions
	if curItem then
		A$ = "File"
		gosub getFileName
		fVerify F$
		gosub clrCmdLine
		if xferType$ = "T" then
			print "Line prompt (Return for none): ";
			get P$
			C% = asc(P$) + 128
			if C% = $8D then C% = 0
			itemCount = 10
			for i = 1 to itemCount
				mitem$[i] = str$(i - 1)
			next
			menuType% = SMENU_TYPE
			itemJust% = TRUE
			itemWidth = 1
			a$ = "Seconds between lines"
			gosub doMenu
			if curItem then
				SD = val(mitem$[curItem])
				gosub setTermWindow
				gosub sendTextFile
			endif
			return
		endif

		gosub protoPrep	
		& snd(F$, options$), I
		gosub protoStat
		if batchMode then & snd ("", options$), I
		goto protoEnd
	endif
return


' ==============================
' File Transfer Misc Stuff
' ==============================

protoStat:
	print ", ";
	if i then
		print XT$[I]
	else
		gosub GetTimeMark
		endTimeMark = curTimeMark
		gosub ElapsedTime
		gosub getFileSize
		j = int(fileSize / seconds)
		print j " cps, " percent(0, topcps, j) "%"
	endif
return

getFileSize:
	& getinfo F$, i$
	fOpen F$ ",T" asc(mid$(i$,5))	' Open any filetype
	poke _SREFNUM, peek(_OREFNUM)	' Get number of bytes in file
	& MLI (_GET_EOF, _SGETEOF), j
	fileSize = peek24(_SEOF)
	fClose F$
return

protoEnd:
	gosub getCursorXY
	& beep
	gosub dumpXTools
return

protoTop:
	& fn fnPortDCD, i
	if not i then pop
return

protoPrep:
	gosub GetConnectSpeed
	topcps = connectSpeed / 10
	gosub dumpXTools
	fFre
	& load get MODULES + left$(proto$, 1) + moduleTag$
	gosub homeCarriage

showCancelMsg:
	gosub clrCmdLine
	& ioctl(ioInverse)
	print proto$ " in progress " EscCan$;
	& ioctl(ioClearEOL)
	& ioctl(ioNormal)
	gosub setTermWindow
	print "### " proto$ " (" xferType$ ") ";
	gosub GetTimeMark
	startTimeMark = curTimeMark
return

getSize:
	& setdata SizeMenu
goto goMenu

getType:
	& setdata TypeMenu
goto goMenu

getOptions:
	a$ = proto$
	gosub goMenu
	if curItem then
		xferType$ = left$(mitem$[curItem], 1)
		if xferType$ = "T" then return
		& pos ("YZ", xferType$), batchMode
		if xferType$ <> "Z" then gosub getSize
	endif
	if options$ > "" then
		a$ = "Use previous " + proto$ + " options"
		gosub getYN
		if y then return
	endif
	if curItem then gosub getType
	if curItem then
		options$ = ""
		moduleTag$ = xferType$
		if xferType$ <> "Z" then
			if xferType$ = "Y" then
				options$ = "Y"
				moduleTag$ = "X"
			endif
			options$ = options$ + mid$(" CKL", lastItem%[mSize], 1)
		endif
		i$ = mid$("XT B", lastItem%[mType], 1)
		if i$ = "T" and xferType$ <> "Z" then i$ = "XT"
		options$ = options$ + i$
	endif
return
		


saveName:
	if newName$ > "" then
		newName$ = rcvDir$ + newName$
		& getinfo newName$, i$
		if i$ > "" then
			a$ = newName$ + " exists!^G  Replace"
			gosub getYN
			if y then
				fDelete newName$
				i$ = ""
			endif
		endif
		if i$ = "" then
			fRename F$ "," newName$
			return
		endif
	endif
	fDelete F$
return


' ==============================
' Menu Utilities
' ==============================

goMenu:
	read id%, menuType%, i$
	if i$ > "" then a$ = i$
	read itemCount
	for i = 1 to itemCount
		read mitem$[i]
	next
	if menuType% = SMENU_TYPE then read itemWidth, itemJust%
	curItem = lastItem%[id%]
	gosub doMenu
	if curItem then lastItem%[id%] = curItem
return

doMenu:
	gosub clrCmdLine
	print a$ ": ";
	hx% = peek(_CH80)
	if not curItem then curItem = 1
	keys$ = ""
	for i = 1 to itemCount
		keys$ = keys$ + left$(mitem$[i], 1)
	next
	& lcase(keys$)
	repeat
		if menuType% = HMENU_TYPE then
			& goto hx%, 0
			for i = 1 to itemCount
				if i = curItem then inverse
				print " " mitem$[i] " ";
				normal
			next
		else
			if itemJust% then
				& right$(mitem$[curItem], itemWidth), a$
			else
				& left$(mitem$[curItem], itemWidth), a$
			endif
			print "<";
			inverse
			print " " a$ " ";
			normal
			print ">";
			& hlin itemWidth + 4, 8
		endif	
		wait _KBD, 128
		a$ = chr$(peek(_KBD) - 128)
		poke _KBDSTRB, 0
		i = a$ = "^M" or a$ = "^["
		if not i then
			& lcase(a$)
			& pos (keys$, a$), i
			if i then
				curItem = i
				if menuType% = SMENU_TYPE then i = FALSE
			endif
		endif
		if not i then
			curItem = curItem - (a$ = "^H" or a$ = "^J")
			curItem = curItem + (a$ = "^U" or a$ = "^K")
			if curItem > itemCount then curItem = 1
			if curItem < 1 then curItem = itemCount
		endif
	until i
	if a$ = "^[" then curItem = 0
	gosub clrCmdLine
return


#ifndef APP_STAND_ALONE
' ==============================
' Scripting Interface Routines
' ==============================

tcScript:
	& setdata ScriptMenu
	gosub goMenu
	if curItem then
		on curItem gosub tcRun, tcGoto, tcScrEdit, tcCompile, \
		tcLoad, tcNew
		goto tcScript
	endif
return

tcNew:
	A$ = "New script"
	gosub getFileName
	goto tcSrcEdit2

tcScrEdit:
	A$ = "Edit"
	gosub getScriptFile

tcSrcEdit2:
	if F$ = "" then return

	& lcase(F$)
	if right$(F$, 4) <> Ext$ then F$ = F$ + Ext$
	gosub scriptPath

editFile:
	& lcase(F$)
	CommandLine$ = ID$[uEditor] + " " + F$

sublaunch:
	lastTerm% = -1		' Forces a reload
	fStore TmpFile$
	gosub replaceStatus
	ReturnPath$ = AppPath$
goto _Launch


getScriptFile:
	gosub waitMsg
	F$ = ""
	& files (SRC$, mitem$, 4), j
	itemCount = 0
	for i = 1 to j
		& lcase(mitem$[i])
		if right$(mitem$[i], 4) = Ext$ then
			itemCount = itemCount + 1
			mitem$[itemCount] = left$(mitem$[i], len(mitem$[i]) - 4)
		endif
	next
	if itemCount then		
		& sort (mitem$, itemCount)
		itemWidth = 15
		menuType% = SMENU_TYPE
		itemJust% = FALSE
		curItem = 1
		gosub doMenu
		if curItem then F$ = mitem$[curItem]
	endif
return

tcCompile:
	a$ = "Compile"
	gosub getScriptFile
	if F$ > "" then
		CommandLine$ = ITC$ + " " + F$
		goto subLaunch
	endif
return

scriptPath:
	& pos (F$, "/"), p%
	if not p% then F$ = SRC$ + F$
return

tcLoad:
	a$ = "Load"
	gosub getScriptFile
	if F$ = "" then return

verifyScript:
	gosub scriptPath

verifyScript2:
	fVerify F$
	gosub clrCmdLine
	print "Loading " F$;
	& load peek ommInfo, PARSER_ID, i$
	if i$ = "" then & load get MODULES + PARSER_NAME, i
	fOpen F$
	fRead F$
	input TL,LL,DL
	for I = 1 to TL
		& get a$
		if asc(a$) = 34 then
			a$ = mid$(a$, 2, len(a$) - 2)
			ParseBackslashes(a$, a$)
			ParseQuotes(34, a$, a$)
			ParseControls(a$, a$)
			ParseNormalize(a$)
		endif
		T$[i] = a$
	next 
	for I = 1 to LL
		input L$[I],L%[I]
	next 
	for I = 1 to DL
		input M%[I]
	next 
	fClose
	scriptLoaded = TRUE
return 



tcGoto:
	itemCount = LL
	for I = 1 to itemCount
		mitem$[i] = L$[i]
	next
	itemWidth = 20
	menuType% = SMENU_TYPE
	itemJust% = FALSE
	a$ = "Goto"
	gosub doMenu
	if curItem then
		a$ = mitem$[curItem]
		goto tcFkeyEnt
	endif
return


tcGotoFKey:
	a$ = "FKEY" + a$
	curItem = 0
	for I = 1 to LL
		if a$ = L$[i] then
			curItem = I
			I = LL
		endif
	next
	if not curItem then
		& ioctl(ioBeep)
		return
	endif

tcFkeyEnt:
	P = L%[curItem]
	gosub setTermWindow
	SP = 1
	S(SP) = - 1
	gosub clrCmdLine
	print a$ "...";
	gosub setTermWindow
goto startScript2


tcRun:
	a$ = "Run"
	gosub getScriptFile
	if F$ = "" then return
	gosub verifyScript

startScript:
	P = 1
	SP = 0
	gosub clrCmdLine
	print "Running "F$"...";
	gosub homeTerm

startScript2:
	& scrn (printerOff + printerMode%)

	repeat
		OP = M%(P)
		P = P + 1
		on OP gosub cmdDo,termMode,cmdGoto,\
			cmdHome,cmdPrint,cmdBaud,cmdDuplex,\
			cmdDial,cmdConnect,cmdReturn,cmdWaitFor,\
			cmdIf,cmdSend,cmdHangup,cmdSendFile,\
			cmdExit,cmdBreak,cmdPause,cmdEnd,\
			cmdExec,cmdRun,cmdPrinter,cmdEmulate,cmdFlush
	until OP <= 0

scriptError:
	gosub getCursorXY
	& beep
	a$ = "Script stopped"
	gosub doOK
	gosub setTermWindow

cmdEnd:
	P = 1
	SP = 0
	gosub getCursorXY
	inTerm% = TRUE
goto main


cmdExit:
	gosub getCursorXY
goto tcQuit


cmdExec:
	CommandLine$ = T$[M%[P]]
	P = P + 1
	inExec% = TRUE
goto sublaunch


cmdDo:
	SP = SP + 1
	S[SP] = P + 1
goto cmdGoto

cmdGoto:
	P = M%[P]
return 

cmdHome:
	home 
return 
	

cmdPrint:
	print T$[M%[P]];
	P = P + 1
return 
	

cmdBaud:
	& speed M%[P]
	P = P + 1
return
	

cmdDuplex:
	echoFlag% = M%[P]
	P = P + 1
return 
	

cmdDial:
	lastNum$ = T$[M%[P]]
	print lastNum$;
	& call lastNum$
	P = P + 1
return 
	

cmdConnect:
	gosub getCursorXY
	gosub clrCmdLine
	print "Connecting" EscCan$;
	& wait for CARRIER,I
	GOOD = not I
	print result$[I];
	gosub setTermWindow
	if I = 1 then
		A$ = result$[I]
		goto scriptError
	endif
return


cmdReturn:
	if not SP then 
		A$ = "'Return' Unexpected"
		goto scriptError
	endif
	P = S[SP]
	SP = SP - 1
	on P < 0 goto cmdEnd
return 
	

cmdWaitFor:
	& wait for T$[M%[P]],GOOD
	P = P + 1
return 
	

cmdIf:
	P = P + 1
	on GOOD = M%[P - 1] goto cmdGoto
	P = P + 1
return 
	

cmdSend:
	A$ = T$[M%[P]]
	P = P + 1
	if echoFlag% then print A$;
	& put(A$)
return 
	

cmdHangup:
	& hangup
return 
	

cmdSendFile:
	F$ = T$[M%[P]]
	P = P + 1
	SD = M%[P]
	P = P + 1
	C% = M%[P]
	P = P + 1
	& / F$,I$
	if I$ = "" then 
		A$ = "File '" + F$ + "' not found"
		goto scriptError
	endif
goto sendTextFile

cmdBreak:
	& break			' Ignore break time argument
	P = P + 1
return 


cmdPause:
	& wait M%[P]
	P = P + 1
return
	

cmdRun:
	F$ = T$[M%[P]]
	gosub verifyScript
goto startScript
	

cmdPrinter:
	printerMode% = M%[P]
	P = P + 1
goto startScript2
	

cmdEmulate:
	F$ = T$[M%[P]]
	gosub tsetTerminal
	P = P + 1
return
	

cmdFlush:
	& clear 
	P = P + 1
return

#endif


homeCarriage:
	if x% then
		gosub setTermWindow
		print
		gosub getCursorXY
	endif
return

homeTerm:
	X% = 0
	Y% = 2
	gosub setTermWindow
	home
return

sendTextFile:
	fOpen F$ ",T" peek(_FIFILID)
	fRead F$
	onerr goto sfEOF
	& on int goto sfInt
	do
		& get A$
		& print A$
		& put A$ + "^M"
		& clear 
		if SD then & wait SD
		if C% then 

			repeat
				& fn fnPortByte,I
				K = peek (_KBD) > 128
			until I = C% or K
			on K goto sfInt
		endif
	loop

sfInt:
	ERROR(0)

sfEOF:
	& onerr E,I
	onerr goto itHandleError
	& on int goto main
	GOOD = E = 5
	fClose
	gosub getCursorXY
	& clear 
return 


' ************************************************************
' **
' ** Time routines:

ElapsedTime:
	if endTimeMark <  startTimeMark then
		seconds = 86400 - startTimeMark + endTimeMark
	else
		seconds = endTimeMark - startTimeMark
	endif
return

GetTimeMark:
	&time(t$)
	curTimeMark = val(mid$(t$,16,2)) * 3600 + \
		val(mid$(t$,19,2)) * 60 + \
		val(mid$(t$,22,2))
return


' ==============================
  GetConnectSpeed:
' ==============================
	& fn fnModemType, connectSpeed
	if connectSpeed then
		& fn fnConnectSpeed, i$
	else
		& fn fnPortSpeed, connectSpeed
		connectSpeed = connectSpeed - ((connectSpeed > 5) * 6)
		i$ = mid$("  3  6 12 18 24 36 48 72 96192384576", \
			connectSpeed * 3 + 1, 3) + "00"
	endif
	connectSpeed = val(i$)
return


#define	APP_AT_EXIT dumpAllTools

#include <proline/fixname.lib>
#include <proline/proline.lib>

#ifndef APP_STAND_ALONE
#define	LAUNCH_PARSE
#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
#endif APP_STAND_ALONE
