' **********************************************************************
' ***
' ***	grep.b		Globally find regular expressions and print
' ***

#define IDENT_PROG "grep"
#define IDENT_VERS "1.1"
#define IDENT_DATE "28dec91"
#define IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	oREVERSE	1
#define	oCOUNT		2
#define	oNAME		3
#define	oLINENUM	4
#define oNONAME		5
#define	oNOCASE		6

	gosub AppInit

	gosub testOutput
	if accFile$ > "" then
		on not AccOK goto Exit
		if k = 1 and accMode > accWrite then fDelete accFile$
		outputFile$ = accFile$
	endif

	optchar$ = ""
	options$ = "vclnhy"
	repeat
		gosub getopt
		on optchar$ = "?" goto ShowUsage
		& pos (options$, optchar$), p
		f%[p] = 1
	until optchar$ = ""

	if nargc < 3 then goto ShowUsage

	pattern$ = nargv$[1]
	if f%[oNOCASE] then &ucase(pattern$)

	for i = 2 to nargc-1
		accFile$ = nargv$[i]
		& getinfo accFile$,t$
		if t$ = "" then 
			print argv$[0]": can't find "accFile$
			goto Exit
		endif
		type = asc (mid$(t$,5))
		accMode = accRead
		gosub CheckAccess
		if type = 15 or not accOK then 
			print argv$[0]": can't open "accFile$
			goto Exit
		endif

		l = 0
		f = 0
		onerr goto HandleError
		fOpen accFile$ ",T" type
		onerr goto eofError
		searchloop:
			fRead accFile$
			& get l$
			l = l + 1
			a$ = l$
			if f%[oNOCASE] then &ucase(a$)
			& pos (a$,pattern$),j
			f = f + (j > 0)
			on not j and \
				not f%[oREVERSE] or \
				(j and f%[oREVERSE]) or \
				f%[oCOUNT] goto searchloop
			gosub prepOutput
			if f%[oNAME] then 
				print accFile$
				goto nextFile
			endif
			if f%[oLINENUM] then 
				print l ":" ;
				if f%[oCOUNT] then l$ = ""
			endif
			& spc(l$,4),l$
			print l$
		goto searchloop

	eofError:
		& onerr e,l
		onerr goto HandleError
		if e <> 5 then
			error(e)
		endif
		if f%[oCOUNT] then
			gosub prepOutput
			print f
		endif

	nextfile:
		fClose accFile$
	next 
	if outputFile$ > "" then fClose outputFile$
goto Exit

ShowUsage:
	print "Usage: grep [-vclnhy] pattern file..."
goto Exit

prepOutput:
	if outputFile$ > "" then
		if not ofOpened then
			fAppend outputFile$
			ofOpened = TRUE
		else
			fWrite outputFile$
		endif
	endif
return

testOutput:
	accFile$ = ""
	if asc(argv$[argc-1]) = 62 then
		argc = argc - 1
		accFile$ = argv$[argc]
		k = len(accFile$)
		& spc (accFile$, 62), accFile$
		k = k - len(accFile$)
		gosub testAccFile
	endif
return

testAccFile:
	& getinfo accFile$,i$
	accMode = accWrite + accWrite * (i$ > "")
	gosub CheckAccess
	if not accOK then
		print argv$[0] ": can't open " accFile$
		status% = -1
	endif
return

#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
