' **********************************************************************
' ***
' ***	csmod.b		CS moderator's utility
' ***			(C)opyright 1993 Morgan Davis Group
' ***
' *** 09sep93 mwd 1.1	Added newsgroup interface
' ***

#define	IDENT_PROG "csmod"
#define IDENT_VERS "3.0"
#define	IDENT_DATE "16jan94"
#define IDENT_NAME "Morgan_Davis"

#define	TITLE	"CS Moderator's Tool"
#define	VERSTR	"Version " IDENT_VERS " " IDENT_DATE

#include <basic.h>
#include <proline/proline.h>

	gosub AppInit
	gosub Setup

	if not titleShown then
		gosub MainHelp
		titleShown = TRUE
	endif

	on editWhere% gosub EditTopic
	
	quitting = FALSE

	repeat
		print conference$ "> ";
		get a$
		& lcase(a$)
		& pos ("tmiojusq?/", a$), p
		on p + 1 gosub \
			BadInput, \
			TopicChanges, \
			ModeratorChange, \
			MainInfoFile, \
			OpenStatus, \
			JoinUser, \
			UnjoinUser, \
			SubscriberReport, \
			Quit, \
			MainHelp, MainHelp
	until quitting		
goto Exit


TopicChanges:
	print "Topics are:"
	print
	for i = 1 to topicCount%
		print "^I" i ".  " topic$[i]
	next
	print
	print "Which topic? (1-" topicCount%") ";
	& read (1),a$
	theTopic% = val(a$)
	if theTopic% > 0 and theTopic% <= topicCount% then
			topic$ = topic$[theTopic%]
			gosub TopicHelp
			gosub EditTopic
	endif
return

EditTopic:
	topicQuitting = FALSE
	repeat
		print conference$ "/" topic$ "> ";
		get a$
		& lcase(a$)
		& pos ("tnirq?/", a$), p
		on p + 1 gosub \
			BadInput, \
			TopicName, \
			NetworkChange, \
			TopicInfoFile, \
			ReadOnlyChange, \
			TopicQuit, \
			TopicHelp, TopicHelp
	until topicQuitting		
return

TopicQuit:
	print "Quit"
	topicQuitting = TRUE
return

TopicName:
	i$ = topic$
	& read (-15, i$), "Topic name: ", a$
	if a$ > "" and a$ <> topic$ then
		topic$[theTopic%] = a$
		fRename confDir$ "/" topic$ "," confDir$ "/" a$
		topic$ = a$
	endif
	print
return

NetworkChange:
	print "Network Changes^M"
	post$ = netAddress$[theTopic%]
	& pos(post$, ";"), p
	if p then
		group$ = mid$(post$, p + 1)
		post$ = left$(post$, p - 1)
	endif
	i$ = post$
	& read (-128,i$),        "  Posting address: ", post$
	if post$ > "" then
		i$ = group$
		& read (-128,i$),"   Newsgroup name: ", group$
		if group$ > "" then post$ = post$ + ";" + group$
		print            "Attach signatures";
		gosub GetYN
		includeSig%[theTopic%] = y
	endif
	netAddress$[theTopic%] = post$
	print
return


TopicInfoFile:
	CommandLine$ = ID$[uEditor] + " " + confDir$ + "/" + topic$ + "/info"
	editWhere% = 1
goto LaunchEditor
	
ReadOnlyChange:
	print "Read-only status is " mid$("FalseTrue", readOnly%[theTopic%] * 5 + 1, 5)
	print "Change it";
	gosub GetYN
	if y then readOnly%[theTopic%] = not readOnly%[theTopic%]
return
	
GetYN:
	print "? (Y/N) ";
	repeat
		get a$
		& ucase(a$)
		& pos ("NY", a$), y
	until y
	y = y - 1
	print a$
return
	
SubscriberReport:
	print "Subscribers to " conference$ "..."
	print
	user$[1] = ""
	& erase(user$)
	dim user$[1]
	& files (ADM_PATH, user$), i, j
	& erase(user$)
	dim user$[j]
	& files (ADM_PATH, user$), userCount%
	& sort (user$, userCount%)
	curUser% = 1
	subs% = 0
	while curUser% <= userCount%
		user$ = user$[curUser%]
		& lcase(user$)
		gosub LookupConference
		if joined then
			subs% = subs% + 1
			print user$,
		endif
		curUser% = curUser% + 1
	wend
	& erase (user$)
	print
	print
	print "(" subs% " total)"
	print
return

JoinUser:
	& read (15), "Join who? ", user$
	gosub LookupUser
	if i$ > "" then
		if joined then
			print user$ " is already joined to " conference$
		else
			print "Joining " user$ "...";
			addMode = TRUE
			gosub RewriteCSData
			print "done"
		endif
	endif
return


UnjoinUser:
	& read (15), "Unjoin who? ", user$
	gosub LookupConference
	if i$ > "" then
		if joined then
			print "Unjoining " user$ "...";
			addMode = FALSE
			gosub RewriteCSData
			print "done"
		else
			print user$ " is not joined to " conference$
		endif
	endif
return


RewriteCSData:
	csdataTmp$ = csdata$ + ".tmp"
	& getinfo csdataTmp$, i$
	if i$ then fDelete csdataTmp$

	fOpen csdata$
	fOpen csdataTmp$
	onerr goto rewriteEOF
	do
		fRead csdata$
		input cn$, j
		if cn$ = conference$ and not addMode then
			if j then
				for i = 1 to j
					& get
				next
			endif
		else
			fWrite csdataTmp$
			print cn$ "," j
			if j then
				for i = 1 to j
					fRead csdata$
					& get a$
					fWrite csdataTmp$
					print a$
				next
			endif
		endif	
	loop
	rewriteEOF:
	& onerr
	onerr goto HandleError
	if addMode then
		fWrite csdataTmp$
		print conference$ ",0"
	endif
	fClose
	fDelete csdata$
	fRename csdataTmp$ "," csdata$
return


LookupUser:
	& getinfo ADM_PATH + user$, i$
	if i$ = "" then
		print user$ " does not exist!"
		return
	endif

LookupConference:
	joined = FALSE
	csdata$ = ADM_PATH + user$ + "/csdata"
	& getinfo csdata$, i$
	if i$ > "" then
		fOpen csdata$
		fRead csdata$
		onerr goto csdataEOF
		do
			input cn$, j
			if cn$ = conference$ then
				joined = TRUE
				error(5)
			endif
			while j
				& get
				j = j - 1
			wend
		loop
		csdataEOF:
		onerr goto HandleError
		& onerr
		fClose
	endif
return


ModeratorChange:
	i$ = moderator$
	& read (-15, i$), "Moderator: ", a$
	& getinfo ADM_PATH + a$, i$
	if i$ = "" then
		print "No such user '" a$ "'"
	else
		moderator$ = a$
		print a$ " now moderates " conference$
	endif
return

OpenStatus:
	print "Open status is " mid$("FalseTrue", openStatus% * 5 + 1, 5)
	print "Change it";
	gosub GetYN
	if y then openStatus% = not openStatus%
return
	


MainInfoFile:
	CommandLine$ = ID$[uEditor] + " " + confDir$ + "/info"
	editWhere% = 0
LaunchEditor:
	print "Info file...";
	fStore CSModEnv$
	ReturnPath$ = AppPath$
	SetRoot = TRUE
goto _Launch

Quit:
	print "Quit"
	quitting = TRUE
	& getinfo CSModEnv$, i$
	gosub PutIndex
return

BadInput:
	print "Type ? for help"
return

MainHelp:
	& ioctl(ioNormal)
	& ioctl(ioClearScreen)
	if not titleShown then	
		print
		print TITLE
		print VERSTR
		print
	endif
	print
	print "^I^IModerating the '" conference$ "' conference"
	print
	print "^I^I<T>opic changes"
	print "^I^I<M>oderator change"
	print "^I^I<I>nfo file changes"
	print "^I^I<O>pen status change"
	print "^I^I<J>oin a user"
	print "^I^I<U>njoin a user"
	print "^I^I<S>ubscriber report"
	print "^I^I<Q>uit"
	print
return


TopicHelp:
	& ioctl(ioClearScreen)
	print
	print "^I^IChanging '" conference$ "/" topic$ "'"
	print
	print "^I^I<T>opic name change"
	print "^I^I<N>etwork changes"
	print "^I^I<I>nfo file changes"
	print "^I^I<R>ead-Only change"
	print "^I^I<Q>uit topic changes"
	print
return


' ====================
  Setup:
' ====================

	CSModEnv$	= TEMP_PATH + "csmod.env." + ID$[uUID]

	& getinfo CSModEnv$, i$
	if i$ > "" then
		fRestore CSModEnv$
		fDelete CSModEnv$
		return
	endif

	if argc < 2 then
		& print "Usage: " argv$[0] " conference"
		goto ExitError
	endif

	CSResources$	= RSRC_PATH + "cs.rsrc"

	& getinfo CSResources$, i$
	if i$ = "" then
		& print argv$[0] ": CS not installed"
		goto ExitError
	endif

	fOpen CSResources$
	fRead CSResources$
	& get csDir$
	fClose

	conference$ = argv$[1]
	& lcase(conference$)
	confDir$ = csDir$ + "/" + conference$

	& getinfo confDir$, i$
	if i$ = "" then
		& print argv$[0] ": '" conference$ "' conference not found"
		goto ExitError
	endif

	indexFile$ = confDir$ + "/i.."
	gosub GetIndex
	if not(SuperUser or (ID$[uName] = moderator$)) then
		& print argv$[0] ": can't moderate '" conference$ "'"
		goto ExitError
	endif
return


' ====================
  GetIndex:
' ====================
	fOpen indexFile$
	fRead indexFile$
	& get moderator$
	input openStatus%, topicCount%
	for i = 1 to topicCount%
		& get i$
		& pos (i$, ":"), p
		& pos (p + 1, i$, ":"), q
		if not p then p = len(i$) + 1
		if not q then q = 254
		topic$[i] = left$(i$,p - 1)
		netAddress$[i] = mid$ (i$,p + 1, q - p - 1)
		includeSig%[i] = val(mid$(i$, q + 1))
		input readOnly%[i], firstMsg[i], nextMsg[i]
	next
	fClose
return 


' ====================
  PutIndex:
' ====================
	fDelete indexFile$
	fOpen indexFile$
	fWrite indexFile$
	print moderator$
	print openStatus% "," topicCount%
	for i = 1 to topicCount%
		print topic$[i];
		if netAddress$[i] > "" then 
			print ":" netAddress$[i] ":" includeSig%[i];
		endif
		print
		print readOnly%[i] "," firstMsg[i] "," nextMsg[i]
	next 
	fClose
return 

#include <proline/proline.lib>

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
