' ***************************************************************************
' *
' *	csh.h		ProLine C-Shell Constants
' *			(C)opyright 1994 Morgan Davis Group
' *
' *	Files:		csh.h	-- header stuff (this one)
' *			csh.b	-- main startup/init stuff
' *			cshx.b	-- core shell stuff
' *
' * When      Who Ver   Description
' * ========= === ===== =====================================================
' *

#ifndef IDENT_PROG
#define	IDENT_PROG "csh"
#endif
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "12apr94"
#define IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>
#include <proline/parse.h>

#define	SHELL_VERSION	IDENT_PROG " " IDENT_VERS " " IDENT_DATE " C-Shell" \
			" / ProLine " + SysInfo$[plVersion]

#define	ENVNAME		"cshenv"
#define	CSHRC		"cshrc"
#define CSH_LOGIN	ID$[uHome] + "/login"
#define	CSH_RC		ID$[uHome] + "/" CSHRC

#define	VALID_EDITORS	";ed;edit;vedit;"

#define STARTUP_COMMAND	"source ~/login"
#define	INIT_COMMAND	"source ~/" CSHRC

#define	SHELL_COMMANDS  "A;exit B;logout C;cat D;pwd E;rm F;cd G;cp H;mkdir "\
			"I;mv J;echo K;set L;add M;alias N;read "\
			"O;clear P;unset Q;unalias R;source S;history "\
			"T;exec U;shift "

#define	COMMANDS_FUNCS	cmdExit, cmdLogout, cmdCat, cmdPwd, cmdRm, \
			cmdCd, cmdCp, cmdMkdir, cmdMv, cmdEcho, \
			cmdSet, cmdAdd, cmdAlias, \
			cmdRead, cmdClear, cmdUnset, cmdUnalias, \
			cmdSource, cmdHistory, cmdExec, cmdShift
			
#define	DIRECTIVES	"A;if B;else C;endif "
#define	DIRECTIVE_FUNCS	cmdIf, cmdElse, cmdEndif

#define	OPERATORS	"A;|| B;&& C;== D;!= E;! F;and G;or H;not "\
			"I;= J;< K;> L;<> M;>= N;<= "
#define	SUBOPS		"or and=  <> not"
#define SUBOP_NEXT	6

#define	PRINTER_DEVICE	".printer"

#define	VAR_SLASH	1
#define	VAR_ARGC	2
#define	VAR_ARGV	3
#define	VAR_CALLER	4
#define	VAR_CWD		5
#define VAR_DATE	6
#define	VAR_EDITOR	7
#define	VAR_GID		8
#define	VAR_HOME	9
#define	VAR_HOST	10
#define	VAR_LOGIN	11
#define	VAR_MAIL	12
#define	VAR_NAME	13
#define	VAR_PATH	14
#define	VAR_PROMPT	15
#define	VAR_SHELL	16
#define	VAR_SHLVL	17
#define VAR_SPOOL	18
#define	VAR_STATUS	19
#define	VAR_TIME	20
#define	VAR_TMPDIR	21
#define	VAR_TTY		22
#define	VAR_UID		23
#define	VAR_VERSION	24
#define	VAR_NEXT	25

#define	MAX_ALIASES	32
#define	MAX_ARGS	48
#define	MAX_VARS	20
#define	MAX_HISTORY	20

#define	STAFF_TIME	300
#define	ROOT_TIME	3300

#define	DIR_TYPE	$0F
#define	CMD_TYPE	$F0
#define	BAS_TYPE	$FC
			
' =============================================================================
'			      V A R I A B L E S
' =============================================================================

#declare argv$, argc, SuperUser, SysInfo$, ID$, AppPath$, ExitStatus%
#declare i, j, k, p, q, t, i%, j%, p%, q%, ifLevel%, skipLevel%
#declare envLevel%, dcd%, exitFlag%, printing%, execFlag%, exitOnEOC%
#declare a$, i$, j$, p$, CommandLine$, envFile$, var$, Shell$, ShellPath$
#declare history$, histHead%, histTail%, inHist%, histID%, q$, ShellXPath$
#declare commands$, directives$, theCommand$, realCL$, fileType%
#declare accMode, accOK, accFile$, accFile2$, status%, target$, stuffer$
#declare scriptFile$, scriptOpen%, scriptType%, scriptPos%, CLSave$
#declare varsDefined%, unsetBegin%, aliasBegin%, aliasesDefined%
#declare nextHistory, prevHistory, operators$, ParserPath$, prompting%
