' *****************************************************************************
' *
' *	csh.b		ProLine C-Shell Initialization
' *			(C)opyright 1994 Morgan Davis Group
' *
' * When      Who Ver   Description
' * ========= === ===== =======================================================
' *  7-Dec-91 mwd 1.5	Converted to MD-BASIC
' * 12-Jun-92 mwd 2.0b1 Split back into two parts
' * 21-Oct-93 mwd 2.1b2 Supports cshrc script
' *
' *
' *****************************************************************************

#include "csh.h"

' =============================================================================
'			   C - S H E L L   C O D E
' =============================================================================

	onerr goto HandleError
	gosub InitShell
	fChain ShellXPath$

	
InitShell:
	dim var$[VAR_NEXT + MAX_VARS + MAX_ALIASES], history$[MAX_HISTORY]
	q$ = chr$(34)

	gosub AppInit
	accFile$ = AppPath$
	gosub stripPath
	ShellPath$ = i$ + "/"
	Shell$ = mid$(accFile$, len(ShellPath$) + 1)
	accFile$ = argv$[0]
	if accFile$ > ""
		gosub stripPath
		accFile$ = mid$(accFile$, len(i$) + 2)
	endif

	ShellXPath$ = TEMP_PATH + Shell$ + "x"
	& getinfo ShellXPath$, i$
	if i$ = "" then ShellXPath$ = ShellPath$ + Shell$ + "x"

	a$ = PARSER_NAME
	ParserPath$ = TEMP_PATH + a$
	& getinfo ParserPath$, i$
	if i$ = "" then ParserPath$ = SysInfo$[plModulesDir] + a$

	gosub MakeEnvFile
	if Shell$ = accFile$ then
		CommandLine$ = ""
		if argc > 1 then
			exitOnEOC% = argv$[1] <> "-c"
			j = 2 - exitOnEOC%
			for i = j to argc - 1
				i$ = argv$[i]
				& pos (i$, " "), p
				if p then i$ = q$ + i$ + q$
				CommandLine$ = CommandLine$ + i$ + " "
			next
'			& spc(CommandLine$), CommandLine$
		else
			if not envLevel% then
				a$ = CSHRC
				scriptFile$ = SysInfo$[plTempDir] + a$
				& getinfo scriptFile$, i$
				if i$ = "" then
					scriptFile$ = ETC_PATH + a$
					& getinfo scriptFile$, i$
				endif
				if i$ = "" then
					scriptFile$ = i$
					CommandLine$ = STARTUP_COMMAND
				else
					scriptType% = asc(mid$(i$, 5))
				endif
			else
				& getinfo CSH_RC, i$
				if i$ > "" then CommandLine$ = INIT_COMMAND
			endif
		endif
		gosub NewShell
	else
		fRestore envFile$
	endif

	& timer(STAFF_TIME + ROOT_TIME * SuperUser)
	& timer on
	& fn fnCarrier, dcd%
	var$[VAR_TTY]	= "tty=" + mid$("consolemodem", 1 + dcd% * 7, 7)
	var$[VAR_EDITOR]= "editor="	+ ID$[uEditor]
	
MakeEnvFile:
	envLevel% = peek(sttyShell)
	envFile$ = SysInfo$[plTempDir] + ENVNAME + str$(envLevel%)
return

NewShell:
	poke sttyShell, envLevel% + 1

	var$[VAR_SLASH]	= "/="		+ SysInfo$[plDir]
	var$[VAR_CALLER]= "caller="	+ ID$[uCallerID]
	var$[VAR_CWD]	= "cwd="
	var$[VAR_DATE]	= "date="
	var$[VAR_GID]	= "gid="	+ ID$[uGID]
	var$[VAR_HOME]	= "home="	+ ID$[uHome]
	var$[VAR_HOST]	= "host="	+ SysInfo$[plNode]
	var$[VAR_LOGIN]	= "login="	+ ID$[uName]
	var$[VAR_MAIL]	= "mail="	+ MAIL_PATH + ID$[uName]
	var$[VAR_NAME]	= "name="	+ ID$[uFullName]
	i$ = SysInfo$[plDir]
	var$[VAR_PATH]	= "path="	+ PATH_LIST
	var$[VAR_PROMPT]= "prompt="	+ "!" + chr$(37 - 2 * SuperUser) + " "
	var$[VAR_SHELL]	= "shell="	+ ShellPath$ + Shell$
	accFile$ = SysInfo$[plSpoolDir]
	gosub stripSlash
	var$[VAR_SPOOL]	= "spool="	+ accFile$
	accFile$ = SysInfo$[plTempDir]
	gosub stripSlash
	var$[VAR_TIME]	= "time="
	var$[VAR_TMPDIR]= "tmpdir="	+ accFile$
	var$[VAR_UID]	= "uid="	+ ID$[uUID]
	var$[VAR_VERSION]= "version="	SHELL_VERSION
	var$[VAR_NEXT]	= "exit="

	varsDefined% = VAR_NEXT
	unsetBegin% = VAR_NEXT
	aliasBegin% = VAR_NEXT + MAX_VARS
	aliasesDefined% = 0
	histHead% = 0
	histTail% = 0

	& erase (argv$)
	dim argv$[MAX_ARGS]

	commands$ = SHELL_COMMANDS
	directives$ = DIRECTIVES
	operators$ = OPERATORS
return

stripPath:
	gosub fullPath
	& lcase(accFile$)
	& < accFile$, i$
return


fullPath:
	if asc(accFile$) <> 47 then
		fPrefix
		& get j$
		& lcase(j$)
		accFile$ = j$ + accFile$
	endif
stripSlash:
	if right$(accFile$,1) = "/" then
		accFile$ = left$(accFile$, len(accFile$) -1)
	endif
return 


#include <proline/proline.lib>
