' calendar	1.6
'
' Version 1.0  DJZ  14 Aug 91
' Version 1.1  DJZ  16 Aug 91
' Version 1.2  DJZ  18 Aug 91
' Version 1.3  DJZ   4 Sep 91
' Version 1.4  DJZ   8 Sep 91
' Version 1.5  DJZ  15 Sep 91
' Version 1.6  DJZ  11 Nov 91 - Added alternate eventfile, updated editor
' Last revision 28 Mar 92
'

#define IDENT_PROG "calendar"
#define IDENT_VERS "1.6"
#define IDENT_DATE "11nov91"
#define	IDENT_NAME "David_J_Zachmeyer"

#include <amperworks.h>
#include <proline/proline.h>
#declare ID$ EventFile$ FileInfo$ Access$ N P PageShown Event Calc Edit CheckYear
#declare Date$ DOW$ Month$ Month Day$ Day DPM Year$ Year DOY DeciYear
#declare LastEvent argc argv$ Command$ Command Characters NewEvent$ Flag$
#declare Advance DaysUntil Prompt$ Default$ MonthList$ Temp$ Changes Mode
#declare GetFile$ GetInfo$

#define Current		0
#define Check		1

GOSUB AppInit
EventFile$ = ID$[uHome] + "/events"

& GETINFO EventFile$,FileInfo$
IF FileInfo$ = "" THEN GOSUB No_Events

DIM Date$(100,1),DPM(12)
DATA	0,31,59,90,120,151,181,212,243,273,304,334

FOR N = 1 TO 12
	READ DPM(N)
NEXT N

MonthList$ = "***JanFebMarAprMayJunJulAugSepOctNovDec"

& TIME (Date$(Current,0))
Date$(Current,0) = LEFT$(Date$(Current,0),14)
Event = Current
GOSUB Calc_Date
GOSUB Get_Events

argc = argc -1
IF NOT argc THEN GOTO View

'Process shell arguments
IF argv$(1) = "-e" THEN

	IF argc > 1 THEN
		Mode = 1
		EventFile$ = Argv$(2)
		& GETINFO EventFile$,FileInfo$

		IF FileInfo$ = "" THEN
			LastEvent = 0
			GOSUB No_Events
		ENDIF

		GOSUB Get_Events
	ENDIF
	
	GOTO Editor
ELSE
	Mode = 1
	EventFile$ = argv$(1)
	& GETINFO EventFile$,FileInfo$

	IF FileInfo$ = "" THEN
		PRINT "<File '"EventFile$"' not found>"
		GOTO Exit
	ENDIF

	GOSUB Get_Events
	GOTO View
ENDIF

View:				'View calendar

IF NOT LastEvent THEN GOTO Exit

FOR Event = 1 TO LastEvent
	GOSUB Calc_Date
	
	DaysUntil = 0
	
	IF LEFT$(DOW$(Check),1) = "+" THEN
		DaysUntil = INT((DeciYear(Check)-DeciYear(Current))*365+.5)
		
		IF DaysUntil => 0 AND DaysUntil <= Advance THEN

			IF DaysUntil THEN Flag$ = "!"
		
			GOSUB Display
			GOTO Get_Next_Event
		ENDIF
	ENDIF

	IF DeciYear(Check) = DeciYear(Current) AND \
		DOW$(Check) = DOW$(Current) THEN GOSUB Display

Get_Next_Event:
NEXT Event

GOTO Finished

Calc_Date:
	Calc = (Event <> 0)
	DOW$(Calc) = LEFT$(Date$(Event,0),3)
	Advance = VAL(DOW$(Calc))
	
	IF DOW$(Calc) = "***" THEN DOW$(Calc) = DOW$(Current)

	Day$ = MID$(Date$(Event,0),6,2)
	Day(Calc) = VAL(Day$)

	IF Day(Calc) = 0 THEN Day(Calc) = Day(Current)

	Month$ = MID$(Date$(Event,0),9,3)
	& POS(MonthList$,Month$),N
	Month(Calc) = INT((N - 1) / 3)

	IF Month(Calc) = 0 THEN Month(Calc) = Month(Current)

	Year$ = RIGHT$(Date$(Event,0),2)

	Year(Calc) = VAL(Year$)
	
	IF Year$ = "**" THEN Year(Calc) = Year(Current)

	IF Mode = 0 AND Advance AND Month$ = "***" AND \
			Day(Current) > Day(Calc) THEN
		Month(Calc) = Month(Calc) + 1

		IF Month(Calc) = 13 THEN
			Month(Calc) = 1
			Year(Calc) = Year(Calc) + 1
		ENDIF
	ENDIF

	DOY(Calc) = DPM(Month(Calc)) + Day(Calc)
	DeciYear(Calc) = Year(Calc) + (DOY(Calc)/365)

	IF Mode = 0 AND Advance AND Year$ = "**" AND \
			DeciYear(Current) > DeciYear(Calc) THEN
		DeciYear(Calc) = DeciYear(Calc) + 1
	ENDIF

	Flag$ = MID$(Date$(Event,0),4,1)
RETURN

Display:
	IF NOT PageShown THEN

		IF NOT Mode THEN
			& POS (ID$[uFullName]," "),N
			PRINT LEFT$(ID$[uFullName],N-1)"'s Calendar:"
		ENDIF
		
		PRINT " ________________"
		PRINT "|                |"
		PRINT "| "Date$(Current,0)" |"
		PRINT "|________________|"
		PRINT
		PageShown = 1
	ENDIF
	
	IF DaysUntil THEN

		IF DaysUntil > 1 THEN
			PRINT DaysUntil" days until:"
			PRINT "  ";
		ELSE
			PRINT "Tomorrow:"
			PRINT "  ";
		ENDIF
	ENDIF

	IF LEN(Date$(Event,1)) > 4 THEN

		IF LEFT$(Date$(Event,1),5) = "File:" THEN
			GetFile$ = RIGHT$(Date$(Event,1),LEN(Date$(Event,1))-5)
			& GETINFO GetFile$,GetInfo$

			IF GetInfo$ <> "" THEN
				PRINT
				& IOCTL (16)
				& LIST GetFile$
			ELSE
				PRINT "<File '"GetFile$"' not found>"
			ENDIF
		ELSE
			PRINT Date$(Event,1)
		ENDIF

	ENDIF
	
	IF Flag$ <> "!" THEN Date$(Event,0) = ""

RETURN

Editor:
	Edit = (LastEvent <> 0)
	
Display_Event:
	PRINT
	
	IF Edit THEN
		Event = Edit
		GOSUB List_Event

	ELSE
		PRINT "<NO EVENTS>"
	ENDIF
	
	IF Edit AND Edit < LastEvent THEN PRINT "(n)ext, " ;

	IF Edit > 1 THEN PRINT "(p)revious, " ;
	
	IF LastEvent < 100 THEN PRINT "(a)dd, " ;

	IF Edit THEN PRINT "(d)elete, (c)hange, " ;

	PRINT "(q)uit >" ;
Get_Command:
	& GET(1),Command$
	& LCASE(Command$)
	& POS("npadcq",Command$),Command
	
	IF NOT Command THEN GOTO Get_Command

	IF Command = 1 AND Event AND Edit < LastEvent THEN
		PRINT "next"
		Edit = Edit + 1
		GOTO Display_Event
	ENDIF

	IF Command = 2 AND Edit > 1 THEN
		PRINT "previous"
		Edit = Edit - 1
		GOTO Display_Event
	ENDIF
	
	IF Command = 3 AND LastEvent < 99 THEN
		PRINT "add"
		PRINT
		PRINT "Enter new event:"
		Event = LastEvent + 1
		Date$(Event,0) = Date$(Current,0)
		Date$(Event,1) = Date$(Current,1)
		GOSUB Calc_Date
		GOSUB Enter_Event
		
		IF Command$ = "Y" OR Command$ = "y" THEN
			LastEvent = LastEvent + 1
			Edit = LastEvent
			Changes = 1
		ENDIF
		
		GOTO Display_Event
	ENDIF
	
	IF Command = 4 AND Edit THEN
		PRINT "delete"
		PRINT
		Default$ = "n"
		Prompt$ = "Are you sure (y/n)? "
		Characters = 1
		GOSUB Get_Input
		
		IF Command$ = "Y" OR Command$ = "y" THEN
			FOR N = Edit TO LastEvent - 1
				Date$(N,0) = Date$(N+1,0)
				Date$(N,1) = Date$(N+1,1)
			NEXT N

			LastEvent = LastEvent - 1

			IF Edit > LastEvent THEN Edit = Edit - 1

			Changes = 1
		ENDIF

		GOTO Display_Event
	ENDIF

	IF Command = 5 AND Edit THEN
		PRINT "change"
		PRINT
		PRINT "Change event:"
		Event = Edit
		GOSUB Enter_Event

		IF Command$ = "Y" OR Command$ = "y" THEN
			Changes = 1
		ELSE
			Date$(Edit,0) = Temp$(0)
			Date$(Edit,1) = Temp$(1)
		ENDIF
		
		GOTO Display_Event
	ENDIF
	
	IF Command = 6 THEN
		PRINT "quit"
		PRINT

		IF Changes THEN
			Prompt$ = "Save changes (y/n)? "
			Default$ = "y"
			Characters = 1
			GOSUB Get_Input
		
			IF Command$ = "Y" OR Command$ = "y" THEN
				GOSUB Write_Events
			ENDIF
		ENDIF

		GOTO Exit
	ENDIF

	GOTO Get_Command



List_Event:			' List information for event
	GOSUB Calc_Date

	IF Advance THEN
		PRINT Advance" day";

		IF Advance > 1 THEN PRINT "s";
		
		PRINT " advance notice --> ";
	ELSE
		PRINT LEFT$(Date$(Event,0),3)", ";
	ENDIF

	PRINT RIGHT$(Date$(Event,0),9)"   ";

	IF Flag$ = "!" THEN
		PRINT "SAVE ";
	ELSE
		PRINT "DELETE ";
	ENDIF

	PRINT "event after display"
	PRINT Date$(Event,1)
RETURN

Enter_Event:			' Enter information for event
	Temp$(0) = Date$(Event,0)
	Temp$(1) = Date$(Event,1)

	Prompt$ = "Advance notice of this event? "

	IF Advance THEN
		Default$ = "y"
	ELSE
		Default$ = "n"
	ENDIF

	Characters = 1
	GOSUB Get_Input

Get_Advance:
	IF Command$ = "Y" OR Command$ = "y" THEN

		Prompt$ = "Number of days (1-99): "
		
		IF Advance THEN
			Default$ = STR$(Advance)
			& RIGHT$(Default$,2,32),Default$
		ELSE
			Default$ = ""
		ENDIF

		Characters = 2
		GOSUB Get_Input
		
		Advance = INT(VAL(Command$))

		IF Advance < 1 THEN
			PRINT "Invalid number of days"
			Command$ = "Y"
			GOTO Get_Advance
		ENDIF
		
		DOW$(Check) = "+" + STR$(Advance)
		& LEFT$(DOW$(Check),3,32),NewEvent$(1)
		GOTO Get_Date
	ELSE
		Command$ = LEFT$(Date$(Event,0),3)
		& POS("***SunMonTueWedThuFriSat",Command$),N

		IF NOT N THEN & MID$(Date$(Event,0),1) = "***"

	ENDIF
	
Get_DOW:
	Prompt$ = "   Day of week (Sun-Sat,***): "
	Default$ = LEFT$(Date$(Event,0),3)
	Characters = 3
	GOSUB Get_Input
	
	GOSUB Capitalize
	& POS("***SunMonTueWedThuFriSat",Command$),N

	IF N = 0 THEN
		PRINT "Invalid day"
		GOTO Get_DOW
	ENDIF

	NewEvent$(1) = Command$

Get_Date:
	Prompt$ = "   Day of month (1-31,**): "
	Default$ = MID$(Date$(Event,0),6,2)
	Characters = 2
	GOSUB Get_Input
	
	IF (VAL(Command$) = 0 OR VAL(Command$) > 31) AND Command$ <> "**" THEN
		PRINT "Invalid date"
		GOTO Get_Date
	ENDIF

	& RIGHT$(Command$,2,32),NewEvent$(3)

Get_Month:
	Prompt$ = "   Month (Jan-Dec,***): "
	Default$ = MID$(Date$(Event,0),9,3)
	Characters = 3
	GOSUB Get_Input
	
	GOSUB Capitalize
	& POS(MonthList$,Command$),N

	IF N = 0 THEN
		PRINT "Invalid month"
		GOTO Get_Month
	ENDIF

	& LEFT$(Command$,3,32),NewEvent$(4)
	Prompt$ = "   Year (00-99,**): "
	Default$ = RIGHT$(Date$(Event,0),2)
	Characters = 2
	GOSUB Get_Input

	IF Command$ <> "**" THEN Command$ = STR$(INT(VAL(Command$)))

	& RIGHT$(Command$,2,32),NewEvent$(5)
	Prompt$ = "Message: "
	Default$ = Date$(Event,1)
	Characters = 70
	GOSUB Get_Input

	NewEvent$(6) = Command$
	Prompt$ = "Delete event after display (y/n)? "
	Default$ = "n"
	Characters = 1
	GOSUB Get_Input

	IF Command$ = "Y" OR Command$ = "y" THEN
		NewEvent$(2) = " "
	ELSE
		NewEvent$(2) = "!"
	ENDIF
	
	Date$(Event,0) = NewEvent$(1) + NewEvent$(2) + " " + \
		NewEvent$(3) + " " + NewEvent$(4) + " " + NewEvent$(5)
	Date$(Event,1) = NewEvent$(6)
	PRINT
	GOSUB List_Event
	Prompt$ = "Is this correct (y/n)? "
	Default$ = "y"
	Characters = 1
	GOSUB Get_Input
RETURN

Capitalize:
	IF LEN(Command$) = 3 THEN
		& UCASE(Command$)
		Temp$ = RIGHT$(Command$,2)
		& LCASE(Temp$)
		Command$ = LEFT$(Command$,1) + Temp$
	ELSE
		Command$ = "###"
	ENDIF
RETURN

Get_Input:
	PRINT Prompt$;Default$;
	& STR$ (LEN(Default$),8)
	& READ (Characters),Command$

	IF Command$ = "" THEN Command$ = Default$

	& IOCTL (16)

	FOR P = 1 TO LEN(Prompt$)
		& IOCTL (18)
	NEXT P

	PRINT Command$;
	& IOCTL (4)
	PRINT

RETURN

Get_Events:
	LastEvent = 0
	fOpen EventFile$
	fRead EventFile$

	REPEAT
		& GET Date$(1,0)
		& GET Date$(1,0)
		LastEvent = LastEvent + 1
	UNTIL Date$(1,0) = "END"

	fClose EventFile$

	LastEvent = LastEvent - 1

	IF LastEvent = 0 THEN RETURN

	IF LastEvent > 99 THEN
		PRINT "'events' file too large!"
		GOTO Exit
	ENDIF

	fOpen EventFile$	
	fRead EventFile$
	& GET Date$(1,0)
	
	FOR Event = 1 TO LastEvent
		& GET Date$(Event,0)	' get date
		& GET Date$(Event,1)	' get text
	NEXT Event

	fClose EventFile$
RETURN

Write_Events:
	& GETINFO EventFile$,FileInfo$
	Access$ = MID$(FileInfo$,4,1)
	
	fDelete EventFile$
No_Events:
	fOpen EventFile$
	fWrite EventFile$

	PRINT "DOW  Dy Mon Yr"

	IF LastEvent THEN	
		FOR Event = 1 TO LastEvent

			IF Date$(Event,0) <> "" THEN
				PRINT Date$(Event,0)
				PRINT Date$(Event,1)
			ENDIF
			
		NEXT Event
	ENDIF
	
	PRINT "END"
	fClose EventFile$

	IF FileInfo$ <> "" THEN
		& GETINFO EventFile$,FileInfo$
		FileInfo$ = LEFT$(FileInfo$,3) + Access$ + RIGHT$(FileInfo$,14)
		& SETINFO EventFile$,FileInfo$
	ENDIF
	
RETURN

Finished:
	IF PageShown THEN
		GOSUB Write_Events
		& STR$(18,95)
		PRINT
		PRINT
	ENDIF
	GOTO Exit

#include <proline/proline.lib>
