.TH SCRIPTS M
.DA 5 May 1992
.SH Name
scripts - All about shell scripts
.SH Description
This entry is an addendum to the C-Shell (_csh_) entry.  Refer to _csh_
first for introductory details on shell script files.
.PP
Shell scripts are text files that contain commands to be executed
as a batch operation by the shell.  Anything that can be performed at the
shell prompt can be executed from a shell script.  Here's a sample:
.IP 5
.AF
# First, set up some command aliases
alias   ls      ls -F
alias   c       "clear; ctime"
alias   send    sx -yl
alias   recv    rx -yl
.BR
# Now print out a random, hopefully humorous adage
fortune
.BR
mail -n         # read new mail (if any)
.BR
# Lastly, set up some variables
set bob=$/usr/bob
set prompt="\$time[4]> "
.AF 1
.IP
A file such as this can be created using a text editor and saved in your
user directory.  You can execute it from the shell just by typing
``source file'', where ``file'' is the name of the script you just created. 
.PP
You can avoid having to enter the shell's ``source'' command to run
a shell script by changing the filetype attribute of the script to ``cmd''.
To change a text file to an executable ``cmd'' (command) file, use the _setfile_
command.  If you've just created a script and named it ``wonka'', for example,
the command:
.IP 5
.AF
setfile -t cmd wonka
.AF
.IP
makes it executable.  To run it, you simply enter its name.  Note that
the editor can edit ``cmd'' files as if they were ordinary text files, so
using _setfile_ is only necessary once after the file is first created
(editing the file does not change its type).  If you plan on creating
many shell scripts, they're typically stored in a directory called ``bin''
in your $home directory (e.g. $home/bin/wonka).
.PP
There is a special ``cmd'' file named ``login'' in your directory which is
automatically executed after logging in.  You can use an editor to
tailor it to your heart's desire, making your session on ProLine a
unique experience.
.PP
.PP Special Script Commands
.BR
Your scripts have the ability to use some special commands that allow for
greater flexibility in the way they execute:
.IP 10 exit
halt a running script and return control back to the shell for regular
keyboard-based command input.  The _exit_ command accepts a numeric
argument as a result code to pass back to the shell or calling process.
Any non-zero result is considered an error. If no argument is given,
zero is assumed (no error).
.IP 10 if
test for a certain condition, such as the existence of a file.  If the
condition is true, script execution continues with the commands which follow
until an _else_ or _endif_ command is encountered. If the condition is false,
the first _else_ or _endif_ command on a new line is searched for, and
execution will continue with the commands that follow it.  (See _if_ for
complete details on if, else, and endif)
.IP 10 read var
read a line of input from the user and assign it to a shell variable.
.IP
You can place comments into your scripts by putting a pound-sign (#)
before each comment.  The shell ignores anything that follows.
.PP
Scripts can also make use of any arguments that are entered at the
command line when the script was launched.  This is done by making reference
to the argc and argv shell variables which hold the argument count and
argument list respectively.
.PP
Consider following script called ``view'':
.IP 10
.AF
if $argc < 2 then
     echo -n "Name of file to view? "
     read file
else
     set file=$argv[1]
endif
.BR
if ! -f $file then
     echo Can't seem to find $file!
     exit -1
endif
echo ------------------
cat $file
echo ------------------
.AF 1
.IP
View begins by checking the argument count in argc.  Since the command
itself is part of the argument list, the argument count is always one plus
the number of arguments following the command.
.PP
If $argc is less than two, meaning it must be one because only the name of
the script was entered, then it prompts the user to enter a file name.
Otherwise, if $argc is two or more, it assigns the file variable to the
first argument, $argv[1].
.PP
Next, the view script tests for the existence of the file.  The ``!'' operator
is a logical NOT, which reverses the logic.  Thus, the statement reads,
``if the file does not exist''.  Should the file be non-existent, an
error message is printed, and the script exits with -1, which sets the
shell's status variable to -1.
.PP
If the file does exist, it is displayed, bordered by lines of dashes.
.PP
.PP Ignoring Errors
.BR
Normally, if an error occurs (due to a command or process that
returns a non-zero result), a running script is halted.  To avoid this,
unset the exit shell variable.  To restore normal error handling,
set exit (no assignment value is necessary -- it just has to exist).
.SH Note
A script can call another script as a command, but when the second script
stops, the first one WILL NOT resume execution.  To have execution of the
calling script resume, launch the second script through a new shell.  Example:
.IP 5
.AF
# This is the first script
$shell source script2       # invoke 2nd script via a new shell
echo It worked              # when the 2nd is done, it returns here
# end of first script
.AF 1
.IP
The ``shell'' variable contains the pathname to the current shell program.
.SH See Also
csh(C), if(C), setfile(C), source(C)
