.TH MAP F
.DA 30 March 1994
.SH Name
map - Networking map file
.SH Description
Map files are used to catalog and identify ProLine systems in our
network. Each ProLine site must create its own map entry file and submit
it for processing, or else the rest of the network will not know the
site exists.
.PP
In the event that paths databases are automatically generated as a
result of processing map files, network sites depending on automatic
routing and smart mailers to handle delivery require your map entry to
be accurate.  Inaccurate data will, at the least, cause delayed or more
expensive deliveries, and at the most, failed deliveries.
.PP
.PP Building Your Map
.BR
You'll need to create your map entry file in any text editor. All lines
beginning with `#' are comment lines to _pathalias_, however the UUCP
Project has defined a set of these comment lines to have a specific format
so that a complete database can be built.
.PP
Each comment field in your map entry file uses this format:
.IP 5
#<field id letter><tab><field data>
.IP
Note that <tab> means the actual Control-I character (ASCII 9), or six
spaces to put you into the next tab column.
.PP
The entry should begin with the #N line, and end with a blank line after the
routing data.  The final blank line is important in that it denotes the
end of your routing list.  Here's a template:
.PP
.AF
#N      sitename
#S      Machine type; operating system
#O      Organization name
#C      Contact person's name
#E      Contact person's electronic mail address
#T      Contact person's telephone number
#P      Organization's address
#L      Latitude / Longitude
#R      Remarks
#U      Netnews neighbors
#W      Who last edited the entry; Date edited
#
sitename        remote1(FREQUENCY), remote2(FREQUENCY),
                remote3(FREQUENCY)
.AF 1
_(one blank line goes here!)_
.PP
Example of a completed entry:
.PP
.AF
#N      pro-sol
#S      Apple IIGS; ProLine 2.0
#O      Morgan Davis Group
#C      Morgan Davis
#E      mdavis@pro-sol.cts.com
#T      +1 619 670 0563
#P      10079 Nuerto Lane, Spring Valley, CA 91977-7132
#L      32 47 N / 116 56 W
#R      24 hour operation at +1 619 670 5379
#R      300 to 9600 bps V.32, V.42, V.42bis
#W      pro-sol!mdavis (Morgan Davis); Wed Jun 15 18:00:00 PDT 1988
#U
#
pro-sol pnet01(HOURLY-5), pro-mercury(HOURLY), pro-mars(HOURLY-5),
        pro-sat(HOURLY), pro-simasd(HOURLY-5), pro-test(HOURLY),
        pro-carolina(EVENING), pro-exchange(WEEKLY/2), pro-party(WEEKLY),
        pro-angmar(WEEKLY/2), pro-charlotte(WEEKLY), pro-colony(WEEKLY),
        pro-pac(WEEKLY), rti-austin(DAILY), pro-hobbyist(DAILY),
        pnet08(DAILY*2), pro-avalon(HOURLY), pro-vide(HOURLY+5),
        pro-starbase(DAILY), pro-ascii(HOURLY), pro-la(WEEKLY)
.AF 1
.PP
Be sure to include that final blank line at the end of your map file,
because maps are submitted through the mail system which can attach
signature files to the end of your messages.
.PP
.PP Map Fields
.BR
The following is a description of each field in the map entry.  Each field
prefix should be present in your map, even if the field is blank.
.IP 5 #N
Your system's name.  One of our goals is to keep duplicate host names
from appearing because there exist mailers in the world which assume no
duplicates (and attempt UUCP path optimization on that basis), and it's
just plain confusing to have two different sites with the same name.
.IP 5 #S
This is a quick description of your equipment (i.e., ``Apple IIGS''),
followed by the version of ProLine you're running.
.IP 5 #O
This should be the name of your organization (company, school, computer
club, etc.), squeezed to fit inside 80 columns as necessary.
.IP 5 #C
The full name (or names, separated by commas) of the person
responsible for handling queries from the outside world about your machine.
.IP 5 #E
This should be just a machine name, and a user name, like ``pro-sol!mdavis''.
The site name does not have to be the same as the #N field
(i.e. the contact ``lives'' on another machine at your site).
.IP 5
Multiple electronic addresses should be separated by commas, and all of
them should be specified in the manner described above.
.IP 5 #T
Telephone number of the contact person in this format:
.IP 10
+1 415 642 1024
.IP 5
This is the international format for the representation of phone numbers.
The country code for the United States of America (and Canada) is 1. Other
country codes should be listed in your telephone book.  If an extension
is needed, use this format:
.IP 10
+1 415 549 3854 x37
.IP 5
Multiple phone numbers should be separated by commas, and all of them
should be completely specified as described above to prevent confusion.
.IP 5 #P
Postal address of the contact person.  Include all information necessary
for anyone in the world to reach the address through paper mail.
.IP 5 #L
The site's latitude and longitude (or nearest approximation).
This should be in the following format (two fields, with optional third):
.IP 10
DD MM [SS] N|S / DDD MM [SS] E|W [``city'']
.IP 5
The first number is Latitude in degrees (DD), minutes (MM), and seconds (SS),
and a N or S to indicate North or South of the Equator.
.IP 5
A slash separator.
.IP 5
Second number is Longitude in degrees (DDD), minutes (MM), and seconds
(SS), and a E or W to indicate East or West of the Prime Meridian in
Greenwich, England.
.IP 5
Seconds are optional, but it is worth noting that the more accurate you
are, the more accurate maps we can make of the network (including blow-ups
of various high density areas, like New Jersey, or the San Francisco Bay Area).
.IP 5
If you give the coordinates for your city (i.e. without fudging for where
you are relative to that), add the word ``city'' at the end of the end of
the specification, to indicate that.
.IP 5
If you're not sure of your coordinates, call any land surveying company
in your area, or your local government offices.
.IP 5 #R
Remarks. As noted before, all lines beginning with
a `#' character are comment lines, so if you need more than one line to
tell us something about your site, do so before the other fields.
.IP 5 #U
Network news neighbors. The Internet is the network that moves netnews
around.  Unless you receive news directly from an Internet site, leave
this blank.
.IP 5 #W
Who last edited the map entry and when. This field contains an e-mail
address, a name in parentheses, followed by a semi-colon, and the output
of the UNIX date program. Example:
.BR 2
.AF
pro-sol!mdavis (Morgan Davis); Sat Feb 23 05:03:00 PST 1988
.AF 1
.BR
The rules that apply in the contact's e-mail address
apply here also. (i.e. only one system name, and user name). This
field is used for automatic aging of the map entries.
.IP
.PP The Connectivity List
.BR
After all the `#' fields comes a list of systems that your site
talks to directly.  This list begins at the left margin with the name of your
site, followed by the remote systems yours talks to.  Commas are used to
separate each site in the list, and any sites that are positioned on
following lines must begin with one or more tabs.  Example:
.IP 5
.AF
pro-test        pnet01(DIRECT), pro-sol(HOURLY),
                pro-lumen(DAILY/4)
.AF 1
.IP
Immediately following the LAST entry in this list is a completely blank
line.
.PP
The items in parenthesis which immediately follow a site name are
imaginary cost values associated with that connection.  Cost values
are measured in both frequency of polling and/or answering times,
in addition to other factors (such as long distance charges, modem
speeds, etc.).  _Pathalias_ uses these values to calculate the lowest
cost routes from site to site.
.PP
The cost breakdown is:
.IP 5
DIRECT
.TB 20
200
.TB 30
Local call, many connections per hour
.BR
DEMAND
.TB 20
300
.TB 30
Toll call, many connections per hour
.BR
HOURLY
.TB 20
500
.TB 30
One connection per hour
.BR
EVENING
.TB 20
1800
.TB 30
Multiple calls during low-rate hours
.BR
POLLED
.TB 20
5000
.TB 30
One or more polls per day by remote site
.BR
DAILY
.TB 20
5000
.TB 30
One connection per day
.BR
WEEKLY
.TB 20
30000
.TB 30
One connection per week
.BR
DEAD
.TB 20
(high)
.TB 30
Temporarily inoperable connection
.IP
If a site goes down for good, or you decide to discontinue connections
with one, remove the site and its cost entirely from your map.  A DEAD
cost means that you're still connected and you accumulate mail for
that site.
.PP
Incrementals of these costs can be used, too.  For example, DAILY*2 would
mean every other day.  DAILY/2 could mean twice a day or twice an evening if
EVENING isn't quite the right description of the connection.
.PP
.PP Steps For Determining Costs
.BR
Due to the nature of the ProLine software, DIRECT and DEMAND are
impossible costs to use.  These indicate a connection where your site
would immediately poll another upon receipt of mail for that site. 
ProLine polls on a schedule, not because of the immediate presence of
outgoing mail.  Do not use these costs.
.PP
The best a ProLine can do is HOURLY, and that is only possible
if a site makes two or more attempts to poll another site in the course of
an hour.  This is because ProLine can only poll when it is not busy doing
something else (system maintenance or hosting a user).  It realistically
cannot connect once an hour unless it makes multiple attempts (every
15 to 30 minutes).  If a sites a single attempt each hour to connect with
another site, the cost is probably more accurate as HOURLY*3 (meaning, every
three hours).
.IP 5 1.
Use the above values to establish a starting point for your connectivity,
and base it only on the sites that you call.
.IP 5 2.
Next, for each site that calls you, estimate the costs based on the
frequency of calls you receive.  If the estimated cost of incoming calls
is _lower_ than your initial cost, use the lower value.  If it is the
_same_ or _higher_, make no changes.  Do not add or subtract values
based on two-way communications.  If the site that calls you is one you
don't call, use POLLED.
.IP 5 3.
At this point, you should see that your calls are the primary cost
factor, and calls you receive might lower cost, but will never
increase it.
.IP
.PP Fudge Factors
.BR
You can include values to raise or lower a cost to show preference or
avoidance.  Typical values might be a -10 preference for a high speed
connection, or a +5 or +10 to avoid a certain site for which there might
be several parallel paths.  Example: pro-site(HOURLY+10).
.PP
You can also declare a high cost to a site if you don't want net traffic for
that site going through your machine.  Such an entry will not effect your
local use of that connection.
.PP
.PP Storing Your Map Entry File
.BR
After you create your map file, place a copy of it in the $/sys/maps
directory using the name of your site as the filename in legal ProDOS
format.  For example, ``$/sys/maps/pro.sol''.
.PP
At the present, $/sys/maps is used only for local map entry storage. 
But as tools become available for building and updating maps right on a
ProLine system, this directory will become more important.
.PP
.PP Submitting Your Map Updates
.BR
After creating your map entry, you must submit it to the map coordinator
for archiving and potential processing.  Using the electronic mail
system, send your map to:
.IP 5
mapcoord@pro-sol
.IP
(If you use _rcp_ to send it, be sure to specify ASCII text format with the
-a option).
.PP
Currently, map submissions are archived on pro-sol.cts.com (available via
mail server request), and various site list maintainers.
.SH Files
$/sys/maps/* - map storage area.
.SH See Also
aliases(F), intro(NET)
