.TH ALIASES F
.DA 30 March 1994
.SH Name
aliases - Description of mail alias files
.SH Description
When the mail system is unable to recognize an address, it can search
two alias databases for a valid address. Mail aliases come in two forms:
user aliases and path aliases.  A user alias is one which replaces the
username in a mail address.
.PP
For example, if the system did not recognize the user ``jsbach'', it
would look up jsbach in the user aliases database. If the system is
instructed to send mail to pro-sample!user, and it does not talk
directly to pro-sample, it would look it up in the paths database.
.PP
If the mailer can't recognize a user or site name, and it can't find a
matching alias in either of the two databases, it will forward the message
back to the sender with an error message.
.PP
.PP User Aliases
.BR
The user alias database is the file $/etc/aliases.  It contains lines in the
form:
.IP 5
.AF
# This is a comment
root:           ~mdavis
sysop:          ~mdavis
mdss:           ~mdavis
postmaster:     ~mdavis
rnews:          ~rnews
null:           ~            # Mail just evaporates
news-update:    >/a/etc/news # Mail is written to a file
weather:	>>/a/etc/wx  # Mail is appended to a file
bblue:          bblue@crash
friends:        danield, tom, bob, jay@snnark.uucp,
                jim@fpr.com, ddavis, jholt@adobe.com
my-group:       ~my.group
.AF
.IP
As shown, the username to match is followed by a colon, and the alias to
replace that name follows.  Multiple addresses in the alias can be
given; this denotes a distribution list.  If there are more names in a
list than can fit on one line, extra lines can be included on subsequent
indented lines, as shown in the friends entry.
.PP
Comments can be inserted by prefixing them with the pound-sign (#).
Anything following the pound-sign up to the end of the line is ignored.
.PP
If a message was addressed to ``bblue'', it would be replaced with
``bblue@crash'' and passed back to the mailer for routing through the
``crash'' site.
.PP
If a local address in the list begins with a tilde (~), it forces
sendmail to write the message into the named mailbox without verifying
that the address is an actual user on the system.  For example, the
my-group entry is aliased to ~my.group.  Any mail sent to my-group is
added into the $/sys/mail/my.group mailbox, even though no user exists with
that account name.  If no mailbox names follows the tilde, letters to
that alias are discarded.
.PP
If an address in the list begins with >, the letter is written into
the pathname that follows, replacing it if it exists.  If the address
begins with >>, the letter is appended to the pathname that follows.
.PP
.PP Path Aliases
.BR
The path alias database is the file $/etc/paths.  It contains lines formatted
in the same manner as user aliases.  Example:
.IP 5
.AF
.RC 1 .
cts.com: crash!*
alphalpha: pro-angmar!alphalpha!*
baron: pnet07!baron!*
cerf.net: pro-nbs!pro-fred!cerf.net!*
crash: crash!*
pro-aasgard: pro-aasgard!*
.AF 1
.IP
The sitename to match is followed by a colon, and the alias to replace
that name is last.  The asterisk shows where the remainder of the path
should be placed into the address.
.PP
Comments can be included following the pound-sign (#).
.PP
If a message was addressed to ``baron!jcurtis'', the path alias entry would be
substituted and the full address would expand to ``pnet07!baron!jcurtis''.
.SH Notes
An alias can contain another alias, as long as they don't cause an infinite
loop to result.  Nested aliases should be avoided, however, since it causes
the mailer to work extra hard to resolve a route.
.PP
To speed up searches through these databases, copy them to your temporary
directory ($tmpdir) if it is a RAM disk.  Using _cp_ commands in your
$/etc/rc startup script is a good place to do this.
.SH Files
$/etc/aliases - user alias database,
.BR
$/etc/paths - path alias database
.SH See Also
domains(NET), forward(F), map(F), sendmail(C)
