.TH SETFILE C
.DA 16 May 1992
.SH Name
setfile - Set file attributes
.SH Syntax
setfile [ _options_ ] _file_...
.SH Description
Sets attributes for one or more _files_.  The _options_ apply to all
files listed.  Options are:
.IP 10 -a flags
Sets or clears the file attributes.  The _flags_ string is composed of
the characters listed below.  Attributes that aren't listed remain
unchanged.
.BR 2
D = Destroy enable
.BR
N = Rename enable
.BR
B = Backup needed
.BR
I = Invisible
.BR
W = Write enable
.BR
R = Read enable
.BR 2
Uppercase letters set the attribute to 1; lowercase letters
clear it to 0.  For example,
.BR 2
.AF
setfile -a dnwbR Filename
.AF
.BR
Clears the Destroy, Rename, Write, and Backup bits, and sets
the Read bit.  This means that the file cannot be deleted,
renamed, or written to, but it can be read from.  The backup
bit is also cleared, which tells backup programs
that the file doesn't need to be backed up.
.IP 10 -at type
Sets the auxilliary type.  _Type_ may be specified either in
decimal or hexadecimal form.  Hexadecimal numbers must be
preceded by a `$' character or ``0x'' character sequence.
.IP 10 -c date
Set the creation date.  _date_ is a string in one of the forms
listed:
.BR 2
.AF
mm/dd/yy
"mm/dd/yy hh:mm"
"mm/dd/yy hh:mm AM"
"mm/dd/yy hh:mm PM"
.AF
.BR 1
representing the month (1-12), day (1-31), year (0-99), hour
(0-23), and minute (0-59).  The string must be
quoted if it contains a space.  A period (.) indicates the
current date and time.
.IP 10 -m date
Set the modification date.  _Date_ is the same format as for
the -c option.  A period (.) indicates the current date and time.
.IP 10 -t type
Sets the file type.  _Type_ may be specified as a decimal
number, a hexadecimal number when preceded by a `$' or ``0x''
character(s), or a 3-character filetype mnemonic.
.IP 10 -s size
Sets the file's size in bytes.  _Size_ may be specified as a decimal
number or a hexadecimal number when preceded by a `$' or ``0x''
character(s).
.IP
.PP Examples
.BR
.AF
setfile -a b -m \. foo.asm
.AF
.PP
Clears the backup-needed access attribute bit, and set's the
modification date to the current date and time on the file ``foo.asm''.
Note that the shell interprets a period as a reference to the
current working directory, thus the backslash (\) is used to include
the period for _setfile_.
.PP
.AF
setfile -m "07/03/90 02:25" mbox
.AF
.PP
Sets the modification date to July 3, 1990, and 02:25 A.M. on ``mbox''.
Note that the date string is quoted, since it contains a space, and that
AM is assumed when the hour is less than 13 and no AM or PM is
specified.
.PP
.AF
setfile Foo -t bin Bar -s 4096 Baz -at 0x4000
.AF
.PP
Operates on the files Foo, Bar, and Baz, setting their types to BIN ($06),
auxiliary types to $4000, and their sizes to 4096 ($1000 or 0x1000) bytes.
Note how filenames and options can be intermixed.
.SH See Also
dstat(C), ls(C), sweep(C)
