.TH RX C
.DA 17 May 1992
.SH Name
rx - Receive files using XMODEM or YMODEM
.SH Syntax
rx [ _options_ ] [ _file_... ]
.SH Description
_Rx_ receives files using XMODEM or YMODEM transfer protocol.
.PP
If _rx_ is used for receiving files with XMODEM, it invokes an XMODEM
receive for each _file_ given on the command line.  Files are assigned
the names given in the command line in the order in which they are
received.
.PP
If YMODEM batch is used to receive files, the _file_ argument(s) are
optional.  If given, however, the files received are assigned the names
given on the command line, rather than those supplied by the sender.
.PP
A number of options control the transfer characteristics:
.IP 5 -b
Binary II mode (Apple II).  This causes _rx_ to unwrap files in Binary II
format.  This restores directory information unique to the file, and required
by the ProDOS operating system.
.IP 5 -c
128-byte blocks with CRC-16.
.IP 5 -d
Double delay tolerance.  This effectively doubles the time that _rx_ allows
for responses over sluggish packet-switched networks.
.IP 5 -f
Accept full pathnames from the sender -- the prefix to the file plus the
file's name.
.IP 5 -k
1K blocks with CRC-16.
.IP 5 -l
4K blocks with CRC-16.
.IP 5 -p
ProDOS mode (Apple II).  Like the Binary II mode, this option employs an
extension unique to some Apple II terminal programs to transfer file
information.  This scheme has been made obsolete by the Binary II standard,
but is included for compatibility with older programs.
.IP 5 -r
Replace existing files.
.IP 5 -t
Text mode.  This mode converts end of line characters (newlines) to be
compatible with all operating systems.  Include this option whenever text
files are received to ensure proper newline conversion.  Newline characters
are Control-M in Apple II and Macintosh operating systems, Control-J in UNIX,
and Control-M Control-J in MS-DOS.
.IP 5 -v
Verbose 1K and 4K modes.  When the -k or -l modes are used, -v causes them
to initiate the transfer by sending ``CK'' or ``CKL'' to the sender. Normally,
only `C' is sent.
.IP 5 -y
YMODEM batch mode receive with at least 1K blocks and CRC-16.  YMODEM-g
mode is not supported for receiving.
.IP
Without options, _rx_ receives files in plain 128-byte XMODEM protocol using
checksums for error correction.
.SH See Also
rz(C), sx(C), sz(C)
