.TH LS C
.DA 13 May 1992
.SH Name
ls - List directory contents
.SH Syntax
ls [ _options_ ] _directory_...
.SH Description
_Ls_ lists the files in one or more _directories_. If no _directory_
is given, files in the current working directory are shown. Without options,
_ls_ displays the filenames in a directory in five columns, sorted
alphabetically.
.PP
_Ls_ takes a variety of options:
.IP 5 -a
displays all files in the directory, including the ``hidden'' files.
.IP 5 -l
displays a ``long'' directory, showing file information for each filename.
.BR 2
Example:
.BR 2
.AF
total 4 for 821 bytes
-rw- txt     258 13-aug-85 23:11  dead.letter
drw- dir     512 19-aug-85 00:42  letters
-rw- txt      33 14-aug-85 20:46  patch
-rwx cmd      18 12-aug-85 16:43  login
.AF 1
.BR
The first line shows the number of files within the directory and the amount
of space (in bytes) occupied by them.  For each line of file information:
.BR 2
.AF
 -rwx cmd      18 12-aug-85 16:43  login
   |   |        |       |            |
   |   |        |       |           name of file
   |   |        |       |
   |   |        |      date file was last modified
   |   |        |
   |   |       size of file (in bytes)
   |   |
   |  file type
   |
 d--- indicates a directory
 -r-- file can be read by owner
 --w- file can be written to by owner
 ---x file can be executed by owner
.AF 1
.IP 5 -n
reports the number of files in the specified directory.
.IP 5 -s
causes a long directory to express all size values in 512 byte blocks,
instead of bytes.
.IP 5 -F
marks subdirectory files with a trailing `/', and executable files with a
trailing `*'.
.IP 5 -p
displays a directory in standard ProDOS format (full display, all
information). This option supersedes all others.
.IP 5 -i
shows only invisible files (not available with the -l option).
.IP
In all forms except -p, _ls_ supports output redirection to files.
Example:
.IP 5
.AF
ls /heartbeat/city >file.list
.AF
.IP
This redirects the columnar output from _ls_ on the /heartbeat/city
directory into the file ``file.list''.
.SH Diagnostics
``(more files exist than shown)'' -- Too many files exist in the
directory and all their names could not be read into memory. If the
`-p' option is used, there is no file count limitation.
.SH See Also
dstat(C), setfile(C)
