.TH LOGIN C
.DA 21 October 1993
.SH Name
login - Sign on
.SH Syntax
login
.SH Description
The _login_ program is used when a user initially signs on, or it may be used
at any time to change from one user to another without having to disconnect.
.PP
After a normal system startup sequence, the _login_ program is executed. 
Its job is to answer the phone when remote callers dial the
system, prompt them for a login code and password, and then allow them
into the system if the codes are valid.  While waiting for a call, it
displays the current time on the screen.  _Login_ is also responsible
for handling scheduled _cron_ tasks.
.PP
.PP Commands While Waiting
.BR
While waiting for a call, the console operator can instruct _login_ to
process a command by pressing the `!' key.  _Login_ reads a command line
from the operator and executes the first command
passing forward any arguments.  For example, entering ``!ctime''
causes _login_ to run the _ctime_ program as a process.  When
_ctime_ exits, control returns to _login_.
.PP
Other keys that _login_ recognizes while waiting are:
.BR
.LM 5
.IP 15 RETURN
Allows the operator to log into the system locally
.IP 15 SPACE
Toggles the screen saver on and off
.IP 15 ESCAPE
Exit to BASIC
.LM -5
.IP
In addition, certain keys can be configured to invoke macro commands
to perform a variety of functions without actually having to login.
See the Resources section of this manual entry for more details.
.IP
.PP Task Scheduling
.BR
_Login_ includes an internal task manager called _cron_ which runs once a
minute. _Cron_ scans the file $/etc/crontab for tasks to perform at certain
times and executes them in a way similar to the `!' command for local
console commands.  (See _cron_ for more details).
.PP
Any processes that _login_ invokes are logged with the date and time of
execution, including elapsed time.  Local console processes are labeled
``local'' while _cron_ processes are labeled ``cron'' in $spool/logs/syslog.
.PP
.PP Intercepting Phone Calls
.BR
Unless otherwise instructed (see _Resource File_ below), _login_ answers
a call on the first ring and attempts to connect.  The connection speed
is verified with a required rate, if specified. If the connection is
slower than desired, the $/etc/lowbps file is displayed, and _login_
disconnects to wait for another call.
.PP
After _login_ answers a ringing phone line and successfully connects
with another computer, it displays the file $/etc/herald.  This file
contains the name and location of the host system.  The caller is
prompted to enter a valid login name.
.PP
After a valid login name is given, _login_ scans $/etc/passwd for a
matching entry.  Once found, the information for that account is read
in.  If the account is a non-root user, and the file $/etc/nologin
exists, _login_ prints its contents on the user's terminal and
disconnects. This stops users from logging in when the system is about
to go down, or when it is closed to user traffic.
.PP
If the interpreter entry for the login is a quoted message, it is
displayed, and the caller is prompted to enter a login name again.
(e.g., a ``help'' login attempt might display a short message for
signing on using a public account.  Use _adduser_ to create a ``help''
login which would display the quoted message given as the interpreter).
.PP
Next, _login_ prompts the caller for a password, if appropriate. Echoing is
turned off during the typing of the password, so it will not appear on any
written record of the session.  However, if the encrypted password in the
entry deciphers to ``none'', password input is bypassed.  This is
usually the case for guest logins. 
.PP
The user has three attempts to enter a valid login name and matching
password. If the caller fails, the file $/etc/badlogin is displayed,
and _login_ disconnects.  Badlogin contains information on
how to contact the system administrator for assistance, or may offer
instructions for using a public account.
.PP
If all is well, the user is shown the previous sign on date, the message
of the day file ($/etc/motd), and if a guest, the welcome file
($/etc/welcome).  _Login_ then executes a command interpreter according
to the user's password file entry. The current working directory will be
set to the user's home directory.
.PP
.PP Screen Saver
.BR
While _login_ is waiting for a call or a command, it blacks out the
local console display after a period of inactivity.  This prevents
images from ``burning'' into the screen.  If a call comes in, a key is
pressed, or a cron task starts up, the screen is restored.
The time is displayed at random positions while the
screen is blank.
.PP
.PP Resource File
.BR
Certain features of _login_ can be adjusted by editing $/etc/rsrc/login.rsrc.
The format of the file is described by the following sample
entries in the order required (with comments added):
.IP 15 30
Seconds before the screen blanks. Zero seconds disables the screen saver.
.IP 15 <blank>
Normally left blank, this line may contain a command line that is executed
whenever a caller logs out or a cron task completes.  By default, no command
line tells _login_ to scan for any letters that need
delivering, and if found it executes _sendmail_.  Typically, a command line
would start with _csh_ and the name of a shell script that contains a list of
commands to execute, including _sendmail_.
.IP 15 0
Speaker control. This feature allows you to control the modem's speaker via
joystick position control.  If this entry is 1, the direction of
the joystick affects the modem's speaker output during connections.
Positioned to the left, the speaker remains silent.
.IP 15 300
Lowest connect speed allowed.  If a caller connects at a speed
lower than this value, $/etc/lowbps is displayed, and _login_
disconnects.
.IP 15 0
Console availability hold time.
This is a feature for Apple IIGS hosts only.
This feature allows the administrator to lock the Caps Lock key while the
system is in use.  When the system becomes available, a series of beeps
(the number determined by this entry's value) is emitted, holding the
system until there is a keyboard response.  Unlocking the Caps Lock key,
or setting this entry to 0, disables this feature. 
.IP 15 !cmpqs
Macro command keys.  Each letter in this line corresponds to subsequent
lines that expand the macro key into commands.  That is, the first line
following this one is for the `!' character. The second is for the `c'
character, and so on. The macro lines must follow in the order that the
characters are given.  Up to 26 macros may be defined.  Shown here are the
defaults with comments in parenthesis (omit the comments):
.BR 2
.AF
            (for "!" -- usually nothing)
csh -c      (for "c")
mail        (for "m")
poll        (for "p")
boot -q     (for "q")
scan -l     (for "s")
.AF
.IP 15
Pressing `q' at the Waiting prompt expands into the ``boot -q'' command.
This is because `q' is the fifth character in the first line of macro
keys, and ``boot -q'' is the fifth line following.  
You can change or edit the command line, then execute it by pressing RETURN.
You can, of course, add, delete, or change any these macros.
.IP 15 3
Console cancel key (ASCII).
The default console cancel key is Control-C (ASCII 3).  This can be changed
to any other character from ASCII 0 to 127.  This cancel key is used whenever
a macro is invoked.
.IP 15 0
No answer flag.
If set to 1, causes _login_ to ignore any incoming
calls.  It simply prevents the system from answering, allowing the
modem to remain operational for outgoing calls only.
.IP 15 0
Command line time-out.
This value (in seconds) sets the duration of inactivity
at the Waiting command line prompt.  If zero, no inactivity checking is
performed.
.IP 15 <blank>
This line, normally blank, contains a comma-separated list of account
names that triggers a unique alert sequence.  When a user signs on whose
login name is in this line, a series of beeps is generated at the
console.  Then a second set of beeps follow, unique to that user.  You
can distinguish certain users from others without having to look at the
console.  This is useful for alerting you to troublesome callers.
.IP
.SH Files
$/etc/rsrc/login.rsrc - Login resources,
.BR
$/etc/adm - Accounting,
.BR
$tmpdir/utmp - Accounting,
.BR
$/etc/crontab - Task table,
.BR
$/etc/herald - Login herald,
.BR
$/etc/motd - Message of the day,
.BR
$/etc/passwd - Password file,
.BR
$/etc/lowbps - Message indicating connect speed requirements,
.BR
$/etc/nologin - Stops non-root user logins,
.BR
$/etc/badlogin - Shown after three failed login attempts,
.BR
$/etc/welcome - guest welcome,
.BR
$/adm/*/environs - User's terminal environment settings,
.SH Diagnostics
``Login incorrect,'' if the name or the password is bad.
.BR
``Account overdrawn,'' when a caller has used up his monthly time allotment.
.BR
''File or directory not found,'' when the specified user's directory or
interpreter to launch cannot be found.
.SH See Also
adduser(ADM), cron(ADM), csh(C), passwd(C), plush(C), setenv(C)
