.TH GREP C
.DA 13 May 1992
.SH Name
grep - Find a pattern in a file
.SH Syntax
grep [ _options_ ] _pattern_ _file_...
.SH Description
_Grep_, abbreviation of Globally find Regular Expressions and Print,
searches one or more _files_ for lines matching a _pattern_. Normally,
each line found is displayed. The following _options_ are recognized:
.IP 5 -v
All lines but those matching are printed.
.IP 5 -c
Only a count of matching lines is printed.
.IP 5 -l
The names of files with matching lines are listed (once) separated by
newlines.
.IP 5 -n
Each line is preceded by its relative line number in the file.
.IP 5 -h
Suppress display of filename headers.
.IP 5 -y
The case of letters is ignored in making comparisons (that is, upper and
lower case are considered identical).
.IP
Example:
.IP 5
.AF
grep -y endif login
.AF
.IP
This displays all lines in the file _login_ containing the word
_endif_, ignoring alphabetic case.
.SH Note
To search for a pattern consisting of words and spaces,
the entire pattern must be enclosed in quotes:
.IP 5
.AF
grep "dream into action" clip
.AF
.IP
If the last argument in the command line starts with `>', the output from
_grep_ is directed into the filename which follows:
.IP 5
.AF
grep -v mozart music.db >temp
.AF
.IP
This writes all lines in ``music.db'' not containing (-v) the pattern
``mozart'', into the file ``temp''.
.PP
Lines are limited to 255 characters; longer lines are truncated.
.SH See Also
cat(C), tail(C), wc(C)
