.TH FIND C
.DA 20 March 1994
.SH Name
find - Find files
.SH Syntax
find [ _options_ ] [ _pathname_... ] [ >output ]
.SH Description
_Find_ recursively descends the directory hierarchy for one or more
_pathnames_ given, seeking all files that match specified search
options. If a _pathname_ is `/', the root prefix is assumed.
.PP
Without options, _find_ lists all the files in the current working
directory and every directory found within.
.PP
A number of useful examples are given at the end of this manual entry.
.PP
.PP Options
.IP 15 -a
Consider all files when reading directories.  This includes visible
and invisible files.  By default, only visible files are considered.
.IP 15 -c
Report a count of matching files when _find_ is done.
.IP 15 -d levels
Search only through a specified number of directory _levels_.  The
default is 16 levels deep.
.IP 15 -f file
Use information obtained from _file_ for making comparisons with
searched files.  Comparison is made for all search selectors
except for file names (-N).  Example:
.BR 2
.AF
find -f foo -T =
.AF
.BR
This finds all files within the current directory tree that match the
file type for the file ``foo''. Using `=' with a selector tells _find_
to use the appropriate information from the file specified with -f.
(Selectors are discussed below).
.IP 15 -i
Consider only invisible (hidden) files when reading directories.
.IP 15 -p pattern
Specify _pattern_ when printing matched files.  The contents of
_pattern_ are printed for each match, and imbedded `%' characters
are used to substitute special information:
.BR 2
% - displays nothing
.BR
%f - fully qualified path to file
.BR
%n - name of file
.BR
%p - parent path to file
.BR
%s - size of file in blocks
.BR
%x - partial path to file excluding source prefix
.BR 2
Combinations of these options can be included in the _pattern_ (e.g.,
the pattern ``%n found in %p'' displays ``bar found in /a/usr/foo/'' when
the complete pathname is ``/a/usr/foo/bar'').
.BR 2
By default, _find_ displays the path to each file.
.IP 15 -q matches
Quit after the specified _matches_ are found.  The default is to never
quit until all paths have been searched.
.IP 15 -t
Include the time (hh:mm) whenever a date match is made.  By default, only the
date (mm/dd/yy) is used in searches.
.IP 15 -v
Displays progress information on each directory being searched.
.IP
.PP Selectors
.BR
The following selectors are used to specify matching files:
.IP 15 -A attrib
Match files that have attributes as specified by these characters:
.BR 2
d = Destroy (file can be removed)
.BR
n = Rename (file can be renamed)
.BR
b = Backup (file needs a backup)
.BR
i = Invisible (file is hidden)
.BR
w = Write (file can be written to)
.BR
r = Read (file can be read)
.IP 15 -N pattern
Match files by a name _pattern_.  The the _pattern_ must be in lowercase,
and may contain `*' to match wildcard portions.  Thus,
``-N *baz*'' finds all file names containing ``baz''.
.IP 15 -T type
Match files by _type_ (a decimal value from 0 to 255).
.IP 15 -X auxtype
Match files by _auxtype_ (a decimal value from 0 to 65535).
.IP 15 -S blocks
Match files by size in 512-byte _blocks_.
.IP 15 -B blocks
Match files bigger than the size given in _blocks_.
.IP 15 -L blocks
Match files smaller than the size given in _blocks_.
.IP 15 -M date
Match files modified on _date_.  _date_ is a string in one of the forms
listed:
.BR 2
.AF
mm/dd/yy
"mm/dd/yy hh:mm"
"mm/dd/yy hh:mm AM"
"mm/dd/yy hh:mm PM"
.AF
.BR 1
representing the month (1-12), day (1-31), year (0-99), hour
(0-23), and minute (0-59).  The string must be
quoted if it contains a space.  A period (.) indicates the
current date and time.
.BR 2
If the time is omitted, midnight is assumed.  If the time is significant
in date comparisons, include the -t option as described above.
.IP 15 -O date
Match files older than _date_.
.IP 15 -Y date
Match files younger (newer) than _date_.
.IP
An equal sign (=) may be the argument to a selector if the -f option
is used.  See -f above for more details.
.PP
.PP Negating Matches
.BR
Prefixing a selector with `!' inverts (or negates) the match result.
That is, ``-!N'' means to match all files that do not match a particular
name pattern, thus ``-!N *baz*'' finds all files that do not contain
the pattern ``baz'' in their names.
.PP
.PP Composite Selectors
.BR
Multiple search selectors can be combined.  As long as each selector
matches, _find_ continues to apply selection criteria to the current
file.  When all selectors have been processed successfully for a file,
it is considered to be a match.
.PP
.PP Output Redirection
.BR
If the very last argument given begins with `>', _find_ redirects all of
its output, except verbose progress reports, into the filename which
follows. This is excellent for creating scripts containing commands
which act on all the matched files.
.PP
.PP Examples
.BR
To find all executable programs younger (newer) than $/bin/man:
.IP 5
.AF
find -f $/bin/man -Y = $path
.AF
.IP
To build and run a script that removes all files beginning with ``finder.'':
.IP 5
.AF
find -N finder.* -p "echo found %n in %p; rm %f" / >killfndr
source killfndr
.AF
.IP
To find all files in $/usr that are not named ``login'', ``signature'',
nor ``mailrc'', and are not directory files:
.IP 5
.AF
find -!N login -!N signature -!N mailrc -!T 15 $/usr
.AF
.IP
To report only the count of all invisible files in the current directory
level:
.IP 5
.AF
find -i -d 1 -c -p %
.AF
.IP
To find all files that need to be backed up, showing their sizes:
.IP 5
.AF
find / -a -A b -p "%f (%s blocks)"
.AF
.IP
To find all files modified between January and February in 1994:
.IP 5
.AF
find / -a -Y "01/01/94" -O "02/01/94"
.AF
.IP
.SH Author
Morgan Davis (mdavis@mdg.cts.com)
.SH See Also
grep(C), setfile(C), version(C), whereis(C)
