.TH ED C
.DA 12 May 1992
.SH Name
ed - Text editor
.SH Syntax
ed _file_
.SH Description
_ed_ is the standard UNIX text editor.  When the file argument is
given, _ed_ simulates an e command (see below) on the named file; that
is to say, the file is read into ed's buffer so that it can be edited. 
_ed_ operates on a copy of the file it is editing; changes made to the
copy have no effect on the file until a w (write) command is given. 
The copy of the text being edited resides in a temporary buffer.  There
is only one buffer.
.PP
Commands to _ed_ have a simple and regular structure: zero, one, or two
addresses followed by a single-character command, possibly followed by
parameters to that command. These addresses specify one or more lines
in the buffer. Every command that requires addresses has default
addresses, so that the addresses can very often be omitted.
.PP
In general, only one command may appear on a line.  Certain commands
allow the input of text.  This text is placed in the appropriate place
in the buffer.  While _ed_ is accepting text, it is said to be in input
mode.  In this mode, no commands are recognized; all input is merely
collected. Input mode is left by entering a period (.) alone at the
beginning of a line.
.PP
The ProLine version of _ed_ does not support regular expression
parsing, other than simple /text/ and ?text? syntaxes for
bi-directional pattern searching.  A null regular expression, // or ??,
is equivalent to the last one used.
.PP
To understand addressing in _ed_ , it is necessary to know that there
is a current line at all times. Generally speaking, the current line is
the last line affected by a command; the exact effect on the current
line is discussed under the description of each command.  Addresses are
constructed as follows:
.IP 7 1.
The character . addresses the current line.
.IP 7 2.
The character $ addresses the last line of the buffer.
.IP 7 3.
A decimal number n addresses the n-th line of the buffer.
.IP 7 4.
A regular expression enclosed by slashes (/) addresses the first line
found by searching forward from the line following the current line
toward the end of the buffer and stopping at the first line containing
a string matching the regular expression. If necessary, the search
wraps around to the beginning of the buffer and continues up to and
including the current line, so that the entire buffer is searched.
.IP 7 5.
A regular expression enclosed in question marks (?) addresses the first
line found by searching backward from the line preceding the current
line toward the beginning of the buffer and stopping at the first line
containing a string matching the regular expression.  If necessary, the
search wraps around to the end of the buffer and continues up to and
including the current line.  Also see the last paragraph before Files below.
.IP 7 6.
An address followed by a plus sign (+) or a minus sign (-) followed by
a decimal number specifies that address plus or minus the indicated
number of lines. The plus sign may be omitted.
.IP 7 7.
If an address begins with + or -, the addition or subtraction is taken
with respect to the current line; e.g, -5 is understood to mean .-5.
.IP 7 8.
If an address ends with + or -, then 1 is added to or subtracted from
the address, respectively.  As a consequence of this rule and of rule 7
immediately above, the address - refers to the line preceding the
current line. Moreover, trailing + and - characters have a cumulative
effect, so -- refers to the current line less 2.
.IP 7 9.
For convenience, a comma (,) stands for the address pair 1,$, while a
semicolon (;) stands for the pair .,$.
.IP
Commands may require zero, one, or two addresses.  Commands that
require no addresses regard the presence of an address as an error. 
Commands that accept one or two addresses assume default addresses when
an insufficient number of addresses is given; if more addresses are
given than such a command requires, the last address(es) are used.
.PP
Typically, addresses are separated from each other by a comma (,). 
They may also be separated by a semicolon (;). In the latter case, the
current line (.) is set to the first address, and only then is the
second address calculated. This feature can be used to determine the
starting line for forward and backward searches (see rules 4 and 5
above). The second address of any two-address sequence must correspond
to a line that follows, in the buffer, the line corresponding to the
first address.
.PP
In the following list of _ed_ commands, the default addresses are shown
in parentheses.  The parentheses are not part of the address; they show
that the given addresses are the default.
.PP
It is generally illegal for more than one command to appear on a line. 
However, any command (except e, f, r, or w) may be suffixed by p or by
l, in which case the current line is either printed or listed,
respectively, as discussed below under the p and l commands.
.PP (.)a
<text>
.BR
.RC 1 .
.BR
.LM 5
The append command reads the given text and appends it after the
addressed line; dot is left at the last inserted line, or, if there
were no inserted lines, at the addressed line.  Address 0 is legal for
this command: it causes the ``appended'' text to be placed at the
beginning of the buffer.  This is equivalent to the 1i command.
.LM -5
.PP (.)c
<text>
.BR
.RC 1 .
.BR
.LM 5
The change command deletes the addressed lines, then accepts input text
that replaces these lines; dot is left at the last line input, or, if
there were none, at the first line that was not deleted.
.LM -5
.PP (.,.)d
.LM 5
The delete command deletes the addressed lines from the buffer.  The
line after the last line deleted becomes the current line; if the lines
deleted were originally at the end of the buffer, the new last line
becomes the current line.
.LM -5
.PP e file
.LM 5
The edit command causes the entire contents of the buffer to be
deleted, and then the named file to be read in; dot is set to the last
line of the buffer.  If no filename is given, the currently remembered
filename, if any, is used (see the f command).  The number of
characters read is typed; file is remembered for possible use as a
default filename in subsequent e, r, and w commands.
.LM -5
.PP E file
.LM 5
The Edit command is like e, except the editor does not check to see if
any changes have been made to the buffer since the last w command.
.LM -5
.PP f file
.LM 5
If file is given, the filename command changes the currently remembered
filename to file; otherwise, it prints the currently remembered
filename.
.LM -5
.PP h
.LM 5
The help command gives a short error message that explains the reason
for the most recent ? diagnostic.
.LM -5
.PP H
.LM 5
The Help command causes _ed_ to enter a mode in which error messages
are printed for all subsequent ? diagnostics.  It will also explain the
previous diagnostic if there was one.  The H command alternately turns
this mode on and off; it is initially off.
.LM -5
.PP (.)i
<text>
.BR
.RC 1 .
.BR
.LM 5
The insert command inserts the given text before the addressed line;
dot is left at the last inserted line, or if there were no inserted
lines, at the addressed line.  This command differs from the a command
only in the placement of the input text.  Address 0 is not legal for
this command.
.LM -5
.PP (.,.+1)j
.LM 5
The join command joins contiguous lines by removing the appropriate
newline characters.  If only one address is given, this command does
nothing.
.LM -5
.PP (.,.)l
.LM 5
The list command prints the addressed lines in an unambiguous way: a
few nonprinting characters (e.g., tab, backspace) are represented by
mnemonic overstrikes, all other nonprinting characters are printed in
octal, and long lines are folded.  An l command may be appended to any
command other than e, f, r, or w.
.LM -5
.PP (.,.)ma
.LM 5
The move command repositions the addressed line(s) after the line
addressed by a.  Address 0 is legal for a and causes the addressed
line(s) to be moved to the beginning of the file; it is an error if
address a falls within the range of moved lines; dot is left at the
last line moved.
.LM -5
.PP (.,.)n
.LM 5
The number command prints the addressed lines, preceding each line by
its line number and a tab character; dot is left at the last line
printed.  The n command may be appended to any command other than e, f,
r, or w.
.LM -5
.PP (.,.)p
.LM 5
The print command prints the addressed lines; dot is left at the last
line printed.  The p command may be appended to any command other than
e, f, r, or w; for example, dp deletes the current line and prints the
new current line.
.LM -5
.PP (*)P prompt
.LM 5
The editor will prompt with a * for all subsequent commands.  If the
optional prompt is included it becomes the new prompt string.  P alone
alternately turns this mode on and off; it is initially on.
.LM -5
.PP q
.LM 5
The quit command causes _ed_ to exit.  No automatic write of a file is
done.
.LM -5
.PP Q
.LM 5
The editor exits without checking if changes have been made in the
buffer since the last w command.
.LM -5
.PP r file
.LM 5
The read command reads in the given file after last line in the buffer.
If no filename is given, the currently remembered filename, if any, is
used (see e and f commands).  The currently remembered filename is not
changed unless file is the very first filename mentioned since _ed_ was
invoked.  If the read is successful, the number of characters read is
typed; dot is set to the last line read in.
.LM -5
.PP (.,.)s/regular-expression/replacement/
.PP (.,.)s/regular-expression/replacement/g
.PP
.LM 5
The substitute command searches each addressed line for an occurrence
of the specified regular expression.  In each line in which a match is
found, all (nonoverlapped) matched strings are replaced by the
_replacement_ if the global replacement indicator g appears after the
command.  If the global indicator does not appear, only the first
occurrence of the matched string is replaced.  It is an error for the
substitution to fail on all addressed lines.  Any character other than
space or newline may be used instead of / to delimit the regular
expression and the replacement; dot is left at the last line on which a
substitution occurred.
.LM -5
.PP (.,.)ta
.LM 5
This command acts just like the m command, except that a copy of the
addressed lines is placed after address a (which may be 0); dot is left
at the last line of the copy.
.LM -5
.PP (1,$)w file
.LM 5
The write command writes the addressed lines into the named file.  If
the file does not exist, it is created. The currently remembered
filename is not changed unless file is the very first filename
mentioned since _ed_ was invoked.  If no filename is given, the
currently remembered filename, if any, is used (see e and f commands);
dot is unchanged.  If the command is successful, the number of
characters written is displayed.
.LM -5
.PP ($)=
.LM 5
The line number of the addressed line is typed; dot is unchanged by
this command.
.LM -5
.PP (.+1)
.LM 5
An address alone on a line causes the addressed line to be printed.  A
RETURN alone on a line is equivalent to .+1p. This is useful for
stepping forward through the editing buffer a line at a time.
.LM -5
.PP
If an interrupt signal is sent, _ed_ prints a question mark (?) and
returns to its command level.
.PP
Some size limitations: 255 characters per line, 255 characters per
global command list, 64 characters per filename. The limit on the
number of lines depends on the amount of memory.
.PP
Files that contain characters not in the ASCII set (bit 8 on), cannot
be edited by _ed_.  Editable file types are TXT and CMD.  TXT files
cannot be the random-access text files.
.SH Diagnostics
.IP 7 ?
Command errors
.IP 7 ? file
An inaccessible file
.IP
Use the help and Help commands for detailed explanations.
.PP
If changes have been made in the buffer since the last w command that
wrote the entire buffer, _ed_ warns the user if an attempt is made to
destroy _ed_'s buffer via the e or q commands: it prints ? and allows
you to continue editing.  A second e or q command at this point will
take effect.
.SH See Also
edit(C), grep(C), csh(C), setenv(C), vedit(C)
