.TH ALIAS C
.DA 5 May 1992
.SH Name
alias, unalias - Alias or unalias command names
.SH Syntax
alias [ _name_ _value_ ]
.BR
unalias _name_...
.SH Description
Without arguments, _alias_ displays a list of the currently defined
aliases.  With arguments, _alias_ associates _name_ with the
following _value_.  The shell applies all transformations on the command
line, notably the _value_ assigned to the alias.  Therefore, care must
be taken when using _alias_ so that the resulting _value_ is stored
as desired.
.PP
Example:
.IP 5
.AF
alias   ls      ls -F
alias   bye     "echo It's \$date[4]; logout"
.IP
.AF 1
Whenever ``ls'' is entered, the shell expands it to ``ls -F''.  In the
second example, ``bye'' is replaced by two commands.  Remember that
_values_ assigned to aliases pass through all transformations twice:
once when the alias is defined, and a second time when the alias is
actually used. This includes character escaping, control character
insertion, and variable expansion.  See csh(C) for a dissertation on
avoiding variable expansion when it isn't desired.
.PP
Note that alias only affects the very first argument.  If you
typed the command ``echo bye'' you would see ``bye'' printed on your screen, not
``logout''.
.PP
.PP Argument Insertion
.BR
Alias values can contain special characters that indicate where command
line arguments should be inserted.  They are:
.LM 5
.IP 5 !^
Inserts the first argument
.IP 5 !$
Inserts the last argument
.IP 5 !*
Inserts all arguments
.LM -5
.IP
Here's an example:
.IP 5
.AF
alias test "echo !\^"
.AF
.IP
Note: The caret character denotes special control code insertion.  To
include the caret literally, it has to be escaped with a backslash.
.PP
Entering ``test'' followed by one or more arguments causes the shell to
first replace it with the ``echo'' command, and then takes the first argument
following ``test'' and makes it the only argument to the ``echo'' command.
Example:
.IP 5
.AF
test fizbin data compression
fizbin
.AF
.IP
Alias substitutions may contain multiple argument insertion sequences, and the
new command line will be built using the appropriate arguments from the
original command line.
.PP Changing and Removing Aliases
.BR
Old aliases can be changed with the _alias_ command by reentering them with
new values.
.PP
To remove an alias, use _unalias_ followed by one or more alias _names_.
.SH See Also
csh(C)
