**********************************************************
*                                                        *
*                 P a s s i v e B o o t                  *
*                    for NadaNet 3.x                     *
*                                                        *
*            Michael J. Mahon - June 23, 2004            *
*                 Adapted Apr 15, 2008                   *
*                 Revised Apr 30, 2010                   *
*                                                        *
*    Copyright (c) 1996, 2003, 2004, 2005, 2008, 2010    *
*                                                        *
*   PassiveBoot is ROM boot code for a diskless Enhanced *
*   Apple //e which replaces the self-test code.  It     *
*   causes the //e to boot from a "master-capable"       *
*   machine on the network that sends the boot code.     *
*                                                        *
*   This major modification to the boot protocol creates *
*   a minimal boot code which can fit into the smaller   *
*   2-page self-test area of the Enhanced //e ROM.       *
*                                                        *
*   This version only waits for a BOOT transaction to    *
*   appear on the net, then it loads the boot image      *
*   sent and passes it control.                          *
*                                                        *
*   This allows all but RCVPKT and RCVLONG, plus the     *
*   RESET and boot logic itself to be eliminated.        *
*                                                        *
**********************************************************
*                                                        *
*                    Change History                      *
*                                                        *
*   04/30/10:                                            *
*                                                        *
*   Updated to use NadaNet 3.x boot request format.      *
*                                                        *
*   RESET code changed to force reboot if network state  *
*   is not ONE.  Makes power cycle much more likely to   *
*   cause all 'Crate machines to reboot, while still     *
*   permitting warm restart by resetting a machine with  *
*   the network held at ONE (locked).                    *
*                                                        *
*   04/18/08:                                            *
*                                                        *
*   Restricted boot code load address to $0400..$BFFF.   *
*                                                        *
*   04/15/08:                                            *
*                                                        *
*   Major modification to create minimal boot code.      *
*                                                        *
*   Changed sign-on message to "AppleCrate //e", like    *
*   the Enhanced //e sign-on.                            *
*                                                        *
*   Since the boot is accomplished prior to the machine  *
*   getting an ID, that task is left to a second stage   *
*   boot prefixed to the NadaNet boot image.  The need   *
*   to obtain an ID is communicated by setting the       *
*   page 3 variable 'bootself' to 0.                     *
*                                                        *
*   To provide visual indication that the machine is in  *
*   the "awaiting boot" state, a message is displayed    *
*   on the video screen and the 'send' LED is lit.       *
*                                                        *
*   06/29/05:                                            *
*                                                        *
*   Uses the new NadaNet RCVPKT routine (NadaNet 2.x)    *
*   with faster 8-cycle bit timings (thanks to Stephen   *
*   Thomas for his brilliant code).                      *
*                                                        *
*   Changed AppleCrate sign-on version to 2.0.           *
*                                                        *
*   10/20/04:                                            *
*                                                        *
*   Moved "bootself" to $3CC (out of way of ProDOS).     *
*                                                        *
*   Reorganized to use NADANET "put" files.              *
*                                                        *
*   06/23/04:                                            *
*                                                        *
*   Made "packet"/"message" nomenclature consistent.     *
*                                                        *
*   05/13/04:                                            *
*                                                        *
*   Initial ROM boot version.                            *
*                                                        *
**********************************************************
         pag
******************** Version setup ***********************

         org   $C600      ; (Enhanced //e self-test)
master   equ   0          ; Non-master version
dos      equ   0          ; Non-DOS version
crate    equ   0          ; Non-Crate version
mserve   equ   0          ; Non-Message Server version
ROMboot  equ   1          ; ROM boot version
enhboot  equ   1          ; Enhanced //e version

         put   NADACONST
         use   NADAMACS
         put   NADADEFS
         put   NADAVECTOR
         put   NADAVARS
         put   SENDRCV
         put   ENHBOOTCODE
         align 256        ; Align to page boundary
endcode  equ   *
         err   *-1/$C800  ; Can't exceed $C800
         end
