***************** Macro definitions ********************

inc16    mac
         inc   ]1         ; Increment 16-bit word.
         do    ]1+1/$100  ; If ]1 is non-page zero
         bne   *+5        ; - No carry.
         else             ; Else if ]1 on page zero
         bne   *+4        ; - No carry.
         fin
         inc   ]1+1       ; Propagate carry.
         eom

mov16    mac
         lda   ]1         ; Move 2 bytes
         sta   ]2
         if    #=]1
         lda   ]1/$100    ; high byte of immediate
         else
         lda   1+]1
         fin
         sta   1+]2
         eom

delay    mac
         ldx   #]1/5      ; (5 cycles per iteration)
]delay   dex
         bne   ]delay
         eom

dlyms    mac
         ldy   #]1        ; Delay 1ms. per iteration
]dly     delay 1020-4     ; Cycles per ms. - 4
         dey
         bne   ]dly
         eom

align    mac
         ds    *-1/]1*]1+]1-*
         eom

         tr    on         ; Only one line of data per op
         lstdo off        ; Don't print 'do 0' stuff.
         pag
