**********************************************************
*                                                        *
*                 NadaNet Definitions                    *
*                        v3.1                            *
*                                                        *
*            Michael J. Mahon - Oct 13, 2004             *
*                 Revised Apr 29, 2010                   *
*                                                        *
*            Copyright (c) 2004, 2008, 2010              *
*                                                        *
**********************************************************

version equ $31 ; NadaNet version 3.1

********** Control Packet Definition **********

 dum 0 ; Control packet format:
rqmd ds 1 ;   Request & Modifier
frmc ds 1 ;   Complement of sending ID
dst ds 1 ;   Destination ID (0 = bcast)
frm ds 1 ;   Sending ID (never 0)
adr ds 2 ;   Address field
len ds 2 ;   Length field
   ; =========================
lenctl ds 0 ; Length of control packet
 dend

* Request codes (upper 5 bits) and modifiers (lower 3 bits)

reqfac equ 8 ; Request code factor (2^3)
reqmask equ 256-reqfac ; Request code mask (7..3)
modmask equ reqfac-1 ; Modifier code mask (2..0)

 dum reqfac ; Request codes (0 invalid):
r_PEEK ds reqfac ;   PEEK request
r_POKE ds reqfac ;   POKE request
r_CALL ds reqfac ;   CALL request
r_PUTMSG ds reqfac ;   PUTMSG request
r_GETMSG ds reqfac ;   GETMSG request
r_GETID ds reqfac ;   GETID request
r_BOOT ds reqfac ;   BOOT request (in ROM)
r_BCAST ds reqfac ;   BCAST request
r_BPOKE ds reqfac ;   Broadcast POKE request
r_PKINC ds reqfac ;   PEEK & INCrement request
r_PKPOK ds reqfac ;   PEEKPOKE request
r_RUN ds reqfac ;   RUN request
r_BRUN ds reqfac ;   BRUN request
   ; ==========================
maxreq ds 0 ;   Max request + reqfac
 dend

 dum 1 ; Modifier codes (0 invalid):
rm_REQ ds 1 ;   Request
rm_ACK ds 1 ;   Acknowledge
rm_DACK ds 1 ;   Data Acknowledge
rm_NAK ds 1 ;   Negative Acknowledge
 dend

***************** BCAST tags *******************
*                                              *
* High byte of BCAST address field.  Tags <$D0 *
* can be confused with RAM addresses. (The low *
* byte may be an additional specification.)    *
*                                              *
************************************************

t_BASIC equ $E0 ; Applesoft BASIC program
t_SYNTH equ $F0 ; Crate SYNTH program
t_VOICE equ $F1 ; Crate SYNTH voice

************ NadaNet Page 3 Vector *************

 dum $3CC ; Fixed memory vector
bootself db 0 ; Machine ID from BOOT
warmstrt jmp 0*0 ; Warm start SERVE loop entry
nadapage equ *-1 ; NADANET load page
 dend
 pag
