**********************************************************
*                                                        *
*                 N A D A . M S E R V E                  *
*                                                        *
*           Message Server version of NadaNet            *
*                                                        *
*           Michael J. Mahon - April 14, 1996            *
*                  Revised May 3, 2010                   *
*                                                        *
* Copyright (c) 1996, 2003, 2004, 2005, 2008, 2009, 2010 *
*                                                        *
*   NadaNet is a suite of 6502 machine code routines     *
*   to support bidirectional communication among several *
*   Apple // computers.  It uses one wire (plus ground)  *
*   connected to the game ports of the machines.         *
*                                                        *
*   An annunciator output is used to "broadcast" to all  *
*   machines, and a "pushbutton" input is used to sense  *
*   the state of the shared signalling wire.  This is    *
*   similar to Ethernet, but at lower speed and at TTL   *
*   levels.                                              *
*                                                        *
*   The raw signaling speed is 1 bit every 8 cycles, or  *
*   127.6 kilobaud.  With byte separator overhead of 31  *
*   cycles, this translates to 1 byte every 94-95 cycles,*
*   or over 10K bytes/sec (thanks to Stephen Thomas!).   *
*                                                        *
*   All signal transmission and reception is done with   *
*   precisely timed software routines.  Synchronization  *
*   is assured by a digital PLL at the receiver which    *
*   adapts to variations in timing of 93-96 cycles/byte. *
*   (If a machine has a Zip Chip accelerator installed,  *
*   it is temporarily slowed during packet transmission  *
*   and reception.)                                      *
*                                                        *
**********************************************************

******************** Version setup ***********************

         org   $800       ; 'NADA.MSERVE' for AppleCrate
master   equ   0          ; Omit master-only functions
dos      equ   0          ; Non-DOS version
crate    equ   0          ; Not general AppleCrate version
mserve   equ   1          ; Message Server version
ROMboot  equ   0          ; Non-boot ROM version
enhboot  equ   0          ; Non-Enhanced //e ROM version
         pag
         put   NADAHIST
         put   NADACONST
         use   NADAMACS
         put   NADADEFS
         put   NADAVECTOR
         put   NADAVARS
         put   INITSERVE
         put   PEEKPOKECALL
         put   PUTMGETM
         put   SENDRCV
]end     align 256        ; Align to page boundary
xreceive equ   *-]end     ; Extra space at end.
INSTALL  equ   INIT       ; (No AmperNada install)
endcode  equ   *
pgmaplo  equ   endcode    ; First message buffer page
         end
