**********************************************************
*                                                        *
*                    M O N I T O R                       *
*                                                        *
*            Michael J. Mahon - May 26, 2004             *
*                 Revised Nov 10, 2004                   *
*                                                        *
*                  Copyright (c) 2004                    *
*                                                        *
*  Receive the first 8 bytes of each packet into buffer  *
*  in memory, together with its checksum residue.        *
*                                                        *
*  RCVPKT timeouts are recorded as 2-byte $DEAD marks    *
*  and are temporarily increased to 20ms.                *
*                                                        *
**********************************************************

bufstrt  equ   $2000      ; Start of monitor buffer
         do    ROMboot    ; (If 'ROMboot')
bufend   equ   $C000-$100 ; Ending page of monitor buffer
         else             ; (If 'not ROMboot')
bufend   equ   entry-$100 ; Ending page of monitor buffer
         fin              ; (end 'ROMboot')
monlen   equ   lenctl     ; Monitor record data length
toflg1   equ   $DE        ; Timeout flag byte 1
toflg2   equ   $AD        ; Timeout flag byte 2

MONITOR  mov16 #bufstrt   ;ptr ; Set start of buffer
         ldx   #idleto    ; Set RCVPKT timeout
         stx   tolim      ;  to 20 ms.
:waitgap ldx   #gapwait   ; Wait for interpacket gap.
         cmp   zipslow    ; Slow Zip Chip to 1MHz.
         ldy   drecv      ; Sample network state.
:wait    tya
         eor   drecv      ; Net unchanged?
         bmi   :waitgap   ; -No, start over.
         dex              ; -Yes, count down
         bne   :wait      ;   until satisfied.
:next    ldx   #monlen    ; Set length
         jsr   RCVPTR     ;  to receive...
         ldy   #monlen    ; Point to cksum residue
         tax              ; Save cksum residue
         bcc   :store     ; -Good packet.
         bne   :store     ; -Cksum error.
         lda   #toflg1    ; -Timeout.  Flag
         ldy   #0         ;   it in buffer.
         sta   (ptr),y
         lda   #toflg2
         iny
:store   sta   (ptr),y    ; Store byte in buffer
         tya              ; Inc ptr by record
         sec              ;  length + 1.
         adc   ptr
         sta   ptr
         lda   #0
         adc   ptr+1
         sta   ptr+1
         cmp   #>bufend   ; Buffer full?
         bcs   :end       ; -Yes, stop.
         lda   keybd      ; Key pressed?
         bmi   :end       ; -Yes, stop.
         txa              ; Recover cksum residue
         beq   :next      ; -Good, receive next.
         bne   :waitgap   ; -Bad, wait next gap.

:end     ldx   #reqto     ; Restore timeout to
         stx   tolim      ;  minimum arb time.
         rts
         pag
