/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  Header file for Dapple shared components
 *
 * This source file is not intended for release versions of EMU][ at this
 * time, because the lack of source to ASMLIB.O at this time prevents the
 * compliance with the license for YAZE (a small amount of code was taken
 * from YAZE and if it is used, there can be no exceptions to the GPL).
 * It is provided for debug builds.  We have intent to include this in the
 * future when full compliance with GPL is possible. -uso.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        Z80 emulation


        see z80.c for implementation


----------------------------------------*/


#ifndef DEF_INC_Z80_H
#define DEF_INC_Z80_H



// **** include general libraries concerning definitions

//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
//#include <string.h>           // included by dapple.h
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h
#include "dapple.h"


// **** public constants

#ifndef DEF_INC_CPU65C02_H
// type of CPU
#define CPU_6502        0x01
#define CPU_65C02       0x02
#define CPU_65SC02      0x04
#define CPU_Z80         0x08

// cpu state
#define CPU_STATEHALT   0x0001
#define CPU_STATERESET  0x0002
#define CPU_STATEGURU   0x0004
#define CPU_STATEBPT    0x0008
#define CPU_STATEBRK    0x0010
#define CPU_STATETRACE  0x0020
#define CPU_STATECOP    0x0040
#define CPU_STATEIRQ1   0x0100
#define CPU_STATEIRQ2   0x0200
#define CPU_STATENMI1   0x1000
#define CPU_STATENMI2   0x2000
#endif


// **** public functions

unsigned char   *z80init        (void);                 // initialize emulation
unsigned char   *z80loadrom     (unsigned int keyboard, unsigned int window);


unsigned char   *z80new         (slot *slotpointer, unsigned int slotnumber);
unsigned char   *z80reset       (void *slotdata);
unsigned char   *z80store       (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *z80restore     (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   z80get          (void *slotdata, unsigned int addr);
void            z80set          (void *slotdata, unsigned int addr, unsigned char value);
unsigned char   z80romget       (void *slotdata, unsigned int addr);
void            z80romset       (void *slotdata, unsigned int addr, unsigned char value);

unsigned int    z80getstate     (void);
void            z80setstate     (unsigned int value);           // e.g. set RESET, IRQ, NMI etc
void            z80clearstate   (unsigned int value);           // e.g. clear RESET, IRQ, NMI etc
unsigned int    z80getbreakpoint(void);
void            z80setbreakpoint(unsigned int value);
void            z80clearbreakpoint(void);

void            z80light        (unsigned int value);           // draw little cpu-on indicator on screen

unsigned char   z80pullstack    (void);
void            z80pushstack    (unsigned int value);

unsigned int    z80line         (void);
void            z80writeregs    (unsigned int window);

#ifdef DEF_ASMLIB
void            z80menu         (void);
#endif


// public global variables
extern  unsigned char   z80active;


// --> #ifndef DEF_INC_Z80_H
#endif
