/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  VIDEO: routines graphic output
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        video.c


        see include file video.h for definitions


----------------------------------------*/


#ifndef DEF_INC_VIDEO_C
#define DEF_INC_VIDEO_C


// **** include general definition files

//#include <stdio.h>            // included by video.h
//#include <string.h>           // included by video.h
//#include "..\libs\asmlib.h"   // included by video.h
//#include "..\libs\general.h"  // included by video.h
//#include "dapple.h"           // included by video.h


// **** include definition file of this source

#include "video.h"


// **** include further Emu][ specific files

#include "gui.h"
#include "font.h"
#include "memory.h"
#include "mouse.h"



/* Methods:

   - virtsetmode
   - virtcacheinit
   - virtsetcharset
   - virtgetcharset
   - virtsettextmode
   - virtgettextmode
   - virtsetlresmode
   - virtgetlresmode
   - virtsethresmode
   - virtgethresmode
   - virtsetdhrsmode
   - virtgetdhrsmode
   - virtsetmonochrome
   - virtgetmonochrome
   - virtsetpalette
   - virtgetpalette
   - virtpaletteset
   - virtpaletteput
   - virtpaletteinit
   - virtinit
   - virtreset
   - virtstore
   - virtrestore
   - virtline
   - virtwrite0400
   - virtwrite0800
   - virtwrite2000
   - virtwrite4000

*/


// **** definitions

// cache flags
// the lower 8 bits including cachepage are resevered for the switch counter
#define cachechanged    0
#define cachepage       0x000001        // (0 = page 1/ 1 = page 2)
#define cachetext40     0x000100
#define cachetext40f    0x000200
#define cachetext40b    0x000400
#define cachetext40bf   0x000800
#define cachetext80     0x001000
#define cachetext80f    0x002000
#define cachetext80b    0x004000
#define cachetext80bf   0x008000
#define cachelres40     0x010000
#define cachelres80     0x020000
#define cachehres       0x040000
#define cachehreso      0x080000
#define cachedhrs       0x100000

// videomodes
#define MODETEXT40      0
#define MODETEXT40BLUR  1
#define MODETEXT80      2
#define MODETEXT80BLUR  3
#define MODELRES        4
#define MODELRESBLUR    5
#define MODELRESMONO    6
#define MODEDLRS        7
#define MODEDLRSBLUR    8
#define MODEDLRSMONO    9
#define MODEHRES        10
#define MODEHRESRGB     11
#define MODEHRESBLUR    12
#define MODEHRESOFF     13
#define MODEHRESRGBOFF  14
#define MODEHRESBLUROFF 15
#define MODEHRESMONO    16
#define MODEHRESMONOE   17
#define MODEDHRS        18
#define MODEDHRS140     19
#define MODEDHRSRGB     20
#define MODEDHRSMONO    21


// **** variables

Charset              virtcharset;
static unsigned char virttextmode;
static unsigned char virtlresmode;
static unsigned char virthresmode;
static unsigned char virtdhrsmode;
static unsigned char virtmonochrome;
static unsigned char virtmonocol0;
static unsigned char virtmonocol1;
static unsigned int  virtmodetop;
static unsigned int  virtmodedown;
static unsigned int  virttextpage;       // 0x0400 or 0x0800
static unsigned int  virthrespage;       // 0x2000 or 0x4000
static unsigned int  virtsplit;
unsigned int  virtrasterline;
unsigned int  virtflashloop;
unsigned int  virtflashmode;
unsigned int  virtflashmodeb;
unsigned int  virtflashmode80;
unsigned int  virtflashmode80b;
unsigned int  virtcachemode;
unsigned char virtgraphic;              // softswitches $c050/51
unsigned char virtmixed;                // softswitches $c052/53
unsigned char virtpage2;                // softswitches $c054/55
unsigned char virthgr;                  // softswitches $c056/67
unsigned char virt80col;                // 40col or 80col?
unsigned char virtaltchar;              // alternate charset?
unsigned char virtiou;                  // IOU active?
unsigned char virtdhres;                // Double hi-res activated?
unsigned char virtvideobyte;            // byte put on the data bus by the graphic circuit

static unsigned char colourtabe[8];
static unsigned char colourtabo[8];
static unsigned char colourtabe2[8];
static unsigned char colourtabo2[8];

unsigned char virtdouble;
unsigned char virtscanline;
static unsigned char virtpalette;

unsigned char virtfont[2048];
unsigned char virtfontflash[2048];
unsigned char virtfontalt[2048];
unsigned char *virtfontptr;
unsigned char *virtfontflashptr;

static unsigned int virtcache[192];
static unsigned int doublebits[256];

static unsigned int textline[0x400];
static const unsigned int textaddr[192] = {
                0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
                0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
                0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
                0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
                0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
                0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280,
                0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
                0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380,
                0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
                0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
                0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128,
                0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
                0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228,
                0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8,
                0x0328, 0x0328, 0x0328, 0x0328, 0x0328, 0x0328, 0x0328, 0x0328,
                0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8,
                0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
                0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0,
                0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
                0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0,
                0x0250, 0x0250, 0x0250, 0x0250, 0x0250, 0x0250, 0x0250, 0x0250,
                0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0,
                0x0350, 0x0350, 0x0350, 0x0350, 0x0350, 0x0350, 0x0350, 0x0350,
                0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0
                };


static unsigned int hresline[0x2000];
static const unsigned int hresaddr[192] = {
                0x0000, 0x0400, 0x0800, 0x0c00, 0x1000, 0x1400, 0x1800, 0x1c00,
                0x0080, 0x0480, 0x0880, 0x0c80, 0x1080, 0x1480, 0x1880, 0x1c80,
                0x0100, 0x0500, 0x0900, 0x0d00, 0x1100, 0x1500, 0x1900, 0x1d00,
                0x0180, 0x0580, 0x0980, 0x0d80, 0x1180, 0x1580, 0x1980, 0x1d80,
                0x0200, 0x0600, 0x0a00, 0x0e00, 0x1200, 0x1600, 0x1a00, 0x1e00,
                0x0280, 0x0680, 0x0a80, 0x0e80, 0x1280, 0x1680, 0x1a80, 0x1e80,
                0x0300, 0x0700, 0x0b00, 0x0f00, 0x1300, 0x1700, 0x1b00, 0x1f00,
                0x0380, 0x0780, 0x0b80, 0x0f80, 0x1380, 0x1780, 0x1b80, 0x1f80,
                0x0028, 0x0428, 0x0828, 0x0c28, 0x1028, 0x1428, 0x1828, 0x1c28,
                0x00a8, 0x04a8, 0x08a8, 0x0ca8, 0x10a8, 0x14a8, 0x18a8, 0x1ca8,
                0x0128, 0x0528, 0x0928, 0x0d28, 0x1128, 0x1528, 0x1928, 0x1d28,
                0x01a8, 0x05a8, 0x09a8, 0x0da8, 0x11a8, 0x15a8, 0x19a8, 0x1da8,
                0x0228, 0x0628, 0x0a28, 0x0e28, 0x1228, 0x1628, 0x1a28, 0x1e28,
                0x02a8, 0x06a8, 0x0aa8, 0x0ea8, 0x12a8, 0x16a8, 0x1aa8, 0x1ea8,
                0x0328, 0x0728, 0x0b28, 0x0f28, 0x1328, 0x1728, 0x1b28, 0x1f28,
                0x03a8, 0x07a8, 0x0ba8, 0x0fa8, 0x13a8, 0x17a8, 0x1ba8, 0x1fa8,
                0x0050, 0x0450, 0x0850, 0x0c50, 0x1050, 0x1450, 0x1850, 0x1c50,
                0x00d0, 0x04d0, 0x08d0, 0x0cd0, 0x10d0, 0x14d0, 0x18d0, 0x1cd0,
                0x0150, 0x0550, 0x0950, 0x0d50, 0x1150, 0x1550, 0x1950, 0x1d50,
                0x01d0, 0x05d0, 0x09d0, 0x0dd0, 0x11d0, 0x15d0, 0x19d0, 0x1dd0,
                0x0250, 0x0650, 0x0a50, 0x0e50, 0x1250, 0x1650, 0x1a50, 0x1e50,
                0x02d0, 0x06d0, 0x0ad0, 0x0ed0, 0x12d0, 0x16d0, 0x1ad0, 0x1ed0,
                0x0350, 0x0750, 0x0b50, 0x0f50, 0x1350, 0x1750, 0x1b50, 0x1f50,
                0x03d0, 0x07d0, 0x0bd0, 0x0fd0, 0x13d0, 0x17d0, 0x1bd0, 0x1fd0
              };


        static const unsigned char blurcol0[16] = {
                COL_LGR0,
                COL_LGR1,
                COL_LGR2,
                COL_LGR3,
                COL_LGR4,
                COL_LGR5,
                COL_LGR6,
                COL_LGR7,
                COL_LGR8,
                COL_LGR9,
                COL_LGRA,
                COL_LGRB,
                COL_LGRC,
                COL_LGRD,
                COL_LGRE,
                COL_LGRF
              };

        static const unsigned char blurcol1[16] = {
                COL_LGR0,
                COL_LGR2,
                COL_LGR4,
                COL_LGR6,
                COL_LGR8,
                COL_LGRA,
                COL_LGRC,
                COL_LGRE,
                COL_LGR1,
                COL_LGR3,
                COL_LGR5,
                COL_LGR7,
                COL_LGR9,
                COL_LGRB,
                COL_LGRD,
                COL_LGRF
              };

        static const unsigned char blurcol2[16] = {
                COL_LGR0,
                COL_LGR4,
                COL_LGR8,
                COL_LGRC,
                COL_LGR1,
                COL_LGR5,
                COL_LGR9,
                COL_LGRD,
                COL_LGR2,
                COL_LGR6,
                COL_LGRA,
                COL_LGRE,
                COL_LGR3,
                COL_LGR7,
                COL_LGRB,
                COL_LGRF
              };


        static const unsigned char blurcol3[16] = {
                COL_LGR0,
                COL_LGR8,
                COL_LGR1,
                COL_LGR9,
                COL_LGR2,
                COL_LGRA,
                COL_LGR3,
                COL_LGRB,
                COL_LGR4,
                COL_LGRC,
                COL_LGR5,
                COL_LGRD,
                COL_LGR6,
                COL_LGRE,
                COL_LGR7,
                COL_LGRF
              };


        static unsigned char textcol[16] = {
                COL_LGR0,
                COL_LGR2,
                COL_LGR4,
                COL_LGR6,
                COL_LGR8,
                COL_LGRA,
                COL_LGRC,
                COL_LGRE,
                COL_LGR1,
                COL_LGR3,
                COL_LGR5,
                COL_LGR7,
                COL_LGR9,
                COL_LGRB,
                COL_LGRD,
                COL_LGRF
              };

        static unsigned char textcol2[16] = {
                COL_LGR0,
                COL_LGR4,
                COL_LGR8,
                COL_LGRC,
                COL_LGR1,
                COL_LGR5,
                COL_LGR9,
                COL_LGRD,
                COL_LGR2,
                COL_LGR6,
                COL_LGRA,
                COL_LGRE,
                COL_LGR3,
                COL_LGR7,
                COL_LGRB,
                COL_LGRF
              };


        static unsigned char textcol3[16] = {
                COL_LGR0,
                COL_LGR8,
                COL_LGR1,
                COL_LGR9,
                COL_LGR2,
                COL_LGRA,
                COL_LGR3,
                COL_LGRB,
                COL_LGR4,
                COL_LGRC,
                COL_LGR5,
                COL_LGRD,
                COL_LGR6,
                COL_LGRE,
                COL_LGR7,
                COL_LGRF
              };

        static unsigned char textcol4[16] = {
                COL_LGR0,
                COL_LGR1,
                COL_LGR2,
                COL_LGR3,
                COL_LGR4,
                COL_LGR5,
                COL_LGR6,
                COL_LGR7,
                COL_LGR8,
                COL_LGR9,
                COL_LGRA,
                COL_LGRB,
                COL_LGRC,
                COL_LGRD,
                COL_LGRE,
                COL_LGRF
              };

        static unsigned char hrescol[16] = {
                COL_LGR0,
                COL_LGR2,
                COL_LGR4,
                COL_LGR6,
                COL_LGR8,
                COL_LGRA,
                COL_LGRC,
                COL_LGRE,
                COL_LGR1,
                COL_LGR3,
                COL_LGR5,
                COL_LGR7,
                COL_LGR9,
                COL_LGRB,
                COL_LGRD,
                COL_LGRF
              };

        static unsigned char hrescol2[16] = {
                COL_LGR0,
                COL_LGR4,
                COL_LGR8,
                COL_LGRC,
                COL_LGR1,
                COL_LGR5,
                COL_LGR9,
                COL_LGRD,
                COL_LGR2,
                COL_LGR6,
                COL_LGRA,
                COL_LGRE,
                COL_LGR3,
                COL_LGR7,
                COL_LGRB,
                COL_LGRF
              };


        static unsigned char hrescol3[16] = {
                COL_LGR0,
                COL_LGR8,
                COL_LGR1,
                COL_LGR9,
                COL_LGR2,
                COL_LGRA,
                COL_LGR3,
                COL_LGRB,
                COL_LGR4,
                COL_LGRC,
                COL_LGR5,
                COL_LGRD,
                COL_LGR6,
                COL_LGRE,
                COL_LGR7,
                COL_LGRF
              };

        static unsigned char hrescol4[16] = {
                COL_LGR0,
                COL_LGR1,
                COL_LGR2,
                COL_LGR3,
                COL_LGR4,
                COL_LGR5,
                COL_LGR6,
                COL_LGR7,
                COL_LGR8,
                COL_LGR9,
                COL_LGRA,
                COL_LGRB,
                COL_LGRC,
                COL_LGRD,
                COL_LGRE,
                COL_LGRF
              };

        static unsigned char dhrscol[16] = {
                COL_LGR0,
                COL_LGR2,
                COL_LGR4,
                COL_LGR6,
                COL_LGR8,
                COL_LGRA,
                COL_LGRC,
                COL_LGRE,
                COL_LGR1,
                COL_LGR3,
                COL_LGR5,
                COL_LGR7,
                COL_LGR9,
                COL_LGRB,
                COL_LGRD,
                COL_LGRF
              };

        static unsigned char dhrscol2[16] = {
                COL_LGR0,
                COL_LGR4,
                COL_LGR8,
                COL_LGRC,
                COL_LGR1,
                COL_LGR5,
                COL_LGR9,
                COL_LGRD,
                COL_LGR2,
                COL_LGR6,
                COL_LGRA,
                COL_LGRE,
                COL_LGR3,
                COL_LGR7,
                COL_LGRB,
                COL_LGRF
              };


        static unsigned char dhrscol3[16] = {
                COL_LGR0,
                COL_LGR8,
                COL_LGR1,
                COL_LGR9,
                COL_LGR2,
                COL_LGRA,
                COL_LGR3,
                COL_LGRB,
                COL_LGR4,
                COL_LGRC,
                COL_LGR5,
                COL_LGRD,
                COL_LGR6,
                COL_LGRE,
                COL_LGR7,
                COL_LGRF
              };

        static unsigned char dhrscol4[16] = {
                COL_LGR0,
                COL_LGR1,
                COL_LGR2,
                COL_LGR3,
                COL_LGR4,
                COL_LGR5,
                COL_LGR6,
                COL_LGR7,
                COL_LGR8,
                COL_LGR9,
                COL_LGRA,
                COL_LGRB,
                COL_LGRC,
                COL_LGRD,
                COL_LGRE,
                COL_LGRF
              };



        static unsigned char dhrscol1rgb[16] = {
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR2,
                COL_LGR6,
                COL_LGRA,
                COL_LGRE,
                COL_LGR3,
                COL_LGR7,
                COL_LGRB,
                COL_LGRF
              };


        static unsigned char dhrscol2rgb[16] = {
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR4,
                COL_LGRC,
                COL_LGR5,
                COL_LGRD,
                COL_LGR6,
                COL_LGRE,
                COL_LGR7,
                COL_LGRF
              };

        static unsigned char dhrscol3rgb[16] = {
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR8,
                COL_LGR9,
                COL_LGRA,
                COL_LGRB,
                COL_LGRC,
                COL_LGRD,
                COL_LGRE,
                COL_LGRF
              };

        static unsigned char dhrscol4rgb[16] = {
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR0,
                COL_LGR1,
                COL_LGR3,
                COL_LGR5,
                COL_LGR7,
                COL_LGR9,
                COL_LGRB,
                COL_LGRD,
                COL_LGRF
              };

/*-------------------------------------*/


      void virtsetmode(void) {

        if (virtgraphic) {                      // set the display modes for both parts of the screen
          if (virthgr) {
            if (virt80col) {
              if (virtdhres) {
                if (virtmonochrome) {
                  virtmodetop = MODEDHRSMONO;
                }
                else {
                  if (virtdhrsmode == 0) {
                    virtmodetop = MODEDHRS;
                  }
                  else {
                    if (virtdhrsmode == 1) {
                      virtmodetop = MODEDHRS140;
                    }
                    else {
                      virtmodetop = MODEDHRSRGB;
                    }
                  }
                }
                if (virtmixed) {
                  if ((virtmonochrome) || (virttextmode == 0)) {
                    virtmodedown = MODETEXT80;
                  }
                  else {
                    virtmodedown = MODETEXT80BLUR;
                  }
                  virtsplit = 160;
                }
                else {
                  virtmodedown = virtmodetop;
                  virtsplit = 192;
                }
              }
              else { // if (virtdhres)
                if (virtmonochrome) {
                  if (appletype & (APPLEIIE | APPLEIIC)) {
                    virtmodetop = MODEHRESMONOE;
                    dvalue1++;
                  }
                  else {
                    virtmodetop = MODEHRESMONO;
                  }
                }
                else {
                  if (virthresmode == 0) {
                    virtmodetop = MODEHRES;
                  }
                  else {
                    if (virthresmode == 1) {
                      virtmodetop = MODEHRESRGB;
                    }
                    else {
                      virtmodetop = MODEHRESBLUR;
                    }
                  }
                }
                if (virtmixed) {
                  if ((virtmonochrome) || (virttextmode == 0)) {
                    virtmodedown = MODETEXT80;
                  }
                  else {
                    virtmodedown = MODETEXT80BLUR;
                  }
                  virtsplit = 160;
                }
                else {
                  virtmodedown = virtmodetop;
                  virtsplit = 192;
                }
              }
            }
            else { // if (virt80col
              if (virtdhres) {
                if (virtmonochrome) {
                  virtmodetop = MODEHRESMONO;
                }
                else {
                  if (virthresmode == 0) {
                    virtmodetop = MODEHRESOFF;
                  }
                  else {
                    if (virthresmode == 1) {
                      virtmodetop = MODEHRESRGBOFF;
                    }
                    else {
                      virtmodetop = MODEHRESBLUROFF;
                    }
                  }
                }
              }
              else { // if (virtdhres)
                if (virtmonochrome) {
                  if (appletype & (APPLEIIE | APPLEIIC)) {
                    virtmodetop = MODEHRESMONOE;
                  }
                  else {
                    virtmodetop = MODEHRESMONO;
                  }
                }
                else {
                  if (virthresmode == 0) {
                    virtmodetop = MODEHRES;
                  }
                  else {
                    if (virthresmode == 1) {
                      virtmodetop = MODEHRESRGB;
                    }
                    else {
                      virtmodetop = MODEHRESBLUR;
                    }
                  }
                }
              } // else if (virtdhres)
              if (virtmixed) {
                if ((virtmonochrome) || (virttextmode == 0)) {
                  virtmodedown = MODETEXT40;
                }
                else {
                  virtmodedown = MODETEXT40BLUR;
                }
                virtsplit = 160;
              }
              else {
                virtmodedown = virtmodetop;
                virtsplit = 192;
              }
            } // else if (virt80col)
          }
          else { // if (virthgr)
            virtsplit = 0;
            if (virt80col) {
              if (virtdhres) {
                if (virtmonochrome) {
                  virtmodetop = MODEDLRSMONO;
                }
                else {
                  if (virtlresmode) {
                    virtmodetop = MODEDLRSBLUR;
                  }
                  else {
                    virtmodetop = MODEDLRS;
                  }
                }
                if (virtmixed) {
                  if ((virtmonochrome) || (virttextmode == 0)) {
                    virtmodedown = MODETEXT80;
                  }
                  else {
                    virtmodedown = MODETEXT80BLUR;
                  }
                }
                else {
                  virtmodedown = virtmodetop;
                }
              }
              else {
                if (virtmonochrome) {
                  virtmodetop = MODELRESMONO;
                }
                else {
                  if (virtlresmode) {
                    virtmodetop = MODELRESBLUR;
                  }
                  else {
                    virtmodetop = MODELRES;
                  }
                }
                if (virtmixed) {
                  if ((virtmonochrome) || (virttextmode == 0)) {
                    virtmodedown = MODETEXT80;
                  }
                  else {
                    virtmodedown = MODETEXT80BLUR;
                  }
                }
                else {
                  virtmodedown = virtmodetop;
                }
              }
            }
            else {
              if (virtmonochrome) {
                virtmodetop = MODELRESMONO;
              }
              else {
                if (virtlresmode) {
                  virtmodetop = MODELRESBLUR;
                }
                else {
                  virtmodetop = MODELRES;
                }
              }
              if (virtmixed) {
                if ((virtmonochrome) || (virttextmode == 0)) {
                  virtmodedown = MODETEXT40;
                }
                else {
                  virtmodedown = MODETEXT40BLUR;
                }
              }
              else {
                virtmodedown = virtmodetop;
              }
            }
          }
        }
        else {
          virtsplit = 0;
          if (virt80col) {
            virtmodetop = MODETEXT80;
            virtmodedown = virtmodetop;
          }
          else {
            virtmodetop = MODETEXT40;
            virtmodedown = virtmodetop;
          }
        }

        if ((memstore80) || !(virtpage2)) {                     // set the visible page
          virtcachemode = virtcachemode & ~cachepage;
          virttextpage = 0x400;
          virthrespage = 0x2000;
        }
        else {
          virtcachemode = virtcachemode | cachepage;
          virttextpage = 0x800;
          virthrespage = 0x4000;
        }

      } // virtsetmode


/*--------------------------------------*/


      void virtcacheinit(void) {

        memset(virtcache, 0, sizeof(virtcache));

      } // virtcacheinit


/*--------------------------------------*/


      void virtsetcharset(Charset charset) {
        register unsigned int i;
        register unsigned int j;
        register unsigned char c;
        register unsigned char c2;
        static unsigned char xchr[11][12]={
          {'#', '$', '@', '[', '\\',']', '^', '`', '{', '|', '}', '~'}, /* USA       */
          {'#', '$', 133, 248, 135, 232, '^', '`', 130, 151, 138, 249}, /* France    */
          {'#', '$', '@', 142, 153, 154, '^', '`', 132, 148, 129, 225}, /* Germany   */
          {156, '$', '@', '[', '\\',']', '^', '`', '{', '|', '}', '~'}, /* UK        */
          {'#', '$', '@', 146, 242, 143, '^', '`', 145, 243, 134, '~'}, /* Denmark 1 */
          {'#', 241, 144, 142, 153, 143, 154, 130, 132, 148, 134, 129}, /* Sweden    */
          {'#', '$', '@', 248, '\\',130, '^', 151, 133, 149, 138, 141}, /* Italy     */
          {158, '$', '@', 173, 165, 168, '^', '`', 249, 164, '}', '~'}, /* Spain     */
          {'#', '$', '@', '[', 157, ']', '^', '`', '{', '|', '}', '~'}, /* Japan     */
          {'#', 241, 144, 146, 242, 143, 154, 130, 145, 243, 134, 129}, /* Norway    */
          {'#', '$', 144, 146, 242, 143, 154, 130, 145, 243, 134, 129}, /* Denmark 2 */
        };
        static unsigned char mousechr[32]={
          0x02, 0x01, 0xB2, 0x0F, 0xFB, 0x08, 0xA9, 0xAA,
          0x1B, 0x0E, 0x19, 0x18, 0x15, 0x14, 0x16, 0x11,
          0x10, 0x1F, 0x1E, 0xC4, 0x0D, 0x1A, 0xB0, 0xB1,
          0xF4, 0xF5, 0x13, 0x04, 0xF0, 0x0A, 0x1C, 0x0C
        };


        switch (charset) {
          case USA :
            virtcharset = USA;
            setmessage("Charset set to 'USA'");
            break;
          case France :
            virtcharset = France;
            setmessage("Charset set to 'France'");
            break;
          case Germany :
            virtcharset = Germany;
            setmessage("Charset set to 'Germany'");
            break;
          case UK :
            virtcharset = UK;
            setmessage("Charset set to 'United Kingdom'");
            break;
          case Denmark1 :
            virtcharset = Denmark1;
            setmessage("Charset set to 'Denmark1'");
            break;
          case Sweden :
            virtcharset = Sweden;
            setmessage("Charset set to 'Sweden'");
            break;
          case Italy :
            virtcharset = Italy;
            setmessage("Charset set to 'Italy'");
            break;
          case Spain :
            virtcharset = Spain;
            setmessage("Charset set to 'Spain'");
            break;
          case Japan :
            virtcharset = Japan;
            setmessage("Charset set to 'Japan'");
            break;
          case Norway :
            virtcharset = Norway;
            setmessage("Charset set to 'Norway'");
            break;
          case Denmark2 :
            virtcharset = Denmark2;
            setmessage("Charset set to 'Denmark2'");
            break;
          default :
            return;
        } /* switch */

        for (i=0x100; i<0x400; i++) {
          virtfont[i+0x400]     = fontoriginal[i];
        } /* for i */

        for (i=0; i<0x20; i++) {
          for (j=0; j<8; j++) {
            virtfont[(i << 3) + 0x400 + j] = fontoriginal[(mousechr[i] << 3) + j];
          } /* for j */
        } /* for i */

        for (i=0; i<12; i++) {          /* replace 8 characters with country specific chars */
          c = xchr[charset][i];
          for (j=0; j<8; j++) {
            virtfont[ (xchr[0][i] << 3) + 0x400 + j] = fontoriginal[(c << 3) + j];
          } /* for j */
        } /* for i */

        for (i=0x400; i<0x800; i++) {
          c = virtfont[i];
          c2 = 0;
          if (c & 0x80) { c2 = c2 | 0x01; }
          if (c & 0x40) { c2 = c2 | 0x02; }
          if (c & 0x20) { c2 = c2 | 0x04; }
          if (c & 0x10) { c2 = c2 | 0x08; }
          if (c & 0x08) { c2 = c2 | 0x10; }
          if (c & 0x04) { c2 = c2 | 0x20; }
          if (c & 0x02) { c2 = c2 | 0x40; }
          virtfont[i] = c2;
        } /* for i */

        for (i=0; i<0x100; i++) {
          c = virtfont [i+0x400];               /* mousetext */
          virtfontalt  [i+0x200]= c;            /* on enhanced Apple//e only */

          c = virtfont [i+0x500];               /* numbers */
          virtfont     [i+0x500]= c;
          virtfontflash[i+0x300]= c;
          virtfontflash[i+0x500]= c;
          virtfontalt  [i+0x500]= c;
          c = ~c;
          virtfont     [i+0x100]= c;
          virtfont     [i+0x300]= c;
          virtfontflash[i+0x100]= c;
          virtfontalt  [i+0x100]= c;

          c = virtfont [i+0x600];               /* capital chars */
          virtfont     [i+0x400]= c;
          virtfont     [i+0x600]= c;
          virtfontflash[i+0x200]= c;
          virtfontflash[i+0x400]= c;
          virtfontflash[i+0x600]= c;
          virtfontalt  [i+0x400]= c;
          virtfontalt  [i+0x600]= c;
          c = ~c;
          virtfont     [i+0x000]= c;
          virtfont     [i+0x200]= c;
          virtfontflash[i+0x000]= c;
          virtfontalt  [i+0x000]= c;
/*        virtfontalt  [i+0x200]= c;            on unenhanced AppleIIe only */

          c = virtfont [i+0x700];               /* small chars */
/* This code maps lowercase to uppercase.
   In reality, it should prolly be [i+0x500], not [i+0x600].
   Also, some Apple ][+s have lowercase mods.
   Disabled at present.
          if (appletype == APPLEII) {
            c2 = virtfont[i+0x600];
            virtfont     [i+0x700]= c2;
            virtfontflash[i+0x700]= c2;
          }
          else { */
            virtfont     [i+0x700]= c;
            virtfontflash[i+0x700]= c;
/*          }  */
          virtfontalt  [i+0x700]= c;
          c = ~c;
          virtfontalt  [i+0x300]= c;

        } // for i

        virtfontptr      = virtfont;
        virtfontflashptr = virtfont;
      } // virtsetcharset


/*-------------------------------------*/


      Charset virtgetcharset(void) {

        return virtcharset;

      } // virtgetcharset


/*-------------------------------------*/


      void virtsettextmode(unsigned int mode) {

        if (mode == 0) {
          virttextmode = 0;
          setmessage("Set text mode to 'Standard'");
          virtsetmode();
          virtcacheinit();
        }
        else {
          if (mode == 1) {
            virttextmode = 1;
            setmessage("Set text mode to 'Blurry'");
            virtsetmode();
            virtcacheinit();
          }
        }

      } // virtsettextmode


/*-------------------------------------*/


      unsigned int virtgettextmode(void) {

        return virttextmode;

      } // virtgettextmode


/*-------------------------------------*/


      void virtsetlresmode(unsigned int mode) {

        if (mode == 0) {
          virtlresmode = 0;
          setmessage("Set lo-res mode to 'Standard'");
          virtsetmode();
          virtcacheinit();
        }
        else {
          if (mode == 1) {
            virtlresmode = 1;
            setmessage("Set lo-res mode to 'Blurry'");
            virtsetmode();
            virtcacheinit();
          }
        }

      } // virtsetlresmode


/*-------------------------------------*/


      unsigned int virtgetlresmode(void) {

        return virtlresmode;

      } // virtgetlresmode


/*-------------------------------------*/


      void virtsethresmode(unsigned int mode) {

        switch (mode) {
          case 0 :      /* Set standard */
            virthresmode = 0;
                /* even columns */
            colourtabe[0] = COL_HGR0;   /* 000 */
            colourtabe[1] = COL_HGR0;   /* 100 */
            colourtabe[2] = COL_HGR2;   /* 010 */
            colourtabe[3] = COL_HGR3;   /* 110 */
            colourtabe[4] = COL_HGR0;   /* 001 */
            colourtabe[5] = COL_HGR1;   /* 101 */
            colourtabe[6] = COL_HGR3;   /* 011 */
            colourtabe[7] = COL_HGR3;   /* 111 */
                /* odd columns */
            colourtabo[0] = COL_HGR0;   /* 000 */
            colourtabo[1] = COL_HGR0;   /* 100 */
            colourtabo[2] = COL_HGR1;   /* 010 */
            colourtabo[3] = COL_HGR3;   /* 110 */
            colourtabo[4] = COL_HGR0;   /* 001 */
            colourtabo[5] = COL_HGR2;   /* 101 */
            colourtabo[6] = COL_HGR3;   /* 011 */
            colourtabo[7] = COL_HGR3;   /* 111 */
                /* even columns */
            colourtabe2[0] = COL_HGR4;  /* 000 */
            colourtabe2[1] = COL_HGR4;  /* 100 */
            colourtabe2[2] = COL_HGR6;  /* 010 */
            colourtabe2[3] = COL_HGR7;  /* 110 */
            colourtabe2[4] = COL_HGR4;  /* 001 */
            colourtabe2[5] = COL_HGR5;  /* 101 */
            colourtabe2[6] = COL_HGR7;  /* 011 */
            colourtabe2[7] = COL_HGR7;  /* 111 */
                /* odd columns */
            colourtabo2[0] = COL_HGR4;  /* 000 */
            colourtabo2[1] = COL_HGR4;  /* 100 */
            colourtabo2[2] = COL_HGR5;  /* 010 */
            colourtabo2[3] = COL_HGR7;  /* 110 */
            colourtabo2[4] = COL_HGR4;  /* 001 */
            colourtabo2[5] = COL_HGR6;  /* 101 */
            colourtabo2[6] = COL_HGR7;  /* 011 */
            colourtabo2[7] = COL_HGR7;  /* 111 */
            setmessage(
"!\
ESet hi-res mode to 'Composite';\
GSchalte Hi-Res Modus auf 'Composite';\
");
            virtsetmode();
            virtcacheinit();
            break;
          case 1 :      /* Set RGB */
            virthresmode = 1;
                /* even columns */
            colourtabe[0] = COL_HGR0;   /* 000 */
            colourtabe[1] = COL_HGR0;   /* 100 */
            colourtabe[2] = COL_HGR2;   /* 010 */
            colourtabe[3] = COL_HGR3;   /* 110 */
            colourtabe[4] = COL_HGR0;   /* 001 */
            colourtabe[5] = COL_HGR0;   /* 101 */
            colourtabe[6] = COL_HGR2;   /* 011 */
            colourtabe[7] = COL_HGR3;   /* 111 */
                /* odd columns */
            colourtabo[0] = COL_HGR0;   /* 000 */
            colourtabo[1] = COL_HGR0;   /* 100 */
            colourtabo[2] = COL_HGR1;   /* 010 */
            colourtabo[3] = COL_HGR3;   /* 110 */
            colourtabo[4] = COL_HGR0;   /* 001 */
            colourtabo[5] = COL_HGR0;   /* 101 */
            colourtabo[6] = COL_HGR1;   /* 011 */
            colourtabo[7] = COL_HGR3;   /* 111 */
                /* even columns */
            colourtabe2[0] = COL_HGR4;  /* 000 */
            colourtabe2[1] = COL_HGR4;  /* 100 */
            colourtabe2[2] = COL_HGR6;  /* 010 */
            colourtabe2[3] = COL_HGR7;  /* 110 */
            colourtabe2[4] = COL_HGR4;  /* 001 */
            colourtabe2[5] = COL_HGR4;  /* 101 */
            colourtabe2[6] = COL_HGR6;  /* 011 */
            colourtabe2[7] = COL_HGR7;  /* 111 */
                /* odd columns */
            colourtabo2[0] = COL_HGR4;  /* 000 */
            colourtabo2[1] = COL_HGR4;  /* 100 */
            colourtabo2[2] = COL_HGR5;  /* 010 */
            colourtabo2[3] = COL_HGR7;  /* 110 */
            colourtabo2[4] = COL_HGR4;  /* 001 */
            colourtabo2[5] = COL_HGR4;  /* 101 */
            colourtabo2[6] = COL_HGR5;  /* 011 */
            colourtabo2[7] = COL_HGR7;  /* 111 */
            setmessage(
"!\
ESet hi-res mode to 'RGB';\
GSchalte Hi-Res Modus auf 'RGB';\
");
            virtsetmode();
            virtcacheinit();
            break;
          case 2 :
            virthresmode = 2;
            setmessage(
"!\
ESet hi-res mode to 'Blurry';\
GSchalte Hi-Res Modus auf 'Blurry';\
");
            virtsetmode();
            virtcacheinit();
            break;
        } // switch (mode)

      } // virtsethresmode


/*-------------------------------------*/


      unsigned int virtgethresmode(void) {

        return virthresmode;

      } // virtgethresmode


/*-------------------------------------*/


      void virtsetdhrsmode(unsigned int mode) {

        if (mode == 0) {
          virtdhrsmode = 0;
          setmessage("Set Double Hi-Res resolution to 560 * 192 pixels");
          virtsetmode();
          virtcacheinit();
        }
        else {
          if (mode == 1) {
            virtdhrsmode = 1;
            setmessage("Set Double Hi-Res resolution to 140 * 192 pixels");
            virtsetmode();
            virtcacheinit();
          }
          else {
            if (mode == 2) {
              virtdhrsmode = 2;
              setmessage("Set Double Hi-Res resolution to 'RGB'");
              virtsetmode();
              virtcacheinit();
            }
          }
        }

      } // virtsetdhrsmode


/*-------------------------------------*/


      unsigned int virtgetdhrsmode(void) {

        return virtdhrsmode;

      } // virtgetdhrsmode


/*-------------------------------------*/


      void virtsetmonochrome(unsigned int mode) {

        switch (mode) {
          case 0 :      // colour
            virtmonochrome = 0;
            virtmonocol0 = COL_TXT_WHT0;
            virtmonocol1 = COL_TXT_WHT1;
            setmessage(
"!\
ESet color mode;\
GSchalte um auf Farbmodus;\
");
            virtsetmode();
            virtcacheinit();
            break;
          case 1 :      // monochrome white
            virtmonochrome = 1;
            virtmonocol0 = COL_TXT_WHT0;
            virtmonocol1 = COL_TXT_WHT1;
            setmessage(
"!\
ESet monochrome mode white;\
GSchalte um auf Monochromemodus Wei;\
");
            virtsetmode();
            virtcacheinit();
            break;
          case 2 :      // monochrome green
            virtmonochrome = 2;
            virtmonocol0 = COL_TXT_GRN0;
            virtmonocol1 = COL_TXT_GRN1;
            setmessage(
"!\
ESet monochrome mode green;\
GSchalte um auf Monochromemodus Grn;\
");
            virtsetmode();
            virtcacheinit();
            break;
          case 3 :      // monochrome amber
            virtmonochrome = 3;
            virtmonocol0 = COL_TXT_AMB0;
            virtmonocol1 = COL_TXT_AMB1;
            setmessage(
"!\
ESet monochrome mode amber;\
GSchalte um auf Monochromemodus Braun;\
");
            virtsetmode();
            virtcacheinit();
            break;
          } // switch (mode)

      } // virtsetmonochrome


/*-------------------------------------*/


      unsigned int virtgetmonochrome(void) {

        return virtmonochrome;

      } // virtgetmonochrome


/*-------------------------------------*/


      void virtpaletteset(unsigned int index, unsigned int r,
                          unsigned int g,     unsigned int b) {

        imagesetpcolor(window, index, (r<<16)|(g<<8)|b);
        imagesetpcolor(window, index + 0x20, (((r<<16)|(g<<8)|b) & 0xfefefe) >> 1);

      } // virtpaletteset


/*-------------------------------------*/


      void virtsetpalette(unsigned int mode) {

        switch (mode) {
          case 0x00:                    // AppleIIgs
            virtpalette = 0;
            virtpaletteset(COL_LGR0,   0,  0,  0);
            virtpaletteset(COL_LGR1, 221,  0, 51);
            virtpaletteset(COL_LGR2,   0,  0,153);
            virtpaletteset(COL_LGR3, 221, 34,221);
            virtpaletteset(COL_LGR4,   0,119, 34);
            virtpaletteset(COL_LGR5,  85, 85, 85);
            virtpaletteset(COL_LGR6,  34, 34,255);
            virtpaletteset(COL_LGR7, 102,170,255);
            virtpaletteset(COL_LGR8, 136, 85,  0);
            virtpaletteset(COL_LGR9, 255,102,  0);
            virtpaletteset(COL_LGRA, 170,170,170);
            virtpaletteset(COL_LGRB, 255,153,136);
            virtpaletteset(COL_LGRC,  17,221,  0);
            virtpaletteset(COL_LGRD, 255,255,  0);
            virtpaletteset(COL_LGRE,  68,255,153);
            virtpaletteset(COL_LGRF, 255,255,255);
            virtpaletteset(COL_HGR0,   0,  0,  0);
            virtpaletteset(COL_HGR1,  17,221,  0);
            virtpaletteset(COL_HGR2, 221, 34,221);
            virtpaletteset(COL_HGR3, 255,255,255);
            virtpaletteset(COL_HGR4,   0,  0,  0);
            virtpaletteset(COL_HGR5, 255,102,  0);
            virtpaletteset(COL_HGR6,  34, 34,255);
            virtpaletteset(COL_HGR7, 255,255,255);
            setmessage(
"!\
ESet palette type 'AppleIIgs';\
GSetze Farbpalette auf 'AppleIIgs';\
");
            screenupdate = 1;
            break;
          case 0x01:                    // Standard
            virtpalette = 1;
            virtpaletteset(COL_LGR0,   0,  0,  0);
            virtpaletteset(COL_LGR1, 227, 30, 96);
            virtpaletteset(COL_LGR2,  96, 78,189);
            virtpaletteset(COL_LGR3, 255, 68,253);
            virtpaletteset(COL_LGR4,   0,163, 96);
            virtpaletteset(COL_LGR5, 156,156,156);
            virtpaletteset(COL_LGR6,  20,207,253);
            virtpaletteset(COL_LGR7, 208,195,255);
            virtpaletteset(COL_LGR8,  96,114,  3);
            virtpaletteset(COL_LGR9, 255,106, 60);
            virtpaletteset(COL_LGRA, 156,156,156);
            virtpaletteset(COL_LGRB, 255,160,208);
            virtpaletteset(COL_LGRC,  20,245, 60);
            virtpaletteset(COL_LGRD, 208,221,141);
            virtpaletteset(COL_LGRE, 114,255,208);
            virtpaletteset(COL_LGRF, 255,255,255);
            virtpaletteset(COL_HGR0,   0,  0,  0);
            virtpaletteset(COL_HGR1,  20,245, 60);
            virtpaletteset(COL_HGR2, 255, 68,253);
            virtpaletteset(COL_HGR3, 255,255,255);
            virtpaletteset(COL_HGR4,   0,  0,  0);
            virtpaletteset(COL_HGR5, 255,106, 60);
            virtpaletteset(COL_HGR6,  20,207,253);
            virtpaletteset(COL_HGR7, 255,255,255);
            setmessage(
"!\
ESet palette type 'Standard';\
GSetze Farbpalette auf 'Standard';\
");
            screenupdate = 1;
            break;
          case 0x02:                    // ApplePC
            virtpalette = 2;
            virtpaletteset(COL_LGR0,   0,  0,  0);
            virtpaletteset(COL_LGR1, 124, 32, 64);
            virtpaletteset(COL_LGR2,  32, 48,124);
            virtpaletteset(COL_LGR3, 188, 80,188);
            virtpaletteset(COL_LGR4,   0, 92, 60);
            virtpaletteset(COL_LGR5, 124,124,124);
            virtpaletteset(COL_LGR6,  64,140,184);
            virtpaletteset(COL_LGR7, 188,172,248);
            virtpaletteset(COL_LGR8,  60, 76,  0);
            virtpaletteset(COL_LGR9, 184,108, 64);
            virtpaletteset(COL_LGRA, 124,124,124);
            virtpaletteset(COL_LGRB, 248,156,188);
            virtpaletteset(COL_LGRC,  60,168, 60);
            virtpaletteset(COL_LGRD, 188,200,124);
            virtpaletteset(COL_LGRE, 124,216,188);
            virtpaletteset(COL_LGRF, 255,255,255);
            virtpaletteset(COL_HGR0,   0,  0,  0);
            virtpaletteset(COL_HGR1,  60,168, 60);
            virtpaletteset(COL_HGR2, 188, 80,188);
            virtpaletteset(COL_HGR3, 224,224,224);
            virtpaletteset(COL_HGR4,   0,  0,  0);
            virtpaletteset(COL_HGR5, 184,108, 64);
            virtpaletteset(COL_HGR6,  64,140,184);
            virtpaletteset(COL_HGR7, 224,224,224);
            setmessage(
"!\
ESet palette type 'ApplePC';\
GSetze Farbpalette auf 'ApplePC';\
");
            screenupdate = 1;
            break;
          case 0x03:                    // greyscale
            virtpalette = 3;
            virtpaletteset(COL_LGR0,   0,  0,  0);
            virtpaletteset(COL_LGR1,  96, 96, 96);
            virtpaletteset(COL_LGR2,  95, 95, 95);
            virtpaletteset(COL_LGR3, 144,144,144);
            virtpaletteset(COL_LGR4, 107,107,107);
            virtpaletteset(COL_LGR5, 156,156,156);
            virtpaletteset(COL_LGR6, 155,155,155);
            virtpaletteset(COL_LGR7, 205,205,205);
            virtpaletteset(COL_LGR8,  97, 97, 97);
            virtpaletteset(COL_LGR9, 146,146,146);
            virtpaletteset(COL_LGRA, 155,155,155);
            virtpaletteset(COL_LGRB, 194,194,194);
            virtpaletteset(COL_LGRC, 157,157,157);
            virtpaletteset(COL_LGRD, 208,208,208);
            virtpaletteset(COL_LGRE, 207,207,207);
            virtpaletteset(COL_LGRF, 255,255,255);
            virtpaletteset(COL_HGR0,   0,  0,  0);
            virtpaletteset(COL_HGR1, 157,157,157);
            virtpaletteset(COL_HGR2, 144,144,144);
            virtpaletteset(COL_HGR3, 255,255,255);
            virtpaletteset(COL_HGR4,   0,  0,  0);
            virtpaletteset(COL_HGR5, 146,146,146);
            virtpaletteset(COL_HGR6, 155,155,155);
            virtpaletteset(COL_HGR7, 255,255,255);
            setmessage(
"!\
ESet palette type 'Grayscale';\
GSetze Farbpalette auf 'Graustufen';\
");
            screenupdate = 1;
            break;
        } // switch (mode)

      } // virtsetpalette


/*-------------------------------------*/


      unsigned int virtgetpalette(void) {

        return virtpalette;

      } // virtgetpalette


/*-------------------------------------*/


      void virtpaletteinit(void) {

        virtsetpalette(1);      // standard colours for LoRes and HiRes

        virtpaletteset(COL_TXT_WHT0,0x00,0x00,0x00);
        virtpaletteset(COL_TXT_WHT1,0xff,0xff,0xff);
        virtpaletteset(COL_TXT_GRN0,0x00,0x00,0x00);
        virtpaletteset(COL_TXT_GRN1,0x00,0xaf,0x00);
        virtpaletteset(COL_TXT_AMB0,0x00,0x00,0x00);
        virtpaletteset(COL_TXT_AMB1,0xbf,0x5f,0x00);

      } // virtpaletteinit


/*-------------------------------------*/


      void virtreset(void) {

        virtrasterline  = 0;
        virtflashloop   = 0;
        virtgraphic     = 0;
        virtmixed       = 0;
        virtpage2       = 0;
        virthgr         = 0;
        virt80col       = 0;
        virtaltchar     = 0;
        virtiou         = 0x80;
        virtdhres       = 0;
        virtflashmode   = cachetext40;
        virtflashmodeb  = cachetext40b;
        virtflashmode80 = cachetext80;
        virtflashmode80b= cachetext80b;
        virtcacheinit();
        virtsetmode();

      } // virtreset


/*-------------------------------------*/


      void virtinit(void) {
        register unsigned int i;
        register unsigned int byte;
        register unsigned int val;
        unsigned int *textlineptr;
        unsigned int *hreslineptr;
        const unsigned char textlinet[32] = {
                0x00,0x08,0x10,0xff,0x01,0x09,0x11,0xff,0x02,0x0a,0x12,0xff,0x03,0x0b,0x13,0xff,
                0x04,0x0c,0x14,0xff,0x05,0x0d,0x15,0xff,0x06,0x0e,0x16,0xff,0x07,0x0f,0x17,0xff
        };
        const unsigned char hreslinet[256] = {
                0x00,0x40,0x80,0xff,0x08,0x48,0x88,0xff,0x10,0x50,0x90,0xff,0x18,0x58,0x98,0xff,
                0x20,0x60,0xa0,0xff,0x28,0x68,0xa8,0xff,0x30,0x70,0xb0,0xff,0x38,0x78,0xb8,0xff,
                0x01,0x41,0x81,0xff,0x09,0x49,0x89,0xff,0x11,0x51,0x91,0xff,0x19,0x59,0x99,0xff,
                0x21,0x61,0xa1,0xff,0x29,0x69,0xa9,0xff,0x31,0x71,0xb1,0xff,0x39,0x79,0xb9,0xff,
                0x02,0x42,0x82,0xff,0x0a,0x4a,0x8a,0xff,0x12,0x52,0x92,0xff,0x1a,0x5a,0x9a,0xff,
                0x22,0x62,0xa2,0xff,0x2a,0x6a,0xaa,0xff,0x32,0x72,0xb2,0xff,0x3a,0x7a,0xba,0xff,
                0x03,0x43,0x83,0xff,0x0b,0x4b,0x8b,0xff,0x13,0x53,0x93,0xff,0x1b,0x5b,0x9b,0xff,
                0x23,0x63,0xa3,0xff,0x2b,0x6b,0xab,0xff,0x33,0x73,0xb3,0xff,0x3b,0x7b,0xbb,0xff,
                0x04,0x44,0x84,0xff,0x0c,0x4c,0x8c,0xff,0x14,0x54,0x94,0xff,0x1c,0x5c,0x9c,0xff,
                0x24,0x64,0xa4,0xff,0x2c,0x6c,0xac,0xff,0x34,0x74,0xb4,0xff,0x3c,0x7c,0xbc,0xff,
                0x05,0x45,0x85,0xff,0x0d,0x4d,0x8d,0xff,0x15,0x55,0x95,0xff,0x1d,0x5d,0x9d,0xff,
                0x25,0x65,0xa5,0xff,0x2d,0x6d,0xad,0xff,0x35,0x75,0xb5,0xff,0x3d,0x7d,0xbd,0xff,
                0x06,0x46,0x86,0xff,0x0e,0x4e,0x8e,0xff,0x16,0x56,0x96,0xff,0x1e,0x5e,0x9e,0xff,
                0x26,0x66,0xa6,0xff,0x2e,0x6e,0xae,0xff,0x36,0x76,0xb6,0xff,0x3e,0x7e,0xbe,0xff,
                0x07,0x47,0x87,0xff,0x0f,0x4f,0x8f,0xff,0x17,0x57,0x97,0xff,0x1f,0x5f,0x9f,0xff,
                0x27,0x67,0xa7,0xff,0x2f,0x6f,0xaf,0xff,0x37,0x77,0xb7,0xff,0x3f,0x7f,0xbf,0xff
        };


// initialize huge lookup table textline and hresline
        textlineptr = textline;
        hreslineptr = hresline;
        for (i=0; i<0x100; i++) {

          if (i < 32) {
            val = textlinet[i];
            if (val == 0xff) {
              for (byte=8; byte; byte--) {              // write screenholes
                *textlineptr++ = val;
              }
            }
            else {
              val = val << 3;
              for (byte=40; byte; byte--) {
                *textlineptr++ = val;
              }
            }
          }

          val = hreslinet[i];
          if (val == 0xff) {
            for (byte=8; byte; byte--) {                // write screenholes
              *hreslineptr++ = val;
            }
          }
          else {
            for (byte=40; byte; byte--) {
              *hreslineptr++ = val;
            }
          }

        } // for i

// initialize double bits lookup table
        for (i=0; i<0x100; i++) {
          byte = 0;
          if (i&0x80) { byte = byte | 0xc000; }
          if (i&0x40) { byte = byte | 0x3000; }
          if (i&0x20) { byte = byte | 0x0c00; }
          if (i&0x10) { byte = byte | 0x0300; }
          if (i&0x08) { byte = byte | 0x00c0; }
          if (i&0x04) { byte = byte | 0x0030; }
          if (i&0x02) { byte = byte | 0x000c; }
          if (i&0x01) { byte = byte | 0x0003; }
          doublebits[i] = byte;
        } // for i

        virtsetcharset(USA);
        virtcacheinit();                        // clear cache
        virtcachemode = 0;

        virtsetmonochrome(0);                   // set to colour mode
        virtsettextmode(0);                     // set standard text mode
        virtsetlresmode(0);                     // set standard lo-res mode
        virtsethresmode(0);                     // set standard hi-res mode
        virtsetdhrsmode(0);                     // set standard double hi-res mode
        virtpaletteinit();                      // set standard palette
        virtscanline = 0;
        virtdouble = 0;

        virtreset();                            // reset softswitches
        virtsetmode();                          // set mode and page for rasterline

        screenupdate = 1;

      } // virtinit


/*-------------------------------------*/


      unsigned char *virtstore(unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        memset(header, 0x00, sizeof(header));
        strcpy(header, "VIDEO STATE V0.27");
        fwrite(header,           sizeof(header),        1, file);

        fwrite(&virtflashloop,  sizeof(virtflashloop),  1,file);
        fwrite(&virtrasterline, sizeof(virtrasterline), 1,file);
        fwrite(&virtgraphic,    sizeof(virtgraphic),    1, file);
        fwrite(&virtmixed,      sizeof(virtmixed),      1, file);
        fwrite(&virtpage2,      sizeof(virtpage2),      1, file);
        fwrite(&virthgr,        sizeof(virthgr),        1, file);
        fwrite(&virt80col,      sizeof(virt80col),      1, file);
        fwrite(&virtaltchar,    sizeof(virtaltchar),    1, file);
        fwrite(&virtiou,        sizeof(virtiou),        1, file);
        fwrite(&virtdhres,      sizeof(virtdhres),      1, file);
        fwrite(&virtcharset,    sizeof(virtcharset),    1, file);
        fwrite(&virttextmode,   sizeof(virttextmode),   1, file);
        fwrite(&virtlresmode,   sizeof(virtlresmode),   1, file);
        fwrite(&virthresmode,   sizeof(virthresmode),   1, file);
        fwrite(&virtdhrsmode,   sizeof(virtdhrsmode),   1, file);
        fwrite(&virtmonochrome, sizeof(virtmonochrome), 1, file);
        fwrite(&virtpalette,    sizeof(virtpalette),    1, file);
        fwrite(&virtdouble,     sizeof(virtdouble),     1, file);
        fwrite(&virtscanline,   sizeof(virtscanline),   1, file);

        guipercent(winprotocol, percent,
"!\
EVideo stored.;\
GVideo gespeichert.;\
");

        return NULL;            // no error

      } // virtstore


/*-------------------------------------*/


      unsigned char *virtrestore(unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        fread(header,           sizeof(header),         1, file);
        if (strcmp(header, "VIDEO STATE V0.27")) {
          stringwrite(winprotocol, "Video emulation data not found.\r");
          return "Video emulation data not found.\r";
        }

        fread(&virtflashloop,   sizeof(virtflashloop),  1,file);
        fread(&virtrasterline,  sizeof(virtrasterline), 1,file);
        fread(&virtgraphic,     sizeof(virtgraphic),    1, file);
        fread(&virtmixed,       sizeof(virtmixed),      1, file);
        fread(&virtpage2,       sizeof(virtpage2),      1, file);
        fread(&virthgr,         sizeof(virthgr),        1, file);
        fread(&virt80col,       sizeof(virt80col),      1, file);
        fread(&virtaltchar,     sizeof(virtaltchar),    1, file);
        fread(&virtiou,         sizeof(virtiou),        1, file);
        fread(&virtdhres,       sizeof(virtdhres),      1, file);
        fread(&virtcharset,     sizeof(virtcharset),    1, file);
        virtsetcharset(virtcharset);
        fread(&virttextmode,    sizeof(virttextmode),   1, file);
        virtsettextmode(virttextmode);
        fread(&virtlresmode,    sizeof(virtlresmode),   1, file);
        virtsetlresmode(virtlresmode);
        fread(&virthresmode,    sizeof(virthresmode),   1, file);
        virtsethresmode(virthresmode);
        fread(&virtdhrsmode,    sizeof(virtdhrsmode),   1, file);
        virtsetdhrsmode(virtdhrsmode);
        fread(&virtmonochrome,  sizeof(virtmonochrome), 1, file);
        virtsetmonochrome(virtmonochrome);
        fread(&virtpalette,     sizeof(virtpalette),    1, file);
        virtsetpalette(virtpalette);
        fread(&virtdouble,      sizeof(virtdouble),     1, file);
        fread(&virtscanline,    sizeof(virtscanline),   1, file);
        virtsetmode();
        virtcacheinit();

        guipercent(winprotocol, percent,
"!\
EVideo restored.;\
GVideo geladen.;\
");

        return NULL;            // no error

      } // virtrestore


/*-------------------------------------*/


      unsigned int virtcalcline (unsigned char *virtptr, unsigned int rastline) {
        unsigned int addr, mode;
        register unsigned int val;
        unsigned char val8;
        unsigned char bit, bytes;

        if (rastline <= 159) {
          val = virtmodetop;
        }
        else {
          val = virtmodedown;
        }

        switch (val) {

          case MODETEXT40 :             // text 40 column
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr];
            val = virtcachemode | virtflashmode;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 40; bytes; bytes--) {
              val = *(virtfontptr+ ((memram[addr++] << 3) | (rastline & 7)) );
              for ( bit = 1; bit < 0x80; bit=bit<<1) {
                val8 = (val & bit) ? virtmonocol1 : virtmonocol0;
                *virtptr++ = val8;
                *virtptr++ = val8;
              } // for bit
            }   // for bytes
            return -1;

          case MODETEXT40BLUR :         // text 40 column blur
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr];
            val = virtcachemode | virtflashmodeb;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 20; bytes; bytes--) {
              val = (doublebits[*(virtfontptr+ ((memram[addr  ] << 3) | (rastline & 7)) )])
                  | (doublebits[*(virtfontptr+ ((memram[addr+1] << 3) | (rastline & 7)) )] << 14)
                  | (doublebits[*(virtfontptr+ ((memram[addr+2] << 3) | (rastline & 7)) )] << 28);
              if (bytes == 1) { val = val & 0x0fffffff; }
              *virtptr++ = textcol4[ val & 0xf ];
              *virtptr++ = textcol [ (val >>  1) & 0xf ];
              *virtptr++ = textcol2[ (val >>  2) & 0xf ];
              *virtptr++ = textcol3[ (val >>  3) & 0xf ];
              *virtptr++ = textcol4[ (val >>  4) & 0xf ];
              *virtptr++ = textcol [ (val >>  5) & 0xf ];
              *virtptr++ = textcol2[ (val >>  6) & 0xf ];
              *virtptr++ = textcol3[ (val >>  7) & 0xf ];
              *virtptr++ = textcol4[ (val >>  8) & 0xf ];
              *virtptr++ = textcol [ (val >>  9) & 0xf ];
              *virtptr++ = textcol2[ (val >> 10) & 0xf ];
              *virtptr++ = textcol3[ (val >> 11) & 0xf ];
              *virtptr++ = textcol4[ (val >> 12) & 0xf ];
              *virtptr++ = textcol [ (val >> 13) & 0xf ];
              *virtptr++ = textcol2[ (val >> 14) & 0xf ];
              *virtptr++ = textcol3[ (val >> 15) & 0xf ];
              *virtptr++ = textcol4[ (val >> 16) & 0xf ];
              *virtptr++ = textcol [ (val >> 17) & 0xf ];
              *virtptr++ = textcol2[ (val >> 18) & 0xf ];
              *virtptr++ = textcol3[ (val >> 19) & 0xf ];
              *virtptr++ = textcol4[ (val >> 20) & 0xf ];
              *virtptr++ = textcol [ (val >> 21) & 0xf ];
              *virtptr++ = textcol2[ (val >> 22) & 0xf ];
              *virtptr++ = textcol3[ (val >> 23) & 0xf ];
              *virtptr++ = textcol4[ (val >> 24) & 0xf ];
              *virtptr++ = textcol [ (val >> 25) & 0xf ];
              *virtptr++ = textcol2[ (val >> 26) & 0xf ];
              *virtptr++ = textcol3[ (val >> 27) & 0xf ];
              addr++;
              addr++;
            } // for bytes
           return -1;

          case MODETEXT80 :             // text 80 column
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | virtflashmode80;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 40; bytes; bytes--) {
              val8 = *(virtfontptr+ ((memram[addr+0x10000] << 3) | (rastline & 7)) );
              *virtptr++ = (val8 & 0x01) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x02) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x04) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x08) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x10) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x20) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x40) ? virtmonocol1 : virtmonocol0;
              val8 = *(virtfontptr+ ((memram[addr++] << 3) | (rastline & 7)) );
              *virtptr++ = (val8 & 0x01) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x02) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x04) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x08) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x10) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x20) ? virtmonocol1 : virtmonocol0;
              *virtptr++ = (val8 & 0x40) ? virtmonocol1 : virtmonocol0;
            } // for bytes
            return -1;

          case MODETEXT80BLUR :         // text 80 column blur
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | virtflashmode80b;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 20; bytes; bytes--) {
              val = (*(virtfontptr+ ((memram[addr+0x10000] << 3) | (rastline & 7)))      )
                  | (*(virtfontptr+ ((memram[addr        ] << 3) | (rastline & 7))) <<  7)
                  | (*(virtfontptr+ ((memram[addr+0x10001] << 3) | (rastline & 7))) << 14)
                  | (*(virtfontptr+ ((memram[addr+1      ] << 3) | (rastline & 7))) << 21)
                  | (*(virtfontptr+ ((memram[addr+0x10002] << 3) | (rastline & 7))) << 28);
              if (bytes == 1) { val = val & 0x0fffffff; }
              *virtptr++ = textcol4[ val & 0xf ];
              *virtptr++ = textcol [ (val >>  1) & 0xf ];
              *virtptr++ = textcol2[ (val >>  2) & 0xf ];
              *virtptr++ = textcol3[ (val >>  3) & 0xf ];
              *virtptr++ = textcol4[ (val >>  4) & 0xf ];
              *virtptr++ = textcol [ (val >>  5) & 0xf ];
              *virtptr++ = textcol2[ (val >>  6) & 0xf ];
              *virtptr++ = textcol3[ (val >>  7) & 0xf ];
              *virtptr++ = textcol4[ (val >>  8) & 0xf ];
              *virtptr++ = textcol [ (val >>  9) & 0xf ];
              *virtptr++ = textcol2[ (val >> 10) & 0xf ];
              *virtptr++ = textcol3[ (val >> 11) & 0xf ];
              *virtptr++ = textcol4[ (val >> 12) & 0xf ];
              *virtptr++ = textcol [ (val >> 13) & 0xf ];
              *virtptr++ = textcol2[ (val >> 14) & 0xf ];
              *virtptr++ = textcol3[ (val >> 15) & 0xf ];
              *virtptr++ = textcol4[ (val >> 16) & 0xf ];
              *virtptr++ = textcol [ (val >> 17) & 0xf ];
              *virtptr++ = textcol2[ (val >> 18) & 0xf ];
              *virtptr++ = textcol3[ (val >> 19) & 0xf ];
              *virtptr++ = textcol4[ (val >> 20) & 0xf ];
              *virtptr++ = textcol [ (val >> 21) & 0xf ];
              *virtptr++ = textcol2[ (val >> 22) & 0xf ];
              *virtptr++ = textcol3[ (val >> 23) & 0xf ];
              *virtptr++ = textcol4[ (val >> 24) & 0xf ];
              *virtptr++ = textcol [ (val >> 25) & 0xf ];
              *virtptr++ = textcol2[ (val >> 26) & 0xf ];
              *virtptr++ = textcol3[ (val >> 27) & 0xf ];
              addr++;
              addr++;
            } /* for bytes */
           return -1;

          case MODELRESMONO :           /* lores 40 column mono */
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachelres40;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            if ((rastline & 7) < 4) {
              for (bytes = 20; bytes; bytes--) {
                val8 = memram[addr++] & 0xf;
                val = (val8 << 12) |(val8 << 8) |(val8 << 4) | val8;
                for (mode=1; mode<0x4000; mode = mode << 1) {
                  *virtptr++ = (val & mode) ? virtmonocol1 : virtmonocol0;
                } /* for mode */
                val8 = memram[addr++] & 0xf;
                val = ((val8 << 12) |(val8 << 8) |(val8 << 4) | val8) >> 2;
                for (mode=1; mode<0x4000; mode = mode << 1) {
                  *virtptr++ = (val & mode) ? virtmonocol1 : virtmonocol0;
                } /* for mode */
              } /* for bytes */
              return -1;
            }
            else {
              for (bytes = 20; bytes; bytes--) {
                val8 = (memram[addr++] & 0xf0) >> 4;
                val = (val8 << 12) |(val8 << 8) |(val8 << 4) | val8;
                for (mode=1; mode<0x4000; mode = mode << 1) {
                  *virtptr++ = (val & mode) ? virtmonocol1 : virtmonocol0;
                } /* for mode */
                val8 = (memram[addr++] & 0xf0) >> 4;
                val = ((val8 << 12) |(val8 << 8) |(val8 << 4) | val8) >> 2;
                for (mode=1; mode<0x4000; mode = mode << 1) {
                  *virtptr++ = (val & mode) ? virtmonocol1 : virtmonocol0;
                } /* for mode */
              } /* for bytes */
              return -1;
            }

          case MODELRES :               /* lores 40 column */
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachelres40;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            if ((rastline & 7) < 4) {
              for (bytes = 40; bytes; bytes--) {
                val8 = (memram[addr++] & 0xf) + COL_LGR0;
                for (bit=14; bit; bit--) {
                  *virtptr++ = val8;
                } /* for bit */
              } /* for bytes */
              return -1;
            }
            else {
              for (bytes = 40; bytes; bytes--) {
                val8 = (memram[addr++] >> 4) + COL_LGR0;
                 for (bit=14; bit; bit--) {
                  *virtptr++ = val8;
                } /* for bit */
              } /* for bytes */
              return -1;
            }

          case MODELRESBLUR :
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachelres40;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            if ((rastline & 7) < 4) {
              for (bytes = 20; bytes; bytes--) {
                val8 = memram[addr++] & 0xf;
                val = ((val8 & 0x3) << 12) | (val8 << 8)  | (val8 << 4)  | val8;
                val8 = memram[addr++] & 0xf;
                val = val | (val8 << 24) | (val8 << 20) | (val8 << 16) | ((val8  & 0xc) << 12);
                if (bytes != 1) {
                  val = val | ((memram[addr] & 0xf) << 28);
                }
                *virtptr++ = blurcol0[ val & 0xf ];
                *virtptr++ = blurcol1[ (val >>  1) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  2) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  3) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  4) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  5) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  6) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  7) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  8) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  9) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 10) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 11) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 12) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 13) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 14) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 15) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 16) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 17) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 18) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 19) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 20) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 21) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 22) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 23) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 24) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 25) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 26) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 27) & 0xf ];
              } /* for bytes */
              return -1;
            }
            else {
              for (bytes = 20; bytes; bytes--) {
                val8 = memram[addr++] & 0xf0;
                val = ((val8 & 0x30) << 8) | (val8 << 4)  | val8  | (val8 >> 4);
                val8 = memram[addr++] & 0xf0;
                val = val | (val8 << 20) | (val8 << 16) | (val8 << 12) | ((val8  & 0xc0) << 8);
                if (bytes != 1) {
                  val = val | ((memram[addr] & 0xf0) << 24);
                }
                *virtptr++ = blurcol0[ val & 0xf ];
                *virtptr++ = blurcol1[ (val >>  1) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  2) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  3) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  4) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  5) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  6) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  7) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  8) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  9) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 10) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 11) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 12) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 13) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 14) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 15) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 16) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 17) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 18) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 19) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 20) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 21) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 22) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 23) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 24) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 25) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 26) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 27) & 0xf ];
              } /* for bytes */
              return -1;
            }

          case MODEDLRSMONO :           /* lores 80 column mono */
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | cachelres80;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            if ((rastline & 7) < 4) {
              for (bytes = 20; bytes; bytes--) {
                val8 = memram[addr+0x10000] & 0xf;
                val = ((val8 << 4) | val8)                                      & 0x000007f;
                val8 = memram[addr++] & 0xf;
                val = val | (((val8 << 12) | (val8 <<  8) | (val8 <<  4))       & 0x0003f80);
                val8 = memram[addr+0x10000] & 0xf;
                val = val | (((val8 << 20) | (val8 << 16) | (val8 << 12))       & 0x01fc000);
                val8 = memram[addr++] & 0xf;
                val = val | (((val8 << 24) | (val8 << 20))                      & 0xfe00000);
                for (mode=1; mode<0x10000000; mode = mode << 1) {
                  *virtptr++ = (val & mode) ? virtmonocol1 : virtmonocol0;
                } /* for mode */
              } /* for bytes */
              return -1;
            }
            else {
              for (bytes = 20; bytes; bytes--) {
                val8 = memram[addr+0x10000] & 0xf0;
                val = (val8 | (val8 >> 4))                                      & 0x000007f;
                val8 = memram[addr++] & 0xf0;
                val = val | (((val8 <<  8) | (val8 <<  4) | val8)               & 0x0003f80);
                val8 = memram[addr+0x10000] & 0xf0;
                val = val | (((val8 << 16) | (val8 << 12) | (val8 << 8))        & 0x01fc000);
                val8 = memram[addr++] & 0xf0;
                val = val | (((val8 << 20) | (val8 << 16))                      & 0xfe00000);
                for (mode=1; mode<0x10000000; mode = mode << 1) {
                  *virtptr++ = (val & mode) ? virtmonocol1 : virtmonocol0;
                } /* for mode */
              } /* for bytes */
              return -1;
            }

          case MODEDLRS :               /* lores 80 column */
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | cachelres80;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            if ((rastline & 7) < 4) {
              for (bytes = 40; bytes; bytes--) {
                val8 = (memram[addr+0x10000] & 0xf) + COL_LGR0;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = (memram[addr++] & 0xf) + COL_LGR0;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
              } /* for bytes */
              return -1;
            }
            else {
              for (bytes = 40; bytes; bytes--) {
                val8 = (memram[addr+65536] >> 4) + COL_LGR0;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = (memram[addr++] >> 4) + COL_LGR0;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
                *virtptr++ = val8;
              } /* for bytes */
              return -1;
            }

          case MODEDLRSBLUR :           /* lo-res 80 column blur */
            addr = textaddr[rastline] + virttextpage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachelres80;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            if ((rastline & 7) < 4) {
              for (bytes = 20; bytes; bytes--) {
                val8 = memram[addr+0x10000] & 0xf;
                val = ((val8 << 4) | val8)                                      & 0x000007f;
                val8 = memram[addr++] & 0xf;
                val = val | (((val8 << 12) | (val8 <<  8) | (val8 <<  4))       & 0x0003f80);
                val8 = memram[addr+0x10000] & 0xf;
                val = val | (((val8 << 20) | (val8 << 16) | (val8 << 12))       & 0x01fc000);
                val8 = memram[addr++] & 0xf;
                val = val | (((val8 << 24) | (val8 << 20))                      & 0xfe00000);
                if (bytes != 1) {
                  val = val | ((memram[addr+0x10000] & 0xf) << 28);
                }
                *virtptr++ = blurcol0[ val & 0xf ];
                *virtptr++ = blurcol1[ (val >>  1) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  2) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  3) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  4) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  5) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  6) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  7) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  8) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  9) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 10) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 11) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 12) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 13) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 14) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 15) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 16) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 17) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 18) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 19) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 20) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 21) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 22) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 23) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 24) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 25) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 26) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 27) & 0xf ];
              } /* for bytes */
              return -1;
            }
            else {
              for (bytes = 20; bytes; bytes--) {
                val8 = memram[addr+0x10000] & 0xf0;
                val = (val8 | (val8 >> 4))                                      & 0x000007f;
                val8 = memram[addr++] & 0xf0;
                val = val | (((val8 <<  8) | (val8 <<  4) | val8)               & 0x0003f80);
                val8 = memram[addr+0x10000] & 0xf0;
                val = val | (((val8 << 16) | (val8 << 12) | (val8 << 8))        & 0x01fc000);
                val8 = memram[addr++] & 0xf0;
                val = val | (((val8 << 20) | (val8 << 16))                      & 0xfe00000);
                if (bytes != 1) {
                  val = val | ((memram[addr+0x10000] & 0xf0) << 24);
                }
                *virtptr++ = blurcol0[ val & 0xf ];
                *virtptr++ = blurcol1[ (val >>  1) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  2) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  3) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  4) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  5) & 0xf ];
                *virtptr++ = blurcol2[ (val >>  6) & 0xf ];
                *virtptr++ = blurcol3[ (val >>  7) & 0xf ];
                *virtptr++ = blurcol0[ (val >>  8) & 0xf ];
                *virtptr++ = blurcol1[ (val >>  9) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 10) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 11) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 12) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 13) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 14) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 15) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 16) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 17) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 18) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 19) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 20) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 21) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 22) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 23) & 0xf ];
                *virtptr++ = blurcol0[ (val >> 24) & 0xf ];
                *virtptr++ = blurcol1[ (val >> 25) & 0xf ];
                *virtptr++ = blurcol2[ (val >> 26) & 0xf ];
                *virtptr++ = blurcol3[ (val >> 27) & 0xf ];
              } /* for bytes */
              return -1;
            }

          case MODEHRESMONO :           /* hires mono */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachehres;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 40; bytes; bytes--) {
              val = memram[addr++];
              for ( bit = 1; bit<128; bit=bit<<1) {
                val8 = (val & bit) ? virtmonocol1 : virtmonocol0;
                *virtptr++ = val8;
                *virtptr++ = val8;
              } /* for bit */
            } /* for bytes */
            return -1;

          case MODEHRESMONOE :          /* hires mono on Apple//e */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachehres;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            bit = 0;
            for (bytes = 40; bytes; bytes--) {
              val = memram[addr++];
              if (val & 0x80) {
                *virtptr++ = (bit) ? virtmonocol1 : virtmonocol0;
                for (bit = 1; bit < 0x40; bit=bit<<1) {
                  val8 = (val & bit) ? virtmonocol1 : virtmonocol0;
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                }
                bit = val & 0x40;
                *virtptr++ = (bit) ? virtmonocol1 : virtmonocol0;
              }
              else {
                for ( bit = 1; bit<0x80; bit=bit<<1) {
                  val8 = (val & bit) ? virtmonocol1 : virtmonocol0;
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                } /* for bit */
                bit = val & 0x40;
              }
            } /* for bytes */
            return -1;

          case MODEHRES :               /* hires standard */
          case MODEHRESRGB :            /* hires RGB */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachehres;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 40; bytes; bytes--) {
              val = ((memram[addr-1] & 0x60) >> 5)
                  | ((memram[addr]   & 0x7f) << 2)
                  | ((memram[addr+1] & 0x3)  << 9);
              if ((bytes & 1) == 0) {              /* even column */
                if (bytes == 40) {
                  val = val & 0x7fc;       /* drop surrounding bits at left border */
                }
                if (memram[addr] & 0x80) {
                  val8 = colourtabe2[(val >> 1) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo2[(val >> 2) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe2[(val >> 3) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo2[(val >> 4) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe2[(val >> 5) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo2[(val >> 6) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe2[(val >> 7) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                }
                else {
                  val8 = colourtabe[(val >> 1) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo[(val >> 2) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe[(val >> 3) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo[(val >> 4) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe[(val >> 5) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo[(val >> 6) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe[(val >> 7) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                }
              }
              else {                            /* odd column */
                if (bytes == 1) {
                  val = val & 0x1ff;            /* drop surrounding bits at right border */
                }
                if (memram[addr] & 0x80) {
                  val8 = colourtabo2[(val >> 1) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe2[(val >> 2) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo2[(val >> 3) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe2[(val >> 4) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo2[(val >> 5) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe2[(val >> 6) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo2[(val >> 7) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                }
                else {
                  val8 = colourtabo[(val >> 1) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe[(val >> 2) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo[(val >> 3) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe[(val >> 4) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo[(val >> 5) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabe[(val >> 6) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                  val8 = colourtabo[(val >> 7) & 7];
                  *virtptr++ = val8;
                  *virtptr++ = val8;
                }
              }
              addr++;
            } /* for bytes */
            return -1;

//        case MODEHRESRGB :            /* hires RGB */
/*          addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachehres;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            bit = 0;
            for (bytes = 20; bytes; bytes--) {
              val8 = memram[addr-1];
              if (val8 & 0x80) {
                val = (doublebits[val8 & 0x7f] << 1) | (bit == 0x40);
              }
              else {
                val = doublebits[val8];
              }
              bit = val8 & 0x40;

              val8 = memram[addr++];
              if (val8 & 0x80) {
                val = (doublebits[val8 & 0x7f] << 1) | (bit == 0x40);
              }
              else {
                val = doublebits[val8];
              }
              bit = val8 & 0x40;
              val8 = memram[addr++];
              if (val8 & 0x80) {
                val = val | (doublebits[val8 & 0x7f] << 15) | (bit << 8);
              }
              else {
                val = val | (doublebits[val8] << 14);
              }
              bit = val8 & 0x40;
              val8 = memram[addr];
              if (val8 & 0x80) {
                val = val | (doublebits[val8 & 0x7f] << 29) | (bit << 22);
              }
              else {
                val = val | doublebits[val8] << 28;
              }
              if (bytes == 20) { val = val & 0x07ffffff8; }
//            if (bytes == 1) { val = val & 0x0fffffff; }
              *virtptr++ = dhrscol4rgb[ val & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >>  1) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >>  2) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >>  3) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >>  4) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >>  5) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >>  6) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >>  7) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >>  8) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >>  9) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 10) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 11) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 12) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 13) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 14) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 15) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 16) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 17) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 18) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 19) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 20) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 21) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 22) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 23) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 24) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 25) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 26) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 27) & 0xf ];
            } // for bytes //
            return -1;
*/
          case MODEHRESBLUR :           /* hi-res blur */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachehres;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            bit = 0;
            for (bytes = 20; bytes; bytes--) {
              val8 = memram[addr++];
              if (val8 & 0x80) {
                val = (doublebits[val8 & 0x7f] << 1) | (bit == 0x40);
              }
              else {
                val = doublebits[val8];
              }
              bit = val8 & 0x40;
              val8 = memram[addr++];
              if (val8 & 0x80) {
                val = val | (doublebits[val8 & 0x7f] << 15) | (bit << 8);
              }
              else {
                val = val | (doublebits[val8] << 14);
              }
              bit = val8 & 0x40;
              val8 = memram[addr];
              if (val8 & 0x80) {
                val = val | (doublebits[val8 & 0x7f] << 29) | (bit << 22);
              }
              else {
                val = val | doublebits[val8] << 28;
              }
              if (bytes == 1) { val = val & 0x0fffffff; }
              *virtptr++ = hrescol4[ val & 0xf ];
              *virtptr++ = hrescol [ (val >>  1) & 0xf ];
              *virtptr++ = hrescol2[ (val >>  2) & 0xf ];
              *virtptr++ = hrescol3[ (val >>  3) & 0xf ];
              *virtptr++ = hrescol4[ (val >>  4) & 0xf ];
              *virtptr++ = hrescol [ (val >>  5) & 0xf ];
              *virtptr++ = hrescol2[ (val >>  6) & 0xf ];
              *virtptr++ = hrescol3[ (val >>  7) & 0xf ];
              *virtptr++ = hrescol4[ (val >>  8) & 0xf ];
              *virtptr++ = hrescol [ (val >>  9) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 10) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 11) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 12) & 0xf ];
              *virtptr++ = hrescol [ (val >> 13) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 14) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 15) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 16) & 0xf ];
              *virtptr++ = hrescol [ (val >> 17) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 18) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 19) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 20) & 0xf ];
              *virtptr++ = hrescol [ (val >> 21) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 22) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 23) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 24) & 0xf ];
              *virtptr++ = hrescol [ (val >> 25) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 26) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 27) & 0xf ];
            } /* for bytes */
            return -1;

          case MODEHRESOFF :            /* illegal hi-res standard */
          case MODEHRESRGBOFF :         /* illegal hi-res RGB */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachehreso;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 40; bytes; bytes--) {
              val = ((memram[addr-1] & 0x60) >> 5)
                  | ((memram[addr]   & 0x7f) << 2)
                  | ((memram[addr+1] & 0x3)  << 9);
              if ((bytes & 1) == 0) {              /* even column */
                if (bytes == 40) {
                  val = val & 0x7fc;       /* drop surrounding bits at left border */
                }
                val8 = colourtabe[(val >> 1) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabo[(val >> 2) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabe[(val >> 3) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabo[(val >> 4) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabe[(val >> 5) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabo[(val >> 6) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabe[(val >> 7) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
              }
              else {                            /* odd column */
                if (bytes == 1) {
                  val = val & 0x1ff;            /* drop surrounding bits at right border */
                }
                val8 = colourtabo[(val >> 1) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabe[(val >> 2) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabo[(val >> 3) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabe[(val >> 4) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabo[(val >> 5) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabe[(val >> 6) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
                val8 = colourtabo[(val >> 7) & 7];
                *virtptr++ = val8;
                *virtptr++ = val8;
              }
              addr++;
            } /* for bytes */
            return -1;

          case MODEHRESBLUROFF :        /* illegal hi-res blur */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr];
            val = virtcachemode | cachehreso;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 20; bytes; bytes--) {
              val8 = memram[addr++] & 0x7f;
              val = doublebits[val8];
              val8 = memram[addr++] & 0x7f;
              val = val | (doublebits[val8] << 14);
              val8 = memram[addr] & 0x7f;
              val = val | doublebits[val8] << 28;
              if (bytes == 1) { val = val & 0x0fffffff; }
              *virtptr++ = hrescol4[ val & 0xf ];
              *virtptr++ = hrescol [ (val >>  1) & 0xf ];
              *virtptr++ = hrescol2[ (val >>  2) & 0xf ];
              *virtptr++ = hrescol3[ (val >>  3) & 0xf ];
              *virtptr++ = hrescol4[ (val >>  4) & 0xf ];
              *virtptr++ = hrescol [ (val >>  5) & 0xf ];
              *virtptr++ = hrescol2[ (val >>  6) & 0xf ];
              *virtptr++ = hrescol3[ (val >>  7) & 0xf ];
              *virtptr++ = hrescol4[ (val >>  8) & 0xf ];
              *virtptr++ = hrescol [ (val >>  9) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 10) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 11) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 12) & 0xf ];
              *virtptr++ = hrescol [ (val >> 13) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 14) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 15) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 16) & 0xf ];
              *virtptr++ = hrescol [ (val >> 17) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 18) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 19) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 20) & 0xf ];
              *virtptr++ = hrescol [ (val >> 21) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 22) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 23) & 0xf ];
              *virtptr++ = hrescol4[ (val >> 24) & 0xf ];
              *virtptr++ = hrescol [ (val >> 25) & 0xf ];
              *virtptr++ = hrescol2[ (val >> 26) & 0xf ];
              *virtptr++ = hrescol3[ (val >> 27) & 0xf ];
            } /* for bytes */
            return -1;

          case MODEDHRSMONO :           /* double hi-res mono */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | cachedhrs;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 40; bytes; bytes--) {
              val = memram[addr+0x10000];
              for ( bit = 1; bit<128; bit=bit<<1) {
                *virtptr++ = (val & bit) ? virtmonocol1 : virtmonocol0;
              } /* for bit */
              val = memram[addr++];
              for ( bit = 1; bit<128; bit=bit<<1) {
                *virtptr++ = (val & bit) ? virtmonocol1 : virtmonocol0;
              } /* for bit */
            } /* for bytes */
            return -1;

          case MODEDHRS :               /* double hi-res */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | cachedhrs;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 20; bytes; bytes--) {
              val = ( memram[addr+0x10000]&0x7f)
                  | ((memram[addr]        &0x7f) << 7)
                  | ((memram[addr+0x10001]&0x7f) << 14)
                  | ((memram[addr+1]      &0x7f) << 21)
                  | ((memram[addr+0x10002]&0x7f) << 28);
              if (bytes == 1) { val = val & 0x0fffffff; }
              *virtptr++ = dhrscol [ val & 0xf ];
              *virtptr++ = dhrscol2[ (val >>  1) & 0xf ];
              *virtptr++ = dhrscol3[ (val >>  2) & 0xf ];
              *virtptr++ = dhrscol4[ (val >>  3) & 0xf ];
              *virtptr++ = dhrscol [ (val >>  4) & 0xf ];
              *virtptr++ = dhrscol2[ (val >>  5) & 0xf ];
              *virtptr++ = dhrscol3[ (val >>  6) & 0xf ];
              *virtptr++ = dhrscol4[ (val >>  7) & 0xf ];
              *virtptr++ = dhrscol [ (val >>  8) & 0xf ];
              *virtptr++ = dhrscol2[ (val >>  9) & 0xf ];
              *virtptr++ = dhrscol3[ (val >> 10) & 0xf ];
              *virtptr++ = dhrscol4[ (val >> 11) & 0xf ];
              *virtptr++ = dhrscol [ (val >> 12) & 0xf ];
              *virtptr++ = dhrscol2[ (val >> 13) & 0xf ];
              *virtptr++ = dhrscol3[ (val >> 14) & 0xf ];
              *virtptr++ = dhrscol4[ (val >> 15) & 0xf ];
              *virtptr++ = dhrscol [ (val >> 16) & 0xf ];
              *virtptr++ = dhrscol2[ (val >> 17) & 0xf ];
              *virtptr++ = dhrscol3[ (val >> 18) & 0xf ];
              *virtptr++ = dhrscol4[ (val >> 19) & 0xf ];
              *virtptr++ = dhrscol [ (val >> 20) & 0xf ];
              *virtptr++ = dhrscol2[ (val >> 21) & 0xf ];
              *virtptr++ = dhrscol3[ (val >> 22) & 0xf ];
              *virtptr++ = dhrscol4[ (val >> 23) & 0xf ];
              *virtptr++ = dhrscol [ (val >> 24) & 0xf ];
              *virtptr++ = dhrscol2[ (val >> 25) & 0xf ];
              *virtptr++ = dhrscol3[ (val >> 26) & 0xf ];
              *virtptr++ = dhrscol4[ (val >> 27) & 0xf ];
              addr++;
              addr++;
            } /* for (bytes) */
            return -1;

          case MODEDHRS140 :            /* double hi-res 140*192, just a joke */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | cachedhrs;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 20; bytes; bytes--) {
              val8 = dhrscol[ (memram[addr+0x10000]&0xf)];
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              val8 = dhrscol[ ((memram[addr+0x10000]&0x70) >> 4) | ((memram[addr] & 0x01) << 3)];
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              val8 = dhrscol[ ((memram[addr]&0x1e) >> 1)];
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              val8 = dhrscol[ ((memram[addr]&0x60) >> 5) | ((memram[addr+0x10000+1] & 0x03) << 2)];
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              addr++;
              val8 = dhrscol[ ((memram[addr+0x10000]&0x3c) >> 2)];
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              val8 = dhrscol[ ((memram[addr+0x10000]&0x40) >> 6) | ((memram[addr] & 0x7) << 1)];
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              val8 = dhrscol[ ((memram[addr]&0x78) >> 3)];
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              *virtptr++ = val8;
              addr++;
            } /* for (bytes) */
            return -1;

          case MODEDHRSRGB :            /* double hi-res RGB */
            addr = hresaddr[rastline] + virthrespage;
            virtvideobyte = memram[addr+65536];
            val = virtcachemode | cachedhrs;
            if (virtcache[rastline] == val) { return 0; }
            virtcache[rastline] = val;
            screenupdate = 1;
            for (bytes = 20; bytes; bytes--) {
              val = ( memram[addr+0x10000]&0x7f)
                  | ((memram[addr]        &0x7f) << 7)
                  | ((memram[addr+0x10001]&0x7f) << 14)
                  | ((memram[addr+1]      &0x7f) << 21)
                  | ((memram[addr+0x10002]&0x7f) << 28);
              val = (val << 3) | ((memram[addr-1] & 0x70) >> 4);
              if (bytes == 20) { val = val & 0x07ffffff8; }
              *virtptr++ = dhrscol1rgb[ val & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >>  1) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >>  2) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >>  3) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >>  4) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >>  5) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >>  6) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >>  7) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >>  8) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >>  9) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 10) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 11) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 12) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 13) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 14) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 15) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 16) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 17) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 18) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 19) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 20) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 21) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 22) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 23) & 0xf ];
              *virtptr++ = dhrscol1rgb[ (val >> 24) & 0xf ];
              *virtptr++ = dhrscol2rgb[ (val >> 25) & 0xf ];
              *virtptr++ = dhrscol3rgb[ (val >> 26) & 0xf ];
              *virtptr++ = dhrscol4rgb[ (val >> 27) & 0xf ];
              addr++;
              addr++;
            } // for (bytes)
            return -1;

        } // switch

        return 0;       // not needed, only here to avoid compiler warnings

      } // virtcalcline


/*-------------------------------------*/


      void virtline(void) {
        unsigned char *sourceptr;
        register unsigned char *destptr;
        register unsigned int i;

        if (virtrasterline > 265) {             // vertical blank reached?
          virtrasterline = 0;
          virtflashloop++;
          if ((virtflashloop&0x3f)==0x00) {
            if (!virtaltchar) {
              virtflashmode = cachetext40;
              virtflashmodeb = cachetext40b;
              virtflashmode80 = cachetext80;
              virtflashmode80b = cachetext80b;
              virtfontflashptr = virtfont;
              virtfontptr = virtfont;
            }
          }
          else {
            if ((virtflashloop&0x3f)==0x20) {
              if (!virtaltchar) {
                virtflashmode = cachetext40f;
                virtflashmodeb = cachetext40bf;
                virtflashmode80 = cachetext80f;
                virtflashmode80b = cachetext80bf;
                virtfontflashptr = virtfontflash;
                virtfontptr = virtfontflash;
              }
            }
          }
          mousevblank();
         } // virtrasterline > 265
         else {
          if (virtrasterline <= 191) {

            if (virtdouble) {
              virtcache[virtrasterline] = 0;
              virttextpage = 0x400;
              virthrespage = 0x2000;
              virtcalcline(imagegetaddress(window, virtrasterline + 8)       + 40, virtrasterline);
              virtcache[virtrasterline] = 0;
              virttextpage = 0x800;
              virthrespage = 0x4000;
              virtcalcline(imagegetaddress(window, virtrasterline + 192 + 8) + 40, virtrasterline);
            }
            else {
              if (virtscanline == 0) {
                sourceptr = imagegetaddress(window, (virtrasterline <<1) + 8) + 40;
                if (virtcalcline(sourceptr, virtrasterline)) {
                  memcpy( imagegetaddress(window, (virtrasterline <<1) + 9) + 40, sourceptr, 560);
                }
              }
              else {
                if (virtscanline == 1) {
                  sourceptr = imagegetaddress(window, (virtrasterline <<1) + 8) + 40;
                  if (virtcalcline(sourceptr, virtrasterline)) {
                    destptr   = imagegetaddress(window, (virtrasterline <<1) + 9) + 40;
                    for (i=560; i; i--) {
                      *(destptr++) = (*sourceptr++) + 0x20;
                    } // for (i)
                  }
                }
                else {
                  if (virtcalcline(imagegetaddress(window, (virtrasterline <<1) + 8) + 40, virtrasterline)) {
                    memset(imagegetaddress(window, (virtrasterline <<1) + 9) + 40, 0, 560);
                  }
                }
              }
            } // else if (virtdouble)

          } // if virtrasterline <= 191
          virtrasterline++;
        } // else if (virtrasterline > 265)

      } // virtline


/*-------------------------------------*/


      void virtwrite0400(unsigned int addr) {
        register unsigned int line;
        register unsigned int *cacheptr;

        if (~(virtcachemode & cachepage)) {
          line = textline[addr - 0x400];
          if ((line >= virtsplit) && (line <= 191)) {
            cacheptr = &virtcache[line];
            *cacheptr = 0;
            *(cacheptr+1) = 0;
            *(cacheptr+2) = 0;
            *(cacheptr+3) = 0;
            *(cacheptr+4) = 0;
            *(cacheptr+5) = 0;
            *(cacheptr+6) = 0;
            *(cacheptr+7) = 0;
/*          virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line] = 0;
*/        }
        }
      } // virtwrite0400


/*-------------------------------------*/


      void virtwrite0400aux(unsigned int addr) {
        register unsigned int line;

        if (virt80col) {
          if (~(virtcachemode & cachepage)) {
            line = textline[addr - 0x400];
            if ((line >= virtsplit) && (line <= 191)) {
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line] = 0;
            }
          }
        }
      } // virtwrite0400aux


/*-------------------------------------*/


      void virtwrite0800(unsigned int addr) {
        register unsigned int line;

        if (virtcachemode & cachepage) {
          line = textline[addr - 0x800];
          if ((line >= virtsplit) && (line <= 191)) {
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line++] = 0;
            virtcache[line] = 0;
          }
        }
      } // virtwrite0800


/*-------------------------------------*/


      void virtwrite0800aux(unsigned int addr) {
        register unsigned int line;

        if (virt80col) {
          if (virtcachemode & cachepage) {
            line = textline[addr - 0x800];
            if ((line >= virtsplit) && (line <= 191)) {
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line++] = 0;
              virtcache[line] = 0;
            }
          }
        }
      } // virtwrite0800aux


/*-------------------------------------*/


      void virtwrite2000(unsigned int addr) {
        register unsigned int line;

        if (!(virtcachemode & cachepage)) {
          line = hresline[addr - 0x2000];
          if (line < virtsplit) {
            virtcache[line] = 0;
          }
        }
      } // virtwrite2000


/*-------------------------------------*/


      void virtwrite2000aux (unsigned int addr) {
        register unsigned int line;

        if (virtdhres) {
          if (!(virtcachemode & cachepage)) {
            line = hresline[addr - 0x2000];
            if (line < virtsplit) {
              virtcache[line] = 0;
            }
          }
        }
      } // virtwrite2000aux


/*-------------------------------------*/


      void virtwrite4000(unsigned int addr) {
        register unsigned int line;

        if (virtcachemode & cachepage) {
          line = hresline[addr - 0x4000];
          if (line < virtsplit) {
            virtcache[line] = 0;
          }
        }
      } // virtwrite4000


/*-------------------------------------*/


      void virtwrite4000aux(unsigned int addr) {
        register unsigned int line;

        if (virtdhres) {
          if (virtcachemode & cachepage) {
            line = hresline[addr - 0x4000];
            if (line < virtsplit) {
              virtcache[line] = 0;
            }
           }
        }
      } // virtwrite4000aux


/*-------------------------------------*/


      void virtmenu(void) {
        unsigned int  keyboard;
        unsigned int  window;
        unsigned char key;
        unsigned int  update;

        if (!windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1,
"!\
EVideo Options;\
GVideo Optionen;\
", 0, &keyboard, &window)) {
          messageflag = 0;
          update = 1;
          do {
            if (update) {
              channelout(window, 12);           /* clear window */
              stringwritemessage(window,
"!\
E\r[ESC] - Quit\r\r      ;\
G\r[ESC] - Verlasse Men\r\r      ;\
");
              imagesettextattribute(window, IMAGEUNDERLINE);
              stringwrite(window, "Monitor:");
              imagesettextattribute(window, 0);
              imagesetcursor(window, imagegetcursorx(window), imagegetcursory(window)+2);
              switch (virtgetmonochrome() ) {
                case 0 :
                  stringwritemessage(window,
"!\
E\r[M] - Color Screen;\
G\r[M] - Farbbildschirm;\
");
                  break;
                case 1 :
                  stringwritemessage(window,
"!\
E\r[M] - Monochrome screen (white);\
G\r[M] - Monochrombildschirm (wei);\
");
                  break;
                case 2 :
                  stringwritemessage(window,
"!\
E\r[M] - Monochrome screen (green);\
G\r[M] - Monochrombildschirm (grn);\
");
                  break;
                case 3 :
                  stringwritemessage(window,
"!\
E\r[M] - Monochrome screen (amber);\
G\r[M] - Monochrombildschirm (braun);\
");
                  break;

              } // switch

              stringwrite(window, "\r\r      ");
              imagesettextattribute(window, IMAGEUNDERLINE);
              stringwrite(window, "Lo-res mode:");
              imagesettextattribute(window, 0);
              imagesetcursor(window, imagegetcursorx(window), imagegetcursory(window)+2);
              stringwrite(window, "\r[L] - ");
              if (virtgetlresmode() == 0) {
                stringwrite(window, "Standard lo-res display");
              }
              else {
                stringwrite(window, "Blurry lo-res display");
              }

              stringwrite(window, "\r\r      ");
              imagesettextattribute(window, IMAGEUNDERLINE);
              stringwrite(window, "Text mode:");
              imagesettextattribute(window, 0);
              imagesetcursor(window, imagegetcursorx(window), imagegetcursory(window)+2);
              stringwrite(window, "\r[T] - ");
              if (virtgettextmode() == 0) {
                stringwrite(window, "Standard text display");
              }
              else {
                stringwrite(window, "Blurry text display");
              }

              stringwrite(window, "\r\r      ");
              imagesettextattribute(window, IMAGEUNDERLINE);
              stringwrite(window, "Hi-res mode:");
              imagesettextattribute(window, 0);
              imagesetcursor(window, imagegetcursorx(window), imagegetcursory(window)+2);
              stringwrite(window, "\r[H] - ");
              if (virtgethresmode() == 0) {
                stringwrite(window, "Standard hi-res display");
              }
              else {
                if (virtgethresmode() == 1) {
                  stringwrite(window, "RGB hi-res display");
                }
                else {
                  stringwrite(window, "Blurry hi-res display");
                }
              }

              stringwrite(window, "\r\r      ");
              imagesettextattribute(window, IMAGEUNDERLINE);
              stringwrite(window, "Double Hi-res mode:");
              imagesettextattribute(window, 0);
              imagesetcursor(window, imagegetcursorx(window), imagegetcursory(window)+2);
              stringwrite(window, "\r[D] - ");
              if (virtgetdhrsmode() == 0) {
                stringwrite(window, "560 * 192 resolution");
              }
              else {
                if (virtgetdhrsmode() == 1) {
                  stringwrite(window, "140 * 192 resolution");
                }
                else {
                  stringwrite(window, "RGB");
                }
              }

              stringwrite(window, "\r\r      ");
              imagesettextattribute(window, IMAGEUNDERLINE);
              stringwrite(window, "Lo-res/Hi-res color palette:");
              imagesettextattribute(window, 0);
              imagesetcursor(window, imagegetcursorx(window), imagegetcursory(window)+2);
              stringwrite(window, "\r[0] - Palette 0 (Apple IIgs)        ");
              channelout(window, virtgetpalette()==0 ? 42:32);
              stringwrite(window, "\r[1] - Palette 1 (Standard)          ");
              channelout(window, virtgetpalette()==1 ? 42:32);
              stringwrite(window, "\r[2] - Palette 2 (ApplePC-like)      ");
              channelout(window, virtgetpalette()==2 ? 42:32);
              stringwrite(window, "\r[3] - Palette 3 (Grayscale)         ");
              channelout(window, virtgetpalette()==3 ? 42:32);

              stringwrite(window, "\r\r      ");
              imagesettextattribute(window, IMAGEUNDERLINE);
              stringwrite(window, "Display:");
              imagesettextattribute(window, 0);
              imagesetcursor(window, imagegetcursorx(window), imagegetcursory(window)+2);
              stringwrite(window, "\r[V] - View ");
              if (virtdouble) {
                stringwrite(window, "both pages simultaneously");
              }
              else {
                stringwrite(window, "one page");
              }
              stringwrite(window, "\r[S] - Scanline: ");
              if (virtscanline == 0) {
                stringwrite(window, "None");
              }
              else {
                if (virtscanline == 1) {
                  stringwrite(window, "HalfTone");
                }
                else {
                  stringwrite(window, "Full");
                }
              }

              stringwrite(window,"\r[F] - Font: ");
              switch (virtgetcharset()) {
                case USA :
                  stringwrite(window, "USA");
                  break;
                case France :
                  stringwrite(window, "France");
                  break;
                case Germany :
                  stringwrite(window, "Germany");
                  break;
                case UK :
                  stringwrite(window, "United Kingdom");
                  break;
                case Denmark1 :
                  stringwrite(window, "Denmark1");
                  break;
                case Sweden :
                  stringwrite(window, "Sweden");
                  break;
                case Italy :
                  stringwrite(window, "Italy");
                  break;
                case Spain :
                  stringwrite(window, "Spain");
                  break;
                case Japan :
                  stringwrite(window, "Japan");
                  break;
                case Norway :
                  stringwrite(window, "Norway");
                  break;
                case Denmark2 :
                  stringwrite(window, "Denmark2");
                  break;
                default :
                  stringwrite(window, "None selected");
                  break;
              }

              update = 0;
              screenupdate = 1;
            }
            do {
              taskswitch();
              if (windowgetclose(window)) {
                key = 27;
              }
              else {
                key = (unsigned char)channelin(keyboard);
              }
            }
            while ((key == 0) && (!exitprogram));
            switch (key) {
              case 'm' :
              case 'M' :
                update = (virtgetmonochrome() + 1) & 0x3;
                virtsetmonochrome(update);
                update = 1;
                break;

              case 't' :
              case 'T' :
                update = virtgettextmode();
                update++;
                if (update > 1) { update = 0; }
                virtsettextmode(update);
                update = 1;
                break;

              case 'l' :
              case 'L' :
                update = virtgetlresmode();
                update++;
                if (update > 1) { update = 0; }
                virtsetlresmode(update);
                update = 1;
                break;

              case 'h' :
              case 'H' :
                update = virtgethresmode();
                update++;
                if (update > 2) { update = 0; }
                virtsethresmode(update);
                update = 1;
                break;

              case 'd' :
              case 'D' :
                update = virtgetdhrsmode();
                update++;
                if (update > 2) { update = 0; }
                virtsetdhrsmode(update);
                update = 1;
                break;

              case '0' :
                virtsetpalette(0);
                update = 1;
                break;
              case '1' :
                virtsetpalette(1);
                update = 1;
                break;
              case '2' :
                virtsetpalette(2);
                update = 1;
                break;
              case '3' :
                virtsetpalette(3);
                update = 1;
                break;

              case 'v' :
              case 'V' :
                virtdouble = !virtdouble;
                virtcacheinit();
                virtsetmode();
                update = 1;
                break;
              case 'f' :
              case 'F' :
                update = virtgetcharset();
                update++;
                if (update > Denmark2) { update = USA; }
                virtsetcharset(update);
                update = 1;
                break;
              case 's' :
              case 'S' :
                virtscanline++;
                if (virtscanline > 2) { virtscanline = 0; }
                virtcacheinit();
                update = 1;
                break;
            } // switch (key)
          }
          while ((key != 27) && (key != 32) && (key != 13) && (!exitprogram));
          channelclose(keyboard);
          channelclose(window);
          messageflag = 1;
        }

      } // virtmenu

// --> #ifndef DEF_INC_VIDEO_C
#endif
