/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  PIC: Parallel interface
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        pic.c


        see include file pic.h for definitions


----------------------------------------*/


#ifndef DEF_INC_PIC_C
#define DEF_INC_PIC_C


// **** include general definition files

//#include <stdio.h>            // included by pic.h
//#include <string.h>           // included by pic.h
#include <unistd.h>             // used by chdir()
//#include "..\libs\general.h"  // included by pic.h
//#include "..\libs\asmlib.h"   // included by pic.h
//#include "dapple.h"           // included by pic.h


// **** include definition file of this source

#include "pic.h"


// **** include further Emu][ specific files

#include "gui.h"
#include "video.h"


// **** variables

static unsigned char parallelrom[256];
static unsigned char parallelpresent;
unsigned char        parallelactive;






/*--------------------------------------*/


      void parallelinit(void) {

        memset(parallelrom, 0xff, sizeof(parallelrom));
        parallelpresent = 0;
        parallelactive  = 1;

      } // parallelinit


/*--------------------------------------*/


      void parallelloadrom(unsigned int keyboard, unsigned int window) {
        FILE *file;
        unsigned char filepath[260];
        unsigned char oldcwd[260];

        cwdxchgslash(oldcwd, 256);                              /* read old directory path      */
        chdir(inirompath);                                      /* set rom directory            */

        strcpy(filepath, "slotprnt.a65");                       /* search for source code       */
        file=fopen(filepath,"rb");
        if (!file) {
          strcpy(filepath, "slotprnt.s");
          file=fopen(filepath,"rb");
          if (!file) {
            strcpy(filepath, "slotprnt.asm");
            file=fopen(filepath,"rb");
          }
        }
        if (file) {
          fclose(file);                                         /* close file again */
          stringwritemessage(window,
"!\
EAssemble source code for parallel port slot rom...\r;\
GAssembliere Source Code fr das Parallelport-Slotrom...\r;\
;");
          screenupdate = 1;
          taskswitch();
          memset(parallelrom, 0xff, sizeof(parallelrom));
          assembler(parallelrom, sizeof(parallelrom), filepath);/* assemble source code */
          parallelpresent = 1;
        }
        else {
          strcpy(filepath, "parallel.rom");;                    /* search binary rom file       */
          file=fopen(filepath,"rb");
          if (file) {
            stringwritemessage(window,
"!\
EReading parallel port slot rom from file...\r;\
GLese Parallelport-Slotrom aus Datei...\r;\
;");
            screenupdate = 1;
            taskswitch();
            fread(parallelrom, sizeof(parallelrom), 1, file);   /* read binary rom file */
            fclose(file);
            parallelpresent = 1;
          }
          else {
            stringwritemessage(window,
"!\
ENo separate parallel port slot rom found\r;\
GKein gesondertes Parallelport-Slotrom vorhanden\r;\
;");
            screenupdate = 1;
            taskswitch();
            parallelpresent = 0;
            parallelactive  = 0;
          }
        }
        chdir(oldcwd);                                          // restore original directory
//      windowpresskey(keyboard, window);
//      debugger(parallelrom, sizeof(parallelrom));

      } // parallelloadrom


/*--------------------------------------*/


      unsigned char *parallelnew(slot *slotpointer, unsigned int slotnumber) {

        slotpointer->slotclose          = (void *)&slotnofunction;
        slotpointer->slotreset          = (void *)&slotnofunction;
        slotpointer->slotstore          = (void *)&parallelstore;
        slotpointer->slotrestore        = (void *)&parallelrestore;
        slotpointer->slotget            = (void *)&parallelread;
        slotpointer->slotset            = (void *)&parallelwrite;
        slotpointer->slotromget         = (void *)&parallelromread;
        slotpointer->slotromset         = (void *)&parallelromwrite;
        slotpointer->slotmenu           = (void *)&parallelmenu;
        slotpointer->slotshift          = (void *)&slotnofunction;
        slotpointer->slotctrl           = (void *)&slotnofunction;
        slotpointer->slotshiftctrl      = (void *)&slotnofunction;
        slotpointer->slottype           = SLOTTYPEPARALLEL;
        slotpointer->slotdata           = NULL;
        slotpointer->slotname           =
"!\
EParallel Interface;\
GParallele Schnittstelle;\
";
        if (!parallelpresent) {
          return taskseterror("No rom present");        // no rom present ==> emulation not possible
        }
        return NULL;            // no error

      } // parallelnew


/*---------------------------------------*/


      unsigned char *parallelstore(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        memset(header, 0x00, sizeof(header));
        strcpy(header, "PARALLEL STATE V0.27");
        fwrite(header,                  sizeof(header),                 1,file);

        fwrite(parallelrom,             sizeof(parallelrom),            1,file);
        fwrite(&parallelpresent,        sizeof(parallelpresent),        1,file);
        fwrite(&parallelactive,         sizeof(parallelactive),         1,file);

        guipercent(winprotocol, percent,
"!\
EParallel interface stored.;\
GParallele Schnittstelle gespeichert.;\
");

        return NULL;            // no error

      } // parallelstore


/*--------------------------------------*/


      unsigned char *parallelrestore(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        fread(header,                   sizeof(header),                 1,file);
        if (strcmp(header, "PARALLEL STATE V0.27")) {
          stringwrite(winprotocol, "Parallel interface emulation data not found.\r");
          return taskseterror("Parallel interface emulation data not found.");
        }

        fread(parallelrom,              sizeof(parallelrom),            1,file);
        fread(&parallelpresent,         sizeof(parallelpresent),        1,file);
        fread(&parallelactive,          sizeof(parallelactive),         1,file);

        guipercent(winprotocol, percent,
"!\
EParallel interface restored.;\
GParallele Schnittstelle geladen.;\
");

        return NULL;            // no error

      } // parallelrestore


/*--------------------------------------*/


      unsigned char parallelread(void *slotdata, unsigned int addr) {

        return virtvideobyte;

      } // parallelread


/*--------------------------------------*/


      void parallelwrite(void *slotdata, unsigned int addr, unsigned char value) {

        if ((inidebugflag) || (!parallelactive)) {
          return;
        }

        switch (addr & 0x0f) {
          case 0x00 :   // load output port
            fputc(value & 0x7F, stdprn);
            fflush(stdprn);
            break;
        } // switch

      } // parallelwrite


/*--------------------------------------*/


      unsigned char parallelromread(void *slotdata, unsigned int addr) {

        if (parallelactive) {
          return parallelrom[addr & 0xff];      // read from the rom which was separately loaded
        }
        else {
          return 0xff;
        }

      } // parallelromread


/*--------------------------------------*/


      void parallelromwrite(void *slotdata, unsigned int addr, unsigned char value) {

        return;         // Nothing happens here

      } // parallelromwrite


/*--------------------------------------*/


      void parallelmenu (void *slotdata) {
        unsigned int    menukeyboard;
        unsigned int    menuwindow;
        unsigned char   key;
        unsigned int    update;

        if (!windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1,
"!\
EParallel Interface Options;\
GParallelschnittstelle Optionen;\
", 0, &menukeyboard, &menuwindow)) {
          update = 1;
          do {
            if (update) {
              channelout(menuwindow, 12);       /* clear window */
              stringwritemessage(menuwindow,
"!\
E\r[ESC] - Quit\r\r;\
G\r[ESC] - Verlasse Men\r\r;\
");
              if (appletype == APPLEIIC) {
                stringwritemessage(menuwindow,
"!\
E\rNo separate parallel interface present on an Apple//c;\
G\rKeine separate parallele Schnittstelle vorhanden beim Apple//c;\
");
              }
              else {
                if (!parallelpresent) {
                  stringwritemessage(menuwindow,
"!\
E\rNo parallel interface present;\
G\rKeine parallele Schnittstelle vorhanden;\
");
                }
                else {
                  if (parallelactive) {
                    stringwritemessage(menuwindow,
"!\
E\r[A] - Parallel interface activated;\
G\r[A] - Parallele Schnittstelle aktiviert;\
");
                  }
                  else {
                    stringwritemessage(menuwindow,
"!\
E\r[A] - Parallel interface inactive;\
G\r[A] - Parallele Schnittstelle deaktiviert;\
");
                  }
                }
              }
              update = 0;
              screenupdate = 1;
            }
            do {
              taskswitch();
              if (windowgetclose(menuwindow)) {
                key = 27;
              }
              else {
                key = (unsigned char)channelin(menukeyboard);
              }
            }
            while ((key == 0) && (!exitprogram));
            switch (key) {
              case 'a' :
              case 'A' :
                if (parallelpresent) {
                  if (parallelactive) {
                    parallelactive = 0;
                  }
                  else {
                    parallelactive = 1;
                  }
                  update = 1;
                }
                break;
            } // switch (key)
          }
          while ((key != 27) && (key != 32) && (key != 13) && (!exitprogram));
          channelclose(menukeyboard);
          channelclose(menuwindow);
        }

      } // parallelmenu


// --> #ifndef DEF_INC_PIC_C
#endif
