/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  Header file for Dapple shared components
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */

/*----------------------------------------


        mouse.h


        see mouse.c for implementation


----------------------------------------*/


#ifndef DEF_INC_MOUSE_H
#define DEF_INC_MOUSE_H


// **** include general libraries concerning definitions

//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
//#include <string.h>           // included by dapple.h
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h
#include "dapple.h"


// **** public functions

void            mouseinit       (void);                         // general mouse initialization
void            mouseloadrom    (unsigned int keyboard, unsigned int window);
void            mousevblank     (void);                         // general mouse vertical blank handling

void            mousereset      (void *slotdata);               // reset mouse slot
unsigned char   *mousestore     (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *mouserestore   (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);

void            mouseputcoor    (void *slotdata);
unsigned char   mouseread       (void *slotdata, unsigned int addr);
void            mousewrite      (void *slotdata, unsigned int addr, unsigned char value);
unsigned char   mousereadiou    (unsigned int addr);
void            mousewriteiou   (unsigned int addr);
unsigned char   mouseromread    (void *slotdata, unsigned int addr);
void            mouseromwrite   (void *slotdata, unsigned int addr, unsigned int value);

void            mousemenu       (void *slotdata);
unsigned int    mousenew        (slot *slotpointer, unsigned int slotnumber);


// **** public global variables

extern  unsigned int    mousebutton;
extern  unsigned char   mouseactive;


// --> #ifndef DEF_INC_MOUSE_H
#endif
