/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */




#ifndef DEF_INC_MKBMP_C
#define DEF_INC_MKBMP_C


#include <stdio.h>
#include <string.h>
#include "..\libs\general.h"


struct bmp_filehead
{
 char bfh_type[2] structpack;   /* 'BM' */
 int32 bfh_size structpack;     /* total filesize */
 int32 bfh_reserved structpack; /* 0; XXX */
 int32 bfh_offbit structpack;   /* offset to bitmap */
};

struct bmp_infohead
{
 card32 bmpsize structpack;     /* 40? */
 card32 bmpwid structpack;      /* 640 */
 card32 bmphgt structpack;      /* 400 */
 int16 bmpplane structpack;     /* 1 */
 int16 bmpbitcnt structpack;    /* 8 */
 int32 bmppak structpack;       /* BI_RGB, or 0? */
 int32 bmpimgsz structpack;     /* 0 */
 int32 bmppixmx structpack;     /* 2800 */
 int32 bmppixmy structpack;     /* 2800 */
 int32 bmpcolused structpack;   /* 0 */
 int32 bmpcolimport structpack; /* 0 */
};

struct rgba
{
 card8 b structpack;
 card8 g structpack;
 card8 r structpack;
 card8 a structpack;
};

struct screen
{
 struct bmp_filehead filehead structpack;
 struct bmp_infohead infohead structpack;
 struct rgba color[256] structpack;
 card8 image[640][400] structpack;
};

int wrbmp (char *filename, void *buffer, struct rgba *palette)
{
 struct screen bmp;
 int pal;
 FILE *file;

 bmp.filehead.bfh_type[0]='B';
 bmp.filehead.bfh_type[1]='M';
 bmp.filehead.bfh_size=sizeof(struct screen);
 bmp.filehead.bfh_reserved=0;
 bmp.filehead.bfh_offbit=(int)((char*)&(bmp.image)-(char*)&(bmp));
 bmp.infohead.bmpsize=40;
 bmp.infohead.bmpwid=640;
 bmp.infohead.bmphgt=400;
 bmp.infohead.bmpplane=1;
 bmp.infohead.bmpbitcnt=8;
 bmp.infohead.bmppak=0;
 bmp.infohead.bmpimgsz=640*400;
 bmp.infohead.bmppixmx=0;
 bmp.infohead.bmppixmy=0;
 bmp.infohead.bmpcolused=0;
 bmp.infohead.bmpcolimport=0;

 for (pal=0;pal<256;pal++)
 {
  bmp.color[pal].r=palette[pal].r;
  bmp.color[pal].g=palette[pal].g;
  bmp.color[pal].b=palette[pal].b;
  bmp.color[pal].a=0;
 }

 for (pal=0;pal<400;pal++)
 {
  int reallin;
  char *tgt,*src;

  reallin=399-pal;
  src=(char*) buffer;
  tgt=(char*) bmp.image;
  src+=(640*pal);
  tgt+=(640*reallin);
  memcpy(tgt,src,640);
 }

 file=fopen(filename,"wb");
 if (!file) return -1;
 fwrite(&bmp,sizeof(bmp),1,file);
 fclose(file);
 return 0;
}


// --> #ifndef DEF_INC_MKBMP_C
#endif
