@echo off
REM --------------------
REM     Make Emu][
REM --------------------
REM
REM Please put the programs 'NEWER.EXE' and 'PRTWHEAD.EXE'
REM either into your source file folder or add a
REM path to them.
REM
echo Make Emu][ ...



REM **** general libraries ****



REM ---- general.c ----
REM general.c dependencies: general.c, general.h
newer general.o ..\libs\general.c ..\libs\general.h
if errorlevel 1 goto c_general
goto f_general
:c_general
echo Compiling general.c ...
REM redir -o general.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c ..\libs\general.c
redir -o general.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c ..\libs\general.c
if errorlevel 1 goto e_general
goto f_general
:e_general
echo Error in general.c
goto end
:f_general



REM ---- raf.c ----
REM raf.c dependencies: raf.c, raf.h, general.h
newer raf.o ..\libs\raf.c ..\libs\raf.h ..\libs\general.h
if errorlevel 1 goto c_raf
goto f_raf
:c_raf
echo Compiling raf.c ...
redir -o raf.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c ..\libs\raf.c
if errorlevel 1 goto e_raf
goto f_raf
:e_raf
echo Error in raf.c
goto end
:f_raf



REM **** Emu][ specific files ****



REM ---- cpu6502.c ----
REM cpu6502.c dependencies: cpu6502.c, cpu6502.h, asmlib.h, general.h
newer cpu6502.o cpu6502.c cpu6502.h ..\libs\asmlib.h ..\libs\general.h
if errorlevel 1 goto c_cpu6502
goto f_cpu6502
:c_cpu6502
echo Compiling cpu6502.c ...
REM redir -o cpu6502.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c cpu6502.c
redir -o cpu6502.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c cpu6502.c
if errorlevel 1 goto e_cpu6502
goto f_cpu6502
:e_cpu6502
echo Error in cpu6502.c
goto end
:f_cpu6502



REM ---- cpu65c02.c ----
REM cpu65c02.c dependencies: cpu65c02.c, cpu65c02.h, asmlib.h, general.h, dapple.h, disk.h, memory.h
newer cpu65c02.o cpu65c02.c cpu65c02.h ..\libs\asmlib.h ..\libs\general.h dapple.h disk.h memory.h
if errorlevel 1 goto c_cpu65c02
goto f_cpu65c02
:c_cpu65c02
echo Compiling cpu65c02.c ...
REM redir -o cpu65c02.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c cpu65c02.c
redir -o cpu65c02.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c cpu65c02.c
if errorlevel 1 goto e_cpu65c02
goto f_cpu65c02
:e_cpu65c02
echo Error in cpu65c02.c
goto end
:f_cpu65c02



REM ---- dapple.c ----
REM dapple.c dependencies: dapple.c, dapple.h, asmlib.h, general.h, cpu65c02.h, disk.h
REM                        gui.h, lldisk.h, memory.h, mouse.h, pic.h, version.h, video.h, z80.h
newer dapple.o dapple.c dapple.h ..\libs\asmlib.h ..\libs\general.h cpu65c02.h disk.h
if errorlevel 1 goto c_dapple
newer dapple.o gui.h lldisk.h memory.h mouse.h pic.h version.h video.h z80.h
if errorlevel 1 goto c_dapple
goto f_dapple
:c_dapple
echo Compiling dapple.c ...
REM redir -o dapple.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c dapple.c
redir -o dapple.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c dapple.c
if errorlevel 1 goto e_dapple
goto f_dapple
:e_dapple
echo Error in dapple.c
goto end
:f_dapple



REM ---- disk.c ----
REM disk.c dependencies: disk.c, disk.h, asmlib.h, general.h, cpu65c02.h, dapple.h, gui.h, memory.h
newer disk.o disk.c disk.h ..\libs\asmlib.h ..\libs\general.h cpu65c02.h dapple.h gui.h memory.h
if errorlevel 1 goto c_disk
goto f_disk
:c_disk
echo Compiling disk.c ...
REM redir -o disk.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c disk.c
redir -o disk.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c disk.c
if errorlevel 1 goto e_disk
goto f_disk
:e_disk
echo Error in disk.c
goto end
:f_disk



REM ---- gui.c ----
REM gui.c dependencies: gui.c, gui.h, asmlib.h, general.h, dapple.h, 
newer gui.o gui.c ..\libs\asmlib.h ..\libs\general.h dapple.h
if errorlevel 1 goto c_gui
goto f_gui
:c_gui
echo Compiling gui.c ...
REM redir -o gui.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c gui.c
redir -o gui.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c gui.c
if errorlevel 1 goto e_gui
goto f_gui
:e_gui
echo Error in gui.c
goto end
:f_gui



REM ---- ini.c ----
REM ini.c dependencies: ini.c, asmlib.h, general.h, cpu65c02.h, dapple.h,
REM                     disk.h, lldisk.h, memory.h, mouse.h, pic.h, video.h
newer ini.o ini.c ..\libs\asmlib.h ..\libs\general.h cpu65c02.h dapple.h
if errorlevel 1 goto c_ini
newer ini.o disk.h lldisk.h memory.h mouse.h pic.h video.h
if errorlevel 1 goto c_ini
goto f_ini
:c_ini
echo Compiling ini.c ...
REM redir -o ini.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c ini.c
redir -o ini.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c ini.c
if errorlevel 1 goto e_ini
goto f_ini
:e_ini
echo Error in ini.c
goto end
:f_ini



REM ---- lldisk.c ----
REM lldisk.c dependencies: lldisk.c, asmlib.h, general.h, dapple.h, gui.h, memory.h
newer lldisk.o lldisk.c ..\libs\asmlib.h ..\libs\general.h dapple.h gui.h memory.h
if errorlevel 1 goto c_lldisk
goto f_lldisk
:c_lldisk
echo Compiling lldisk.c ...
REM redir -o lldisk.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c lldisk.c
redir -o lldisk.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c lldisk.c
if errorlevel 1 goto e_lldisk
goto f_lldisk
:e_lldisk
echo Error in lldisk.c
goto end
:f_lldisk



REM ---- memory.c ----
REM memory.c dependencies: memory.c, memory.h asmlib.h, general.h, cpu65c02.h, dapple.h,
REM                        disk.h, gui.h, mouse.h, video.h
newer memory.o memory.c memory.h ..\libs\asmlib.h ..\libs\general.h cpu65c02.h dapple.h
if errorlevel 1 goto c_memory
newer memory.o disk.h gui.h mouse.h video.h
if errorlevel 1 goto c_memory
goto f_memory
:c_memory
echo Compiling memory.c ...
REM redir -o memory.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c memory.c
redir -o memory.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c memory.c
if errorlevel 1 goto e_memory
goto f_memory
:e_memory
echo Error in memory.c
goto end
:f_memory



REM ---- mkbmp.c ----
REM mkbmp.c dependencies: mkbmp.c
newer mkbmp.o mkbmp.c
if errorlevel 1 goto c_mkbmp
goto f_mkbmp
:c_mkbmp
echo Compiling mkbmp.c ...
REM redir -o mkbmp.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c mkbmp.c
redir -o mkbmp.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c mkbmp.c
if errorlevel 1 goto e_mkbmp
goto f_mkbmp
:e_mkbmp
echo Error in mkbmp.c
goto end
:f_mkbmp



REM ---- mouse.c ----
REM mouse.c dependencies: mouse.c, mouse.h asmlib.h, general.h, cpu65c02.h, dapple.h, memory.h
newer mouse.o mouse.c mouse.h ..\libs\asmlib.h ..\libs\general.h cpu65c02.h dapple.h memory.h
if errorlevel 1 goto c_mouse
goto f_mouse
:c_mouse
echo Compiling mouse.c ...
REM redir -o mouse.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c mouse.c
redir -o mouse.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c mouse.c
if errorlevel 1 goto e_mouse
goto f_mouse
:e_mouse
echo Error in mouse.c
goto end
:f_mouse



REM ---- pic.c ----
REM pic.c dependencies: pic.c, asmlib.h, general.h, dapple.h
newer pic.o pic.c ..\libs\asmlib.h ..\libs\general.h dapple.h
if errorlevel 1 goto c_pic
newer pic.o ..\libs\asmlib.h
goto f_pic
:c_pic
echo Compiling pic.c ...
REM redir -o pic.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c pic.c
redir -o pic.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c pic.c
if errorlevel 1 goto e_pic
goto f_pic
:e_pic
echo Error in pic.c
goto end
:f_pic



REM ---- rom.c ----
REM rom.c dependencies: rom.c, asmlib.h, general.h, dapple.h
newer rom.o rom.c ..\libs\asmlib.h ..\libs\general.h dapple.h
if errorlevel 1 goto c_rom
goto f_rom
:c_rom
echo Compiling rom.c ...
REM redir -o rom.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c rom.c
redir -o rom.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c rom.c
if errorlevel 1 goto e_rom
goto f_rom
:e_rom
echo Error in rom.c
goto end
:f_rom



REM ---- video.c ----
REM video.c dependencies: video.c, video.h asmlib.h, general.h, dapple.h, font.h, memory.h, mouse.h
newer video.o video.c video.h ..\libs\asmlib.h ..\libs\general.h dapple.h font.h memory.h mouse.h
if errorlevel 1 goto c_video
goto f_video
:c_video
echo Compiling video.c ...
REM redir -o video.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c video.c
redir -o video.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c video.c
if errorlevel 1 goto e_video
goto f_video
:e_video
echo Error in video.c
goto end
:f_video

rem Z80 is disabled

:: REM ---- z80.c ----
:: REM z80.c dependencies: z80.c, z80.h, asmlib.h, general.h, cpu65c02.h, dapple.h, gui.h, memory.h, mouse.h, video.h
:: newer z80.o z80.c z80.h ..\libs\asmlib.h ..\libs\general.h cpu65c02.h dapple.h gui.h memory.h mouse.h video.h
:: if errorlevel 1 goto c_z80
:: goto f_z80
:: :c_z80
:: echo Compiling z80.c ...
:: REM redir -o z80.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -S -c z80.c
:: redir -o z80.err -eo gcc -Wall -O3 -fomit-frame-pointer -s -c z80.c
:: if errorlevel 1 goto e_z80
:: goto f_z80
:: :e_z80
:: echo Error in z80.c
:: goto end
:: :f_z80



REM **** link files ****


REM emu2.exe general libraries dependencies: asmlib.o, general.o, raf.o
newer emu2.exe ..\libs\asmlib.o general.o raf.o
if errorlevel 1 goto link

REM emu2.exe specific files dependencies: cpu6502asm.o, cpu6502.o, cpu65c02.o, dapple.o, disk.o, gui.o, ini.o
REM                                       lldisk.o, memory.o, mkbmp.o, mouse.o, pic.o, rom.o, video.o, z80.o
newer emu2.exe cpu6502asm.o cpu6502.o cpu65c02.o dapple.o disk.o gui.o ini.o
if errorlevel 1 goto link
newer emu2.exe lldisk.o memory.o mkbmp.o mouse.o pic.o rom.o video.o z80.o
if errorlevel 1 goto link
echo (Your Emu][ binaries are already up-to-date.)
goto absend

:link
echo Linking emu2.exe ...
redir -o link.err -eo gcc @link.txt
if errorlevel 1 goto e_link
goto f_link
:e_link
ECHO Link error
goto end
:f_link



REM **** compress emu2.exe ****



upx --best emu2.exe



REM **** finish ****



echo emu2.exe done.



REM **** collect error files ****



:end
prtwhead *.err>error.txt
del *.err


:absend
