/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  Header file for Dapple shared components
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        disk.h


        see disk.c for implementation


----------------------------------------*/


#ifndef DEF_INC_DISK_H
#define DEF_INC_DISK_H


// **** include general libraries concerning definitions

//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
#include "dapple.h"
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h


// **** public constants

#define DISKTYPENONE    0
#define DISKTYPEDOS     1
#define DISKTYPEPRODOS  2
#define DISKTYPENIBBLE  3
#define DISKTYPENIBBLE2 4


// **** public type definition

typedef struct {
  unsigned char slot            structpack;
  unsigned char drive           structpack;
  unsigned char path[260]       structpack;
  unsigned char type            structpack;
  int           volume          structpack;
  unsigned int  phase           structpack;
  unsigned int  tracksize       structpack;
  unsigned int  track           structpack;
  unsigned int  bytepointer     structpack;
  unsigned char access          structpack;
  unsigned char changed         structpack;
  unsigned char writeprotected  structpack;
  unsigned char data[233472]    structpack;
} drivedisk;


// **** public functions

void            driveinit       (void);
void            driveloadrom    (unsigned int keyboard, unsigned int window);

void            driveempty      (drivedisk *disk);
void            driveconvertsecnib(unsigned char source[144360], drivedisk *disk, unsigned int volume);
unsigned int    drivereadsector (unsigned int window, drivedisk *disk, unsigned char *diskbuffer,
                                 unsigned int track, unsigned int sector);
unsigned int    drivesave       (drivedisk *disk, unsigned char *filename);
unsigned char   *driveeject     (drivedisk *disk);
unsigned char   *driveload      (drivedisk *disk, unsigned char *filename);

unsigned char   *drivenew       (slot *slotpointer, unsigned int slotnumber);
unsigned char   *driveclose     (void *slotdata);
unsigned char   *drivestore     (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *driverestore   (void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *drivereset     (void *slotdata);
unsigned char   driveread       (void *slotdata, unsigned int addr);
void            drivewrite      (void *slotdata, unsigned int addr, unsigned char value);
unsigned char   driveromread    (void *slotdata, unsigned int addr);
void            driveromwrite   (void *slotdata, unsigned int addr, unsigned char value);
unsigned char   *drivemenu      (void *slotdata);


// **** public global variables

extern  drivedisk       drivedisk1;
extern  drivedisk       drivedisk2;
extern  unsigned char   drivefastmode;
extern  unsigned char   drivepath[260];
extern  unsigned char   drivemessageflag;       // display current drive track?
extern  unsigned char   drivefastflag;          // fast emulation of disk drive?


// --> #ifndef DEF_INC_DISK_H
#endif
