/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002- 2004 by the EMU][ Project/Dapple ][ Team
 *
 * $Header: /winc/emuiil/source/dapple.c,v 1.5 2003/08/30 10:22:29 dosius Exp $
 *
 * Component:  DAPPLE: main menu, global functions, keyboard emulation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Log: dapple.c,v $
 * Revision ???
 * Z80 core development
 *
 */


#ifndef DEF_INC_DAPPLE_C
#define DEF_INC_DAPPLE_C


// **** include general definition files

#include <dir.h>
// Used by stringgeterror(): convert strerror format to one usable by the
//	windowing system. -uso.
#include <errno.h>
#include <dos.h>
#include <fcntl.h>		// O_BINARY
#include <go32.h>		// _go32_want_ctrl_break()
#include <signal.h>
//#include <stdio.h>		// included by dapple.h
//#include <string.h>		// included by dapple.h
#include <sys/exceptn.h>	// __djgpp_set_ctrl_c()
#include <unistd.h>
//#include "..\libs\general.h"	// included by dapple.h
//#include "..\libs\asmlib.h"	// included by dapple.h


// **** include definition file of this source

#include "dapple.h"


// **** include further Emu][ specific files

#include "version.h"
#include "cpu65c02.h"
#include "disk.h"
#include "gui.h"
#include "ini.h"
#include "lldisk.h"
#include "memory.h"
#include "mouse.h"
#include "pic.h"
#include "video.h"
#ifdef EMUZ80
#include "z80.h"
#endif


#ifdef REECOP
void	romexecute(unsigned int pcaddr);
#endif


// **** definitions

static const unsigned int KEYJOYLEFT	= 0x008;
static const unsigned int KEYJOYCENTER	= 0x600;	// 0x575
static const unsigned int KEYJOYRIGHT	= 0xb7c;


// **** variables

unsigned char *fatalerror;		// pointer to error message of fatal error

unsigned int  screen_xsize;		// screen x resolution
unsigned int  screen_ysize;		// screen y resolution

unsigned int  keyboard;			// basic keyboard handle
unsigned int  window;			// basic window handle

unsigned char callingpath[260];		// filepath when calling Emu2

unsigned int  logkeyboard;		// keyboard handle for logwindow
unsigned int  logwindow;		// window handle for logwindow

unsigned int  cpuregskeyboard;		// keyboard handle for cpuwindow
unsigned int  cpuregswindow;		// window handle for logwindow

unsigned char appletype;		// II+/IIe/IIc

unsigned char keycapslock;		// capslock mode on?
unsigned char keygerman;		// switch 'Y' and 'Z' on German keyboards?
unsigned char keybs;			// switch <BS> and <DEL> ?
unsigned char keyjoystick;		// emulate joystick via numbpad or real joystick

unsigned int  messagecount;		// count down display visibility of message
unsigned char messageflag;		// allow messages

unsigned char cpuflag;			// 6502 or z80 active

unsigned int  inicpudelay;
unsigned char inirompath[260];
unsigned char inidiskpath1[260];
unsigned char inidiskpath2[260];
unsigned char inistatepath[260];
unsigned char inidebugflag;		// debugger on?
unsigned char inidrivemessageflag;	// display current drive track?
unsigned char inidrivefastflag;
unsigned char inimenulanguage;

unsigned char stringerror[256];		// Is that enough? What is the maximum?

slot	      slots[8];			// 8 slots (only 1..7 are used)






/*-------------------------------------*/


     void setmessage(unsigned char *message) {

	if (messageflag) {
	  imagesetcursor(window, 0, 399);
	  imagefillbox(window, 0, 392, 639, 399, 0xff8000);
	  imagesettextcolor(window, 0xff8000, 0x000000);
	  stringwritemessage(window, message);
	  messagecount = 50 * 4;
	  screenupdate = 1;
	}

     } // setmessage


/*-------------------------------------*/


// 'strright' and 'stringcomparec' have been moved to general.c!


      void cwdxchgslash(unsigned char *stringptr, unsigned int value) {

	getcwd(stringptr, value);
	while (*stringptr) {
	  if (*stringptr == '/') {
	    *stringptr = '\\';
	  }
	  stringptr++;
	} // while
      } // cwdxchgslash


/*-------------------------------------*/


      void getpathstring(unsigned char *destptr, unsigned char *sourceptr) {
	register unsigned char *last;
	register unsigned char c;

	last = destptr;
	do {
	  c = *(sourceptr++);
	  *destptr = c;
	  if (c == '\\') {
	    last = destptr;
	  }
	  destptr++;
	}
	while (c != '\0');
	*last = '\0';

      } // getpathstring


/*-------------------------------------*/


      void getfilestring(unsigned char *destptr, unsigned char *sourceptr) {
	register unsigned char *last;
	register unsigned char c;

	last = sourceptr;
	do {
	  c = *(sourceptr++);
	  if ((c == '\\') || (c == ':')) {
	    last = sourceptr;
	  }
	}
	while (c != '\0');
	do {
	  c = *(last++);
	  *(destptr++) = c;
	}
	while (c != '\0');
      } // getfilestring






/*----------------------------------------

	additional keyboard handling

----------------------------------------*/

      unsigned char keyboardyesno(unsigned int keyboard, unsigned int window) {
	register unsigned char key;

	screenupdate = 1;
	do {
	  do {
	    taskswitch();
	    if (windowgetclose(window)) {
	      key = 27;
	    }
	    else {
	      key = (unsigned char)channelin(keyboard);
	    }
	  }
	  while ((key == 0) && (!exitprogram));
	  if ((key == 27) || (key == 32)) {
	    return 0;
	  }
	  if (inimenulanguage == 'E') {
	    switch (key) {
	      case 'n' :
	      case 'N' :
	        return 0;
	      case 'y' :
	      case 'Y' :
	        return 1;
	    }
	  }
	  else {
	    switch (key) {
	      case 'n' :
	      case 'N' :
	        return 0;
	      case 'j' :
	      case 'J' :
	        return 1;
	    }
	  }
	}
	while (!exitprogram);
	return 0;

      } // keyboardyesno






/*----------------------------------------

	additional string handling

----------------------------------------*/

      unsigned char *stringgeterror(void) {
	register unsigned char *stringptr;

	stringptr = strerror(errno);
	strcpy(stringerror, stringptr);	// copy string. GCC says: pointer to static string. Do no not modify.

	stringptr = strchr(stringerror,'\n');
	while (stringptr) {		// change C's newline to a CR for the windowing system
	  *stringptr='\r';
	  stringptr=strchr(stringptr,'\n');
	}

	return stringerror;

      } // stringgeterror


/*--------------------------------------*/


      void stringfilemessage(unsigned int channel, unsigned char *messagename) {
	register unsigned char *messageptr;

	messageptr = messageget(messagename);
	if (messageptr != NULL) {
	  stringwritemessage(channel, messageptr);
	}
	else {
	  stringwrite(channel, "No message found");
	}

      } // stringfilemessage


/*--------------------------------------*/


      void stringwritecenterx(unsigned int window, unsigned char *stringpointer) {
        unsigned int xsize;
        unsigned int ysize;

	imagegetsize(window, &xsize, &ysize);
	imagesetcursor(window, (int)(xsize - (strlen(stringpointer) << 3)) / 2, imagegetcursory(window) );
	stringwrite(window, stringpointer);

      } // stringwritecenterx


/*--------------------------------------*/


      void stringwriteyesno(unsigned int window, unsigned char value) {
	if (value) {
	  stringwritemessage(window,
"!\
EYes;\
GJa;\
");
	}
	else {
	  stringwritemessage(window,
"!\
ENo;\
GNein;\
");
	}

      } // stringwriteyesno


/*--------------------------------------*/


      void stringwriteonoff(unsigned int window, unsigned char value) {
	if (value) {
	  stringwritemessage(window,
"!\
EOn;\
GAn;\
");
	}
	else {
	  stringwritemessage(window,
"!\
EOff;\
GAus;\
");
	}

      } // stringwriteonoff






/*----------------------------------------

	additional window handling

----------------------------------------*/


      unsigned char *windowprotocol(unsigned int *keyboard, unsigned int *window, unsigned char *title) {
	const unsigned int XSIZE = 480;
	const unsigned int YSIZE = 128;
	register unsigned char *error;

	error = windowaddio(-1, -1, XSIZE, YSIZE, 0, 0, NULL, 0, keyboard, window);
	if (!error) {
	  imagedrawbox(*window, 0,	0,	XSIZE-1,YSIZE-1,0x000000);

	  guishadowbox(*window, 1, 1, XSIZE - 2, YSIZE - 2, 0xffffff, 0x404040);

	  imagesetview(*window, 2,	2,	XSIZE-3,YSIZE-3);
	  imagesettextcolor(*window,	0x808080,	0xffffff);
	  imagesettextattribute(*window, IMAGEBOLD);
	  channelout(*window, 12);
	  stringwritemessage(*window, title);
	  imagesettextattribute(*window, 0);
	  imagefillbox(*window, 2, imagegetcursory(*window)+2, XSIZE-3, imagegetcursory(*window)+2, 0x404040);
	  imagefillbox(*window, 2, imagegetcursory(*window)+3, XSIZE-3, imagegetcursory(*window)+3, 0xffffff);
	  imagesetview(*window, 2,	imagegetcursory(*window)+6, XSIZE-3, YSIZE-3);

	  guishadowbox(*window, 14, 22, XSIZE - 14, 24 + 65, RGBWHITE, RGBDGREY);


	  imagesetview(*window, 16, 24, XSIZE - 16, 24+63);
	  imagesettextcolor(*window,	0x808090,	0xffff00);
	  channelout(*window, 12);
	}
	return error;

      } // windowprotocol


/*--------------------------------------*/


      void windowpresskey(unsigned int keyboard, unsigned int window) {

	stringwritemessage(window,
"!\
EPress a key to continue.;\
GBitte drcken Sie eine beliebige Taste zum Fortfahren.;\
");
	screenupdate = 1;
	do {
	  taskswitch();
	}
	while (((unsigned char)channelin(keyboard) == 0) && (!exitprogram));

      } // windowpresskey


/*--------------------------------------*/


/*
      void imagetickbox(unsigned int window, unsigned int value) {

	register unsigned int cursorx;
	register unsigned int cursory;

	cursorx = imagegetcursorx(window);
	cursory = imagegetcursory(window);

	imagefillbox(window, cursorx, cursory-7, cursorx+7, cursory, RGBLIGHT);
	imagefillbox(window, cursorx, cursory-6, cursorx+6, cursory, RGBDARK);
	imagefillbox(window, cursorx+1, cursory-6, cursorx+6, cursory-1, RGBWHITE);

	if (value) {
	  imagedrawline(window, cursorx+2, cursory-4, cursorx+3, cursory-2, RGBBLACK);
	  imagedrawline(window, cursorx+3, cursory-2, cursorx+6, cursory-5, RGBBLACK);
	}
	imagesetcursor(window, cursorx+8, cursory);

      } // imagetickbox
*/





/*----------------------------------------

	slot handling

----------------------------------------*/


      unsigned char *slotnofunction(void *slotdata) {

	return NULL;

      } // slotnofunction


/*--------------------------------------*/


      unsigned char *slotnostore(void *slotdata, unsigned int window, FILE *file, unsigned int percent) {

	return NULL;

      } // slotnostore


/*--------------------------------------*/


      unsigned char *slotnorestore(void *slotdata, unsigned int window, FILE *file, unsigned int percent) {

	return NULL;

      } // slotnostore


/*--------------------------------------*/


      unsigned char slotnoget(void *slotdata, unsigned int address) {

	return virtvideobyte;

      } // slotnoget


/*--------------------------------------*/


      void slotnoset(void *slotdata, unsigned int address, unsigned int value) {

      } // slotnoset


/*--------------------------------------*/


      unsigned char slotnoromget(void *slotdata, unsigned int address) {

	return 0xff;

      } // slotnoromget


/*--------------------------------------*/


      void slotnoromset(void *slotdata, unsigned int address, unsigned int value) {

      } // slotnoromset


/*--------------------------------------*/


      void slotempty(slot *slotpointer) {

	slotpointer->slotclose		= (void *)&slotnofunction;
	slotpointer->slotreset		= (void *)&slotnofunction;
	slotpointer->slotstore		= (void *)&slotnostore;
	slotpointer->slotrestore	= (void *)&slotnorestore;
	slotpointer->slotget		= (void *)&slotnoget;
	slotpointer->slotset		= (void *)&slotnoset;
	slotpointer->slotromget		= (void *)&slotnoromget;
	slotpointer->slotromset		= (void *)&slotnoromset;
	slotpointer->slotmenu		= (void *)&slotnofunction;
	slotpointer->slotshift		= (void *)&slotnofunction;
	slotpointer->slotctrl		= (void *)&slotnofunction;
	slotpointer->slotshiftctrl	= (void *)&slotnofunction;
	slotpointer->slottype		= SLOTTYPENONE;
	slotpointer->slotdata		= NULL;
	slotpointer->slotname		= NULL;

      } // slotempty






/*----------------------------------------

	basic Apple emulation

----------------------------------------*/

      unsigned char *appleinit(void) {
	register unsigned char *error;

	slotempty(&slots[0]);	// not really in use, is it?
	slotempty(&slots[1]);
	slotempty(&slots[2]);
	slotempty(&slots[3]);
	slotempty(&slots[4]);
	slotempty(&slots[5]);
	slotempty(&slots[6]);
	slotempty(&slots[7]);

	error = cpuinit();
	if (error) {
	  return error;
	}
	cpuwriteregs(cpuregswindow);

#ifdef EMUZ80
	z80init();
#endif
	memoryinit();
	keyboardinit();
	soundinit();
	virtinit();
	parallelinit();
	mouseinit();
	driveinit();
	lldiskinit();

	return NULL;		// no error

      } // appleinit



/*-------------------------------------*/


      unsigned char *appleclose(void) {

// close all slots
	slots[1].slotclose(slots[1].slotdata);
	slots[2].slotclose(slots[2].slotdata);
	slots[3].slotclose(slots[3].slotdata);
	slots[4].slotclose(slots[4].slotdata);
	slots[5].slotclose(slots[5].slotdata);
	slots[6].slotclose(slots[6].slotdata);
	slots[7].slotclose(slots[7].slotdata);

	cpuclose();
	memoryclose();		// free dynamically allocated memory


	return NULL;		// no error

      } // appleclose


/*-------------------------------------*/


      unsigned char *applereset(void) {

	cpuflag = 0;
	imagefillbox(window, 0, 0, 639, 7, RGBBLACK);
	cpureset();
	memoryreset();
	virtreset();
	slots[1].slotreset(slots[1].slotdata);
	slots[2].slotreset(slots[2].slotdata);
	slots[3].slotreset(slots[3].slotdata);
	slots[4].slotreset(slots[4].slotdata);
	slots[5].slotreset(slots[5].slotdata);
	slots[6].slotreset(slots[6].slotdata);
	slots[7].slotreset(slots[7].slotdata);

	setmessage("Reset Apple");

	return NULL;		// no error

      } // applereset


/*-------------------------------------*/


      unsigned char *applestore(unsigned char *filename) {
	unsigned int  keyboard;
	unsigned int  window;
	unsigned int  slot;
	unsigned char header[24];
	unsigned char oldcwd[260];
	FILE *file;
	register unsigned char *error;


	error = windowprotocol(&keyboard, &window,
"!\
ESave emulation state;\
GSpeichere Emulationszustand;\
");
	if (!error) {

	  getcwd(oldcwd, 256);
	  chdir(callingpath);

	  file = fopen(filename, "wb");
	  if (!(file)) {
	    stringwrite(window, "Sorry, I could not open the file \"");
	    stringwrite(window, filename);
	    stringwrite(window, "\".\r");
	    error = "File could not be opened";
 	  }
	  else {

	    strcpy(header, "EMU][ STATE V0.31");
	    fwrite(header,	sizeof(header),	1, file);
	    guipercent(window, 8,
"!\
EHeader stored.;\
GHeader gespeichert.;\
");
	    error = keyboardstore(window, file, 16);
	    if (!error) {
	      error = memorystore(window, file, 24);
	      if (!error) {
		error = cpustore(window, file, 32);
		if (!error) {
		  fwrite(&cpuflag, sizeof(cpuflag), 1, file);
		  error = virtstore(window, file, 40);
		  if (!error) {
		    slot = 1;
		    do {
		      fwrite(&slots[slot].slottype,	sizeof(slots[slot].slottype),	1, file);
		      error = slots[slot].slotstore(slots[1].slotdata, window, file, 40 + slot*8);
		      slot++;
		    }
		    while ((!error) && (slot < 8));
		    if (!error) {
		      guipercent(window, 100,
"!\
EEmulator state stored.;\
GEmulatorzustand gespeichert.;\
");
//		      windowpresskey(keyboard, window);
		    }
		  }
		}
	      }
	    }

	    fclose(file);
	  }

	  chdir(oldcwd);

	  if (error) {
	    windowpresskey(keyboard, window);
	  }

	  channelclose(keyboard);
	  channelclose(window);
	}

	return error;

      } // applestore


/*-------------------------------------*/


      unsigned char *applerestore(unsigned char *filename) {
	unsigned int  keyboard;
	unsigned int  window;
	unsigned int  slot;
	unsigned char header[24];
	unsigned char oldcwd[260];
	FILE *file;
	register unsigned char *error;


	error = windowprotocol(&keyboard, &window,
"!\
ELoad emulation state;\
GLade Emulatorzustand;\
");
	if (!error) {

	  guipercent(window, 0,
"!\
ERestoring emulator state...\r;\
GWiederherstellen des Emulatorzustands...\r;\
");

	  getcwd(oldcwd, 256);
	  chdir(callingpath);

	  file = fopen(filename, "rb");
	  if (!(file)) {
	    stringwrite(window, "Sorry, I could not open the file \"");
	    stringwrite(window, filename);
	    stringwrite(window, "\".\r");
	    error = "File could not be opened";
 	  }
	  else {

	    fread(header, sizeof(header), 1, file);
	    if (strcmp(header, "EMU][ STATE V0.31")) {
	      stringwrite(window, "File is not an Emu ][ Emulator State file.\r");
	      error = "File is not an Emu ][ Emulator State file.\r";
	    }
	    else {
	      guipercent(window, 8,
"!\
EHeader found;\
GHeader gefunden;\
");
	      error = keyboardrestore(window, file, 16);
	      if (!error) {
		error = memoryrestore(window, file, 24);
		if (!error) {
		  error = cpurestore(window, file, 32);
		  if (!error) {
		    fread(&cpuflag, sizeof(cpuflag), 1, file);
		    error = virtrestore(window, file, 40);
		    if (!error) {
		      slot = 1;
		      do {
			slots[slot].slotclose(slots[slot].slotdata);	// close old slot
			slotempty(&slots[slot]);			// define empty slot
			fread(&slots[slot].slottype,	sizeof(slots[slot].slottype),	1, file);
			switch (slots[slot].slottype) {
			  case SLOTTYPENONE :
			    break;
			  case SLOTTYPEPARALLEL :
			    parallelnew(&slots[slot], slot);
			    break;
			  case SLOTTYPEMOUSE :
			    mousenew(&slots[slot], slot);
			    break;
#ifdef EMUZ80
			  case SLOTTYPEZ80 :
			    z80new(&slots[slot], slot);
			    break;
#endif
			  case SLOTTYPEMASSSTORE :
			    lldisknew(&slots[slot], slot);
			    break;
			  case SLOTTYPEDISKDRIVE :
			    drivenew(&slots[slot], slot);
			    break;
			} // switch
			error = slots[slot].slotrestore(slots[slot].slotdata, window, file, 40 + slot*8);
			if (error) {
			  slotempty(&slots[slot]);
			}
			slot++;
		      }
		      while ((!error) && (slot < 8));
		      if (!error) {
			guipercent(window, 100,
"!\
EEmulator state restored.;\
GEmulatorzustand wiederhergestellt.;\
");
//			windowpresskey(keyboard, window);
	  	      }
	  	    }
	  	  }
	  	}
	      }
	    }

	    fclose(file);
	  }

	  chdir(oldcwd);

	  if (error) {
	    windowpresskey(keyboard, window);
	  }

	  channelclose(keyboard);
	  channelclose(window);
	}

	return error;

      } // applerestore


/*--------------------------------------*/


static int joya(void) {
  union REGS regs;

  regs.h.ah=0x84;
  regs.x.dx=0;
  int86(0x15,&regs,&regs); /* al */
  if ((regs.h.al&0x10)==0) return 255; else return 0;
}

static int joyb(void) {
  union REGS regs;

  regs.h.ah=0x84;
  regs.x.dx=0;
  int86(0x15,&regs,&regs); /* al */
  if ((regs.h.al&0x20)==0) return 255; else return 0;
}


/*-------------------------------------*/


      unsigned char *applevblank(void) {
	register int i;
	register unsigned char key;
	register unsigned char keyspec;

	memjoybutton0 = 0x00;
	memjoybutton1 = 0x00;

	if (keyjoystick) {		// read PC joystick?
	   memjoybutton0 = joya();
	   memjoybutton1 = joyb();
	}
	else {				// joystick emulation via numeric keypad
	  i = keyboardjoyx();
	  if (i < 0) { memjoyx = KEYJOYLEFT; }
	  else {
	    if (i == 0)	{ memjoyx = KEYJOYCENTER; }
	    else	{ memjoyx = KEYJOYRIGHT; }
	  }
	  i = keyboardjoyy();
	  if (i < 0) { memjoyy = KEYJOYLEFT; }
	  else {
	    if (i == 0)	{ memjoyy = KEYJOYCENTER; }
	    else	{ memjoyy = KEYJOYRIGHT; }
	  }
	}

	i = keyboardjoyb();		// open and close apple button will always work, even on an Apple][+
	if (i & 0xff00)		{ memjoybutton0 = memjoybutton0 | 0x80; }
	if (i & 0xff)		{ memjoybutton1 = memjoybutton1 | 0x80; }

	i = channelin(keyboard) & 0xffff;
	key	= (unsigned char)i;
	keyspec	= (unsigned char)(i >> 8);

	switch (key) {
	  case 0 :					// no key pressed
	    break;
	  case 28 :					// function keys
	    switch (keyspec) {
	      case 0x90 :				// <Arrow-Left>
		memkey = 0x88;
		break;
	      case 0x91 :				// <Arrow-Right>
		memkey = 0x95;
		break;
	      case 0x92 :				// <Arrow-Up>
		memkey = 0x8b;
		break;
	      case 0x93 :				// <Arrow-Down>
		memkey = 0x8a;
		break;
	      case 0xc1 :				// <F1>
	        slots[1].slotmenu(slots[1].slotdata);
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xc2 :				// <F2>
	        slots[2].slotmenu(slots[2].slotdata);
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xc3 :				// <F3>
		virtmenu();
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xc4 :				// <F4>
		cpumenu();
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xc5 :				// <F5>
	        slots[5].slotmenu(slots[5].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc6 :				// <F6>
	        slots[6].slotmenu(slots[6].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc8 :				// <F8>
	        memorymenu();
	        if (appletype == 0) {
	          mainmenu();
	        }
	        screenupdate = 1;
		taskswitch();
	        break;
		// if (!nof8) prtsc();
		break;
	      case 0xc9 :				// <F9>
		keyboardmenu();
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xca :				// <F10>
	        mainmenu();
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xcb :				// <F11>
                if (appletype == APPLEIIC) {
                    memiic4080 = !memiic4080;
                    setmessage(memiic4080?"Screen switch set to 80 columns":
                                          "Screen switch set to 40 columns");
                }
	        break;
	    } // switch (keyspec)
	    break;
	  case 29 :					// shift function keys
	    switch (keyspec) {
	      case 0xc1 :				// <Shift-F1>
	        slots[1].slotshift(slots[1].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc2 :				// <Shift-F2>
	        slots[2].slotshift(slots[2].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc3 :				// <Shift-F3>
		virtsetmonochrome((virtgetmonochrome() + 1) & 0x3);
		break;
	      case 0xc4 :				// <Shift-F4>
		if (memjoybutton0 || memjoybutton1) { exitprogram = -1; }
		else {
		  if (cpugetlinecycle() == 65) {
		    cpusetlinecycle(65 * 8);
		    cpusetdelay(0);
		    drivefastmode = 0;
		    setmessage(
"!\
ESet 65x02 CPU to fast mode;\
GSchalte 65x02 CPU in den Schnellmodus;\
");
		  }
		  else {
		    cpusetlinecycle(65);
		    cpusetdelay(inicpudelay);
		    drivefastmode = 0;
		    setmessage(
"!\
ESet 65x02 CPU to 1Mhz;\
GSchalte 65x02 CPU in 1Mhz Modus;\
");
		  }
		}
		break;
	      case 0xc5 :				// <Shift-F5>
	        slots[5].slotshift(slots[5].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc6 :				// <Shift-F6>
	        slots[6].slotshift(slots[6].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc8 :				// <Shift-F8>
		if (!(applestore(inistatepath))) {
		  setmessage(
"!\
EEmulation state stored;\
GEmulationszustand gespeichert;\
");
		}
		else {
		  screenupdate = 1;
		}
	        break;
	      case 0xc9 :				// <Shift-F9>
		quitmenu();
	        screenupdate = 1;
		taskswitch();
		break;
	    } // switch (keyspec)
	    break;
	  case 30 :					// control function keys
	    switch (keyspec) {
	      case 0xc1 :				// <Ctrl-F1>
	        slots[1].slotctrl(slots[1].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc2 :				// <Ctrl-F2>
	        slots[2].slotctrl(slots[2].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc3 :				// <Ctrl-F3>
		i = virtgetpalette();
		i++;
		if (i > 3) { i = 0; }
		virtsetpalette(i);
		break;
	      case 0xc4 :				// <Ctrl-F4>
		if (memjoybutton0 || memjoybutton1) { exitprogram = -1; }
		else {
#ifdef EMUZ80
		  if (!cpuflag) {
#endif
		    if (cpugetstate() & CPU_STATEHALT) {
		      cpuclearstate(CPU_STATEHALT);
		    }
		    else {
		      cpusetstate(CPU_STATEHALT);
		    }
#ifdef EMUZ80
		  }
		  else {
		    if (z80getstate() & CPU_STATEHALT) {
		      z80clearstate(CPU_STATEHALT);
		    }
		    else {
		      z80setstate(CPU_STATEHALT);
		    }
		  }
#endif
		}
		break;
	      case 0xc5 :				// <Ctrl-F5>
	        slots[5].slotctrl(slots[5].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc6 :				// <Ctrl-F6>
	        slots[6].slotctrl(slots[6].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc8 :				// <Ctrl-F8>
		if (!(applerestore(inistatepath))) {
		  setmessage(
"!\
EEmulation state restored;\
GEmulationszustand wiederhergestellt;\
");
		}
		else {
		  screenupdate = 1;
		}
		break;
	      case 0xc9 :				// <Ctrl-F9>
		inidebugflag = 1;
		ramdebugger(memram, sizeof(memram));
		inidebugflag = 0;
		virtsetmode();
		virtcacheinit();
		break;
	      case 0xca :				// <Ctrl-F10>
	      case 0xcc :				// <Ctrl-F12>
		applereset();
		break;
	    } // switch (keyspec)
	    break;
	  case 31 :					// shift control function keys
	    switch (keyspec) {
	      case 0xc1 :				// <Shift-Ctrl-F1>
	        slots[1].slotshiftctrl(slots[1].slotdata);
	        screenupdate = 1;
		taskswitch();
	        break;
	      case 0xc2 :				// <Shift-Ctrl-F2>
		slots[2].slotshiftctrl(slots[2].slotdata);
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xc3 :				// <Shift-Ctrl-F3>
		i = virtgethresmode();
		if (i >= 2) {
		  i = 0;
		}
		else {
		  i++;
		}
		virtsethresmode(i);
		break;
	      case 0xc5 :				// <Shift-Ctrl-F5>
		slots[5].slotshiftctrl(slots[5].slotdata);
	        screenupdate = 1;
		taskswitch();
		break;
	      case 0xc6 :				// <Shift-Ctrl-F6>
		slots[6].slotshiftctrl(slots[6].slotdata);
	        screenupdate = 1;
		taskswitch();
		break;
	    } // switch (keyspec)
	    break;
	  default :
	    if (key <= 0x7f) {

	      if (keybs) {
		if (key == 0x8) {
		  if (!(keyboardkeymap[0x82]) || (keyboardkeymap[0x83])) {	// not CTRL-H !
		    key = 0x7f;				// change to <DEL>
		  }
		}
		else {
		  if (key == 0x7f) {
		    key = 0x08;				// change to <BS>
		  }
		}
	      } // if (keybs)

	      if (keycapslock) {
		if ( ((key >= 'A') && (key <= 'Z')) || ((key >= 'a') && (key <= 'z')) ) {
		  key = key ^ 0x20;
		}
	      } // if (keycapslock)

	      if (keygerman) {
		if (key == 'Y') { key = 'Z'; }
		else {
		  if (key == 'y') { key = 'z'; }
		  else {
		    if (key == 'Z') { key = 'Y'; }
		    else {
		      if (key == 'z') { key = 'y'; }
		    }
		  }
		}
	      } // if (keygerman)

	      memkey = key | 0x80;
	    }
	    else { // if (key <= 0x7f)
	      switch (key) {
		case 196 : memkey = 0xdb; break;	// 
		case 214 : memkey = 0xdc; break;	// 
		case 220 : memkey = 0xdd; break;	// 
		case 228 : memkey = 0xfb; break;	// 
		case 246 : memkey = 0xfc; break;	// 
		case 252 : memkey = 0xfd; break;	// 
		case 223 : memkey = 0xfe; break;	// 
	      }
	    }
	} // switch (key)

	if (windowgetclose(window)) {
	  quitmenu();
	  screenupdate = 1;
	  taskswitch();
	}

	return NULL;		// no error

      } // applevblank






/*----------------------------------------

	Apple keyboard emulation

----------------------------------------*/


      unsigned char *keyboardstore(unsigned int winprotocol, FILE *file, unsigned int percent) {
	unsigned char header[32];

	memset(header, 0x00, sizeof(header));
	strcpy(header, "KEYBOARD STATE V0.25");
	fwrite(header,		sizeof(header),	1, file);

	fwrite(&keygerman,	sizeof(keygerman),	1, file);
	fwrite(&keycapslock,	sizeof(keycapslock),	1, file);
	fwrite(&keyjoystick,	sizeof(keyjoystick),	1, file);

	guipercent(winprotocol, percent,
"!\
EKeyboard stored.;\
GTastatur gespeichert.;\
");
	return NULL;		// no error

      } // keyboardstore


/*--------------------------------------*/


      unsigned char *keyboardrestore(unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

	fread(header,		sizeof(header),		1,file);
	if (strcmp(header, "KEYBOARD STATE V0.25")) {
	  stringwrite(winprotocol, "Keyboard emulation data not found.\r");
	  return taskseterror("Keyboard emulation data not found");
	}

	fread(&keygerman,	sizeof(keygerman),	1, file);
	fread(&keycapslock,	sizeof(keycapslock),	1, file);
	fread(&keyjoystick,	sizeof(keyjoystick),	1, file);

	guipercent(winprotocol, percent,
"!\
EKeyboard restored.\
GTastatur geladen.\
");

	return NULL;		// no error

      } // keyboardrestore


/*-------------------------------------*/


      void keyboardinit (void) {

	keycapslock = 1;
	keygerman   = 0;
	keybs       = 0;
	keyjoystick = 0;
	keyboardsetlayout(USA);

      } // keyboardinit


/*-------------------------------------*/


      void keyboardmenu (void) {
	unsigned int  menukeyboard;
	unsigned int  menuwindow;
	register unsigned char key;
	register unsigned char update;

	if (!windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1,
"!\
EKeyboard Options;\
GKeyboard Optionen;\
", 0, &menukeyboard, &menuwindow)) {
	  update = 1;
	  do {
	    if (update) {

	      channelout(menuwindow, 12);		// clear window

	      stringwritemessage(menuwindow,
"!\
E\r[ESC] - Quit\r\r\
\r[C] - ;\
G\r[ESC] - Verlasse Men\r\r\
\r[C] - ;\
;");
//	      imagetickbox(window, keycapslock);
	      stringwritemessage(menuwindow,
"!\
EReverse Caps Lock: ;\
GInvertiere Caps Lock: ;\
;");
	      stringwriteyesno(menuwindow, keycapslock);

	      stringwritemessage(menuwindow,
"!\
E\r[S] - Switch keys 'Y' and 'Z': ;\
G\r[S] - Vertausche die Tasten 'Y' und 'Z': ;\
;");
	      stringwriteyesno(menuwindow, keygerman);

	      stringwritemessage(menuwindow,
"!\
E\r[B] - Switch <BS> and <DEL>: ;\
G\r[B] - Vertausche die Tasten <BS> und <DEL>: ;\
;");
	      stringwriteyesno(menuwindow, keybs);

	      stringwrite(menuwindow,"\r\r      ");
	      imagesettextattribute(menuwindow, IMAGEUNDERLINE);
	      stringwritemessage(menuwindow,
"!\
EKeyboard Layout:;\
GTastatur Layout:;\
;");
	      imagesettextattribute(menuwindow, 0);
	      imagesetcursor(menuwindow, imagegetcursorx(menuwindow), imagegetcursory(menuwindow)+2);

	      stringwritemessage(menuwindow,
"!\
E\r[U] - USA:     ;\
G\r[U] - USA:         ;\
;");
	      channelout(menuwindow, keyboardgetlayout()==0 ? '*':' ');
	      stringwritemessage(menuwindow,
"!\
E\r[G] - Germany: ;\
G\r[G] - Deutschland: ;\
;");
	      channelout(menuwindow, keyboardgetlayout()==1 ? '*':' ');

	      stringwrite(menuwindow,"\r\r      ");
	      imagesettextattribute(menuwindow, IMAGEUNDERLINE);
	      stringwritemessage(menuwindow,
"!\
EJoystick;\
GJoystick:\
;");
	      imagesettextattribute(menuwindow, 0);
	      imagesetcursor(menuwindow, imagegetcursorx(menuwindow), imagegetcursory(menuwindow)+2);


	      stringwritemessage(menuwindow,
"!\
E\r[J] - Joystick emulation: ;\
G\r[J] - Joystick Emulation: ;\
;");
	      if (keyjoystick) {
		stringwritemessage(menuwindow,
"!\
EPC joystick;\
GPC Joystick;\
;");
	      }
	      else {
		stringwritemessage(menuwindow,
"!\
ENumeric keypad;\
GZiffernblock;\
;");
	      }
	      update = 0;
	      screenupdate = 1;
	    }
	    do {
	      taskswitch();
	      if (windowgetclose(menuwindow)) {
	        key = 27;
	      }
	      else {
	        key = (unsigned char)channelin(menukeyboard);
	      }
	    }
	    while ((key == 0) && (!exitprogram));
	    switch (key) {
	      case 'b' :
	      case 'B' :
		keybs = !keybs;
		update = 1;
		break;
	      case 'c' :
	      case 'C' :
		keycapslock = !keycapslock;
		update = 1;
		break;
	      case 'g' :
	      case 'G' :
		keyboardsetlayout(1);
		update = 1;
		break;
	      case 'j' :
	      case 'J' :
		keyjoystick = !keyjoystick;
		if (keyjoystick) {
		  memjoyx = KEYJOYCENTER;
		  memjoyy = KEYJOYCENTER;
		}
		update = 1;
		break;
	      case 's' :
	      case 'S' :
		keygerman = !keygerman;
		update = 1;
		break;
	      case 'u' :
	      case 'U' :
		keyboardsetlayout(0);
		update = 1;
		break;
	    } // switch (key)
	  }
	  while ((key != 27) && (key != 32) && (key != 13) && (!exitprogram));
	  channelclose(menukeyboard);
	  channelclose(menuwindow);
	}

      } // keyboardmenu


// maximum number of filenames for fdialog(), 256+16 bytes each
#define MFN 512
#define MAXROWS 24

typedef struct {
  char name[260]	structpack;
  int  attr		structpack;
} fnam;


      void filesort(fnam *fnames, unsigned int *fnamesptr, int attribute,
      		    unsigned int min, unsigned int max) {

	register int i;
	register int j;
	unsigned int temp;

// stupid bubblesort algorithm
	for (i=min+1; i <= max; i++) {
	  for (j=max; j >= i; j--) {
	    if (fnames[fnamesptr[j-1]].attr == attribute) {
	      if (fnames[fnamesptr[j]].attr == attribute) {
		if (stringcomparec( fnames[fnamesptr[j-1]].name, fnames[fnamesptr[j]].name) > 0) {
		  temp = fnamesptr[j-1];
		  fnamesptr[j-1] = fnamesptr[j];
		  fnamesptr[j] = temp;
		}
	      }
	      else {
		temp = fnamesptr[j-1];
		fnamesptr[j-1] = fnamesptr[j];
		fnamesptr[j] = temp;
	      }
	    }
	  } // for (j)
	} // for (i)

      } // filesort


      unsigned int fileselectmenu (unsigned char *windowtitle, unsigned char *title,
				   unsigned char *filename, unsigned char *filepath, unsigned char *tail,
				   unsigned char optnew) {

	unsigned int  keyboard;
	unsigned int  window;
	unsigned char path[260];
	unsigned char oldpath[260];
	unsigned char filestring[260];
	unsigned int  fileminnumber;
	unsigned int  filenumber = 0;
	int cursor;
	int cursorx;
	int cursory;
	int mousex;
	int mousey;
	unsigned int mousebutton;
	int columnstart = 0;
	int i;
	struct ffblk ffblk;

	fnam fnames[MFN];
	unsigned int fnamesptr[MFN];

	unsigned int backgroundcol;
	unsigned int foregroundcol;
	unsigned char key;
	unsigned char keyspec;
	unsigned char update;
	unsigned char reload;


	if (windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1, windowtitle, 0, &keyboard, &window)) {
	  exitprogram = 1;
	  return 0;
	}

	imagegettextcolor(window, &backgroundcol, &foregroundcol);

	cwdxchgslash(oldpath, MAXPATH);				// store old path
	chdir(filepath);					// change to new path
	cursor = 0;
	update = 1;
	reload = 1;

	do {
	  if (reload) {						// do we have to load the filename array?
	    cwdxchgslash(path, MAXPATH);			// get current directory

	    filenumber = 0;					// add fix elements to array
	    fileminnumber = 0;
	    if (optnew) {
	      if (strlen(filename) != 0) {
		fnames[0].attr = -1;
		getfilestring(fnames[0].name, filename);
		fnamesptr[0] = 0;
		filenumber++;
		fileminnumber++;
	      }

	      if (inimenulanguage == 'G') {
		strcpy(fnames[filenumber].name,"(Neue Datei)");
	      }
	      else {
		strcpy(fnames[filenumber].name,"(New File)");
	      }
	      fnames[filenumber].attr = -2;
	      fnamesptr[filenumber] = filenumber;
	      filenumber++;
	      fileminnumber++;
	    }

	    if (inimenulanguage == 'G') {
	      strcpy(fnames[filenumber].name,"(Laufwerk auswhlen)");
	    }
	    else {
	      strcpy(fnames[filenumber].name,"(Select Drive)");
	    }
	    fnames[filenumber].attr = -3;
	    fnamesptr[filenumber] = filenumber;
	    filenumber++;
	    fileminnumber++;

	    i = findfirst("*.*", &ffblk, FA_DIREC);		// put all filenames into array
	    while ( (!i) && (filenumber < MFN) ) {
	      strcpy(fnames[filenumber].name, ffblk.ff_name);
	      fnames[filenumber].attr = (ffblk.ff_attrib & FA_DIREC) ? FA_DIREC : 0;	// directory?

	      if (!stringcomparec(tail,"._img_")) {		// Custom mode for tail "._img_"
		if ((fnames[filenumber].attr) || (strright(fnames[filenumber].name,".DSK"))
//					      || (strright(fnames[filenumber].name,".IIE")) not yet
//					      || (strright(fnames[filenumber].name,".2MG")) not yet
					      || (strright(fnames[filenumber].name,".DO"))
					      || (strright(fnames[filenumber].name,".PO"))
					      || (strright(fnames[filenumber].name,".NIB"))
					      || (strright(fnames[filenumber].name,".NB2"))) {
					        fnamesptr[filenumber] = filenumber;
					        filenumber++;
		}
	      }
	      else {
		if (!stringcomparec(tail,"._prg_")) {		/* Custom mode for tail "._prg_" */
		  if ((fnames[filenumber].attr)	|| (strright(fnames[filenumber].name,".PG2"))
						|| (strright(fnames[filenumber].name,".APL"))) {
						  fnamesptr[filenumber] = filenumber;
						  filenumber++;
		  }
		}
		else {
		  if (!stringcomparec(tail,"._s_")) {		/* Custom mode for tail "._s_" */
		    if ((fnames[filenumber].attr)	|| (strright(fnames[filenumber].name,".S"))
							|| (strright(fnames[filenumber].name,".ASM"))
							|| (strright(fnames[filenumber].name,".A65"))
							|| (strright(fnames[filenumber].name,".TXT"))) {
							  fnamesptr[filenumber] = filenumber;
							  filenumber++;
		    }
		  }
		  else {
		    if (!stringcomparec(tail,".*")) {
		      fnamesptr[filenumber] = filenumber;
		      filenumber++;
		    }
		    else {
		      if ((fnames[filenumber].attr) || (strright(fnames[filenumber].name, tail))) {
			fnamesptr[filenumber] = filenumber;
			filenumber++;
		      }
		    }
		  }
		}
	      }
	      i = findnext(&ffblk);
	    } // while

	    filesort(fnames, fnamesptr, FA_DIREC, fileminnumber, filenumber-1);
	    filesort(fnames, fnamesptr, 0, fileminnumber, filenumber-1);

	    cursor	= 0;					// set to first entry in array
	    columnstart	= 0;
	    reload	= 0;
	  }

	  if (update) {
	    channelout(window, 12);				// clear window

	    if (strlen(path) > ((WINDOWXSIZE/8)-4)) {		// print current directory path
	      path[(WINDOWXSIZE/8)-4] = 0;
	      imagesetcursor(window, 8, 22);
	    }
	    else {
	      imagesetcursor(window, (WINDOWXSIZE - (strlen(path) << 3)) >> 1, 22);
	    }
	    stringwrite(window, path);

	    imagefillbox(window, 0, 24, WINDOWXSIZE, 25, 0xffff00);
	    imagefillbox(window, 0, WINDOWYSIZE - 34, WINDOWXSIZE, WINDOWYSIZE - 35, 0xffff00);
	    imagefillbox(window, 0, WINDOWYSIZE - 23, WINDOWXSIZE, WINDOWYSIZE - 24, 0xffff00);

	    imagesetcursor(window, 12, WINDOWYSIZE-25);
	    stringwritemessage(window, title);
	    imagesetcursor(window, 4, WINDOWYSIZE-13);		// print bottom message

	    stringwritemessage(window,
"!\
E Arrows move, <ENTER> selects, <ESC> exits\r Folder names end in \"\\\". ;\
G Pfeiltasten bewegen Cursor, <ENTER> zur Auswahl,\r <ESC> Abbruch, Verzeichnisnamen enden in \"\\\". ;\
;");

	    i = columnstart;
	    cursorx = 8;
	    cursory = 35;
	    while ((i < filenumber) & (cursorx < WINDOWXSIZE)) {
	      imagesetcursor(window, cursorx, cursory);
	      if (i == cursor) {
		imagesettextcolor(window, foregroundcol, backgroundcol);
		imagefillbox(window, cursorx, cursory-7, cursorx+(WINDOWXSIZE/3)-1, cursory, 0xffffff);
	      }
	      strcpy(filestring, fnames[fnamesptr[i]].name);
	      if (strlen(filestring) > ((WINDOWXSIZE/24)-1)) {
		filestring[(WINDOWXSIZE/24)-9] = '.';
		filestring[(WINDOWXSIZE/24)-8] = '.';
		strcpy(&filestring[(WINDOWXSIZE/24)-7], &filestring[strlen(filestring)-6]);
//		filestring[(WINDOWXSIZE/24)-2] = '.';
//		filestring[(WINDOWXSIZE/24)-1] = 0;
	      }
	      stringwrite(window, filestring);
	      if (fnames[fnamesptr[i]].attr == FA_DIREC) {	// directory?
		channelout(window, '\\');
	      }
	      if (i == cursor) {
		imagesettextcolor(window, backgroundcol, foregroundcol);
	      }
	      cursory = cursory + 8;
	      if (cursory >= (MAXROWS*8) + 35) {
		cursory = 35;
		cursorx = cursorx + (WINDOWXSIZE/3);
	      }
	      i++;
	    } // while

	    update = 0;
	    screenupdate = 1;
	  } // if (update)

	  do {
	    taskswitch();
	    if (windowgetclose(window)) {
	      key = 27;
	      keyspec = 0;
	    }
	    else {
	      i = channelin(keyboard);
	      key = (unsigned char)(i & 0xff);
	      keyspec = (unsigned char) ((i >> 8) & 0xff);
	      if (key == 0x01) {
	        key = 0;
	        keyspec = 0;
	      }
	      windowgetmouse(window, &mousex, &mousey, &mousebutton);
	      if (mousebutton) {
	        if ((mousex >=  8) && (mousex <= WINDOWXSIZE - 9)
	         && (mousey >= 27) && (mousey <= (MAXROWS*8) + 35  - 1)) {
	          mousex = ((mousey - 27) >> 3) + (((mousex - 8) / (WINDOWXSIZE/3)) * MAXROWS) + columnstart;
	          if (mousex < filenumber) {
	            if (mousex == cursor) {
	              key = 13;
	              keyspec = 0;
	            }
	            else {
	              key = 0x01;
	              cursor = mousex;
	              update = 1;
	            }
	          }
	        }
	        do {
	          taskswitch();
	          windowgetmouse(window, &mousex, &mousey, &mousebutton);
	        }
	        while (mousebutton);
	      }
	    }
	  }
	  while ((key ==0) && (!exitprogram));
	  switch (key) {
	    case 13 :
	      if (fnames[fnamesptr[cursor]].attr == -1) {
	      }
	      else {
	        if (fnames[fnamesptr[cursor]].attr == -2) {
		  imagesetcursor(window, 12, WINDOWYSIZE-25);
		  imagefillbox(window, 0, WINDOWYSIZE-32, WINDOWXSIZE, WINDOWYSIZE-25, 0x03050ff);
		  stringwritemessage(window,
"!\
ENew file name (<ESC> to cancel) >;\
GNeuer Dateiname (<ESC> = Abbruch) >;\
;");
		  strcpy(filestring, "");
		  imagestringread(window, keyboard, filestring, 26);
		  if (strlen(filestring) != 0) {
		    strcpy(filename, path);
		    if (filename[strlen(filename)-1]!='\\') {
		      strcat(filename,"\\");
		    }
		    strcat(filename, filestring);
		  }
		  else {
		    key = 0;
		    update = 1;
		  }
		}
		else {
		  if (fnames[fnamesptr[cursor]].attr == -3) {
		    imagesetcursor(window, 12, WINDOWYSIZE-25);
		    imagegettextcolor(window, &backgroundcol, &foregroundcol);
		    imagefillbox(window, 0, WINDOWYSIZE-32, WINDOWXSIZE, WINDOWYSIZE-25, backgroundcol);
		    stringwritemessage(window,
"!\
EEnter drive or <ENTER> to cancel: _;\
GBitte Laufwerksbuchstaben eingeben (<ENTER> = Abbruch): _;\
;");
		    screenupdate = 1;
		    do {
		      taskswitch();
		      if (windowgetclose(window)) {
		        key = 0x01;
		      }
		      else {
		        key = (unsigned char)channelin(keyboard);
		      }
		    }
		    while ((key == 0) && (!exitprogram));
		    if ((key >= 'a') && (key <= 'z')) {
		      setdisk(key - 'a');
		      reload = 1;
		    }
		    else {
		      if ((key >= 'A') && (key <= 'Z')) {
		        setdisk(key - 'A');
		        reload = 1;
		      }
		    }
		    if (key == 0x01) {
		      windowsetclose(window, 1);
		    }
		    else {
		      key = 0;
		      update = 1;
		    }
		  }
		  else {
		    if (fnames[fnamesptr[cursor]].attr) {
		      chdir(fnames[fnamesptr[cursor]].name);
		      reload = 1;
		      update = 1;
		      key    = 0;
		    }
		    else {
		      strcpy(filename, path);
		      if (filename[strlen(filename)-1]!='\\') {
		        strcat(filename,"\\");
		      }
		      strcat(filename, fnames[fnamesptr[cursor]].name);
		    }
		  }
		}
	      }
	      break;
	    case 27 :
	    case 32 :
	      chdir(oldpath);
	      break;
	    case 28 :
	      switch (keyspec) {
		case 0x90 :		// <Arrow-Left>
		  if (cursor >= MAXROWS) {
		    cursor = cursor - MAXROWS;
		    if (cursor < columnstart) {
		      columnstart = columnstart - MAXROWS;
		      if (columnstart < 0) { columnstart = 0; }
		    }
		  }
		  update = 1;
		  break;
		case 0x91 :		// <Arrow-Right>
		  if ((cursor + MAXROWS) < filenumber) {
		    cursor = cursor + MAXROWS;
		    if (cursor >= (columnstart+3*MAXROWS)) {
		      columnstart = columnstart + MAXROWS;
		    }
		  }
		  update = 1;
		  break;
		case 0x92 :		// <Arrow-Up>
		  if (cursor > 0) {
		    cursor--;
		    if (cursor < columnstart) {
		      columnstart = columnstart - MAXROWS;
		      if (columnstart < 0) { columnstart = 0; }
		    }
		  }
		  update = 1;
		  break;
		case 0x93 :		// <Arrow-Down>
		  if (cursor < (filenumber-1)) {
		    cursor++;
		    if (cursor >= (columnstart+3*MAXROWS)) {
		      columnstart = columnstart + MAXROWS;
		    }
		  }
		  update = 1;
		  break;
	      } // switch (keyspec)
	  } // switch (key)

	}
	while ((key != 13) && (key != 27) && (key != 32) && (!exitprogram));

	channelclose(keyboard);
	channelclose(window);

	return (key == 13);
      } // fileselectmenu






/*----------------------------------------

	additional menus

----------------------------------------*/


      void quitmenu(void) {
	register unsigned char *error;
	unsigned int quitkeyboard;
	unsigned int quitwindow;
	unsigned int halfkeyboard;
	unsigned int halfwindow;
	unsigned char message[60];
	register unsigned int x;
	register unsigned int y;

	error = (windowaddioxml(&halfkeyboard, &halfwindow, "\
<WINDOW>\
	<MODE>buffered</MODE>\
	<XSIZE>640</XSIZE>\
	<YSIZE>400</YSIZE>\
	<XCOO>-1</XCOO>\
	<YCOO>-1</YCOO>\
</WINDOW>\
"));
	if (!error) {
	  windowsetmove(halfwindow, 0);		// don't allow the window to be moved around screen
	  for (y = 0; y <= 399; y++) {
	    for (x = 0; x <= 639; x++ ) {
	      imageplot(halfwindow, x, y, (imagegetpixel(window, x, y) & 0xfefefe) >> 1);	/* Halftone */
	    }
	  }
	}

	if (!(windowaddio( -1, -1, 400, 56, -1, 1, "!>Quit.Title;;", 0, &quitkeyboard, &quitwindow))) {
	  channelout(quitwindow, 13);
	  stringcopymessage(message, "!>Quit.Message;;", 59);
	  stringwritecenterx(quitwindow, message);
	  if (guiyesno(quitkeyboard, quitwindow)) {
	    exitprogram = 1;
	  }
	  channelclose(quitkeyboard);
	  channelclose(quitwindow);
	}
	else {
	  exitprogram = 1;
	}

	if (!error) {
	  channelclose(halfkeyboard);
	  channelclose(halfwindow);
	}

	if (exitprogram) {
	  for (y = 0; y <= 399; y++) {
	    for (x = 0; x <= 639; x++ ) {
	      imageplot(window, x, y, (imagegetpixel(window, x, y) & 0xfefefe) >> 1);	// Halftone
	    }
	  }
	}

      } // quitmenu


/*-------------------------------------*/


      void aboutmenu (void) {
	unsigned int keyboard;
	unsigned int window;
	unsigned int background, foreground;
	unsigned char key;
	unsigned int update;

	if (!windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1,
"!\
EAbout EMU][ v" DappleVersion ";\
Gber EMU][ v" DappleVersion ";\
", 0, &keyboard, &window)) {
	  update = 1;
	  do {
	    channelout(window, 12);		// clear window
	    imagegettextcolor(window, &background, &foreground);
	    guioutbox(window, 96, 22, WINDOWXSIZE-97, 43);
	    imagefillbox(window, 97, 23, WINDOWXSIZE-98, 42, 0x5060a0);
	    imagesettextcolor(window, -1, 0x0ffffff);
	    stringwrite(window, "\r\r");
	    imagesettextattribute(window, IMAGEBOLD);
	    switch (update) {
	      case 1 :
		stringwritecenterx(window, "Author:");
		imagesettextcolor(window, background, foreground);
		imagesettextattribute(window, 0);
		stringwritemessage(window,
/* I'd like to say dapple.sourceforge.net, but I can't update it right now
   since I don't have access to an "ssh" program and can't log in to the
   server any other way. -uso. */
"!\
E\
\r\r\r\
EMU][ v" DappleVersion" was written by Steve Nickolas\r\
with some small portions by Holger Picker.\r\r\
Please send any comments, suggestions, bug reports to\r\
<steve@dosius.zzn.com>.\r\r\
For latest updates visit the homepage at\r\
<http://sourceforge.net/projects/dapple/>.\r\
;\
G\
\r\r\r\
EMU][ v" DappleVersion" wurde geschrieben von Steve Nickolas\r\
unter Einbeziehung kleiner Codeteile von Holger Picker.\r\r\
Bitte schicken Sie Ihre Meinung, Vorschlge oder\r\
Fehlerberichte an:\r\
<steve@dosius.zzn.com>.\r\r\
Die neuesten Updates finden Sie auf der Homepage\r\
<http://sourceforge.net/projects/dapple/>.\r\
;\
");
		update = 2;
		break;
	      case 2 :
		stringwritecenterx(window, "Credits:");
		imagesettextcolor(window, background, foreground);
		imagesettextattribute(window, 0);
		stringwritemessage(window,
"!\
E\r\r\rEMU][ was made possible with the help of a lot of people.\r\r\
Thanks to (in alphabetical order):\r\r;\
G\r\r\rEMU][ war nur mglich dank der Untersttzung\rund Hilfe vieler Leute.\r\r\
Dankeschn an (in alphabetischer Reihenfolge):\r\r;\
");
		stringwrite(window,"\
- Scott Alfter,\r\
- David Empson,\r\
- Andrew Gregory,\r\
- Scott Hemphill,\r\
- Robert Munafo,\r\
- Jon Relay,\r\
- Paul R. Santa-Maria,\r\
- Michael Tippach.\r\
");
		update = 3;
		break;
	      case 3 :
		stringwritecenterx(window, "Function Keys:");
		imagesettextcolor(window, background, foreground);
		imagesettextattribute(window, 0);
		stringwritemessage(window,
"!\
E\
\r\r\rDuring emulation you can use the following function keys:\r\r\
<F1>       : Parallel interface options\r\
<F2>       : Mouse options\r\
<F3>       : Video options\r\
<Shift-F3> : Toggle color/monochrome mode\r\
<Ctrl-F3>  : Toggle color palette\r\
<F4>       : CPU options\r\
<Shift-F4> : Toggle CPU fast/1 MHz mode\r\
<Ctrl-F4>  : Toggle pause on/off\r\
<F5>       : Mass store device options\r\
<F6>       : Disk options\r\
<F8>       : Memory options\r\
<Shift-F8> : Quicksave emulation state\r\
<Ctrl-F8>  : Quickload emulation state\r\
<F9>       : Keyboard/joystick options\r\
<Ctrl-F9>  : Debugger\r\
<F10>      : Main menu\r\
<Ctrl-F10> : Reset\r\
<F11>      : Apple //c \"40/80\" switch\r\
<Alt-F4> will quit the emulator\r\
;\
G\
\r\r\rWhrend der Emulation knnen folgende Funktionstasten\rbenutzt werden:\r\r\
<F1>       : Parallelschnittstelle Optionen\r\
<F2>       : Maus Optionen\r\
<F3>       : Video Optionen\r\
<Shift-F3> : Wechsel zwischen Farb- und Monochrom-Darstellung\r\
<Ctrl-F3>  : Wechsel zwischen verschiedenen Farbpaletten\r\
<F4>       : CPU Optionen\r\
<Shift-F4> : Schalte CPU in den Schnell- oder 1 MHz-Modus\r\
<Ctrl-F4>  : Schalte Pause ein/aus\r\
<F5>       : Massenspeichergert Optionen\r\
<F6>       : Laufwerk Optionen\r\
<F8>       : Speicher Optionen\r\
<Shift-F8> : Schnellspeicherung des Emulationzustandes\r\
<Ctrl-F8>  : Schnellladen des Emulationszustandes\r\
<F9>       : Tastatur/Joystick Optionen\r\
<Ctrl-F9>  : Debugger\r\
<F10>      : Hauptmen\r\
<Ctrl-F10> : Reset\r\
<F11>      : Apple //c \"40/80\" Schalter\r\
<Alt-F4> beendet den Emulator\r\
;\
");
		update = 1;
		break;
	    } // switch
	    imagesetcursor(window, imagegetcursorx(window), WINDOWYSIZE-8);
	    stringwritemessage(window,
"!\
EPress <ESC> to quit, <SPACEBAR> to continue.;\
G<ESC> zurck zum Hauptmen, <SPACEBAR> zum Fortfahren.;\
");
	    screenupdate = 1;
	    do {
	      taskswitch();
	      if (windowgetclose(window)) {
	        key = 27;
	      }
	      else {
	        key = (unsigned char)channelin(keyboard);
	      }
	    }
	    while ((key == 0) && (!exitprogram));
	  }
	  while ((key != 27) && (!exitprogram) && (update != 4));
	  channelclose(keyboard);
	  channelclose(window);
	}

      } // aboutmenu


/*-------------------------------------*/


      void mainmenu(void) {
	register unsigned int  update;
	register unsigned char key;
	register unsigned char menu;
	unsigned int  menukeyboard;
	unsigned int  menuwindow;
	unsigned int  background, foreground;

	do {
	  if (windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1,
			   "!>Main.Title;;", 0, &menukeyboard, &menuwindow)) {
	    exitprogram = 1;
	    fatalerror = tasklogerror(LOG_ALWAYS, "Fatal error: Could not open window for main menu.");
	    return;
	  }
	  else {
	    menu   = 0;
	    update = 1;
	    do {
	      if (update) {
		channelout(menuwindow, 12);		// clear window
		guioutbox(menuwindow, 64, 26, WINDOWXSIZE-65, 51);
		imagegettextcolor(menuwindow, &background, &foreground);
//		imagefillbox(menuwindow, 64, 51, WINDOWXSIZE-65, 51, RGBDARK);
//		imagefillbox(menuwindow, WINDOWXSIZE-65, 26, WINDOWXSIZE-65, 51, RGBDARK);
//		imagefillbox(menuwindow, 64, 26, WINDOWXSIZE-65, 26, RGBWHITE);
//		imagefillbox(menuwindow, 64, 26, 64, 51, RGBWHITE);
		imagefillbox(menuwindow, 65, 27, WINDOWXSIZE-66, 50, 0x5060a0);
		imagesettextcolor(menuwindow, -1, 0x0ffffcf);
		imagesettextattribute(menuwindow, IMAGEBOLD);
		stringwrite(menuwindow, "\r\r");
		stringwritecenterx(menuwindow, "EMU][ v" DappleVersion);
		channelout(menuwindow, 13);
		imagesetcursor(menuwindow, imagegetcursorx(menuwindow), imagegetcursory(menuwindow)+2);
		stringwritecenterx(menuwindow, "(C) 2002 - 2004 EMU][ Project/Dapple ][ Team");
		channelout(menuwindow, 13);
		imagesettextattribute(menuwindow, 0);
		imagesettextcolor(menuwindow, background, foreground);

		stringwritemessage(menuwindow, "!>Main.ResumeEmulation;;");

		if ((slots[1].slotname) && (slots[1].slotmenu != &slotnofunction)) {
		  stringwrite(menuwindow, "\r[1] - Slot 1: ");
		  stringwritemessage(menuwindow, slots[1].slotname);
		  stringwritemessage(menuwindow, "!>Main.Options;;");
		}
		if ((slots[2].slotname) && (slots[2].slotmenu != &slotnofunction)) {
		  stringwrite(menuwindow, "\r[2] - Slot 2: ");
		  stringwritemessage(menuwindow, slots[2].slotname);
		  stringwritemessage(menuwindow, "!>Main.Options;;");
		}
		if ((slots[4].slotname) && (slots[4].slotmenu != &slotnofunction)) {
		  stringwrite(menuwindow, "\r[4] - Slot 4: ");
		  stringwritemessage(menuwindow, slots[4].slotname);
		  stringwritemessage(menuwindow, "!>Main.Options;;");
		}
		if ((slots[5].slotname) && (slots[5].slotmenu != &slotnofunction)) {
		  stringwrite(menuwindow, "\r[5] - Slot 5: ");
		  stringwritemessage(menuwindow, slots[5].slotname);
		  stringwritemessage(menuwindow, "!>Main.Options;;");
		}
		if ((slots[6].slotname) && (slots[6].slotmenu != &slotnofunction)) {
		  stringwrite(menuwindow, "\r[6] - Slot 6: ");
		  stringwritemessage(menuwindow, slots[6].slotname);
		  stringwritemessage(menuwindow, "!>Main.Options;;");
		}
		if ((slots[7].slotname) && (slots[7].slotmenu != &slotnofunction)) {
		  stringwrite(menuwindow, "\r[7] - Slot 7: ");
		  stringwritemessage(menuwindow, slots[7].slotname);
		  stringwritemessage(menuwindow, "!>Main.Options;;");
		}

		stringwritemessage(menuwindow, "!>Main.Menu;;");
		update = 0;
		screenupdate = 1;
	      }
	      do {
		taskswitch();
		if (windowgetclose(menuwindow)) {
		  key = 'q';
		}
		else {
		  key = (unsigned char)channelin(menukeyboard);
		}
	      }
	      while ((key == 0) && (!exitprogram));
	      switch (key) {
		case 13 :
		case 27 :
		case 32 :
		  if (appletype == 0) {
		    stringwritemessage(menuwindow, "!>Main.NoRoms;;");
		    windowpresskey(menukeyboard, menuwindow);
		    update = 1;
		  }
		  else {
		    menu = 1;
		  }
		  break;
		case '1' :
		  menu = 21;
		  break;
		case '2' :
		  menu = 22;
		  break;
		case '5' :
		  menu = 25;
		  break;
		case '6' :
		  menu = 26;
		  break;
		case 'a' :
		case 'A' :
		  menu = 2;
		  break;
		case 'c' :
		case 'C' :
		  menu = 3;
		  break;
		case 'd' :
		case 'D' :
		  menu = 4;
		  break;
		case 'k' :
		case 'K' :
		  menu = 5;
		  break;
		case 'l' :
		case 'L' :
		  if (inimenulanguage == 'E') {
		    inimenulanguage = 'G';
		  }
		  else {
		    inimenulanguage = 'E';
		  }
		  asmsetlanguage(inimenulanguage);
		  menu = 10;
		  break;
		case 'm' :
		case 'M' :
		  menu = 6;
		  break;
		case 'n' :
		case 'N' :
		  menu = 7;
		  break;
		case 'v' :
		case 'V' :
		  menu = 8;
		  break;
		case 'q' :
		case 'Q' :
		  menu = 9;
		  break;
	      } // switch (key)
	    }
	    while ((menu == 0) && (!exitprogram));
	    channelclose(menukeyboard);
	    channelclose(menuwindow);
	  }
	  switch (menu) {
	    case 2 :
	      aboutmenu();
	      break;
	    case 3 :
	      cpumenu();
	      break;
//	    case 4 :
//	      drivemenu();
//	      break;
	    case 5 :
	      keyboardmenu();
	      break;
	    case 6 :
	      memorymenu();
	      break;
	    case 7 :
	      soundmenu();
	      break;
	    case 8 :
	      virtmenu();
	      break;
	    case 9 :
	      quitmenu();
	      break;
	    case 21 :
	      slots[1].slotmenu(slots[1].slotdata);
	      break;
	    case 22 :
	      slots[2].slotmenu(slots[2].slotdata);
	      break;
	    case 25 :
	      slots[5].slotmenu(slots[5].slotdata);
	      break;
	    case 26 :
	      slots[6].slotmenu(slots[6].slotdata);
	      break;
	  } // switch (menu)
	} while ((menu != 1) && (!exitprogram));

      } // mainmenu






/*----------------------------------------

	Main

----------------------------------------*/


      int main () {
	register unsigned int cpustate;


// prevent ^C from killing us -uso. (2002.0130)
//	signal (SIGINT, SIG_IGN); (sometimes GPFs? -uso.)
#ifndef NOGRABBREAK
	_go32_want_ctrl_break(1);
	__djgpp_set_ctrl_c(0);
#endif

// bugfix: try to reopen the printer as a binary file -uso.
//      if (!freopen("/dev/prn","wb",stdprn)) return 0;
        _fmode=O_BINARY;



// initialize global variables

	fatalerror	= NULL;
	keyboard	= 0;
	window		= 0;
	logkeyboard	= 0;
	logwindow	= 0;
	cpuregskeyboard	= 0;
	cpuregswindow	= 0;
	cwdxchgslash(callingpath, 260);		// store original directory at calling Dapple


// initialize log file

	taskopen();
/*	tasklogfile = fopen("log.txt","wb");	// print error and log messages to file 'log.txt'
	if (tasklogfile == NULL) {
	  printf("\nFatal error: Couldn't open file 'log.txt'.\n");
	  return 0;
	}
*/	tasklogstring(LOG_ALWAYS, "Begin of Session");
	tasklogreturn(LOG_ALWAYS);
	tasklogreturn(LOG_ALWAYS);


// initialize asm library

	if (asmopen()) {
	  dvalueshow = 1;
	  fatalerror = tasklogerror(LOG_ALWAYS,
"\nFatal internal error in library.\n\
Please send a bug report with the values shown above to\n\
<steve@dosius.zzn.com>. Thank you.");
	  goto endofprogram;
	}

	if (messageload("emumess.txt")) {
	  fatalerror = tasklogerror(LOG_ALWAYS, "Fatal error: No message file 'emumess.txt' found.");
	  goto endofprogram;
	}
	messagecount = 0;
	messageflag  = 0;


// set resolution

	if (screensetresolution(640, 400, 8)) {
	  if (screensetresolution(640, 480, 8)) {
	    if (screensetresolution(800, 600, 8)) {
	      if (screensetresolution(1024, 768,8)) {
 		fatalerror = tasklogerror(LOG_ALWAYS, "Fatal error: No suitable video modes found (no VESA?).\n");
 		goto endofprogram;
	      }
	      else {
	        screen_xsize = 1024;
	        screen_ysize = 768;
	      }
	    }
	    else {
	      screen_xsize = 800;
	      screen_ysize = 600;
	    }
	  }
	  else {
	    screen_xsize = 640;
	    screen_ysize = 480;
	  }
	}
	else {
	  screen_xsize = 640;
	  screen_ysize = 400;
	}


// open emulation window

	if (windowaddioxml(&keyboard, &window, "\
<WINDOW>\
	<MODE>direct</MODE>\
	<XSIZE>640</XSIZE>\
	<YSIZE>400</YSIZE>\
	<XCOO>-1</XCOO>\
	<YCOO>-1</YCOO>\
</WINDOW>\
")) {
	  fatalerror = tasklogerror(LOG_ALWAYS, "Fatal internal error: Basic emulation window could not be opened.");
	  goto endofprogram;
	}
	imagefillbox(window, 0, 0, 640, 400, 0x000000);		// clear window


// open log window

	if (windowaddio(-1, 0, 640, 154, -1, 1, "Log Window", 0, &logkeyboard, &logwindow)) {
	  fatalerror = tasklogerror(LOG_ALWAYS, "Fatal internal error: Could not open log window.");
	  goto endofprogram;
	}
	tasklogsetchannel(logwindow);


// open cpu window

	if (windowaddio( 4, 0, 256, 44, -1, 1, "6502 Register;", 0, &cpuregskeyboard, &cpuregswindow)) {
	  fatalerror = tasklogerror(LOG_ALWAYS, "Fatal internal error: Could not open cpu window.");
	  goto endofprogram;
	}
	windowsetvisibility(cpuregswindow, 0);			// hide cpu window


// greeting

	tasklogstring(LOG_ALWAYS, "Welcome to EMU][ v" DappleVersion); tasklogreturn(LOG_ALWAYS);
	tasklogstring(LOG_ALWAYS, "==========================="); tasklogreturn(LOG_ALWAYS);
	tasklogreturn(LOG_ALWAYS);
	tasklogstring(LOG_ALWAYS, "This version features emulation of up to"); tasklogreturn(LOG_ALWAYS);
	tasklogstring(LOG_ALWAYS, "3MB expansion RAM dynamically allocated."); tasklogreturn(LOG_ALWAYS);
	tasklogreturn(LOG_ALWAYS);
	screenupdate = 1;
	taskswitch();


// initialize default values

	strcpy(inidiskpath1, "");
	strcpy(inidiskpath2, "");
	strcpy(inistatepath, "EMU2.SAV");
	strcpy(inirompath,   callingpath);
	strcat(inirompath,   "\\ROMS");
	inimenulanguage	= 'E';		// set language to English (default)
	inicpudelay	= 0x120;
	inidebugflag	= 0;


// initialize emulator

	if (appleinit()) {
	  fatalerror = tasklogerror(LOG_ALWAYS, "Fatal error: Emulation could not be initialized.");
	  goto endofprogram;
	}


// get preferences from file

	readini();
	asmsetlanguage(inimenulanguage);
	cpusetdelay(inicpudelay);


// load roms

	memoryautoloadrom(logkeyboard, logwindow);	// automatic search for rom file

	parallelloadrom(logkeyboard, logwindow);
	mouseloadrom   (logkeyboard, logwindow);
#ifdef EMUZ80
	z80loadrom     (logkeyboard, logwindow);
#endif
	driveloadrom   (logkeyboard, logwindow);
	lldiskloadrom  (logkeyboard, logwindow);


// initialize slots

	if (parallelnew(&slots[1], 1)) {
	  slotempty(&slots[1]);
	}
	if (mousenew(&slots[2], 2)) {
	  slotempty(&slots[2]);
	}
#ifdef EMUZ80
	if (z80new(&slots[4], 4)) {
	  slotempty(&slots[4]);
	}
#endif
	if (lldisknew(&slots[5], 5)) {
	  slotempty(&slots[5]);
	}
	if (drivenew(&slots[6], 6)) {
	  slotempty(&slots[6]);
	}

	if (inidiskpath1[0]) {
	  driveload(&drivedisk1, inidiskpath1);
	}
	if (inidiskpath2[0]) {
	  driveload(&drivedisk2, inidiskpath2);
	}
//	windowpresskey(logkeyboard, logwindow);


// initialization done

	tasklogmessage(LOG_ALWAYS,
"!\
EStarting emulation...;\
GStarte Emulation...;\
;");
	tasklogreturn(LOG_ALWAYS);
	if (logwindow) {
	  windowsetvisibility(logwindow, 0);		// hide log window
	}

	messageflag = 1;				// allow messages
	setmessage(
"!\
EWelcome to EMU][;\
GWillkommen bei EMU][;\
");


// call mainmenu first before emulation loop

	mainmenu();
	if (!exitprogram) {
	  applereset();

// emulation loop

	  do {
	    if (!cpuflag) {				// 6502 or Z80?
	      do {

// process one display frame

#ifdef CPU_ASM
	        cpu6502line();
	        cpustate = cpugetstate();
#else
	        cpustate = cpuline();			// cpu and video raster line emulation
#endif
	        if (cpustate & CPU_STATECOP) {
#ifdef REECOP
		  if (!memlcramr) {
		    romexecute(cpugetpc());		// keep COP flag to continue emulation
	          }
	          else {
	            cpustate = cpustate & ~CPU_STATECOP;// otherwise clear it
	          }
#else
		  cpustate = cpustate & ~CPU_STATECOP;	// no COP emulation
#endif
	        }
	      } while (cpustate & CPU_STATECOP);
	      if (cpustate & (CPU_STATETRACE | CPU_STATEGURU | CPU_STATEBPT /*| CPU_STATEBRK */)) {
		cpumenu();
		screenupdate = 1;
		taskswitch();
		if (cpustate & CPU_STATETRACE)	{ cpuclearstate(CPU_STATETRACE); }
		if (cpustate & CPU_STATEGURU)	{ cpuclearstate(CPU_STATEGURU); }
	      }
	    }
#ifdef EMUZ80
	    else {
	      cpustate = z80line();
	      if (cpustate & (CPU_STATETRACE | CPU_STATEGURU | CPU_STATEBPT)) {
		cpumenu();
		screenupdate = 1;
		taskswitch();
		if (cpustate & CPU_STATETRACE)	{ z80clearstate(CPU_STATETRACE); }
		if (cpustate & CPU_STATEGURU)	{ z80clearstate(CPU_STATEGURU); }
	      }
	    }
#endif


// vertical blank

	    taskswitch();
	    if (cpuregswindow) {
	      if (windowgetvisibility(cpuregswindow)) {
		channelout(cpuregswindow, 12);
		if (!cpuflag) {
		  cpuwriteregs(cpuregswindow);
		}
#ifdef EMUZ80
		else {
		  z80writeregs(cpuregswindow);
		}
#endif
		screenupdate = 1;
	      }
	    }

	    if (messagecount != 0) {
	      messagecount--;
	      if (messagecount == 0) {
		imagefillbox(window, 0, 392, 639, 399, 0x000000);
		screenupdate = 1;
	      }
	    }
	    applevblank();
	  }
	  while (!exitprogram);
	} // if (!exitprogram)


// shut down emulation

	exitprogram = 0;		// don't quit menus that ask for saving a disk etc
	appleclose();

	chdir(callingpath);		// restore original directory at calling Dapple

	writeini();
	screenupdate = 1;
	taskswitch();


endofprogram:

// close cpu window
	if (cpuregskeyboard) {
	  channelclose(cpuregskeyboard);
	}
	if (cpuregswindow) {
	  channelclose(cpuregswindow);
	}

// close log window and channel
	if (logkeyboard) {
	  channelclose(logkeyboard);
	}
	tasklogsetchannel(NULL);
	if (logwindow) {
	  channelclose(logwindow);
	}

// close main window
	if (keyboard) {
	  channelclose(keyboard);
	}
	if (window) {
	  channelclose(window);
	}

// close assembly library
	asmclose();

// close log file
	tasklogreturn(LOG_ALWAYS);
	tasklogstring(LOG_ALWAYS, "End of Session");
	tasklogreturn(LOG_ALWAYS);
	taskclose();

	if (fatalerror) {
	  printf("\n%s\n", fatalerror);
	}

	return 0;

      } // main


// --> #ifndef DEF_INC_DAPPLE_C
#endif
