/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002- 2004 by the EMU][ Project/Dapple ][ Team
 *
 * $Header: /winc/emuiil/source/raf.h,v 1.5 2003/08/30 10:22:29 dosius Exp $
 *
 * Component:  RAF: class random access file
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Log: raf.h,v $
 * Revision ???
 * Z80 core development
 *
 */


/*----------------------------------------


	class	raf


	see raf.c for implementation


----------------------------------------*/


#ifndef DEF_INC_RAF_H
#define DEF_INC_RAF_H


// **** public type definitions

typedef struct {
//pointer	raftaskptr;							/* n.u. */
method		(*rafclose)	(void *rafptr);					/* close and delete whole raf	*/
method		(*rafin)	(void *rafptr, card8 *result);			/* read byte from stream	*/
method		(*rafout)	(void *rafptr, card8 value);			/* send byte to stream		*/
method		(*rafget)	(void *rafptr, card32 index, card8  *result);	/* get byte from index		*/
//method	(*rafgetlb)	(void *rafptr, card32 index, card32 *result);	/* get long big from index	*/
method		(*rafset)	(void *rafptr, card32 index, card8 value);	/* set byte to index		*/
//method	(*rafstore)	(void);						/* store whole raf		*/
//method	(*rafrestore)	(void);						/* restore whole raf		*/
card8		*rafbaseptr;							/* pointer to start of array	*/
int32		raflimit;							/* max number of bytes		*/
} raf;


// **** public functions and methods

unsigned char *rafinit		(raf *rafptr, card8 *baseptr, card32 limit);
unsigned char *rafclosedefault	(raf *rafptr);
unsigned char *rafnoin		(raf *rafptr, card8 *result);
unsigned char *rafindefault	(raf *rafptr, card8 *result);
unsigned char *rafnoout		(raf *rafptr, card8 value);
unsigned char *rafoutdefault	(raf *rafptr, card8 value);
unsigned char *rafnoget		(raf *rafptr, card32 index, card8 *result);
unsigned char *rafgetdefault	(raf *rafptr, card32 index, card8 *result);
unsigned char *rafnoset		(raf *rafptr, card32 index, card8 value);
unsigned char *rafsetdefault	(raf *rafptr, card32 index, card8 value);
unsigned char *raffill		(raf *rafptr, card32 start, card32 end, card8 *bytelist, card32 numb);
unsigned char *rafload		(raf *rafptr, unsigned char *filepath, card32 startindex, card32 endindex, unsigned int *psize);
unsigned char *rafloadtext	(raf *rafptr, unsigned char *filepath, card32 startindex, card32 endindex, unsigned int *psize);
unsigned char *rafascii		(raf *rafptr, card32 textmode, card32 *pindex, unsigned char *pstringptr[]);
unsigned char *rafhex		(raf *rafptr, card32 textmode, card32 *pindex, unsigned char *pstringptr[]);


// --> #ifndef DEF_INC_RAF_H
#endif
