/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002- 2004 by the EMU][ Project/Dapple ][ Team
 *
 * $Header: /winc/emuiil/source/raf.c,v 1.5 2003/08/30 10:22:29 dosius Exp $
 *
 * Component:  RAF: class random access file
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Log: raf.c,v $
 * Revision ???
 * Z80 core development
 *
 */


/*----------------------------------------


	class	raf


	see raf.h for include file


----------------------------------------*/


#ifndef _INC_RAF_C
#define _INC_RAF_C

#include <stdio.h>
#include <stdlib.h>
#include "general.h"
#include "raf.h"



/*----------------------------------------

	rafinit

	initialize raf struct

----------------------------------------*/


      unsigned char *rafinit(raf *rafptr, card8 *baseptr, card32 limit) {

//	rafptr->raftaskptr	= NULL;				/* n.u.*/
	rafptr->rafclose	= (void *)&rafclosedefault;	/* define standard rafin */
	rafptr->rafin		= (void *)&rafindefault;	/* define standard rafin */
	rafptr->rafout		= (void *)&rafoutdefault;	/* define standard rafout */
	rafptr->rafget		= (void *)&rafgetdefault;	/* define standard rafget */
	rafptr->rafset		= (void *)&rafsetdefault;	/* define standard rafset */
	rafptr->rafbaseptr	= baseptr;
	rafptr->raflimit	= limit;

	return NULL;

      } /* rafinit */


/*----------------------------------------

	rafclosedefault

	default handling of close method

----------------------------------------*/


      unsigned char *rafclosedefault(raf *rafptr) {

	rafptr->rafin  = (void *)&rafnoin;
	rafptr->rafout = (void *)&rafnoout;
	rafptr->rafget = (void *)&rafnoget;
	rafptr->rafset = (void *)&rafnoset;
	rafptr->raflimit = 0;

	return NULL;


      } /* rafclosedefault */


/*----------------------------------------

	rafnoin

	handling of raf without in method

----------------------------------------*/


      unsigned char *rafnoin(raf *rafptr, card8 *result) {

	*result = 0;
	return taskseterror(
"!\
:F;\
EThe method raf.in is not implemented;\
GDie Methode raf.in ist nicht implementiert;\
;");
      } /* rafnoin */


/*----------------------------------------

	rafindefault

	default handling of in method

----------------------------------------*/


      unsigned char *rafindefault(raf *rafptr, card8 *result) {

	return rafptr->rafget(rafptr, 0, result);	/* read byte from index 0 */

      } /* rafindefault */


/*----------------------------------------

	rafnoout

	handling of raf without out method

----------------------------------------*/


      unsigned char *rafnoout(raf *rafptr, card8 value) {

	return taskseterror(
"!\
:F;\
EThe method raf.out is not implemented;\
GDie Methode raf.out ist nicht implementiert;\
;");
      } /* rafnoout */


/*----------------------------------------

	rafoutdefault

	default handling of out method

----------------------------------------*/


      unsigned char *rafoutdefault(raf *rafptr, card8 value) {

	return rafptr->rafset(rafptr, 0, value);	/* write byte to index 0 */

      } /* rafoutdefault */


/*----------------------------------------

	rafnoget

	handling of raf without get method

----------------------------------------*/


      unsigned char *rafnoget(raf *rafptr, card32 index, card8 *result) {

	*result = 0;
	return taskseterror(
"!\
:F;\
EThe method raf.get is not implemented;\
GDie Methode raf.get ist nicht implementiert;\
;");
      } /* rafnoget */


/*----------------------------------------

	rafgetdefault

	default handling of get method

----------------------------------------*/


      unsigned char *rafgetdefault(raf *rafptr, card32 index, card8 *result) {

	if (index < rafptr->raflimit) {
	  *result = *((rafptr->rafbaseptr)+index);
	  return NULL;
	}
	else {
	  *result = 0;
	  return taskseterror(
"!\
:#;\
EIndex out of bounds while calling raf.get;\
GIndex ausserhalb des gltigen Bereichs bei raf.get;\
");
	}
      } /* rafgetdefault */


/*----------------------------------------

	rafnoset

	handling of raf without set method

----------------------------------------*/


      unsigned char *rafnoset(raf *rafptr, card32 index, card8 value) {

	return taskseterror(
"!\
:F;\
EThe method raf.set is not implemented;\
GDie Methode raf.set ist nicht implementiert;\
;");
      } /* rafnoset */


/*----------------------------------------

	rafsetdefault

	default handling of set method

----------------------------------------*/


      unsigned char *rafsetdefault(raf *rafptr, card32 index, card8 value) {

	if (index < rafptr->raflimit) {
	  *((rafptr->rafbaseptr)+index) = value;
	  return NULL;
	}
	return taskseterror(
"!\
:#;\
EIndex out of bounds while calling raf.set;\
GIndex ausserhalb des gltigen Bereichs bei raf.set;\
");

      } /* rafsetdefault */


/*----------------------------------------

 MODULE	rafload		(raf *rafptr, unsigned char *filepath, card32 startindex, card32 endindex)
			(unsigned int *psize)

	load file into raf

----------------------------------------*/

      unsigned char *rafload(raf *rafptr, unsigned char *filepath, card32 startindex, card32 endindex, unsigned int *psize) {
	register unsigned char *error;
	register card32	index;
	register card8	*byteptr;
	card8		*fileptr;
	unsigned int	size;

	*psize = 0;
	if (startindex > endindex) {
	  return taskseterror(
"!\
:F;\
EStartaddress higher than endaddress in raf.load;\
GStartadresse hher als Endadresse in raf.load;\
");
	}

	error = fileresident(filepath, (void *)&fileptr, &size);
	if (error) {
	  return error;
	}

	byteptr = fileptr;
	for ( index = startindex; index < endindex; index++ ) {
	  error = rafptr->rafset(rafptr, index, *byteptr++);
	  if (error) {
	    free(fileptr);
	    return error;
	  }
	  *psize++;
	}

	free(fileptr);

	return NULL;

      } /* rafload */


/*----------------------------------------

 MODULE	rafloadtext	(raf *rafptr, unsigned char *filepath, card32 startindex, card32 endindex)
 			(unsigned int *psize)

	load and convert text file to raf

----------------------------------------*/

      unsigned char *rafloadtext(raf *rafptr, unsigned char *filepath, card32 startindex, card32 endindex, unsigned int *psize) {
	register unsigned char *error;
	register card32	index;
	register card8	*byteptr;
	register card8	value;
	card8		*fileptr;
	unsigned int	size;

	*psize = 0;
	if (startindex > endindex) {
	  return taskseterror(
"!\
:F;\
EStartaddress higher than endaddress in raf.load;\
GStartadresse hher als Endadresse in raf.load;\
");
	}

	error = fileresident(filepath, (void *)&fileptr, &size);
	if (error) {
	  return error;
	}

	byteptr = fileptr;
	for ( index = startindex; index <= endindex; index++ ) {
	  value = *byteptr;
	  byteptr++;
	  if (value == 0x0a) {
//	    value = '\n';
	    value = '\r';
	    if (*byteptr == 0x0d) {
	      byteptr++;
	    }
	  }
	  else {
	    if (value == 0x0d) {
//	      value = '\n';
	      value = '\r';
	      if (*byteptr == 0x0a) {
	        byteptr++;
	      }
	    }
	  }
	  error = rafptr->rafset(rafptr, index, value);
	  if (error) {
	    free(fileptr);
	    return error;
	  }
	  *psize++;
	  if (value == '\0') {
	    free(fileptr);
	    return NULL;
	  }
	}

	free(fileptr);
	return NULL;

      } // rafload


/*----------------------------------------

 MODULE	raffill		(raf *rafptr, card32 startindex, card32 endindex, card8 *bytelist, card32 numb)
			()

	fill raf with bytes from a list

----------------------------------------*/

      unsigned char *raffill(raf *rafptr, card32 startindex, card32 endindex, card8 *bytelist, card32 numb) {
	register card32		index;
	register card8		value;
	register card32		numbcount;
	register unsigned char	*error;

	if (numb == 0) {
	  return taskseterror(
"!\
:#;\
EThe number of bytes must not be zero;\
GByteanzahl darf nicht null sein;\
;");
	}
	if (endindex > startindex) {
	  return taskseterror(
"!\
:F;\
EStartaddress higher than endaddress in raf.fill;\
GStartadresse hher als Endadresse in raf.fill;\
");
	}
	if (numb == 1) {
	  value = *bytelist;
	  for ( index = startindex; index <= endindex; index++ ) {
	    error = rafptr->rafset(rafptr, index, value);
	    if (error) {
	      return error;
	    }
	  }
	}
	else {
	  numbcount = 0;
	  for ( index = startindex; index <= endindex; index++ ) {
	    error = rafptr->rafset(rafptr, index, *(bytelist+numbcount));
	    if (error) {
	      return error;
	    }
	    numbcount++;
	    if (numbcount >= numb) {
	      numbcount = 0;
	    }
	  }
	}
	return NULL;

      } /* raffill */


/*----------------------------------------

	rafascii

	ascii dump of raf

----------------------------------------*/


      unsigned char *rafascii(raf *rafptr, card32 textmode, card32 *pindex, unsigned char *pstringptr[]) {
	register unsigned char	*error;
	register unsigned char	*stringptr;
	register card32		index;
	register unsigned int	i;
	card8			value;

	index		= *pindex;
	stringptr	= *pstringptr;

	if (textmode) {
	  *stringptr++ = '\t';
	  *stringptr++ = '\t';
	  *stringptr++ = 'A';
	  *stringptr++ = 'S';
	  *stringptr++ = 'C';
	  *stringptr++ = '\t';
	  *stringptr++ = '"';
	} /* if (textmode) */
	else {
	/* write address */
	}

	for ( i=0; i<64; i++) {
	  error = rafptr->rafget(rafptr, index, &value);
	  if (error) {
	    value = '?';
	  }
	  else {
	    if (value < 32) {
	      value = '.';
	    }
	  }
	  *stringptr++ = value;
	  index++;
	}

	*stringptr	= '\0';
	*pindex		= index;
	*pstringptr	= stringptr;

	return NULL;

      } /* rafascii */


/*----------------------------------------

	rafhex

	hex dump of raf

----------------------------------------*/


      unsigned char *rafhex(raf *rafptr, card32 textmode, card32 *pindex, unsigned char *pstringptr[]) {
	register unsigned char	*error;
	register card32		index;
	register unsigned int	i;
	unsigned char		*stringptr;
	card8			value;

	index		= *pindex;
	stringptr	= *pstringptr;

	if (textmode) {
	  *stringptr++ = '\t';
	  *stringptr++ = '\t';
	  *stringptr++ = 'H';
	  *stringptr++ = 'E';
	  *stringptr++ = 'X';
	  *stringptr++ = '\t';
	  for ( i=0; i<32; i++) {
	    error = rafptr->rafget(rafptr, index, &value);
	    if (error) {
	      *stringptr++ = '?';
	      *stringptr++ = '?';
	    }
	    else {
	      card8tohex(value, &stringptr);
	    }
	    index++;
	  } /* for i */
	} /* if (textmode) */
	else {
	/* write address */
	}

	*stringptr	= '\0';
	*pindex		= index;
	*pstringptr	= stringptr;

	return NULL;

      } /* rafhex */


#endif
