#ifndef HDR_HIERARCHY
#define HDR_HIERARCHY

/* An item in the hierarchy */
class THierarchyItem {
public:
  THierarchyItem *Ancestor;   // left
  THierarchyItem *Descendant; // right
  THierarchyItem *Prev;       // up
  THierarchyItem *Next;       // down
  void *Data;
  char isCollapsed;
protected:
  virtual void Link(THierarchyItem *p,THierarchyItem *n);
public:
  THierarchyItem(int ic=0);
  virtual ~THierarchyItem();
  virtual void DeleteDescendants();
  virtual void DescendFrom(THierarchyItem *i);
  virtual void InsertAfter(THierarchyItem *i);
  virtual void InsertBefore(THierarchyItem *i);
  virtual void Unlink();
  virtual short DataSize()=0;
  virtual void SetData(void *d);
  virtual void GetData(void *d);
  virtual void *GetData();
  virtual void HideDescendants();
  virtual void ShowDescendants();
  virtual int IsCollapsed();
};

class TTextHierarchyItem : public THierarchyItem {
public:
  TTextHierarchyItem(char *data,int ic=0);
  virtual short DataSize();
  virtual void SetData(void *d);
  virtual void GetData(void *d);
};

class TSortedTextHItem : public TTextHierarchyItem {
protected:
  inline int compare(THierarchyItem *i1,THierarchyItem *i2);
public:
  TSortedTextHItem(char *text);
  virtual void InsertAfter(THierarchyItem *i);
  virtual void InsertBefore(THierarchyItem *i);
};

class THierarchyViewer : public TListViewer {
private:
  int itemWidth;
  int hierarchyHeight;
  int hierarchyWidth;
  THierarchyItem *Root;
  THierarchyItem *selected;
protected:
  THierarchyItem *getHierarchyItem(short item);
  virtual void getText(char *dest,short item,short maxLen);
  virtual void selectItem(short item);
public:
  THierarchyViewer(TRect& bounds,TScrollBar *aHScrollBar,
                   TScrollBar *aVScrollBar,int iw,
                   THierarchyItem *r=0);
  virtual void calcSize(THierarchyItem *i,int& height,int& width);
  virtual void getHierarchyItemText(char *dest,THierarchyItem *i,short maxLen)=0;
  virtual THierarchyItem *newHierarchy(THierarchyItem *r);
};

#endif /* HDR_HIERARCHY */
