unsigned char BigCharsFG[0x600];
unsigned char BigCharsBG[0x600];

/* Txt-text,Lo-low resoultion,Hi-high resolution,
   DHi-double high resolution,Sp-split,Pg-page */
typedef enum {
  None,
  TxtPg1,LoPg1,LoSpPg1,
  TxtPg2,LoPg2,LoSpPg2,
  HiPg1,HiSpPg1,
  HiPg2,HiSpPg2,
  DHiPg1,DHiSpPg1,
  DHiPg2,DHiSpPg2
} AppleVideoID;

AppleVideoID EGAPageMap[4];

/*
   Buffer 0 = Text Page 1
   Buffer 1 = Lo-Res Graphics Page 1
   Buffer 2 = Text Page 2
   Buffer 3 = Lo-Res Graphics Page 2
   Buffer 4 = Hi-Res Graphics Page 1
   Buffer 5 = Hi-Res Graphics Page 2
   Buffer 6 = Double Hi-Res Graphics Page 1
   Buffer 7 = Double Hi-Res Graphics Page 2
*/
unsigned char far *VideoBuffers[8];
clock_t LastUsed[8];

/* Given the a video mode, sets which video buffers it corresponds to */
void GetIDBuf(AppleVideoID ID,int *Buf1,int *Buf2)
{
  *Buf1=*Buf2=-1;
  switch (ID) {
    TxtPg1  : *Buf1=0;          break;
    LoPg1   : *Buf1=1;          break;
    LoSpPg1 : *Buf1=0; *Buf2=1; break;
    TxtPg2  : *Buf1=2;          break;
    LoPg2   : *Buf1=3;          break;
    LoSpPg2 : *Buf1=2; *Buf2=3; break;
    HiPg1   : *Buf1=4;          break;
    HiSpPg1 : *Buf1=0; *Buf2=4; break;
    HiPg2   : *Buf1=5;          break;
    HiSpPg2 : *Buf1=1; *Buf2=5; break;
    DHiPg1  : *Buf1=6;          break;
    DHiSpPg1: *Buf1=0; *Buf2=6; break;
    DHiPg2  : *Buf1=7;          break;
    DHiSpPg2: *Buf1=1; *Buf2=7; break;
  }
}

/**************************
 *                        *
 * PC SCREEN I/O ROUTINES *
 *                        *
 **************************/

/* Get base EGA address of display */
WORD WriteAppleVideo(AppleVideoID ID)
{
  unsigned int loop;
  unsigned int LRUPage;
  clock_t LRUTime;
  int Buf1,Buf2;
  WORD Addr;
  unsigned char far *Src;
  unsigned char far *Dest;

  /* If required display in EGA buffers return address */
  for (loop=0;loop<4;loop++) {
    if (EGAPageMap[loop] == ID) {
      LastUsed[loop] = clock();
      return loop*0x4000;
    }
  }
  /* Not in buffers */
  /* Find least recently used page */
  LRUPage=0;
  LRUTime=LastUsed[LRUPage];
  for (loop=1;loop<4;loop++) {
    if (LastUsed[loop] > LRUTime) {
      LRUTime = LastUsed[loop];
      LRUPage = loop;
    }
  }
  Addr=LRUPage*0x4000;
  /* and swap it out (copy EGA memory to buffers) */
  WRITEMODE(1);
  GetIDBuf(EGAPageMap[LRUPage],&Buf1,&Buf2);
  if (Buf1>=0) {
    if (Buf2>=0) {
      /* Split mode */
      Dest=VideoBuffers[Buf1]; /* Top */
      Src =MK_FP(0xa000,Addr);
      _fmemcpy(Dest,Src,0x3200);
      Dest=VideoBuffers[Buf2]+0x3200; /* Bottom */
      Src =MK_FP(0xa000,Addr+0x3200);
      _fmemcpy(Dest,Src,0x0a00);
    }
    else {
      /* Full screen mode */
      Dest=VideoBuffers[Buf1];
      Src =MK_FP(0xa000,Addr);
      _fmemcpy(Dest,Src,0x3c00);
    }
  }
  /* Build required display (copy buffers to EGA memory) */
  GetIDBuf(ID,&Buf1,&Buf2);
  if (Buf1>=0) {
    if (Buf2>=0) {
      /* Split mode */
      Dest=MK_FP(0xa000,Addr); /* Top */
      Src =VideoBuffers[Buf1];
      _fmemcpy(Dest,Src,0x3200);
      Dest=MK_FP(0xa000,Addr+0x3200); /* Bottom */
      Src =VideoBuffers[Buf2]+0x3200;
      _fmemcpy(Dest,Src,0x0a00);
    }
    else {
      /* Full screen mode */
      Dest=MK_FP(0xa000,Addr);
      Src =VideoBuffers[Buf1];
      _fmemcpy(Dest,Src,0x3c00);
    }
  }
  WRITEMODE(0);
  /* Return address */
  LastUsed[LRUPage]=clock();
  return Addr;
}

/* Make the given Apple display visible */
void DisplayAppleVideo(AppleVideoID ID)
{
  /* Pretend we're going to write to it and get its' base address */
  unsigned char Page=WriteAppleVideo(ID)>>8; /* Assume low byte = 0 */
  /* Tell the EGA card to display from the base address */
  asm mov dx,0x3d4;
  asm mov al,0x0c;
  asm out dx,al;
  asm mov dx,0x3d5;
  asm mov al,Page;
  asm out dx,al;
}

void InitVideo(void)
{
  int fd;
  int loop,row,bit;
  unsigned char ch,bc1,bc2;

  /* Load character set */
  fd=Open("charset.bin",O_READ);
  Read(fd,(char far *)BigCharsFG,0x300);
  Close(fd);
  for (loop=95;loop>=0;loop--) {
    for (row=7;row>=0;row--) {
      ch=BigCharsFG[loop*8+row];
      bc1=bc2=0;
      /* For each character, make it twice as wide and */
      /* use the correct bit order */
      for (bit=0;bit<4;bit++) {
        if (ch&(1<<bit)) {
          bc1|=(1<<(7-(bit-0)*2));
          bc1|=(1<<(6-(bit-0)*2));
        }
      }
      for (bit=4;bit<7;bit++) {
        if (ch&(1<<bit)) {
          bc2|=(1<<(7-(bit-4)*2));
          bc2|=(1<<(6-(bit-4)*2));
        }
      }
      BigCharsFG[(loop*8+row)*2+1]=bc1;
      BigCharsFG[(loop*8+row)*2+0]=bc2;
      BigCharsBG[(loop*8+row)*2+1]=~bc1;
      BigCharsBG[(loop*8+row)*2+0]=(~bc2)&0xfc;
    }
  }
  /* Create video buffers */
  for (loop=0;loop<8;loop++) {
    VideoBuffers[loop]=farmalloc(16000UL);
    LastUsed[loop]=clock();
  }
  /* Turn on EGA 640x200x16 */
  asm mov ax,0x000e;
  asm int 0x10;

  asm mov dx,0x3d4; /* Page 0 */
  asm mov al,0x0c;
  asm out dx,al;
  asm mov dx,0x3d5;
  asm mov al,0;
  asm out dx,al;

  WRITEMODE(0);
  SETLOGIC(0);
  SETCOLOUR(15);
  SETREG(1,0x0f);

  /* Start display off */
//  DisplayAppleVideo(TxtPg1);
}

void ResetVideo(void)
{
  int loop;

  /* Reset EGA */
  WRITEMODE(0);
  SETREG(0,0);
  SETREG(1,0);
  SETLOGIC(0);
  SETMASK(0xff);
  /* Text video mode */
  asm mov ax,0x0003;
  asm int 0x10;
  /* Free video buffers */
  for (loop=0;loop<8;loop++) farfree(VideoBuffers[loop]);
}

unsigned int Data2Screen[8]=
  {0x7020,0x7000,0xf020,0xf000,0x0720,0x0700,0x0720,0x0740};

void DrawCharacter(int X,int Y,char ch,unsigned char fg,unsigned char bg)
{
  unsigned char far * screenptr;
  unsigned int * charptrfg;
  unsigned int * charptrbg;
  int rowcount=0;
  int pixelno;
  unsigned int rowpattern;
  unsigned char mask;

  X*=7;
  X<<=1;
  Y<<=3;
  screenptr = (char far *)MK_FP(0xa000,Y*80+(X>>3));
  pixelno=X&7;
  charptrfg = (unsigned int *)(BigCharsFG+(ch<<4));
  charptrbg = (unsigned int *)(BigCharsBG+(ch<<4));
  while (rowcount<8) {
    /* FOREGROUND */
    rowpattern=*charptrfg;
    SETCOLOUR(fg);
    /* First byte */
    mask=rowpattern>>(pixelno+8);
    SETMASK(mask);
    *(screenptr+0)|=0;
    /* Second byte */
    mask=(rowpattern>>pixelno);
    SETMASK(mask);
    *(screenptr+1)|=0;
    /* Third byte */
    if (pixelno>2) {
      mask=(rowpattern<<(8-pixelno));
      SETMASK(mask);
      *(screenptr+2)|=0;
    }
    /* BACKGROUND */
    rowpattern=*charptrbg;
    SETCOLOUR(bg);
    /* First byte */
    mask=rowpattern>>(pixelno+8);
    SETMASK(mask);
    *(screenptr+0)|=0;
    /* Second byte */
    mask=(rowpattern>>pixelno);
    SETMASK(mask);
    *(screenptr+1)|=0;
    /* Third byte */
    if (pixelno>2) {
      mask=(rowpattern<<(8-pixelno));
      SETMASK(mask);
      *(screenptr+2)|=0;
    }
    /* Next row */
    rowcount++;
    screenptr+=80;
    charptrfg++;
    charptrbg++;
  }
  WRITEMODE(0);
}

void WriteVideoLo1(WORD Address,BYTE Data)
{
  register unsigned char X,Y,T1;
  unsigned char fg,bg;
  unsigned int d2s;

  pokeb(MemSeg,Address,Data);
  Address -= 0x0400;
  T1 = Address&0x7f;
  if (T1 < 120) {
    X = T1%40;
    Y = T1/40+(Address>>7)*3; // Get row #
    Y = Y/3+(Y%3<<3);      // Convert to staggered rows
    /* X=0..39,Y=0..23 */
    d2s=Data2Screen[Data>>5];
    switch (d2s>>8) {
      case 0x70: /* inverse */
        fg=0;
        bg=13;
        break;
      case 0xf0: /* flashing */
        fg=14;
        bg=15;
        break;
      case 0x07: /* normal */
        fg=13;
        bg=0;
        break;
    }
    DrawCharacter(X,Y,(Data&0x1f)+(d2s&0xff),fg,bg);
  }
}

