;Mass-Storage Device ROM Using DMA
;Version 1.0
;23-Sep-1994
;Copyright (c) 1994
;by Andrew Gregory
;14 Whittington Ave
;Carine WA 6020
;Australia

;Comment-out #define MS_DMA to create a non-DMA version of the mass-storage
; card. The non-DMA version does not access Apple memory outside of the
; hardware I/O locations. If MS_DMA is defined, the DMA version is created.
; The DMA version will handle the command internally and access the given
; ProDOS buffer directly. Make sure the correct version of MASSSTOR.C has
; been compiled.
#define MS_DMA

;Mass-storage device I/O
; $0 - Writing the ProDOS command here will perform that command.
;      It is important to setup the other locations first.
;      0=Status,1=Read,2=Write,3=Format
; $1 - Unit number $0-$3
; $2 - Buffer low byte
; $3 - Buffer high byte
; $4 - Block low byte
; $5 - Block high byte
; $6 - Data register
; $7 - Status register

SLOTSAVE       .EQU $2B
CMD            .EQU $42
UNIT           .EQU $43
BUF            .EQU $44
BLK            .EQU $46
TMP            .EQU $FF        ;some temporary storage
BOOTBUF        .EQU $0800
DEV            .EQU $C080      ;+$s0 accesses i/o
IORTS          .EQU $FF58

               .ORG 0

;NOTE: for ProDOS identification the following offsets must be set to the
;following values:
;$Cs01 = $20, $Cs03 = $00, $Cs05 = $03
; (from ProDOS Technical Reference, pg 112)
;The Autostart Monitor ROM for my unenhanced //e also requires that $Cs07=$3C
;(which means that my unenhanced //e will only boot off disk controllers that
;look like a Disk ][). The enhanced //e ROMs scan for the same bytes as ProDOS,
;which means that they can boot off more than just the Disk ][.
;Due to these requirements it is not possible for this firmware to support
;the Pascal 1.1 firmware protocols.
               LDX #$20
               LDY #$00
               LDX #$03
               LDX #$3C

;What slot are we in?
               PHP
               SEI             ;disable interrupts
               JSR IORTS
               TSX
               LDA $0100,X     ;A now contains $Cs
               PLP             ;restore processor status
               TAX
               ASL A           ;translate into $s0
               ASL A
               ASL A
               ASL A
               STA SLOTSAVE
;Load block 0 into memory at BOOTBUF
               STA UNIT        ;set unit to $s0
               LDA #$01        ;set READ command
               STA CMD
               LDA #BOOTBUF&$FF ;set buffer to BOOTBUF
               STA BUF
               LDA #BOOTBUF>>8
               STA BUF+1
               LDA #$00        ;set block to zero
               STA BLK
               STA BLK+1

;'JSR DRIVER'
               TXA             ;push return address
               PHA
               LDA #RETURN-1
               PHA
               TXA             ;push call address
               PHA
               LDA #DRIVER-1
               PHA

               RTS             ;'JSR DRIVER'

RETURN         LDX SLOTSAVE
               JMP BOOTBUF+1

;Driver handler - cannot assume that Applesoft ROMs will be available
DRIVER         LDA TMP         ;save zero page location
               PHA
               LDA #$60        ;since Applesoft cannot be relied on to be
               STA TMP         ; available, make our own RTS
               PHP
               SEI             ;disable interrupts
               JSR TMP         ;used to be JSR IORTS
               TSX
               LDA $0100,X     ;A now contains $Cs
               PLP             ;restore processor status
               ASL A           ;translate into $s0
               ASL A
               ASL A
               ASL A
               TAX

;ProDOS Unit # -> Device Unit #
; bit 7 = unit except for slots 5 & 6 which may support more than two units.
; If the slot indicated by the ProDOS unit is not the same as the slot the
; card is installed in, then ProDOS has requested a special extended unit.
CONV_UNIT      LDA #$00        ;init to zero unit
               STA DEV+1,X
               LDA UNIT        ;convert ProDOS unit into device unit
               AND #$70        ;get slot $s0 of unit
               STA TMP
               CPX TMP         ;slot of unit and slot of card must be the same
               BEQ UNIT_OK
;Slots are different, but might be OK: card slots 5 & 6 can accept unit slots
;1 & 2 respectively as extra device units.
               CPX #$50
               BEQ EXTRA_VOLS5
               CPX #$60
               BEQ EXTRA_VOLS6
;Card is NOT in slot 5 or 6; indicate an error
UNIT_ERROR     PLA             ;restore zero page location
               STA TMP
               SEC
               LDA #$28        ;no device connected error
               RTS
;The card slot is 5; make sure requested ProDOS slot is slot 1
EXTRA_VOLS5    CMP #$10
               BNE UNIT_ERROR
               BEQ EXTRA_UNIT_OK
;The card slot is 6; make sure requested ProDOS slot is slot 2
EXTRA_VOLS6    CMP #$20
               BNE UNIT_ERROR
;The extra units are valid, extend device units to $2 and $3
EXTRA_UNIT_OK  LDA DEV+1,X
               ORA #$02
               STA DEV+1,X
UNIT_OK        LDA UNIT        ;get ProDOS unit and translate drive into
               ASL A           ;device unit
               BCC SETUP_PARMS
               LDA #$01
               ORA DEV+1,X
               STA DEV+1,X

SETUP_PARMS    LDA BUF         ;get ProDOS buffer
               STA DEV+2,X
               LDA BUF+1
               STA DEV+3,X

               LDA BLK         ;get ProDOS block
               STA DEV+4,X
               LDA BLK+1
               STA DEV+5,X

#ifdef MS_DMA ;****** start of DMA version
               LDA CMD         ;do command
               STA DEV+0,X
#else ;****** start of non-DMA version
;Handle ProDOS command
               LDA CMD
               CMP #$02
               BEQ DO_WRITE
               CMP #$01
               BEQ DO_READ
               STA DEV+0,X     ;STATUS and FORMAT commands fall through to here
               BNE GET_STATUS
DO_READ
DO_WRITE
               LDY #$00        ;set current byte to zero
               CLC             ;C=0=first 256 bytes,C=1=second 256 bytes
NEXT_BYTE      LDA CMD         ;get command (read/write)
               EOR #$01        ;Read:01 EOR 01=00,Write:10 EOR 01=11
               BNE WRITE_BYTE
READ_BYTE      LDA CMD
               STA DEV+0,X     ;tell device to get byte
               LDA DEV+6,X     ;get data
               STA (BUF),Y     ;place it in buffer
               INY
               BNE NEXT_BYTE
               BEQ NEXT_SECTOR
WRITE_BYTE     LDA (BUF),Y     ;get byte from buffer
               STA DEV+6,X     ;put in device data register
               LDA CMD
               STA DEV+0,X     ;tell device to write
               INY
               BNE NEXT_BYTE
NEXT_SECTOR    BCS DONE_RW     ;if C set, then we were reading the second 256
               INC BUF+1       ;move ProDOS buffer pointer along one page
               SEC             ;we're now reading the second 256 bytes
               BNE NEXT_BYTE
DONE_RW        DEC BUF+1       ;restore ProDOS buffer pointer
#endif ;****** end of non-DMA version

GET_STATUS     PLA             ;restore zero page location
               STA TMP
               CLC             ;get status
               LDA DEV+7,X
               BNE ERROR
               LDA CMD         ;no errors
               BNE EXIT        ;exit if command wasn't STATUS
               LDA DEV+5,X     ;get # blocks, high byte
               TAY
               LDA DEV+4,X     ;get # blocks, low byte
               TAX
EXIT           LDA #$00
               RTS
ERROR          SEC
               RTS

               .ORG $FC
               .DB $00,$00     ;Unknown # blocks
               .DB 10011111b   ;Removable,NOT interruptable,2 volumes,
                               ;formattable,can read/write and get status
               .DB $(DRIVER)

               .END
