;Clock card ROM
;Version 2.0
;29-Sep-1994
;Copyright (c) 1994
;by Andrew Gregory
;14 Whittington Ave
;Carine WA 6020
;Australia

;Clock I/O Offsets ($0-$7 in BCD) eg. Saturday September 24th 1994 9:18:37pm
;
; R   $0 = Year low  byte (yy) eg. $94
; R   $1 = Year high byte (cc) eg. $19
; R   $2 = Month          (oo) eg. $09
; R   $3 = Day            (dd) eg. $24
; R   $4 = Day of week    (ww) eg. $06
; R   $5 = Hour           (hh) eg. $21
; R   $6 = Minute         (mm) eg. $18
; R   $7 = Second         (ss) eg. $37 (seconds are not supported)
; Next locations will retrieve various parts of a character string:
;  (these made it much easier to write the ROM code)
; R/W $8 = Mode (see below)
; R   $9 = String length in characters (no trailing CR,LF or NULL)
; R/W $A = Character position on string to access, starting from 0
; R   $B = Character at given position

;Clock mode characters (not currently supported):
;Derived from the ProDOS Technical Reference Manual and Nibble March 1986
;article "Catalog Clock".
; $A3 = '#' : ProDOS format "oo,ww,dd,hh,mm"
; $BE = '>' : Integer BASIC format   "oo/dd  hh;mm;ss;.000" ?
; $A0 = ' ' : Applesoft BASIC format "oo/dd  hh;mm;ss;.000"
; $A5 = '%' : Applesoft BASIC format "oo/dd  hh;mm;ss;.000"
; $A4 = '$' : My custom ProDOS clock format "yy/oo/dd hh:mm:ss" for use with
;             my own driver.
; any other character is ignored

STRING_LEN     .EQU $E         ;length of generated string
KSW            .EQU $38
CUR_CHAR       .EQU $538
CLOCKDEV       .EQU $C080      ;+$s0 accesses clock I/O
IORTS          .EQU $FF58

               .ORG 0

;NOTE: for ProDOS identification the following offsets must be set to the
;following values:
;$Cs00 = $08, $Cs02 = $28, $Cs04 = $58, $Cs06 = $70
; (from ProDOS Technical Reference, pg 105)
;The STARTUP.BAS program supplied with ProDOS 1.0.1 looks for:
;$Cs00 = $08, $Cs01 = $78, $Cs02 = $28
;A program given in Nibble March 1986 "Catalog Clock" looks for:
;$Cs05 = $FF, $Cs07 = $05
ENT0           PHP             ;First 8 bytes for ProDOS identification
               SEI
               PLP
               BIT IORTS
               BVS CLOCK_INIT

ENT_READ       CLC             ;ProDOS READ entry point
               BCC GET_DATE_TIME
ENT_WRITE      BNE PD_SET_MODE ;ProDOS WRITE entry point
                               ;Assume the ProDOS clock driver loads the
                               ;Accumulator with #$A3 and hence clears the
                               ;zero flag.

;Normal entry
CLOCK_INIT     CLC
               BCS $
               .ORG *-1
CLOCK_ENTRY    SEC
               PHA             ;Figure out what slot we're in.
               TXA             ; This returns the slot number s in the X
               PHA             ; register as $Cs. The Accumulator is unchanged
               TYA             ; and the Y register is set to the Accumulator.
               PHA             ; The original values of A,X,Y are saved on the
               PHP             ; stack.
               SEI
               JSR IORTS
               TSX
               PLA
               PLA
               PLA
               PLA
               TAY             ;get original A
               DEX
               TXS
               PLA
               PLP
               TAX             ;$Cs now in X
               TYA             ;original A

               BCS GET_CHAR    ;if Carry set, definitely getting data
;Carry is clear; this is either a set mode call (Applesoft->card) or the
;first get data call (card->Applesoft). If it's the first get data call, then
;the vector at KSW points to ENT0 ($Cs00).
;i.e. If KSW = $Cs00 then getting initial character
;     Else setting mode
               CPX KSW+1
               BNE GOTO_SET_MODE
               LDY KSW
               BEQ INIT_GET_CHAR
GOTO_SET_MODE  CLC
               BCC SET_MODE
INIT_GET_CHAR  LDA #$00
               STA CUR_CHAR,X
               LDA #CLOCK_ENTRY
               STA KSW
;now get the current character
GET_CHAR       TXA             ;first convert $Cs in X into $s0 in Y
               ASL A
               ASL A
               ASL A
               ASL A
               TAY
               LDA CUR_CHAR,X
               STA CLOCKDEV+$A,Y
               LDA CLOCKDEV+$B,Y

INC_COUNTER    PHA
               LDA CUR_CHAR,X  ;if current position = length then return a CR
               CMP CLOCKDEV+$9,Y
               BEQ RETURN_CR
               INC CUR_CHAR,X  ;otherwise, next character
               BNE RETURN_CHAR ;always

RETURN_CR      LDA #$00
               STA CUR_CHAR,X
               PLA
               LDA #$8D
               PHA

RETURN_CHAR    PLA
               TAY
               PHP             ;modify Accumulator on stack (see CLOCK_ENTRY)
               SEI             ; disable interrupts
               TSX
               PLA             ; P
               PLA             ; original Y
               PLA             ; original X
               PLA             ; original A
               TYA             ; put saved character into A
               PHA             ; and save it on the stack
               TXS
               PLP             ;restore processor status
               CLC
               BCC CLOCK_EXIT

PD_SET_MODE    SEC
SET_MODE       PHP
               PHA
               TXA             ;convert $Cs in X into $s0 in Y
               ASL A
               ASL A
               ASL A
               ASL A
               TAY
               PLA
               STA CLOCKDEV+$8,Y
               PLP
               BCS EXIT        ;Carry will be set only if entered via ENT_WRITE
CLOCK_EXIT     PLA             ;restore A,X,Y (see CLOCK_ENTRY above)
               TAY
               PLA
               TAX
               PLA
EXIT           RTS

;Get date and time info from the card
;The X register holds $Cn where n is the slot number
GET_DATE_TIME  PHA             ;save mode character
               TXA             ;convert $Cs in X into $s0 in Y
               ASL A
               ASL A
               ASL A
               ASL A
               TAY
               PLA             ;get mode character
               STA CLOCKDEV+$8,Y
               LDA #$00        ;reset current character
               STA CUR_CHAR,X
               TAY
;simulate a JSR to GET_CHAR
MORE_DATA      TXA             ;push return address onto stack
               PHA
               LDA #RETURN-1   ;RTS will increment PC
               PHA

               PHA             ;simulate action of CLOCK_ENTRY (see above)
               TXA             ;save X register
               PHA
               TYA             ;save Y register
               PHA

               TXA             ;push call address onto stack
               PHA
               LDA #GET_CHAR-1 ;RTS will increment PC
               PHA

               RTS             ;'JSR GET_CHAR'

RETURN         STA $0200,Y
               CMP #$8D
               BEQ STRING_END
               INY
               BNE MORE_DATA
STRING_END     LDA #$00
               STA $0200,Y
               RTS

               .END
