;ProDOS Clock Driver Patch
;Version 1.0
;24-Sep-1994
;Copyright (c) 1994
;by Andrew Gregory
;14 Whittington Ave
;Carine WA 6020
;Australia

TEMP           .EQU $3A
YEAR           .EQU TEMP
MONTH          .EQU TEMP+1
DAY            .EQU TEMP+2
HOUR           .EQU TEMP+3
MINUTE         .EQU TEMP+4
MLI_GET_TIME   .EQU $82
KEYBUF         .EQU $0200      ;keyboard input buffer
MLI            .EQU $BF00      ;ProDOS MLI entry point
CLOCK_VECTOR   .EQU $BF06      ;ProDOS clock driver vector
CUR_DATETIME   .EQU $BF90      ;ProDOS current date/time storage
ROM_ENABLE     .EQU $C082      ;Read ROM, no write, bank 2
RAM_WRITE      .EQU $C08B      ;Read & write RAM, bank 1
COUT           .EQU $FDED      ;Applesoft ROM character output

               .ORG $6000

;Check if ProDOS found a clock card
               LDA CLOCK_VECTOR
               CMP #$4C        ;if ProDOS has put a JMP there, then it found a
               BEQ GET_SLOT    ; clock card

               LDA #NO_CLOCK_MSG&$FF ;otherwise, no clock card
               STA $FD
               LDA #NO_CLOCK_MSG>>8
               STA $FE
               LDA NO_CLK_MSG_LEN
               STA $FF
               JMP QUIT_MSG

;Search existing clock driver for calls to the clock card ROM and get the
;slot the clock card is in. Search for JSR $Cn0B.
GET_SLOT       LDA TEMP        ;save 2 bytes in zero page
               PHA
               LDA TEMP+1
               PHA
               LDA CLOCK_VECTOR+1 ;copy clock vector
               STA TEMP
               LDA CLOCK_VECTOR+2
               STA TEMP+1

               LDA RAM_WRITE   ;Read & write enable RAM card
               LDA RAM_WRITE

               LDY #$00
SRCH_JSR       LDA (TEMP),Y    ;test for #$20 (JSR)
               CMP #$20
               BEQ SRCH_0B     ;got a JSR
               INY             ;next byte
               BEQ SEARCH_FAIL ;if zero, then we've searched 256 bytes without
               JMP SRCH_JSR    ; success, so fail search, otherwise continue
SRCH_0B        INY             ;next byte on from #$20
               BEQ SEARCH_FAIL ;fail if searched 256 bytes
               LDA (TEMP),Y    ;test for #$0B (clock WRITE)
               CMP #$0B
               BNE SRCH_JSR    ;not WRITE offset, is it a JSR?
SRCH_CN        INY             ;is WRITE offset
               BEQ SEARCH_FAIL ;fail if searched 256 bytes
               LDA (TEMP),Y    ;test for slot #$Cn
               AND #$F0        ;mask off slot #
               CMP #$C0        ;test for ROM I/O address
               BNE SRCH_JSR    ;not ROM I/O, is it a JSR?
               LDA (TEMP),Y    ;is a ROM I/O address, get it
               TAX             ;put it in the X register and patch driver
               JMP PATCH_DRIVER

SEARCH_FAIL    LDA #SRCH_FAIL_MSG&$FF
               STA $FD
               LDA #SRCH_FAIL_MSG>>8
               STA $FE
               LDA SF_MSG_LEN
               STA $FF
               JMP QUIT_MSG

;Slot is in X register as $Cn where n is the slot (slot 7:$C7)
PATCH_DRIVER   STX PATCH1
               STX PATCH2
               STX PATCH3
               STX PATCH4

               LDY #$00
COPY_CLOCK     LDA DRIVER,Y
               STA (TEMP),Y
               INY
               CPY DRIVER_LEN
               BNE COPY_CLOCK

DONE_COPY      PLA             ;restore zero page locations
               STA TEMP+1
               PLA
               STA TEMP

               JSR MLI         ;refresh date/time via new driver
               .DB MLI_GET_TIME ;get current time
               .DB 0,0         ;no paramters

               LDA #INSTALLED_MSG&$FF
               STA $FD
               LDA #INSTALLED_MSG>>8
               STA $FE
               LDA INST_MSG_LEN
               STA $FF

;Display message at address ($FD,$FE) with length $FF
QUIT_MSG       LDA ROM_ENABLE  ;make sure ROM is re-enabled
               LDY #$00
NEXT_CHAR      LDA ($FD),Y
               ORA #$80
               JSR COUT
               INY
               CPY $FF
               BNE NEXT_CHAR
               RTS

NO_CLOCK_MSG   .TEXT "No clock card installed."
               .DB $7,$D
NO_CLK_MSG_LEN .DB *-NO_CLOCK_MSG

SRCH_FAIL_MSG  .TEXT "Could not find clock driver WRITE call."
               .DB $7,$D
SF_MSG_LEN     .DB *-SRCH_FAIL_MSG

INSTALLED_MSG  .TEXT "Clock driver installed."
               .DB $D
INST_MSG_LEN   .DB *-INSTALLED_MSG

DRIVER
               LDX #$C0
               .ORG *-1
PATCH1         .DB $C0
               LDA $538,X
               PHA
               LDA #$A4
               JSR $C00B
               .ORG *-1
PATCH2         .DB $C0
               JSR $C008
               .ORG *-1
PATCH3         .DB $C0
               LDX #$04
               LDY #$0C
NEXT_CLK_DATA  LDA KEYBUF,Y
               AND #$0F
               STA TEMP
               ASL A
               ASL A
               ADC TEMP
               ASL A
               ADC KEYBUF+1,Y
               SEC
               SBC #$B0
               STA TEMP,X
               DEY
               DEY
               DEY
               DEX
               BPL NEXT_CLK_DATA

               LDA MONTH
               ASL A
               ASL A
               ASL A
               ASL A
               ASL A
               ORA DAY
               STA CUR_DATETIME
               LDA YEAR
               ROL A
               STA CUR_DATETIME+1
               LDA HOUR
               STA CUR_DATETIME+3
               LDA MINUTE
               STA CUR_DATETIME+2

               PLA
               LDX #$C0
               .ORG *-1
PATCH4         .DB $C0
               STA $538,X
               RTS

DRIVER_LEN     .DB *-DRIVER

               .END
