;This is a stripped-down version of A2ICOMMS.ASM. It contains just the bare
;essentials for receiving data with a checksum from the PC.
;The parallel byte receiving routine has had the timeout code removed, so if
;the remote stops sending it will loop forever.

DEV            .EQU $C080      ;base I/O address

               .ORG $300
;Receive byte over the parallel port
RECPARABYTE    LDX SLOT
WAITLOW        LSR DEV+4,X     ;wait for bit 4 (clock) to go low
               BCS WAITLOW
LOOKLOW        LSR DEV+4,X     ;when bit 4 (clock) goes high, a nibble has
               BCC LOOKLOW
READLOW        LDA DEV+3,X     ;read received nibble
               AND #$E8        ;mask off unused bits
               LSR A           ;shift them down
               LSR A
               LSR A
               LSR A
               BCC NOLOWBIT3   ;bit 3 will have shifted into the Carry
               ORA #$01        ;bring it back
NOLOWBIT3      STA DATA        ;and store it
LOOKHIGH       LSR DEV+4,X     ;when bit 4 (clock) lowers again, another nibble
               BCS LOOKHIGH    ; has been received
READHIGH       LDA DEV+3,X     ;read received nibble
               AND #$E8        ;mask off unused bits
               TAX             ;X register no longer needed - use as temporary
               AND #$08        ;bit 3 needs to move to bit 4
               BEQ MERGENIBS   ;if zero merge immediately
               TXA             ;otherwise,
               ORA #$10        ;set bit 4
               AND #$F0        ;and clear bit 3
               TAX
MERGENIBS      TXA
               ORA DATA        ;merge with previous nibble
               STA DATA        ;and keep it
;               CLC
;               BCC CALCCRC

;Receive byte over serial port
;RECSERIALBYTE  SEC
;               RTS

;*** CRC Stuff ***

;Calculate CRC. Accumulator and X register trashed.
;Set CH with data byte and CRC with cumulative CRC.
;CALCCRC        LDA DATA
               CLV             ;Overflow clear - first time through

DOCRCNIBBLE    EOR CRC         ;index=(CRC^DATA)&0x000f
               AND #$0F
               ASL A           ;word-align index
               TAX             ;store index in X register
               LDY #4          ;CRC>>=4
SHIFTCRC       LSR CRC+1
               ROR CRC
               DEY
               BNE SHIFTCRC
               LDA CRC+1       ;CRC&=0x0fff
               AND #$0F
               EOR CRCTABLE+1,X ;CRC^=CRCTable[index]
               STA CRC+1
               LDA CRC
               EOR CRCTABLE,X
               STA CRC
               BVS CRCDONE
               BIT CRCDONE     ;BIT #$60 ; sets Overflow
               LDA DATA        ;DATA>>=4
               LSR A
               LSR A
               LSR A
               LSR A
               BVS DOCRCNIBBLE
CRCDONE        RTS
CRCTABLE       .DW $0000,$1081,$2102,$3183,$4204,$5285,$6306,$7387
               .DW $8408,$9489,$A50A,$B58B,$C60C,$D68D,$E70E,$F78F
;*** Variables ***
DATA           .DB             ;data received
SLOT           .DB             ;slot as $s0
CRC            .DW             ;cumulative CRC
               .END
