#ifndef APPLEEMU_SYSTEM_H
#define APPLEEMU_SYSTEM_H

#define O_RDONLY 0
#define O_WRONLY 1
#define O_RDWR   2

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

#define FA_NETSHARE 0x0100
#define FA_ARCH     0x0020
#define FA_DIREC    0x0010
#define FA_LABEL    0x0008
#define FA_SYSTEM   0x0004
#define FA_HIDDEN   0x0002
#define FA_RDONLY   0x0001

char far *strcpy( char far *dest, char far *src );

int Open( char far *filename, char mode );
unsigned int Read( int filehandle, char far *buffer, unsigned int size );
unsigned int Write( int filehandle, char far *buffer, unsigned int size );
unsigned int Close( int filehandle );
long Seek( int filehandle, long pos, unsigned char from );
long Tell( int filehandle );
long FileSize( int filehandle );
unsigned int DeleteFile( char far *filename );
unsigned int GetAttrib( char far *filename );
unsigned int SetAttrib( char far *filename, unsigned int attribs );
void interrupt ( far *GetVect( int intnum ) )();
void SetVect(int intnum, void interrupt ( far *isr )() );

#endif /* APPLEEMU_SYSTEM_H */
