#include "ram.h"
#include "speaker.h"

#define SPEAKER_PORT 0x61   // Speaker control port
#define SPEAKER_BIT  0x02   // Speaker on/off bit 1=on,0=off

#pragma argsused
BYTE ReadSpeaker( WORD Address )
{
  // Toggle the speaker
  asm in  al, SPEAKER_PORT;
  asm xor al, SPEAKER_BIT;
  asm and al, 0xfe;
  asm out SPEAKER_PORT, al;
  return 0;
}

#pragma argsused
void WriteSpeaker( WORD Address, BYTE Data )
{
  // Toggle the speaker
  asm in  al, SPEAKER_PORT;
  asm xor al, SPEAKER_BIT;
  asm and al, 0xfe;
  asm out SPEAKER_PORT, al;
}
