#ifndef APPLEEMU_RAM_H
#define APPLEEMU_RAM_H

#include "defns.h"

/* Ripped from DOS.H */
#define MK_FP(seg,ofs)((void _seg *)(seg)+(void near *)(ofs))
#define FP_SEG(fp)((unsigned)(void _seg *)(void far *)(fp))
#define FP_OFF(fp)((unsigned)(fp))
#define peek(a,b)(*((WORD far*)MK_FP((a),(b))))
#define peekb(a,b)(*((BYTE far*)MK_FP((a),(b))))
#define poke(a,b,c)(*((WORD far*)MK_FP((a),(b)))=(WORD)(c))
#define pokeb(a,b,c)(*((BYTE far*)MK_FP((a),(b)))=(BYTE)(c))

extern unsigned int MainSeg;
extern unsigned int MainBankSeg;
extern unsigned int AuxSeg;
extern unsigned int AuxBankSeg;
extern unsigned int ROMSeg;

extern unsigned int CurZPSSeg;
extern unsigned int CurMainSeg;
extern unsigned int CurSlotROMSeg;
extern unsigned int CurAuxSlotROMSeg;
extern unsigned int ExpSlotSeg;
extern unsigned int CurBankSeg;
extern unsigned int CurBank2Seg;

extern unsigned int ZPSRSeg;
extern unsigned int ZPSWSeg;
extern unsigned int MainRSeg;
extern unsigned int MainWSeg;
extern unsigned int BankRSeg;
extern unsigned int BankWSeg;
extern unsigned int Bank2RSeg;
extern unsigned int Bank2WSeg;

extern BYTE ( *ReadPage[ 0x0100 ] )( WORD Address );
extern void ( *WritePage[ 0x0100 ] )( WORD Address, BYTE Data );

void InitRAM( void );
void FreeRAM( void );

#define  ReadByte( ADDRESS )        ReadPage[ ( ADDRESS ) >> 8 ]( ADDRESS )
#define WriteByte( ADDRESS, DATA ) WritePage[ ( ADDRESS ) >> 8 ]( ADDRESS, DATA )

extern BYTE IOUDisabled;
extern BYTE SlotCxROM;
extern BYTE SlotC3ROM;
extern BYTE RdBnk2;

#endif /* APPLEEMU_RAM_H */
