#include "ram.h"
#include "cpu.h"
#include "pic.h"
#include "system.h"
#include "diags.h"

/* PIC = Parallel Interface Card */

BYTE ReadPICIO( WORD Address )
{
    BYTE v;

    v = 0xff;
    switch ( Address & 0x0f )
    {
    case 0x01:
        break;
    case 0x02:
        break;
    case 0x03:
        break;
    case 0x04:
        break;
    case 0x06:
        break;
    case 0x07:
        break;
    }
    return v;
}

#pragma argsused
void WritePICIO( WORD Address, BYTE Data )
{
    switch ( Address & 0x0f )
    {
    case 0x00:
        /* load output port */
        _DX = 0x00; /* LPT1: */
        _AH = 0x00;
        _AL = Data & 0x7f; /* strip high bit */
        asm int 0x17;
        break;
    }
    ReadPICIO( Address );
}
