/********************************
 *                              *
 * 65C02 Micro Code Definitions *
 *                              *
 ********************************/

#define MC_ADC( Data )                         \
    if ( Decimal )                             \
    {                                          \
        ClockTick++;                           \
        _DL = A;                               \
        _AL = Data;                            \
        _AH = Carry;                           \
        asm shr ah, 1;                         \
        asm adc al, dl;                        \
        asm daa;                               \
        asm pushf;                             \
    }                                          \
    else                                       \
    {                                          \
        _DL = A;                               \
        _AL = Data;                            \
        _AH = Carry;                           \
        asm shr ah, 1;                         \
        asm adc al, dl;                        \
        asm pushf;                             \
    }                                          \
    A = _AL;                                   \
    asm pop ax;                                \
    asm mov P, ax;                             \
    Zero = ( A == 0 );                         \
    Negative = ( A & 0x0080 ) ? 1 : 0;         \
    Carry    = ( P & 0x0001 ) ? 1 : 0;         \
    Overflow = ( P & 0x0800 ) ? 1 : 0; cADC++;

#define MC_AND( Data )                       \
    A &= Data;                               \
    Zero = ( A == 0 );                       \
    Negative = ( A & 0x80 ) ? 1 : 0; cAND++;

#define MC_ASL( Data )                          \
    Carry = ( Data & 0x80 ) ? 1 : 0;            \
    Data <<= 1;                                 \
    Zero = ( Data == 0 );                       \
    Negative = ( Data & 0x80 ) ? 1 : 0; cASL++;

#define MC_BCC()                                                     \
    if ( !Carry )                                                    \
    {                                                                \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBCC++;

#define MC_BCS()                                                     \
    if ( Carry )                                                     \
    {                                                                \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBCS++;

#define MC_BEQ()                                                     \
    if ( Zero ) {                                                    \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBEQ++;

#define MC_BIT( Data )                  \
    Zero = ( ( A & Data ) == 0 );       \
    Overflow = ( Data & 0x40 ) ? 1 : 0; \
    Negative = ( Data & 0x80 ) ? 1 : 0; \
    cBIT++;

#define MC_BMI()                                                     \
    if ( Negative )                                                  \
    {                                                                \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBMI++;

#define MC_BNE()                                                     \
    if ( !Zero )                                                     \
    {                                                                \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBNE++;

#define MC_BPL()                                                     \
    if ( !Negative )                                                 \
    {                                                                \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBPL++;

#define MC_BRA()                                                 \
    OldPage = PC & 0xff00;                                       \
    PC += (signed int)(signed char)ReadByte( PC );               \
    ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    cBRA++;

/* used to be PC+=2; */
#define MC_BRK()                        \
    PC++;                               \
    WriteByte( 0x0100 + S, PC >> 8 );   \
    S--;                                \
    WriteByte( 0x0100 + S, PC & 0xff ); \
    S--;                                \
    WriteByte( 0x0100 + S,              \
        ( Negative  << 7 ) |            \
        ( Overflow  << 6 ) |            \
        ( 1         << 5 ) |            \
        ( Break     << 4 ) |            \
        ( Decimal   << 3 ) |            \
        ( Interrupt << 2 ) |            \
        ( Zero      << 1 ) |            \
        ( Carry     << 0 ) );           \
    S--;                                \
    PC = ReadWord( 0xfffe );            \
    Interrupt = Break = 1;              \
    cBRK++;

#define MC_BVC()                                                     \
    if ( !Overflow )                                                 \
    {                                                                \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBVC++;

#define MC_BVS()                                                     \
    if ( Overflow )                                                  \
    {                                                                \
        OldPage = PC & 0xff00;                                       \
        PC += (signed int)(signed char)ReadByte( PC );               \
        ClockTick += ( ( ( PC + 1 ) & 0xff00 ) != OldPage ) ? 2 : 1; \
    }                                                                \
    cBVS++;

#define MC_CLC() \
    Carry = 0;   \
    cCLC++;

#define MC_CLD() \
    Decimal = 0; \
    cCLD++;

#define MC_CLI()   \
    Interrupt = 0; \
    cCLI++;

#define MC_CLV()  \
    Overflow = 0; \
    cCLV++;

#define MC_CMP( Data )                 \
    asm mov ah, 1;                     \
    asm mov dl, A;                     \
    asm mov al, Data;                  \
    asm shr ah, 1;                     \
    asm cmc;                           \
    asm sbb dl, al;                    \
    asm cmc;                           \
    asm pushf;                         \
    asm pop ax;                        \
    asm mov P, ax;                     \
    Zero     = ( P & 0x0040 ) ? 1 : 0; \
    Negative = ( P & 0x0080 ) ? 1 : 0; \
    Carry    = ( P & 0x0001 ) ? 1 : 0; \
    cCMP++;

#define MC_CPX( Data )                 \
    asm mov ah, 1;                     \
    asm mov dl, X;                     \
    asm mov al, Data;                  \
    asm shr ah, 1;                     \
    asm cmc;                           \
    asm sbb dl, al;                    \
    asm cmc;                           \
    asm pushf;                         \
    asm pop ax;                        \
    asm mov P, ax;                     \
    Zero     = ( P & 0x0040 ) ? 1 : 0; \
    Negative = ( P & 0x0080 ) ? 1 : 0; \
    Carry    = ( P & 0x0001 ) ? 1 : 0; \
    cCPX++;

#define MC_CPY( Data )                 \
    asm mov ah, 1;                     \
    asm mov dl, Y;                     \
    asm mov al, Data;                  \
    asm shr ah, 1;                     \
    asm cmc;                           \
    asm sbb dl, al;                    \
    asm cmc;                           \
    asm pushf;                         \
    asm pop ax;                        \
    asm mov P, ax;                     \
    Zero     = ( P & 0x0040 ) ? 1 : 0; \
    Negative = ( P & 0x0080 ) ? 1 : 0; \
    Carry    = ( P & 0x0001 ) ? 1 : 0; \
    cCPY++;

#define MC_DEC( Data )                  \
    Data--;                             \
    Zero = ( Data == 0 );               \
    Negative = ( Data & 0x80 ) ? 1 : 0; \
    cDEC++;

#define MC_DEX()                     \
    X--;                             \
    Zero = ( X == 0 );               \
    Negative = ( X & 0x80 ) ? 1 : 0; \
    cDEX++;

#define MC_DEY()                     \
    Y--;                             \
    Zero = ( Y == 0 );               \
    Negative = ( Y & 0x80 ) ? 1 : 0; \
    cDEY++;

#define MC_EOR( Data )               \
    A ^= Data;                       \
    Zero = ( A == 0 );               \
    Negative = ( A & 0x80 ) ? 1 : 0; \
    cEOR++;

#define MC_INC( Data )                  \
    Data++;                             \
    Zero = ( Data == 0 );               \
    Negative = ( Data & 0x80 ) ? 1 : 0; \
    cINC++;

#define MC_INX()                     \
    X++;                             \
    Zero = ( X == 0 );               \
    Negative = ( X & 0x80 ) ? 1 : 0; \
    cINX++;

#define MC_INY()                     \
    Y++;                             \
    Zero = ( Y == 0 );               \
    Negative = ( Y & 0x80 ) ? 1 : 0; \
    cINY++;

#define MC_JMP() \
    cJMP++;

#define MC_JSR() \
    cJSR++;

#define MC_LDA( Data )               \
    A = Data;                        \
    Zero = ( A == 0 );               \
    Negative = ( A & 0x80 ) ? 1 : 0; \
    cLDA++;

#define MC_LDX( Data )               \
    X = Data;                        \
    Zero = ( X == 0 );               \
    Negative = ( X & 0x80 ) ? 1 : 0; \
    cLDX++;

#define MC_LDY( Data )               \
    Y = Data;                        \
    Zero = ( Y == 0 );               \
    Negative = ( Y & 0x80 ) ? 1 : 0; \
    cLDY++;

#define MC_LSR( Data )                  \
    Carry = ( Data & 1 ) ? 1 : 0;       \
    Data >>= 1;                         \
    Zero = ( Data == 0 );               \
    Negative = ( Data & 0x80 ) ? 1 : 0; \
    cLSR++;

#define MC_NOP() \
    cNOP++;

#define MC_ORA( Data )               \
    A |= Data;                       \
    Zero = ( A== 0 );                \
    Negative = ( A & 0x80 ) ? 1 : 0; \
    cORA++;

#define MC_PHA()                \
    WriteByte( 0x0100 + S, A ); \
    S--;                        \
    cPHA++;

#define MC_PHP()              \
    WriteByte( 0x0100 + S,    \
        ( Negative  << 7 ) |  \
        ( Overflow  << 6 ) |  \
        ( 1         << 5 ) |  \
        ( Break     << 4 ) |  \
        ( Decimal   << 3 ) |  \
        ( Interrupt << 2 ) |  \
        ( Zero      << 1 ) |  \
        ( Carry     << 0 ) ); \
    S--;                      \
    cPHP++;

#define MC_PHX()                \
    WriteByte( 0x0100 + S, X ); \
    S--;                        \
    cPHX++;

#define MC_PHY()                \
    WriteByte( 0x0100 + S, Y ); \
    S--;                        \
    cPHY++;

#define MC_PLA()                     \
    S++;                             \
    A = ReadByte( 0x0100 + S );      \
    Zero = ( A == 0 );               \
    Negative = ( A & 0x80 ) ? 1 : 0; \
    cPLA++;

#define MC_PLP()                      \
    S++;                              \
    P = ReadByte( 0x0100 + S );       \
    Negative  = ( P & 0x80 ) ? 1 : 0; \
    Overflow  = ( P & 0x40 ) ? 1 : 0; \
    Break     = ( P & 0x10 ) ? 1 : 0; \
    Decimal   = ( P & 0x08 ) ? 1 : 0; \
    Interrupt = ( P & 0x04 ) ? 1 : 0; \
    Zero      = ( P & 0x02 ) ? 1 : 0; \
    Carry     = ( P & 0x01 ) ? 1 : 0; \
    cPLP++;

#define MC_PLX()                     \
    S++;                             \
    X = ReadByte( 0x0100 + S );      \
    Zero = ( X == 0 );               \
    Negative = ( X & 0x80 ) ? 1 : 0; \
    cPLX++;

#define MC_PLY()                     \
    S++;                             \
    Y = ReadByte( 0x0100 + S );      \
    Zero = ( Y == 0 );               \
    Negative = ( Y & 0x80 ) ? 1 : 0; \
    cPLY++;

#define MC_ROL( Data )                   \
    if ( Carry )                         \
    {                                    \
        Carry = ( Data & 0x80 ) ? 1 : 0; \
        Data <<= 1;                      \
        Data |= 1;                       \
    }                                    \
    else                                 \
    {                                    \
        Carry = ( Data & 0x80 ) ? 1 : 0; \
        Data <<= 1;                      \
    }                                    \
    Zero = ( Data == 0 );                \
    Negative = ( Data & 0x80 ) ? 1 : 0;  \
    cROL++;

#define MC_ROR( Data )                  \
    if ( Carry )                        \
    {                                   \
        Carry = ( Data & 1 );           \
        Data >>= 1;                     \
        Data |= 0x80;                   \
    }                                   \
    else                                \
    {                                   \
        Carry = ( Data & 1 );           \
        Data >>= 1;                     \
    }                                   \
    Zero = ( Data == 0 );               \
    Negative = ( Data & 0x80 ) ? 1 : 0; \
    cROR++;

#define MC_RTI()                      \
    S++;                              \
    P = ReadByte( 0x0100 + S );       \
    Negative  = ( P & 0x80 ) ? 1 : 0; \
    Overflow  = ( P & 0x40 ) ? 1 : 0; \
    Break     = ( P & 0x10 ) ? 1 : 0; \
    Decimal   = ( P & 0x08 ) ? 1 : 0; \
    Interrupt = ( P & 0x04 ) ? 1 : 0; \
    Zero      = ( P & 0x02 ) ? 1 : 0; \
    Carry     = ( P & 0x01 ) ? 1 : 0; \
    S++;                              \
    PC=ReadWord( 0x0100 + S );        \
    S++;                              \
    cRTI++;

#define MC_RTS()                 \
    S++;                         \
    PC = ReadWord( 0x0100 + S ); \
    S++;                         \
    PC++;                        \
    cRTS++;

#define MC_SBC( Data )                 \
    if ( Decimal )                     \
    {                                  \
        ClockTick++;                   \
        _DL = A;                       \
        _AL = Data;                    \
        _AH = Carry;                   \
        asm shr  ah, 1;                \
        asm cmc;                       \
        asm xchg dl, al;               \
        asm sbb  al, dl;               \
        asm das;                       \
        asm xchg dl, al;               \
        asm cmc;                       \
        asm pushf;                     \
    }                                  \
    else                               \
    {                                  \
        _DL = A;                       \
        _AL = Data;                    \
        _AH = Carry;                   \
        asm shr ah, 1;                 \
        asm cmc;                       \
        asm sbb dl, al;                \
        asm cmc;                       \
        asm pushf;                     \
    }                                  \
    A = _DL;                           \
    asm pop ax;                        \
    asm mov P, ax;                     \
    Zero = ( A == 0 );                 \
    Negative = ( A & 0x0080 ) ? 1 : 0; \
    Carry    = ( P & 0x0001 ) ? 1 : 0; \
    Overflow = ( P & 0x0800 ) ? 1 : 0; \
    cSBC++;

#define MC_SEC() \
    Carry = 1;   \
    cSEC++;

#define MC_SED() \
    Decimal = 1; \
    cSED++;

#define MC_SEI()   \
    Interrupt = 1; \
    cSEI++;

#define MC_STA( Data ) \
    Data = A;          \
    cSTA++;

#define MC_STX( Data ) \
    Data = X;          \
    cSTX++;

#define MC_STY( Data ) \
    Data = Y;          \
    cSTY++;

#define MC_STZ( Data ) \
    Data = 0;          \
    cSTZ++;

#define MC_TAX()                     \
    X = A;                           \
    Zero = ( X == 0 );               \
    Negative = ( X & 0x80 ) ? 1 : 0; \
    cTAX++;

#define MC_TAY()                     \
    Y = A;                           \
    Zero = ( Y == 0 );               \
    Negative = ( Y & 0x80 ) ? 1 : 0; \
    cTAY++;

#define MC_TRB( Data )    \
    Data = ~A & Data;     \
    Zero = ( Data == 0 ); \
    cTRB++;

#define MC_TSB( Data )    \
    Data = A | Data;      \
    Zero = ( Data == 0 ); \
    cTSB++;

#define MC_TSX()                     \
    X = S;                           \
    Zero = ( X == 0 );               \
    Negative = ( X & 0x80 ) ? 1 : 0; \
    cTSX++;

#define MC_TXA()                     \
    A = X;                           \
    Zero = ( A == 0 );               \
    Negative = ( A & 0x80 ) ? 1 : 0; \
    cTXA++;

#define MC_TXS() \
    S = X; \
    cTXS++;

#define MC_TYA()                     \
    A = Y;                           \
    Zero = ( A == 0 );               \
    Negative = ( A & 0x80 ) ? 1 : 0; \
    cTYA++;

#define MC_INV()
