#include <limits.h>

#include "ram.h"
#include "cpu.h"
#include "gameport.h"
#include "keyboard.h"

/* Left/right is X axis, Up/down is Y axis */

unsigned int GameMinX = 26, GameMinY = 26;
unsigned int GameMaxX = 27, GameMaxY = 27;
unsigned long ClockX, ClockY;                /* Timeouts for 556 timer */
unsigned int LeftAltDown = 0, RightAltDown = 0;

#pragma argsused
BYTE ResetGameTimer( WORD Address )
{
    unsigned int ReadX, ReadY;

    /* Get the current position of the game controller */
    asm {
        mov  ah, 0x84                 /* Joystick function */
        mov  dx, 0x0001
        int  0x15
        jc nojoystick
        mov  ReadX, ax                /* Only game port A */
        mov  ReadY, bx
    }
    /* Update maximum ranges */
    if ( ReadX < GameMinX )
    {
        GameMinX = ReadX;
    }
    if ( ReadY < GameMinY )
    {
        GameMinY = ReadY;
    }
    if ( ReadX > GameMaxX )
    {
        GameMaxX = ReadX;
    }
    if ( ReadY > GameMaxY )
    {
        GameMaxY = ReadY;
    }
    /* Convert PC readings to Apple */
    ReadX = ( ReadX - GameMinX ) * 256 / ( GameMaxX - GameMinX );
    ReadY = ( ReadY - GameMinY ) * 256 / ( GameMaxY - GameMinY );
    /* Calculate CPU clock tick at timeout */
    ClockX = ClockTick +7 + 11 * ReadX;
    ClockY = ClockTick +7 + 11 * ReadY;

nojoystick:
    return 0;
}

#pragma argsused
BYTE ReadGameButtons( WORD Address )
{
    unsigned char but; /* buttons */

    asm {
        mov  ah, 0x84                 /* Joystick function */
        mov  dx, 0
        int  0x15
        jc   nojoystick
        mov  but, al
    }
    CheckKB();
    if ( Address == 0x61 )
    {
        return ( ( but & 0x10 ) == 0 || LeftAltDown  ) ? 255 : 0; /* button 0 */
    }
    if ( Address == 0x62 )
    {
        return ( ( but & 0x20 ) == 0 || RightAltDown ) ? 255 : 0; /* button 1 */
    }
    if ( Address == 0x63 )
    {
        return ( ( but & 0x40 ) == 0                 ) ? 255 : 0; /* button 2 */
    }
nojoystick:
    return 0;
}

BYTE ReadGameTimer( WORD Address )
{
  if ( Address == 0x64 )
  {
      return ( ClockTick > ClockX ) ? 0 : 255;  /* Game 0 has timed out */
  }
  if ( Address == 0x65 )
  {
      return ( ClockTick > ClockY ) ? 0 : 255;  /* Game 1 has timed out */
  }
  return 0;
}
