#include <string.h>

#include "a2icomms.h"
#include "diskclnt.h"

int RmtDoRequest( int cmd, int slot, int drive, int fmt, unsigned int track,
                  unsigned int sector, unsigned int block, unsigned char *buf )
{
    struct PacketInfo pi;
    unsigned char request[ 5 ];

    request[ 0 ] = cmd;
    request[ 1 ] = ( fmt << 4 ) | ( ( drive - 1 ) << 3 ) | slot;
    switch ( fmt )
    {
    case 0:
        /* Track/Sector */
        request[ 2 ] = track;
        request[ 3 ] = sector;
        break;
    case 1:
        /* Block */
        request[ 2 ] = block & 0x00ff;
        request[ 3 ] = block >> 8;
        break;
    case 2:
        /* Track Only */
        request[ 2 ] = track;
        request[ 3 ] = 0;
        break;
    }
    pi.length = 5;
    pi.data = request;
    SendPacket( &pi );
    if ( ReceivePacket( &pi ) == 0 )
    {
        if ( request[ 4 ] == 0 && cmd == 0 )
        {
            /* no errors - get data */
            pi.data = buf;
            switch ( fmt )
            {
            case 0:
                /* Track/Sector */
                pi.length = 256;
                ReceivePacket( &pi );
                break;
            case 1:
                /* Block */
                pi.length = 512;
                ReceivePacket( &pi );
                break;
            case 2:
                /* Track Only */
                pi.length = 4096;
                ReceivePacket( &pi );
                pi.length = 2560;
                pi.data = buf + 0x1000;
                ReceivePacket( &pi );
                break;
            }
        }
    }
    return (int)request[ 4 ];
}

// 0 if NO remote disk support, !0 if supported
int TestConnection( void )
{
    struct PacketInfo pi;
    unsigned char request[] = "RMTDISK?";

    // send RMTDISK?
    pi.length = 8;
    pi.data = request;
    SendPacket( &pi );
    // get RMTDISK! back?
    if ( ReceivePacket( &pi ) == 0 )
    {
        // correct length reply?
        if ( pi.length == 8 )
        {
            // valid reply?
            if ( strcmp( (char*)request, "RMTDISK!" ) == 0 )
            {
                return 1;
            }
        }
    }
    return 0;
}

int RmtConnected( void )
{
    if ( TestConnection() )
    {
        return 1;
    }
    /* Sometimes it doesn't work the first time, but does work the second time */
    return TestConnection();
}

void RmtReadTrackSector( int slot, int drive, int track, int sector,
                         unsigned char *buf )
{
    RmtDoRequest( 0, slot, drive, 0, track, sector, 0, buf );
}

void RmtReadBlock( int slot, int drive, int block, unsigned char *buf )
{
    RmtDoRequest( 0, slot, drive, 1, 0, 0, block, buf );
}

void RmtReadTrack( int slot, int drive, int track, unsigned char *buf )
{
    RmtDoRequest( 0, slot, drive, 2, track, 0, 0, buf );
}

void RmtWriteTrackSector( int slot, int drive, int track, int sector,
                          unsigned char *buf )
{
    RmtDoRequest( 1, slot, drive, 0, track, sector, 0, buf );
}

void RmtWriteBlock( int slot, int drive, int block, unsigned char *buf )
{
    RmtDoRequest( 1, slot, drive, 1, 0, 0, block, buf );
}

int RmtReadWriteProtect( int slot, int drive )
{
    return RmtDoRequest( 2, slot, drive, 0, 0, 0, 0, 0 );
}

void RmtDriveOn( int slot, int drive )
{
    RmtDoRequest( 3, slot, drive, 0, 0, 0, 0, 0 );
}

void RmtDriveOff( int slot, int drive )
{
    RmtDoRequest( 4, slot, drive, 0, 0, 0, 0, 0 );
}

void RmtRecalibrateDrive( int slot, int drive )
{
    RmtDoRequest( 5, slot, drive, 0, 0, 0, 0, 0 );
}
