    case 0x00: /* BRK */
      MC_BRK();
      ClockTick+=7;
      break;
    case 0x01: /* ORA (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x02: /* ??? */
      break;
    case 0x03: /* ??? */
      break;
    case 0x04: /* TSB ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_TSB(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x05: /* ORA ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x06: /* ASL ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_ASL(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x07: /* ??? */
      break;
    case 0x08: /* PHP */
      MC_PHP();
      ClockTick+=3;
      break;
    case 0x09: /* ORA #oper */
      Data=ReadByte(PC);
      MC_ORA(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0x0a: /* ASL Acc */
      MC_ASL(A);
      ClockTick+=2;
      break;
    case 0x0b: /* ??? */
      break;
    case 0x0c: /* TSB Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_TSB(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x0d: /* ORA Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x0e: /* ASL Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_ASL(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x0f: /* ??? */
      break;
    case 0x10: /* BPL Rel */
      Data=ReadByte(PC);
      MC_BPL();
      PC+=1;
      ClockTick+=2;
      break;
    case 0x11: /* ORA (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x12: /* ORA (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x13: /* ??? */
      break;
    case 0x14: /* TRB ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_TRB(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x15: /* ORA ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x16: /* ASL ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_ASL(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x17: /* ??? */
      break;
    case 0x18: /* CLC */
      MC_CLC();
      ClockTick+=2;
      break;
    case 0x19: /* ORA Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x1a: /* INC Acc */
      MC_INC(A);
      ClockTick+=2;
      break;
    case 0x1b: /* ??? */
      break;
    case 0x1c: /* TRB Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_TRB(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x1d: /* ORA Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_ORA(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x1e: /* ASL Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_ASL(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x1f: /* ??? */
      break;
    case 0x20: /* JSR Abs */
      PC++;
      WriteByte(0x0100+S,PC>>8);
      S--;
      WriteByte(0x0100+S,PC&0xff);
      S--;
      PC=ReadWord(PC-1)-2;
      PC+=2;
      ClockTick+=6;
      break;
    case 0x21: /* AND (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x22: /* ??? */
      break;
    case 0x23: /* ??? */
      break;
    case 0x24: /* BIT ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_BIT(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x25: /* AND ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x26: /* ROL ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_ROL(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x27: /* ??? */
      break;
    case 0x28: /* PLP */
      MC_PLP();
      ClockTick+=4;
      break;
    case 0x29: /* AND #oper */
      Data=ReadByte(PC);
      MC_AND(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0x2a: /* ROL Acc */
      MC_ROL(A);
      ClockTick+=2;
      break;
    case 0x2b: /* ??? */
      break;
    case 0x2c: /* BIT Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_BIT(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x2d: /* AND Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x2e: /* ROL Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_ROL(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x2f: /* ??? */
      break;
    case 0x30: /* BMI Rel */
      Data=ReadByte(PC);
      MC_BMI();
      PC+=1;
      ClockTick+=2;
      break;
    case 0x31: /* AND (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x32: /* AND (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x33: /* ??? */
      break;
    case 0x34: /* BIT ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_BIT(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x35: /* AND ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x36: /* ROL ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_ROL(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x37: /* ??? */
      break;
    case 0x38: /* SEC */
      MC_SEC();
      ClockTick+=2;
      break;
    case 0x39: /* AND Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x3a: /* DEC Acc */
      MC_DEC(A);
      ClockTick+=2;
      break;
    case 0x3b: /* ??? */
      break;
    case 0x3c: /* BIT Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_BIT(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x3d: /* AND Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_AND(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x3e: /* ROL Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_ROL(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x3f: /* ??? */
      break;
    case 0x40: /* RTI */
      MC_RTI();
      ClockTick+=6;
      break;
    case 0x41: /* EOR (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x42: /* ??? */
      break;
    case 0x43: /* ??? */
      break;
    case 0x44: /* ??? */
      break;
    case 0x45: /* EOR ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x46: /* LSR ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_LSR(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x47: /* ??? */
      break;
    case 0x48: /* PHA */
      MC_PHA();
      ClockTick+=3;
      break;
    case 0x49: /* EOR #oper */
      Data=ReadByte(PC);
      MC_EOR(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0x4a: /* LSR Acc */
      MC_LSR(A);
      ClockTick+=2;
      break;
    case 0x4b: /* ??? */
      break;
    case 0x4c: /* JMP Abs */
      PC=ReadWord(PC);
      PC-=2;
      PC+=2;
      ClockTick+=3;
      break;
    case 0x4d: /* EOR Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x4e: /* LSR Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_LSR(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x4f: /* ??? */
      break;
    case 0x50: /* BVC Rel */
      Data=ReadByte(PC);
      MC_BVC();
      PC+=1;
      ClockTick+=2;
      break;
    case 0x51: /* EOR (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x52: /* EOR (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x53: /* ??? */
      break;
    case 0x54: /* ??? */
      break;
    case 0x55: /* EOR ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x56: /* LSR ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_LSR(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x57: /* ??? */
      break;
    case 0x58: /* CLI */
      MC_CLI();
      ClockTick+=2;
      break;
    case 0x59: /* EOR Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x5a: /* PHY */
      MC_PHY();
      ClockTick+=3;
      break;
    case 0x5b: /* ??? */
      break;
    case 0x5c: /* ??? */
      break;
    case 0x5d: /* EOR Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_EOR(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x5e: /* LSR Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_LSR(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x5f: /* ??? */
      break;
    case 0x60: /* RTS */
      MC_RTS();
      ClockTick+=6;
      break;
    case 0x61: /* ADC (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x62: /* ??? */
      break;
    case 0x63: /* ??? */
      break;
    case 0x64: /* STZ ZP */
      Address=(WORD)ReadByte(PC);
      MC_STZ(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x65: /* ADC ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x66: /* ROR ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_ROR(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x67: /* ??? */
      break;
    case 0x68: /* PLA */
      MC_PLA();
      ClockTick+=4;
      break;
    case 0x69: /* ADC #oper */
      Data=ReadByte(PC);
      MC_ADC(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0x6a: /* ROR Acc */
      MC_ROR(A);
      ClockTick+=2;
      break;
    case 0x6b: /* ??? */
      break;
    case 0x6c: /* JMP (Abs) */
      PC=ReadWord(ReadWord(PC));
      PC-=2;
      PC+=2;
      ClockTick+=6;
      break;
    case 0x6d: /* ADC Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x6e: /* ROR Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_ROR(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x6f: /* ??? */
      break;
    case 0x70: /* BVS Rel */
      Data=ReadByte(PC);
      MC_BVS();
      PC+=1;
      ClockTick+=2;
      break;
    case 0x71: /* ADC (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x72: /* ADC (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x73: /* ??? */
      break;
    case 0x74: /* STZ ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      MC_STZ(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x75: /* ADC ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x76: /* ROR ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_ROR(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x77: /* ??? */
      break;
    case 0x78: /* SEI */
      MC_SEI();
      ClockTick+=2;
      break;
    case 0x79: /* ADC Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x7a: /* PLY */
      MC_PLY();
      ClockTick+=4;
      break;
    case 0x7b: /* ??? */
      break;
    case 0x7c: /* JMP Abs(Abs+X) */
      PC=ReadWord(ReadWord(PC)+(WORD)X);
      PC-=2;
      PC+=2;
      ClockTick+=6;
      break;
    case 0x7d: /* ADC Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_ADC(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x7e: /* ROR Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_ROR(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0x7f: /* ??? */
      break;
    case 0x80: /* BRA Rel */
      Data=ReadByte(PC);
      MC_BRA();
      PC+=1;
      ClockTick+=2;
      break;
    case 0x81: /* STA (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x82: /* ??? */
      break;
    case 0x83: /* ??? */
      break;
    case 0x84: /* STY ZP */
      Address=(WORD)ReadByte(PC);
      MC_STY(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x85: /* STA ZP */
      Address=(WORD)ReadByte(PC);
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x86: /* STX ZP */
      Address=(WORD)ReadByte(PC);
      MC_STX(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0x87: /* ??? */
      break;
    case 0x88: /* DEY */
      MC_DEY();
      ClockTick+=2;
      break;
    case 0x89: /* BIT #oper */
      Data=ReadByte(PC);
      MC_BIT(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0x8a: /* TXA */
      MC_TXA();
      ClockTick+=2;
      break;
    case 0x8b: /* ??? */
      break;
    case 0x8c: /* STY Abs */
      Address=ReadWord(PC);
      MC_STY(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x8d: /* STA Abs */
      Address=ReadWord(PC);
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x8e: /* STX Abs */
      Address=ReadWord(PC);
      MC_STX(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x8f: /* ??? */
      break;
    case 0x90: /* BCC Rel */
      Data=ReadByte(PC);
      MC_BCC();
      PC+=1;
      ClockTick+=2;
      break;
    case 0x91: /* STA (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0x92: /* STA (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0x93: /* ??? */
      break;
    case 0x94: /* STY ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      MC_STY(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x95: /* STA ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x96: /* STX ZP,Y */
      Address=((WORD)ReadByte(PC)+(WORD)Y)&0x00ff;
      MC_STX(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0x97: /* ??? */
      break;
    case 0x98: /* TYA */
      MC_TYA();
      ClockTick+=2;
      break;
    case 0x99: /* STA Abs,Y */
      Address=ReadWord(PC)+Y;
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=5;
      break;
    case 0x9a: /* TXS */
      MC_TXS();
      ClockTick+=2;
      break;
    case 0x9b: /* ??? */
      break;
    case 0x9c: /* STZ Abs */
      Address=ReadWord(PC);
      MC_STZ(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0x9d: /* STA Abs,X */
      Address=ReadWord(PC)+X;
      MC_STA(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=5;
      break;
    case 0x9e: /* STZ Abs,X */
      Address=ReadWord(PC)+X;
      MC_STZ(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=5;
      break;
    case 0x9f: /* ??? */
      break;
    case 0xa0: /* LDY #oper */
      Data=ReadByte(PC);
      MC_LDY(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0xa1: /* LDA (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0xa2: /* LDX #oper */
      Data=ReadByte(PC);
      MC_LDX(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0xa3: /* ??? */
      break;
    case 0xa4: /* LDY ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_LDY(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0xa5: /* LDA ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0xa6: /* LDX ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_LDX(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0xa7: /* ??? */
      break;
    case 0xa8: /* TAY */
      MC_TAY();
      ClockTick+=2;
      break;
    case 0xa9: /* LDA #oper */
      Data=ReadByte(PC);
      MC_LDA(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0xaa: /* TAX */
      MC_TAX();
      ClockTick+=2;
      break;
    case 0xab: /* ??? */
      break;
    case 0xac: /* LDY Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_LDY(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xad: /* LDA Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xae: /* LDX Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_LDX(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xaf: /* ??? */
      break;
    case 0xb0: /* BCS Rel */
      Data=ReadByte(PC);
      MC_BCS();
      PC+=1;
      ClockTick+=2;
      break;
    case 0xb1: /* LDA (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xb2: /* LDA (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xb3: /* ??? */
      break;
    case 0xb4: /* LDY ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_LDY(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0xb5: /* LDA ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0xb6: /* LDX ZP,Y */
      Address=((WORD)ReadByte(PC)+(WORD)Y)&0x00ff;
      Data=ReadByte(Address);
      MC_LDX(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0xb7: /* ??? */
      break;
    case 0xb8: /* CLV */
      MC_CLV();
      ClockTick+=2;
      break;
    case 0xb9: /* LDA Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xba: /* TSX */
      MC_TSX();
      ClockTick+=2;
      break;
    case 0xbb: /* ??? */
      break;
    case 0xbc: /* LDY Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_LDY(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xbd: /* LDA Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_LDA(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xbe: /* LDX Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_LDX(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xbf: /* ??? */
      break;
    case 0xc0: /* CPY #oper */
      Data=ReadByte(PC);
      MC_CPY(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0xc1: /* CMP (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0xc2: /* ??? */
      break;
    case 0xc3: /* ??? */
      break;
    case 0xc4: /* CPY ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_CPY(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0xc5: /* CMP ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0xc6: /* DEC ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_DEC(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xc7: /* ??? */
      break;
    case 0xc8: /* INY */
      MC_INY();
      ClockTick+=2;
      break;
    case 0xc9: /* CMP #oper */
      Data=ReadByte(PC);
      MC_CMP(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0xca: /* DEX */
      MC_DEX();
      ClockTick+=2;
      break;
    case 0xcb: /* ??? */
      break;
    case 0xcc: /* CPY Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_CPY(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xcd: /* CMP Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xce: /* DEC Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_DEC(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0xcf: /* ??? */
      break;
    case 0xd0: /* BNE Rel */
      Data=ReadByte(PC);
      MC_BNE();
      PC+=1;
      ClockTick+=2;
      break;
    case 0xd1: /* CMP (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xd2: /* CMP (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xd3: /* ??? */
      break;
    case 0xd4: /* ??? */
      break;
    case 0xd5: /* CMP ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0xd6: /* DEC ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_DEC(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0xd7: /* ??? */
      break;
    case 0xd8: /* CLD */
      MC_CLD();
      ClockTick+=2;
      break;
    case 0xd9: /* CMP Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xda: /* PHX */
      MC_PHX();
      ClockTick+=3;
      break;
    case 0xdb: /* ??? */
      break;
    case 0xdc: /* ??? */
      break;
    case 0xdd: /* CMP Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_CMP(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xde: /* DEC Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_DEC(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0xdf: /* ??? */
      break;
    case 0xe0: /* CPX #oper */
      Data=ReadByte(PC);
      MC_CPX(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0xe1: /* SBC (ZP,X) */
      Address=ReadWord((WORD)ReadByte(PC)+(WORD)X);
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0xe2: /* ??? */
      break;
    case 0xe3: /* ??? */
      break;
    case 0xe4: /* CPX ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_CPX(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0xe5: /* SBC ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=1;
      ClockTick+=3;
      break;
    case 0xe6: /* INC ZP */
      Address=(WORD)ReadByte(PC);
      Data=ReadByte(Address);
      MC_INC(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xe7: /* ??? */
      break;
    case 0xe8: /* INX */
      MC_INX();
      ClockTick+=2;
      break;
    case 0xe9: /* SBC #oper */
      Data=ReadByte(PC);
      MC_SBC(Data);
      PC+=1;
      ClockTick+=2;
      break;
    case 0xea: /* NOP */
      MC_NOP();
      ClockTick+=2;
      break;
    case 0xeb: /* ??? */
      break;
    case 0xec: /* CPX Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_CPX(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xed: /* SBC Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xee: /* INC Abs */
      Address=ReadWord(PC);
      Data=ReadByte(Address);
      MC_INC(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0xef: /* ??? */
      break;
    case 0xf0: /* BEQ Rel */
      Data=ReadByte(PC);
      MC_BEQ();
      PC+=1;
      ClockTick+=2;
      break;
    case 0xf1: /* SBC (ZP),Y */
      Address=ReadWord((WORD)ReadByte(PC))+(WORD)Y;
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xf2: /* SBC (ZP) */
      Address=ReadWord((WORD)ReadByte(PC));
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=1;
      ClockTick+=5;
      break;
    case 0xf3: /* ??? */
      break;
    case 0xf4: /* ??? */
      break;
    case 0xf5: /* SBC ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=1;
      ClockTick+=4;
      break;
    case 0xf6: /* INC ZP,X */
      Address=((WORD)ReadByte(PC)+(WORD)X)&0x00ff;
      Data=ReadByte(Address);
      MC_INC(Data);
      WriteByte(Address,Data);
      PC+=1;
      ClockTick+=6;
      break;
    case 0xf7: /* ??? */
      break;
    case 0xf8: /* SED */
      MC_SED();
      ClockTick+=2;
      break;
    case 0xf9: /* SBC Abs,Y */
      Address=ReadWord(PC)+Y;
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xfa: /* PLX */
      MC_PLX();
      ClockTick+=4;
      break;
    case 0xfb: /* ??? */
      break;
    case 0xfc: /* ??? */
      break;
    case 0xfd: /* SBC Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_SBC(Data);
      PC+=2;
      ClockTick+=4;
      break;
    case 0xfe: /* INC Abs,X */
      Address=ReadWord(PC)+X;
      Data=ReadByte(Address);
      MC_INC(Data);
      WriteByte(Address,Data);
      PC+=2;
      ClockTick+=6;
      break;
    case 0xff: /* ??? */
      break;
