#ifndef HDR_A2ICOMMS
#define HDR_A2ICOMMS

#ifdef __cplusplus
extern "C" {
#endif

/* Port types */
#define A2I_PARALLEL_TYPE 1
#define A2I_SERIAL_TYPE   2

struct A2ICommsParms
{
    /* Port Type */
    int porttype; /* 1=Parallel,2=Serial */
    int portnum;  /* Parallel:1-3,Serial:1-4 */
    /* Byte I/O */
    unsigned long presenddelay;
    unsigned long senddelay;
    unsigned long rectimeout;
    /* Packet I/O */
    unsigned long packettimeout;
    unsigned int  maxpacketsends;
};

struct PacketInfo
{
    int seq;
    int type;
    int length;
    unsigned char *data;
};

extern void InitA2IComms( void );
extern void SetA2ICommsParms( struct A2ICommsParms *parms );
int ReceiveByte( void );
void SendByte( unsigned char byte );
void InitCRC( unsigned int *CRC );
void CalcCRC( unsigned int *CRC, int Ch );
void PreSendCRC( unsigned int *CRC );
int ValidCRCData( unsigned int *CRC );
int ReceiveConnectionlessPacket( struct PacketInfo *pkt );
void SendConnectionlessPacket( struct PacketInfo *pkt );
int ReceivePacket( struct PacketInfo *pkt );
int SendPacket( struct PacketInfo *pkt );
int SynchroniseSequences( void );

#ifdef __cplusplus
}
#endif

#endif /* HDR_A2ICOMMS */
