window.addEventListener("load", startGS, false);
var count = 0;
var nextCommandNumber = 1;
var baseURI = "";
var wsURL = "";
var screenURL = "";
var touchID = -1;
var touchSupported = false;
var scaleH = 1;
var scaleW = 1;

touchSupported = 'ontouchend' in document;

// Add a string.contains method if there isn't one

if (!('contains' in String.prototype)) {
  String.prototype.contains = function(str, startIndex) {
    return -1 !== String.prototype.indexOf.call(this, str, startIndex);
  };
}

function startGS() {
  var screen = document.getElementById("screen");
  
  //fullscreenify(screen);
  
  baseURI = document.baseURI;
  baseURI = baseURI.substring(baseURI.indexOf(":")+3, baseURI.lastIndexOf("/"));
  wsURL = 'ws://' + baseURI.substring(0, baseURI.lastIndexOf("/"));
  screenURL = "http://" + baseURI.substring(0, baseURI.lastIndexOf("/")) + "/currentscreen.png?";
  
  ws = new WebSocket(wsURL, "sweet16-debug-protocol");

  // Invoked when there was an error with the connection. 
  ws.onerror = function(e) {
    console.log('error', e);
  }

  // Invoked when the socket has been opened successfully.
  ws.onopen = function(e) {
  }

  // Callback invoked when incoming messages arrive. Event `data` attribute
  // holds the string passed. WebSocket in current spec supports utf8 text-based
  // communication only. Binary data  is base64 encoded.
  ws.onmessage = function(e) {
  }

  // Invoked when the socket has been closed
  ws.onclose = function(e) {
    //console.log('close', e);
  }
  
  updateScreen();
  window.setInterval(updateScreen, 50);
  
  screen.addEventListener("mousemove", doMouseMove, false);
  screen.addEventListener("mousedown", doMouseDown, false);
  screen.addEventListener("mouseup", doMouseUp, false);
  document.addEventListener("keydown", doKeyDown, false);
  document.addEventListener("keyup", doKeyUp, false);
  
  // steal the double-click event
  
  document.body.addEventListener("dblclick", ignoreEvent, true);
  
  // add touch handlers
  
  if (touchSupported) {
    var dummyText = document.getElementById("dummyText");
    
    screen.addEventListener("touchstart", doTouchStart, false);
    screen.addEventListener("touchmove", doTouchMove, false);
    screen.addEventListener("touchend", doTouchEnd, false);
    
    dummyText.addEventListener("keypress", doKeypress, false);
  }
  
  // If on mobile, present the mobile controls
  
  var el = document.getElementById('mobileControls');

  if (isMobile()) {
    el.style.visibility = "visible";
  }
}

var touchMousePossibleClick = false;
var clickStartPos = null;

function ignoreEvent(e) {
  e.preventDefault();
  showMessage("IGNORED EVENT: " + e.type);
}

function doTouchStart(e) {
  e.preventDefault();
  
  touchMousePossibleClick = true;
  clickStartPos = getMousePos(document.getElementById("screen"), e);
}

function showMessage(msg) {
  console.log(msg);
  document.getElementById('messagebox').innerHTML = msg;
}

function doTouchEnd(e) {
  e.preventDefault();
  
  if (touchMousePossibleClick) {
    touchMousePossibleClick = false;
    
//    doMouseDown(e);
//    doMouseUp(e);
  }
}

function doTouchMove(e) {
  var pos = getMousePos(document.getElementById("screen"), e);
  
  e.preventDefault();
  
  if (Math.abs(clickStartPos.x - pos.x) > 2 || Math.abs(clickStartPos.y - pos.y) > 2) {
    touchMousePossibleClick = false;
  }
  
  doMouseMove(e.changedTouches[0]);
}

function sendCommand(command) {
	ws.send(JSON.stringify(command));
	nextCommandNumber++;
}

function updateScreen() {
  var screen = document.getElementById("screen");
  var ctx = screen.getContext("2d");
  
  var img = new Image();
  img.addEventListener("load", function() {
    ctx.drawImage(img, 0, 0);
  }, false);
  img.src = screenURL + count;
  count++;
}

var lastMousePosition = null;

function doMouseMove(e) {
  var screen = document.getElementById("screen");
  lastMousePosition = getMousePos(screen, e);
  
  var command = {command: "sendEvent", order: nextCommandNumber, type: "mousemove",
                    x: lastMousePosition.x, y: lastMousePosition.y};
  sendCommand(command);
}

function doMouseDown(e) {
  var screen = document.getElementById("screen");
  lastMousePosition = getMousePos(screen, e);

  var command = {command: "sendEvent", order: nextCommandNumber, type: "mousedown",
                    x: lastMousePosition.x, y: lastMousePosition.y};
  sendCommand(command);
}

function doMouseUp(e) {
  var screen = document.getElementById("screen");
  lastMousePosition = getMousePos(screen, e);

  var command = {command: "sendEvent", order: nextCommandNumber, type: "mouseup",
                    x: lastMousePosition.x, y: lastMousePosition.y};
  sendCommand(command);
}

var keymap = [
  { keyCode: 0x06, adbKey: 0x72 },  // help
  { keyCode: 0x08, adbKey: 0x33 },  // Backspace/delete
  { keyCode: 0x09, adbKey: 0x30 },  // tab
  { keyCode: 0x0C, adbKey: 0x47 },  // clear
  { keyCode: 0x0D, adbKey: 0x24 },  // return
  { keyCode: 0x0E, adbKey: 0x4C },  // enter
  { keyCode: 0x10, adbKey: 0x38 },  // shift (adb: left shift)
  { keyCode: 0x11, adbKey: 0x36 },  // control (adb: left control)
  { keyCode: 0x12, adbKey: 0x3A },  // option (adb: left option)
  { keyCode: 0x14, adbKey: 0x38 },  // caps lock
  { keyCode: 0x1B, adbKey: 0x35 },  // ESC
  { keyCode: 0x20, adbKey: 0x31 },  // Space
  { keyCode: 0x21, adbKey: 0x74 },  // PgUp
  { keyCode: 0x22, adbKey: 0x79 },  // PgDn
  { keyCode: 0x23, adbKey: 0x77 },  // End
  { keyCode: 0x24, adbKey: 0x73 },  // Home
  { keyCode: 0x25, adbKey: 0x3B },  // Left arrow
  { keyCode: 0x26, adbKey: 0x3E },  // Up arrow
  { keyCode: 0x27, adbKey: 0x3C },  // Right arrow
  { keyCode: 0x28, adbKey: 0x3D },  // Down arrow
  { keyCode: 0x2C, adbKey: 0x71 },  // PrintScreen (THIS MAY BE WRONG!)
//  { keyCode: 0x2D, adbKey: ?? }, // Insert
  { keyCode: 0x2E, adbKey: 0x75 },  // Del
  { keyCode: 0x70, adbKey: 0x7A },  // F1
  { keyCode: 0x71, adbKey: 0x7B },  // F2
  { keyCode: 0x72, adbKey: 0x63 },  // F3
  { keyCode: 0x73, adbKey: 0x76 },  // F4
  { keyCode: 0x74, adbKey: 0x60 },  // F5
  { keyCode: 0x75, adbKey: 0x61 },  // F6
  { keyCode: 0x76, adbKey: 0x62 },  // F7
  { keyCode: 0x77, adbKey: 0x64 },  // F8
  { keyCode: 0x78, adbKey: 0x65 },  // F9
  { keyCode: 0x79, adbKey: 0x6D },  // F10
  { keyCode: 0x7A, adbKey: 0x67 },  // F11
  { keyCode: 0x7B, adbKey: 0x6F },  // F12
  { keyCode: 0x7C, adbKey: 0x69 },  // F13
  { keyCode: 0x7D, adbKey: 0x6B },  // F14
  { keyCode: 0x7E, adbKey: 0x71 },  // F15
  { keyCode: 0xE0, adbKey: 0x37 }   // Command (adb: left command)
];

function doKeyDown(e) {
  var isNumpad = false;
  var adbKey = 0;
  var command = null;
  
  if (e.location == 3) {
    isNumpad = true;
  }
  
  for (var i=0; i<keymap.length; i++) {
    if (keymap[i].keyCode == e.keyCode) {
      adbKey = keymap[i].adbKey;
      break;
    }
  }
  
  if (adbKey) {
    command = {command: "sendEvent", order: nextCommandNumber, type: "keydown",
                    keyADB: adbKey, commandKey: e.metaKey, optionKey: e.altKey,
                    controlKey: e.ctrlKey, shiftKey: e.shiftKey, keypad: isNumpad};
  } else {
    command = {command: "sendEvent", order: nextCommandNumber, type: "keydown",
                    keyASCII: e.keyCode, commandKey: e.metaKey, optionKey: e.altKey,
                    controlKey: e.ctrlKey, shiftKey: e.shiftKey, keypad: isNumpad};
  }
  e.preventDefault();
  sendCommand(command);
}

function doKeyUp(e) {
  var adbKey = 0;
  var command = null;

  if (e.location == 3) {
    isNumpad = true;
  }
  
  for (var i=0; i<keymap.length; i++) {
    if (keymap[i].keyCode == e.keyCode) {
      adbKey = keymap[i].adbKey;
      break;
    }
  }
  
  if (adbKey) {
    command = {command: "sendEvent", order: nextCommandNumber, type: "keyup",
                    keyADB: adbKey};
  } else {
    command = {command: "sendEvent", order: nextCommandNumber, type: "keyup",
                    keyASCII: e.keyCode};
  }
  
  e.preventDefault();
  sendCommand(command);
}

function doKeypress(e) {
  e.preventDefault();
  doKeyDown(e);
  doKeyUp(e);
}

function clickMouse() {
  var command = {command: "sendEvent", order: nextCommandNumber, type: "mousedown",
    x: lastMousePosition.x, y: lastMousePosition.y};
  sendCommand(command);
  
  window.setTimeout(function() {
                    command = {command: "sendEvent", order: nextCommandNumber, type: "mouseup",
                                x: lastMousePosition.x, y: lastMousePosition.y};
                    sendCommand(command);
                    showMessage("Release!");
                    }, 250);

  showMessage("Click at " + lastMousePosition.x + ", " + lastMousePosition.y);
}

function doubleClick() {
  clickMouse();
  
  window.setTimeout(clickMouse, 500);
  showMessage("Double click");
}

var buttonState = 0;

function toggleMouse() {
  var btn = document.getElementById("toggleMouse");
  var command = null;
  
  if (!buttonState) {
    command = {command: "sendEvent", order: nextCommandNumber, type: "mousedown",
      x: lastMousePosition.x, y: lastMousePosition.y};
    sendCommand(command);
    btn.innerHTML = "Release";
    buttonState = 1;
  } else {
    command = {command: "sendEvent", order: nextCommandNumber, type: "mouseup",
      x: lastMousePosition.x, y: lastMousePosition.y};
    sendCommand(command);
    btn.innerHTML = "Press";
    buttonState = 0;
  }
}

function showKeyboard() {
  document.getElementById("dummyText").focus();
}

function isMobile() {
  var ua = navigator.userAgent;
  
  if (ua.contains("Mobi") || ua.contains("mobi")) {
    return true;
  }

  return false;
}

function getMousePos(canvas, evt) {
  var rect = canvas.getBoundingClientRect();
  return {
    x: (evt.clientX - rect.left) * scaleW,
    y: (evt.clientY - rect.top) * scaleH
  };
}

function fullscreenify(canvas) {
  var style = canvas.getAttribute('style') || '';
  window.addEventListener('resize', function () {resize(canvas);}, false);
  
  resize(canvas);
  
  function resize(canvas) {
    var w = window.innerWidth - 40;
    var h = w * 0.625;
    
    scaleW = 640/w;
    scaleH = 400/h;
    
    showMessage("scaleW: " + scaleW + ", scaleH: " + scaleH);
    
    canvas.style.width = w + "px";
    canvas.style.height = h + "px";
  }
}