
/**
 * libemulation
 * Joystick interface
 * (C) 2011 by Marc S. Ressl (mressl@umich.edu)
 * Released under the GPL
 *
 * Defines the joystick interface
 */

#ifndef _JOYSTICKINTERFACE_H
#define _JOYSTICKINTERFACE_H

typedef enum
{
    JOYSTICK_GET_JOYSTICKNUM,
} JoystickMessage;

typedef enum
{
    JOYSTICK_DID_CHANGE,
    JOYSTICK_WAS_CONNECTED,
    JOYSTICK_WAS_DISCONNECTED,
} JoystickNotification;

#define JOYSTICK_AXIS_NUM       16
#define JOYSTICK_BUTTON_NUM     16
#define JOYSTICK_HAT_NUM        4
#define JOYSTICK_BALL_NUM       4

typedef struct
{
    OEInt deviceId;
    OEInt usageId;
    float value;
} JoystickHIDEvent;

typedef enum
{
    JOYSTICK_AXIS1,
    JOYSTICK_AXIS2,
    JOYSTICK_AXIS3,
    JOYSTICK_AXIS4,
    JOYSTICK_AXIS5,
    JOYSTICK_AXIS6,
    JOYSTICK_AXIS7,
    JOYSTICK_AXIS8,
    JOYSTICK_AXIS9,
    JOYSTICK_AXIS10,
    JOYSTICK_AXIS11,
    JOYSTICK_AXIS12,
    JOYSTICK_AXIS13,
    JOYSTICK_AXIS14,
    JOYSTICK_AXIS15,
    JOYSTICK_AXIS16,
    JOYSTICK_BUTTON1,
    JOYSTICK_BUTTON2,
    JOYSTICK_BUTTON3,
    JOYSTICK_BUTTON4,
    JOYSTICK_BUTTON5,
    JOYSTICK_BUTTON6,
    JOYSTICK_BUTTON7,
    JOYSTICK_BUTTON8,
    JOYSTICK_BUTTON9,
    JOYSTICK_BUTTON10,
    JOYSTICK_BUTTON11,
    JOYSTICK_BUTTON12,
    JOYSTICK_BUTTON13,
    JOYSTICK_BUTTON14,
    JOYSTICK_BUTTON15,
    JOYSTICK_BUTTON16,
    JOYSTICK_HAT1,
    JOYSTICK_HAT2,
    JOYSTICK_HAT3,
    JOYSTICK_HAT4,
    JOYSTICK_BALL1,
    JOYSTICK_BALL2,
    JOYSTICK_BALL3,
    JOYSTICK_BALL4,
} JoystickUsageId;

#endif
