/*
 * CursdII - curses interface for Appleblossom
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <curses.h>
#include "../a2includes.h"

/* ifcurses.c */
extern void a2_curses_init(void);
extern void a2_curses_dump(void);
extern void a2_curses_free(void);
extern int a2_curses_kbd(void);

/* ifhelp.c */
extern void if_print_help(char * myname);
extern void if_print_keys(void);


FILE * a2_disasm_file = 0;
FILE * a2_jump_file = 0;
int a2_debug_on = 0;

int a2_keyboard_poll(void)
{
	int i = a2_curses_kbd();
	switch (i) {
	case KEY_F(5): a2_pb_down(0); break;
	case KEY_F(6): a2_pb_down(1); break;
	case KEY_F(7): a2_pb_up(0); break;
	case KEY_F(8): a2_pb_up(1); break;
	case KEY_F(9):
		a2_dump_memory("a2memorydump.bin");
		a2_dump_switches("a2switchesdump.txt");
		break;
	case KEY_F(12): c02_reset(a2_mmu_peek, a2_mmu_poke); break;
	case KEY_F(13): a2_debug_on = 1; break;
	case KEY_F(14): a2_debug_on = 0; break;
	default:
		if (i != ERR) {
			a2_key_down(i & 0x7F);
		}
		break;
	}
	return i;
}

int main(int argc, char * argv[])
{
	int i;
	int vbl_clock = -20000;
	a2_disasm_file = 0;
	a2_jump_file = 0;
	a2_debug_on = 0;
	a2_disk_reset();
	a2_hdisk_reset();
	a2_serial_reset();
	if (argc>1) {
		for (i=1; i<argc; i++) {
			if (!strcmp(argv[i],"-help")) {
				if_print_help(argv[0]);
				return 0;
			}
			if (!strcmp(argv[i],"-keys")) {
				if_print_keys();
				return 0;
			}
			if (!strcmp(argv[i],"-disktest")) {
				a2_disk_test();
				return 0;
			}
			if (!strcmp(argv[i],"-hgrtest")) {
				int j;
				for (j=0; j<192; j++) {
					printf("HGR Line %3d: $%04X\n", j, a2_hires_base(j));
				}
				return 0;
			}
			if (!strcmp(argv[i],"-don")) { a2_debug_on = 1; }
			if (!strcmp(argv[i],"-d1po")) { A2_DISK_PRODOS_ORDER[0] = 1; }
			if (!strcmp(argv[i],"-d2po")) { A2_DISK_PRODOS_ORDER[1] = 1; }
			if (!strcmp(argv[i],"-d1do")) { A2_DISK_PRODOS_ORDER[0] = 0; }
			if (!strcmp(argv[i],"-d2do")) { A2_DISK_PRODOS_ORDER[1] = 0; }
			if (!strcmp(argv[i],"-d1n")) { A2_DISK_PRODOS_ORDER[0] = 2; }
			if (!strcmp(argv[i],"-d2n")) { A2_DISK_PRODOS_ORDER[1] = 2; }
			if (i<(argc-1)) {
				if (!strcmp(argv[i],"-d1")) { a2_load_disk(0,-1,argv[i+1]); }
				if (!strcmp(argv[i],"-d2")) { a2_load_disk(1,-1,argv[i+1]); }
				if (!strcmp(argv[i],"-h1")) { a2_load_hdisk(0,argv[i+1]); }
				if (!strcmp(argv[i],"-h2")) { a2_load_hdisk(1,argv[i+1]); }
				if (!strcmp(argv[i],"-s1")) {
					A2_SERIAL_OUT[0] = fopen(argv[i+1], "ab");
					A2_SERIAL_IN[0] = fopen(argv[i+1], "rb");
				}
				if (!strcmp(argv[i],"-s2")) {
					A2_SERIAL_OUT[1] = fopen(argv[i+1], "ab");
					A2_SERIAL_IN[1] = fopen(argv[i+1], "rb");
				}
				if (!strcmp(argv[i],"-d")) { a2_disasm_file = fopen(argv[i+1], "w"); }
				if (!strcmp(argv[i],"-j")) { a2_jump_file = fopen(argv[i+1], "w"); }
			}
		}
	}
	if (!a2_init(0)) {
		printf("Could not find APPLE2E.ROM.\n");
		return 0;
	}
	a2_curses_init();
	A2_PDL0_VALUE = 177;
	A2_PDL1_VALUE = 101;
	A2_PDL2_VALUE = 155;
	A2_PDL3_VALUE = 242;
	while (1) {
		if (a2_disasm_file && a2_debug_on) {
			c02_dump(a2_disasm_file, a2_mmu_peek);
		}
		if (a2_jump_file && a2_debug_on) {
			c02_dumpjump(a2_jump_file, a2_mmu_peek);
		}
		a2_cycle();
		if (a2_keyboard_poll() == KEY_F(10)) break;
		if ((A2_CLOCK - vbl_clock) > 16666) {
			a2_curses_dump();
			vbl_clock = A2_CLOCK;
		}
	}
	if (A2_DISK[0] && A2_DISK_DIRTY[0]) {
		move(26,0);
		printw("Save changes to disk image \"%s\" in slot 6 drive 1?", A2_DISK_PATH[0]);
		while ((i = getch()) == ERR);
		if ((i == 'Y') || (i == 'y')) a2_write_disk(0);
	}
	if (A2_DISK[1] && A2_DISK_DIRTY[1]) {
		move(26,0);
		printw("Save changes to disk image \"%s\" in slot 6 drive 2?", A2_DISK_PATH[1]);
		while ((i = getch()) == ERR);
		if ((i == 'Y') || (i == 'y')) a2_write_disk(1);
	}
	if (A2_HDISK[0] && A2_HDISK_DIRTY[0]) {
		move(26,0);
		printw("Save changes to disk image \"%s\" in slot 7 drive 1?", A2_HDISK_PATH[0]);
		while ((i = getch()) == ERR);
		if ((i == 'Y') || (i == 'y')) a2_write_hdisk(0);
	}
	if (A2_HDISK[1] && A2_HDISK_DIRTY[1]) {
		move(26,0);
		printw("Save changes to disk image \"%s\" in slot 7 drive 2?", A2_HDISK_PATH[1]);
		while ((i = getch()) == ERR);
		if ((i == 'Y') || (i == 'y')) a2_write_hdisk(1);
	}
	a2_curses_free();
	if (a2_disasm_file) { fclose(a2_disasm_file); }
	if (a2_jump_file) { fclose(a2_jump_file); }
	return 0;
}
